/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.graphics.Canvas;
import android.graphics.PixelFormat;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Handler;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Log;
import android.view.IWindowSession;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.android.internal.view.BaseIWindow;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;

public class SurfaceView
extends View {
    private static final boolean DEBUG = false;
    static final int GET_NEW_SURFACE_MSG = 2;
    static final int KEEP_SCREEN_ON_MSG = 1;
    private static final String TAG = "SurfaceView";
    static final int UPDATE_WINDOW_MSG = 3;
    final ArrayList<SurfaceHolder.Callback> mCallbacks = new ArrayList();
    final Configuration mConfiguration;
    final Rect mContentInsets;
    private final ViewTreeObserver.OnPreDrawListener mDrawListener;
    boolean mDrawingStopped = true;
    int mFormat = -1;
    private boolean mGlobalListenersAdded;
    final Handler mHandler;
    boolean mHaveFrame = false;
    int mHeight = -1;
    boolean mIsCreating = false;
    long mLastLockTime = 0L;
    int mLastSurfaceHeight = -1;
    int mLastSurfaceWidth = -1;
    final WindowManager.LayoutParams mLayout;
    int mLeft = -1;
    final int[] mLocation = new int[2];
    final Surface mNewSurface;
    final Rect mOverscanInsets;
    boolean mReportDrawNeeded;
    int mRequestedFormat = 4;
    int mRequestedHeight = -1;
    boolean mRequestedVisible = false;
    int mRequestedWidth = -1;
    final ViewTreeObserver.OnScrollChangedListener mScrollChangedListener;
    IWindowSession mSession;
    final Rect mStableInsets;
    final Surface mSurface;
    boolean mSurfaceCreated = false;
    final Rect mSurfaceFrame;
    private final SurfaceHolder mSurfaceHolder;
    final ReentrantLock mSurfaceLock = new ReentrantLock();
    int mTop = -1;
    private CompatibilityInfo.Translator mTranslator;
    boolean mUpdateWindowNeeded;
    boolean mViewVisibility = false;
    boolean mVisible = false;
    final Rect mVisibleInsets;
    int mWidth = -1;
    final Rect mWinFrame;
    MyWindow mWindow;
    int mWindowType = 1001;
    boolean mWindowVisibility = false;

    public SurfaceView(Context context) {
        super(context);
        this.mSurface = new Surface();
        this.mNewSurface = new Surface();
        this.mLayout = new WindowManager.LayoutParams();
        this.mVisibleInsets = new Rect();
        this.mWinFrame = new Rect();
        this.mOverscanInsets = new Rect();
        this.mContentInsets = new Rect();
        this.mStableInsets = new Rect();
        this.mConfiguration = new Configuration();
        this.mHandler = new Handler(){

            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        return;
                    }
                    case 1: {
                        SurfaceView surfaceView = SurfaceView.this;
                        int n = message.arg1;
                        boolean bl = false;
                        if (n != 0) {
                            bl = true;
                        }
                        surfaceView.setKeepScreenOn(bl);
                        return;
                    }
                    case 2: {
                        SurfaceView.this.handleGetNewSurface();
                        return;
                    }
                    case 3: 
                }
                SurfaceView.this.updateWindow(false, false);
            }
        };
        this.mScrollChangedListener = new ViewTreeObserver.OnScrollChangedListener(){

            @Override
            public void onScrollChanged() {
                SurfaceView.this.updateWindow(false, false);
            }
        };
        this.mSurfaceFrame = new Rect();
        this.mDrawListener = new ViewTreeObserver.OnPreDrawListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public boolean onPreDraw() {
                SurfaceView surfaceView = SurfaceView.this;
                boolean bl = SurfaceView.this.getWidth() > 0 && SurfaceView.this.getHeight() > 0;
                surfaceView.mHaveFrame = bl;
                SurfaceView.this.updateWindow(false, false);
                return true;
            }
        };
        this.mSurfaceHolder = new SurfaceHolder(){
            private static final String LOG_TAG = "SurfaceHolder";

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private final Canvas internalLockCanvas(Rect rect) {
                SurfaceView.this.mSurfaceLock.lock();
                boolean bl = SurfaceView.this.mDrawingStopped;
                Canvas canvas = null;
                if (!bl) {
                    MyWindow myWindow = SurfaceView.this.mWindow;
                    canvas = null;
                    if (myWindow != null) {
                        try {
                            Canvas canvas2;
                            canvas = canvas2 = SurfaceView.this.mSurface.lockCanvas(rect);
                        }
                        catch (Exception exception) {
                            Log.e(LOG_TAG, "Exception locking surface", exception);
                            canvas = null;
                        }
                    }
                }
                if (canvas != null) {
                    SurfaceView.this.mLastLockTime = SystemClock.uptimeMillis();
                    return canvas;
                }
                long l = 100L + SurfaceView.this.mLastLockTime;
                long l2 = SystemClock.uptimeMillis();
                if (l > l2) {
                    long l3 = l - l2;
                    try {
                        Thread.sleep(l3);
                    }
                    catch (InterruptedException interruptedException) {}
                    l2 = SystemClock.uptimeMillis();
                }
                SurfaceView.this.mLastLockTime = l2;
                SurfaceView.this.mSurfaceLock.unlock();
                return null;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void addCallback(SurfaceHolder.Callback callback) {
                ArrayList<SurfaceHolder.Callback> arrayList = SurfaceView.this.mCallbacks;
                synchronized (arrayList) {
                    if (!SurfaceView.this.mCallbacks.contains(callback)) {
                        SurfaceView.this.mCallbacks.add(callback);
                    }
                    return;
                }
            }

            @Override
            public Surface getSurface() {
                return SurfaceView.this.mSurface;
            }

            @Override
            public Rect getSurfaceFrame() {
                return SurfaceView.this.mSurfaceFrame;
            }

            @Override
            public boolean isCreating() {
                return SurfaceView.this.mIsCreating;
            }

            @Override
            public Canvas lockCanvas() {
                return this.internalLockCanvas(null);
            }

            @Override
            public Canvas lockCanvas(Rect rect) {
                return this.internalLockCanvas(rect);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void removeCallback(SurfaceHolder.Callback callback) {
                ArrayList<SurfaceHolder.Callback> arrayList = SurfaceView.this.mCallbacks;
                synchronized (arrayList) {
                    SurfaceView.this.mCallbacks.remove(callback);
                    return;
                }
            }

            @Override
            public void setFixedSize(int n, int n2) {
                if (SurfaceView.this.mRequestedWidth != n || SurfaceView.this.mRequestedHeight != n2) {
                    SurfaceView.this.mRequestedWidth = n;
                    SurfaceView.this.mRequestedHeight = n2;
                    SurfaceView.this.requestLayout();
                }
            }

            @Override
            public void setFormat(int n) {
                if (n == -1) {
                    n = 4;
                }
                SurfaceView.this.mRequestedFormat = n;
                if (SurfaceView.this.mWindow != null) {
                    SurfaceView.this.updateWindow(false, false);
                }
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void setKeepScreenOn(boolean bl) {
                int n = 1;
                Message message = SurfaceView.this.mHandler.obtainMessage(n);
                if (!bl) {
                    n = 0;
                }
                message.arg1 = n;
                SurfaceView.this.mHandler.sendMessage(message);
            }

            @Override
            public void setSizeFromLayout() {
                if (SurfaceView.this.mRequestedWidth != -1 || SurfaceView.this.mRequestedHeight != -1) {
                    SurfaceView surfaceView = SurfaceView.this;
                    SurfaceView.this.mRequestedHeight = -1;
                    surfaceView.mRequestedWidth = -1;
                    SurfaceView.this.requestLayout();
                }
            }

            @Override
            @Deprecated
            public void setType(int n) {
            }

            @Override
            public void unlockCanvasAndPost(Canvas canvas) {
                SurfaceView.this.mSurface.unlockCanvasAndPost(canvas);
                SurfaceView.this.mSurfaceLock.unlock();
            }
        };
        this.init();
    }

    public SurfaceView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mSurface = new Surface();
        this.mNewSurface = new Surface();
        this.mLayout = new WindowManager.LayoutParams();
        this.mVisibleInsets = new Rect();
        this.mWinFrame = new Rect();
        this.mOverscanInsets = new Rect();
        this.mContentInsets = new Rect();
        this.mStableInsets = new Rect();
        this.mConfiguration = new Configuration();
        this.mHandler = new /* invalid duplicate definition of identical inner class */;
        this.mScrollChangedListener = new /* invalid duplicate definition of identical inner class */;
        this.mSurfaceFrame = new Rect();
        this.mDrawListener = new /* invalid duplicate definition of identical inner class */;
        this.mSurfaceHolder = new /* invalid duplicate definition of identical inner class */;
        this.init();
    }

    public SurfaceView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.mSurface = new Surface();
        this.mNewSurface = new Surface();
        this.mLayout = new WindowManager.LayoutParams();
        this.mVisibleInsets = new Rect();
        this.mWinFrame = new Rect();
        this.mOverscanInsets = new Rect();
        this.mContentInsets = new Rect();
        this.mStableInsets = new Rect();
        this.mConfiguration = new Configuration();
        this.mHandler = new /* invalid duplicate definition of identical inner class */;
        this.mScrollChangedListener = new /* invalid duplicate definition of identical inner class */;
        this.mSurfaceFrame = new Rect();
        this.mDrawListener = new /* invalid duplicate definition of identical inner class */;
        this.mSurfaceHolder = new /* invalid duplicate definition of identical inner class */;
        this.init();
    }

    public SurfaceView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.mSurface = new Surface();
        this.mNewSurface = new Surface();
        this.mLayout = new WindowManager.LayoutParams();
        this.mVisibleInsets = new Rect();
        this.mWinFrame = new Rect();
        this.mOverscanInsets = new Rect();
        this.mContentInsets = new Rect();
        this.mStableInsets = new Rect();
        this.mConfiguration = new Configuration();
        this.mHandler = new /* invalid duplicate definition of identical inner class */;
        this.mScrollChangedListener = new /* invalid duplicate definition of identical inner class */;
        this.mSurfaceFrame = new Rect();
        this.mDrawListener = new /* invalid duplicate definition of identical inner class */;
        this.mSurfaceHolder = new /* invalid duplicate definition of identical inner class */;
        this.init();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SurfaceHolder.Callback[] getSurfaceCallbacks() {
        ArrayList<SurfaceHolder.Callback> arrayList = this.mCallbacks;
        synchronized (arrayList) {
            SurfaceHolder.Callback[] callbackArray = new SurfaceHolder.Callback[this.mCallbacks.size()];
            this.mCallbacks.toArray(callbackArray);
            return callbackArray;
        }
    }

    private void init() {
        this.setWillNotDraw(true);
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        if (this.mWindowType != 1000 && (0x80 & this.mPrivateFlags) == 128) {
            canvas.drawColor(0, PorterDuff.Mode.CLEAR);
        }
        super.dispatchDraw(canvas);
    }

    @Override
    public void draw(Canvas canvas) {
        if (this.mWindowType != 1000 && (0x80 & this.mPrivateFlags) == 0) {
            canvas.drawColor(0, PorterDuff.Mode.CLEAR);
        }
        super.draw(canvas);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean gatherTransparentRegion(Region region) {
        if (this.mWindowType == 1000) {
            return super.gatherTransparentRegion(region);
        }
        boolean bl = true;
        if ((0x80 & this.mPrivateFlags) == 0) {
            bl = super.gatherTransparentRegion(region);
        } else if (region != null) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            if (n > 0 && n2 > 0) {
                this.getLocationInWindow(this.mLocation);
                int n3 = this.mLocation[0];
                int n4 = this.mLocation[1];
                region.op(n3, n4, n3 + n, n4 + n2, Region.Op.UNION);
            }
        }
        if (!PixelFormat.formatHasAlpha(this.mRequestedFormat)) return bl;
        return false;
    }

    public SurfaceHolder getHolder() {
        return this.mSurfaceHolder;
    }

    void handleGetNewSurface() {
        this.updateWindow(false, false);
    }

    public boolean isFixedSize() {
        return this.mRequestedWidth != -1 || this.mRequestedHeight != -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mParent.requestTransparentRegion(this);
        this.mSession = this.getWindowSession();
        this.mLayout.token = this.getWindowToken();
        this.mLayout.setTitle(TAG);
        boolean bl = this.getVisibility() == 0;
        this.mViewVisibility = bl;
        if (!this.mGlobalListenersAdded) {
            ViewTreeObserver viewTreeObserver = this.getViewTreeObserver();
            viewTreeObserver.addOnScrollChangedListener(this.mScrollChangedListener);
            viewTreeObserver.addOnPreDrawListener(this.mDrawListener);
            this.mGlobalListenersAdded = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void onDetachedFromWindow() {
        if (this.mGlobalListenersAdded) {
            ViewTreeObserver viewTreeObserver = this.getViewTreeObserver();
            viewTreeObserver.removeOnScrollChangedListener(this.mScrollChangedListener);
            viewTreeObserver.removeOnPreDrawListener(this.mDrawListener);
            this.mGlobalListenersAdded = false;
        }
        this.mRequestedVisible = false;
        this.updateWindow(false, false);
        this.mHaveFrame = false;
        if (this.mWindow != null) {
            try {
                this.mSession.remove(this.mWindow);
            }
            catch (RemoteException remoteException) {}
            this.mWindow = null;
        }
        this.mSession = null;
        this.mLayout.token = null;
        super.onDetachedFromWindow();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        int n3 = this.mRequestedWidth >= 0 ? SurfaceView.resolveSizeAndState(this.mRequestedWidth, n, 0) : SurfaceView.getDefaultSize(0, n);
        int n4 = this.mRequestedHeight >= 0 ? SurfaceView.resolveSizeAndState(this.mRequestedHeight, n2, 0) : SurfaceView.getDefaultSize(0, n2);
        this.setMeasuredDimension(n3, n4);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onWindowVisibilityChanged(int n) {
        boolean bl = true;
        super.onWindowVisibilityChanged(n);
        boolean bl2 = n == 0 ? bl : false;
        this.mWindowVisibility = bl2;
        if (!this.mWindowVisibility || !this.mViewVisibility) {
            bl = false;
        }
        this.mRequestedVisible = bl;
        this.updateWindow(false, false);
    }

    @Override
    protected boolean setFrame(int n, int n2, int n3, int n4) {
        boolean bl = super.setFrame(n, n2, n3, n4);
        this.updateWindow(false, false);
        return bl;
    }

    public void setSecure(boolean bl) {
        if (bl) {
            WindowManager.LayoutParams layoutParams = this.mLayout;
            layoutParams.flags = 0x2000 | layoutParams.flags;
            return;
        }
        WindowManager.LayoutParams layoutParams = this.mLayout;
        layoutParams.flags = 0xFFFFDFFF & layoutParams.flags;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setVisibility(int n) {
        super.setVisibility(n);
        boolean bl = n == 0;
        this.mViewVisibility = bl;
        boolean bl2 = this.mWindowVisibility && this.mViewVisibility;
        if (bl2 != this.mRequestedVisible) {
            this.requestLayout();
        }
        this.mRequestedVisible = bl2;
        this.updateWindow(false, false);
    }

    public void setWindowType(int n) {
        this.mWindowType = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setZOrderMediaOverlay(boolean bl) {
        int n = bl ? 1004 : 1001;
        this.mWindowType = n;
    }

    public void setZOrderOnTop(boolean bl) {
        if (bl) {
            this.mWindowType = 1000;
            WindowManager.LayoutParams layoutParams = this.mLayout;
            layoutParams.flags = 0x20000 | layoutParams.flags;
            return;
        }
        this.mWindowType = 1001;
        WindowManager.LayoutParams layoutParams = this.mLayout;
        layoutParams.flags = 0xFFFDFFFF & layoutParams.flags;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateWindow(boolean var1_1, boolean var2_2) {
        block41: {
            block40: {
                if (!this.mHaveFrame) break block40;
                var3_3 = this.getViewRootImpl();
                if (var3_3 != null) {
                    this.mTranslator = var3_3.mTranslator;
                }
                if (this.mTranslator != null) {
                    this.mSurface.setCompatibilityTranslator(this.mTranslator);
                }
                if ((var4_4 = this.mRequestedWidth) <= 0) {
                    var4_4 = this.getWidth();
                }
                if ((var5_5 = this.mRequestedHeight) <= 0) {
                    var5_5 = this.getHeight();
                }
                this.getLocationInWindow(this.mLocation);
                var6_6 = this.mWindow == null;
                var7_7 = this.mFormat != this.mRequestedFormat;
                var8_8 = this.mWidth != var4_4 || this.mHeight != var5_5;
                var9_9 = this.mVisible != this.mRequestedVisible;
                if (var1_1 || var6_6 || var7_7 || var8_8 || var9_9 || this.mLeft != this.mLocation[0] || this.mTop != this.mLocation[1] || this.mUpdateWindowNeeded || this.mReportDrawNeeded || var2_2) break block41;
            }
            return;
        }
        this.mVisible = var11_10 = this.mRequestedVisible;
        this.mLeft = this.mLocation[0];
        this.mTop = this.mLocation[1];
        this.mWidth = var4_4;
        this.mHeight = var5_5;
        this.mFormat = this.mRequestedFormat;
        this.mLayout.x = this.mLeft;
        this.mLayout.y = this.mTop;
        this.mLayout.width = this.getWidth();
        this.mLayout.height = this.getHeight();
        if (this.mTranslator != null) {
            this.mTranslator.translateLayoutParamsInAppWindowToScreen(this.mLayout);
        }
        this.mLayout.format = this.mRequestedFormat;
        var12_11 = this.mLayout;
        var12_11.flags = 16920 | var12_11.flags;
        if (!this.getContext().getResources().getCompatibilityInfo().supportsScreen()) {
            var55_12 = this.mLayout;
            var55_12.privateFlags = 128 | var55_12.privateFlags;
        }
        var13_13 = this.mLayout;
        var13_13.privateFlags = 64 | var13_13.privateFlags;
        if (this.mWindow == null) {
            var48_14 = this.getDisplay();
            this.mWindow = new MyWindow(this);
            this.mLayout.type = this.mWindowType;
            this.mLayout.gravity = 0x800033;
            var49_15 = this.mSession;
            var50_16 = this.mWindow;
            var51_17 = this.mWindow.mSeq;
            var52_18 = this.mLayout;
            var53_19 = this.mVisible != false ? 0 : 8;
            var49_15.addToDisplayWithoutInputChannel(var50_16, var51_17, var52_18, var53_19, var48_14.getDisplayId(), this.mContentInsets);
        }
        this.mSurfaceLock.lock();
        try {
            this.mUpdateWindowNeeded = false;
            var15_20 = this.mReportDrawNeeded;
            this.mReportDrawNeeded = false;
            var16_21 = var11_10 == false;
            this.mDrawingStopped = var16_21;
            var17_22 = this.mSession;
            var18_23 = this.mWindow;
            var19_24 = this.mWindow.mSeq;
            var20_25 = this.mLayout;
            var21_26 = this.mWidth;
            var22_27 = this.mHeight;
            var23_28 = var11_10 != false ? 0 : 8;
            var24_29 = var17_22.relayout(var18_23, var19_24, var20_25, var21_26, var22_27, var23_28, 2, this.mWinFrame, this.mOverscanInsets, this.mContentInsets, this.mVisibleInsets, this.mStableInsets, this.mConfiguration, this.mNewSurface);
            if ((var24_29 & 2) != 0) {
                this.mReportDrawNeeded = true;
            }
            this.mSurfaceFrame.left = 0;
            this.mSurfaceFrame.top = 0;
            if (this.mTranslator == null) {
                this.mSurfaceFrame.right = this.mWinFrame.width();
                this.mSurfaceFrame.bottom = this.mWinFrame.height();
            } else {
                var25_30 = this.mTranslator.applicationInvertedScale;
                this.mSurfaceFrame.right = (int)(0.5f + var25_30 * (float)this.mWinFrame.width());
                this.mSurfaceFrame.bottom = (int)(0.5f + var25_30 * (float)this.mWinFrame.height());
            }
            var26_31 = this.mSurfaceFrame.right;
            var27_32 = this.mSurfaceFrame.bottom;
            if (this.mLastSurfaceWidth == var26_31 && this.mLastSurfaceHeight == var27_32) ** GOTO lbl87
            ** GOTO lbl89
        }
        catch (Throwable var14_42) {
            block39: {
                block43: {
                    block44: {
                        block42: {
                            this.mSurfaceLock.unlock();
                            throw var14_42;
lbl87:
                            // 1 sources

                            var28_33 = false;
                            break block42;
lbl89:
                            // 1 sources

                            var28_33 = true;
                        }
                        this.mLastSurfaceWidth = var26_31;
                        this.mLastSurfaceHeight = var27_32;
                        this.mSurfaceLock.unlock();
                        var29_34 = var2_2 | (var6_6 | var15_20);
                        var30_35 = (var24_29 & 4) != 0;
                        var32_36 = this.mSurfaceCreated;
                        var33_37 = null;
                        if (!var32_36) break block43;
                        if (var30_35) break block44;
                        var33_37 = null;
                        if (var11_10) break block43;
                        var33_37 = null;
                        if (!var9_9) break block43;
                    }
                    this.mSurfaceCreated = false;
                    var44_38 = this.mSurface.isValid();
                    var33_37 = null;
                    if (var44_38) {
                        var45_39 = var33_37 = this.getSurfaceCallbacks();
                        var46_40 = var45_39.length;
                        for (var47_41 = 0; var47_41 < var46_40; ++var47_41) {
                            var45_39[var47_41].surfaceDestroyed(this.mSurfaceHolder);
                        }
                    }
                }
                this.mSurface.transferFrom(this.mNewSurface);
                if (!var11_10 || !this.mSurface.isValid()) ** break block38
                if (!this.mSurfaceCreated && (var30_35 || var9_9)) {
                    this.mSurfaceCreated = true;
                    this.mIsCreating = true;
                    if (var33_37 == null) {
                        var33_37 = this.getSurfaceCallbacks();
                    }
                    var34_44 = var33_37;
                    var35_45 = var34_44.length;
                    for (var36_46 = 0; var36_46 < var35_45; ++var36_46) {
                        var34_44[var36_46].surfaceCreated(this.mSurfaceHolder);
                    }
                }
                if (!var6_6 && !var7_7 && !var8_8 && !var9_9 && !var28_33) break block39;
                if (var33_37 != null) ** GOTO lbl133
                var33_37 = this.getSurfaceCallbacks();
lbl133:
                // 2 sources

                var37_47 = var33_37;
                var38_48 = var37_47.length;
                for (var39_49 = 0; var39_49 < var38_48; ++var39_49) {
                    var37_47[var39_49].surfaceChanged(this.mSurfaceHolder, this.mFormat, var4_4, var5_5);
                }
            }
            if (!var29_34) ** break block38
            if (var33_37 != null) ** GOTO lbl143
            var33_37 = this.getSurfaceCallbacks();
lbl143:
            // 4 sources

            for (SurfaceHolder.Callback var43_53 : var33_37) {
                if (!(var43_53 instanceof SurfaceHolder.Callback2)) continue;
                ((SurfaceHolder.Callback2)var43_53).surfaceRedrawNeeded(this.mSurfaceHolder);
            }
        }
        catch (Throwable var31_54) {
            this.mIsCreating = false;
            if (var29_34) {
                this.mSession.finishDrawing(this.mWindow);
            }
            this.mSession.performDeferredDestroy(this.mWindow);
            throw var31_54;
        }
        {
            try {
                this.mIsCreating = false;
                if (var29_34) {
                    this.mSession.finishDrawing(this.mWindow);
                }
                this.mSession.performDeferredDestroy(this.mWindow);
                return;
            }
            catch (RemoteException var10_43) {
                return;
            }
        }
    }

    private static class MyWindow
    extends BaseIWindow {
        int mCurHeight = -1;
        int mCurWidth = -1;
        private final WeakReference<SurfaceView> mSurfaceView;

        public MyWindow(SurfaceView surfaceView) {
            this.mSurfaceView = new WeakReference<SurfaceView>(surfaceView);
        }

        @Override
        public void dispatchAppVisibility(boolean bl) {
        }

        @Override
        public void dispatchGetNewSurface() {
            SurfaceView surfaceView = (SurfaceView)this.mSurfaceView.get();
            if (surfaceView != null) {
                Message message = surfaceView.mHandler.obtainMessage(2);
                surfaceView.mHandler.sendMessage(message);
            }
        }

        @Override
        public void executeCommand(String string2, String string3, ParcelFileDescriptor parcelFileDescriptor) {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void resized(Rect var1_1, Rect var2_2, Rect var3_3, Rect var4_4, Rect var5_5, boolean var6_6, Configuration var7_7) {
            block8: {
                block7: {
                    var8_8 = (SurfaceView)this.mSurfaceView.get();
                    if (var8_8 == null) break block7;
                    var8_8.mSurfaceLock.lock();
                    if (!var6_6) break block8;
                    var8_8.mUpdateWindowNeeded = true;
                    var8_8.mReportDrawNeeded = true;
                    var8_8.mHandler.sendEmptyMessage(3);
                }
lbl11:
                // 3 sources

                return;
            }
            try {
                if (var8_8.mWinFrame.width() == var1_1.width() && var8_8.mWinFrame.height() == var1_1.height()) ** GOTO lbl11
                var8_8.mUpdateWindowNeeded = true;
                var8_8.mHandler.sendEmptyMessage(3);
                ** continue;
            }
            catch (Throwable var9_9) {
                throw var9_9;
            }
            finally {
                var8_8.mSurfaceLock.unlock();
            }
        }

        @Override
        public void windowFocusChanged(boolean bl, boolean bl2) {
            Log.w(SurfaceView.TAG, "Unexpected focus in surface: focus=" + bl + ", touchEnabled=" + bl2);
        }
    }
}

