/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.res.CompatibilityInfo;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import android.view.SurfaceControl;
import dalvik.system.CloseGuard;

public class Surface
implements Parcelable {
    public static final Parcelable.Creator<Surface> CREATOR = new Parcelable.Creator<Surface>(){

        @Override
        public Surface createFromParcel(Parcel parcel) {
            try {
                Surface surface = new Surface();
                surface.readFromParcel(parcel);
                return surface;
            }
            catch (Exception exception) {
                Log.e(Surface.TAG, "Exception creating surface from parcel", exception);
                return null;
            }
        }

        public Surface[] newArray(int n) {
            return new Surface[n];
        }
    };
    public static final int ROTATION_0 = 0;
    public static final int ROTATION_180 = 2;
    public static final int ROTATION_270 = 3;
    public static final int ROTATION_90 = 1;
    private static final String TAG = "Surface";
    private final Canvas mCanvas;
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private Matrix mCompatibleMatrix;
    private int mGenerationId;
    final Object mLock = new Object();
    private long mLockedObject;
    private String mName;
    long mNativeObject;

    public Surface() {
        this.mCanvas = new CompatibleCanvas();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Surface(long l) {
        this.mCanvas = new CompatibleCanvas();
        Object object = this.mLock;
        synchronized (object) {
            this.setNativeObjectLocked(l);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Surface(SurfaceTexture surfaceTexture) {
        this.mCanvas = new CompatibleCanvas();
        if (surfaceTexture == null) {
            throw new IllegalArgumentException("surfaceTexture must not be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mName = surfaceTexture.toString();
            this.setNativeObjectLocked(Surface.nativeCreateFromSurfaceTexture(surfaceTexture));
            return;
        }
    }

    private void checkNotReleasedLocked() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Surface has already been released.");
        }
    }

    private static native void nativeAllocateBuffers(long var0);

    private static native long nativeCreateFromSurfaceControl(long var0);

    private static native long nativeCreateFromSurfaceTexture(SurfaceTexture var0) throws OutOfResourcesException;

    private static native boolean nativeIsConsumerRunningBehind(long var0);

    private static native boolean nativeIsValid(long var0);

    private static native long nativeLockCanvas(long var0, Canvas var2, Rect var3) throws OutOfResourcesException;

    private static native long nativeReadFromParcel(long var0, Parcel var2);

    private static native void nativeRelease(long var0);

    private static native void nativeUnlockCanvasAndPost(long var0, Canvas var2);

    private static native void nativeWriteToParcel(long var0, Parcel var2);

    public static String rotationToString(int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("Invalid rotation: " + n);
            }
            case 0: {
                return "ROTATION_0";
            }
            case 1: {
                return "ROATATION_90";
            }
            case 2: {
                return "ROATATION_180";
            }
            case 3: 
        }
        return "ROATATION_270";
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setNativeObjectLocked(long l) {
        if (this.mNativeObject != l) {
            if (this.mNativeObject == 0L && l != 0L) {
                this.mCloseGuard.open("release");
            } else if (this.mNativeObject != 0L && l == 0L) {
                this.mCloseGuard.close();
            }
            this.mNativeObject = l;
            this.mGenerationId = 1 + this.mGenerationId;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void allocateBuffers() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotReleasedLocked();
            Surface.nativeAllocateBuffers(this.mNativeObject);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void copyFrom(SurfaceControl surfaceControl) {
        if (surfaceControl == null) {
            throw new IllegalArgumentException("other must not be null");
        }
        long l = surfaceControl.mNativeObject;
        if (l == 0L) {
            throw new NullPointerException("SurfaceControl native object is null. Are you using a released SurfaceControl?");
        }
        long l2 = Surface.nativeCreateFromSurfaceControl(l);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mNativeObject != 0L) {
                Surface.nativeRelease(this.mNativeObject);
            }
            this.setNativeObjectLocked(l2);
            return;
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void destroy() {
        this.release();
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.release();
            return;
        }
        finally {
            super.finalize();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getGenerationId() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mGenerationId;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isConsumerRunningBehind() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotReleasedLocked();
            return Surface.nativeIsConsumerRunningBehind(this.mNativeObject);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValid() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mNativeObject != 0L) return Surface.nativeIsValid(this.mNativeObject);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Canvas lockCanvas(Rect rect) throws OutOfResourcesException, IllegalArgumentException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotReleasedLocked();
            if (this.mLockedObject != 0L) {
                throw new IllegalArgumentException("Surface was already locked");
            }
            this.mLockedObject = Surface.nativeLockCanvas(this.mNativeObject, this.mCanvas, rect);
            return this.mCanvas;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readFromParcel(Parcel parcel) {
        if (parcel == null) {
            throw new IllegalArgumentException("source must not be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mName = parcel.readString();
            this.setNativeObjectLocked(Surface.nativeReadFromParcel(this.mNativeObject, parcel));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void release() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mNativeObject != 0L) {
                Surface.nativeRelease(this.mNativeObject);
                this.setNativeObjectLocked(0L);
            }
            return;
        }
    }

    void setCompatibilityTranslator(CompatibilityInfo.Translator translator) {
        if (translator != null) {
            float f = translator.applicationScale;
            this.mCompatibleMatrix = new Matrix();
            this.mCompatibleMatrix.setScale(f, f);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toString() {
        Object object = this.mLock;
        synchronized (object) {
            return "Surface(name=" + this.mName + ")/@0x" + Integer.toHexString(System.identityHashCode(this));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public void transferFrom(Surface surface) {
        if (surface == null) {
            throw new IllegalArgumentException("other must not be null");
        }
        if (surface != this) {
            long l;
            Object object = surface.mLock;
            synchronized (object) {
                l = surface.mNativeObject;
                surface.setNativeObjectLocked(0L);
            }
            Object object2 = this.mLock;
            synchronized (object2) {
                if (this.mNativeObject != 0L) {
                    Surface.nativeRelease(this.mNativeObject);
                }
                this.setNativeObjectLocked(l);
            }
        }
    }

    @Deprecated
    public void unlockCanvas(Canvas canvas) {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unlockCanvasAndPost(Canvas canvas) {
        if (canvas != this.mCanvas) {
            throw new IllegalArgumentException("canvas object must be the same instance that was previously returned by lockCanvas");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotReleasedLocked();
            if (this.mNativeObject != this.mLockedObject) {
                Log.w(TAG, "WARNING: Surface's mNativeObject (0x" + Long.toHexString(this.mNativeObject) + ") != mLockedObject (0x" + Long.toHexString(this.mLockedObject) + ")");
            }
            if (this.mLockedObject == 0L) {
                throw new IllegalStateException("Surface was not locked");
            }
            try {
                Surface.nativeUnlockCanvasAndPost(this.mLockedObject, canvas);
                return;
            }
            finally {
                Surface.nativeRelease(this.mLockedObject);
                this.mLockedObject = 0L;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        if (parcel == null) {
            throw new IllegalArgumentException("dest must not be null");
        }
        Object object = this.mLock;
        // MONITORENTER : object
        parcel.writeString(this.mName);
        Surface.nativeWriteToParcel(this.mNativeObject, parcel);
        // MONITOREXIT : object
        if ((n & 1) == 0) return;
        this.release();
    }

    private final class CompatibleCanvas
    extends Canvas {
        private Matrix mOrigMatrix = null;

        private CompatibleCanvas() {
        }

        @Override
        public void getMatrix(Matrix matrix) {
            super.getMatrix(matrix);
            if (this.mOrigMatrix == null) {
                this.mOrigMatrix = new Matrix();
            }
            this.mOrigMatrix.set(matrix);
        }

        @Override
        public void setMatrix(Matrix matrix) {
            if (Surface.this.mCompatibleMatrix == null || this.mOrigMatrix == null || this.mOrigMatrix.equals(matrix)) {
                super.setMatrix(matrix);
                return;
            }
            Matrix matrix2 = new Matrix(Surface.this.mCompatibleMatrix);
            matrix2.preConcat(matrix);
            super.setMatrix(matrix2);
        }
    }

    public static class OutOfResourcesException
    extends RuntimeException {
        public OutOfResourcesException() {
        }

        public OutOfResourcesException(String string2) {
            super(string2);
        }
    }
}

