/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Parcel;
import android.os.Parcelable;
import android.view.InputDevice;
import android.view.KeyEvent;
import android.view.MotionEvent;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class InputEvent
implements Parcelable {
    public static final Parcelable.Creator<InputEvent> CREATOR;
    protected static final int PARCEL_TOKEN_KEY_EVENT = 2;
    protected static final int PARCEL_TOKEN_MOTION_EVENT = 1;
    private static final boolean TRACK_RECYCLED_LOCATION;
    private static final AtomicInteger mNextSeq;
    protected boolean mRecycled;
    private RuntimeException mRecycledLocation;
    protected int mSeq = mNextSeq.getAndIncrement();

    static {
        mNextSeq = new AtomicInteger();
        CREATOR = new Parcelable.Creator<InputEvent>(){

            @Override
            public InputEvent createFromParcel(Parcel parcel) {
                int n = parcel.readInt();
                if (n == 2) {
                    return KeyEvent.createFromParcelBody(parcel);
                }
                if (n == 1) {
                    return MotionEvent.createFromParcelBody(parcel);
                }
                throw new IllegalStateException("Unexpected input event type token in parcel.");
            }

            public InputEvent[] newArray(int n) {
                return new InputEvent[n];
            }
        };
    }

    InputEvent() {
    }

    public abstract InputEvent copy();

    @Override
    public int describeContents() {
        return 0;
    }

    public final InputDevice getDevice() {
        return InputDevice.getDevice(this.getDeviceId());
    }

    public abstract int getDeviceId();

    public abstract long getEventTime();

    public abstract long getEventTimeNano();

    public int getSequenceNumber() {
        return this.mSeq;
    }

    public abstract int getSource();

    public boolean isFromSource(int n) {
        return (n & this.getSource()) == n;
    }

    public abstract boolean isTainted();

    protected void prepareForReuse() {
        this.mRecycled = false;
        this.mRecycledLocation = null;
        this.mSeq = mNextSeq.getAndIncrement();
    }

    public void recycle() {
        if (this.mRecycled) {
            throw new RuntimeException(this.toString() + " recycled twice!");
        }
        this.mRecycled = true;
    }

    public void recycleIfNeededAfterDispatch() {
        this.recycle();
    }

    public abstract void setSource(int var1);

    public abstract void setTainted(boolean var1);
}

