/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.IRemoteCallback;
import android.os.Parcel;
import android.os.RemoteException;
import android.text.TextUtils;
import android.view.IApplicationToken;
import android.view.IOnKeyguardExitResult;
import android.view.IRotationWatcher;
import android.view.IWindowSession;
import android.view.IWindowSessionCallback;
import android.view.WindowContentFrameStats;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputMethodClient;

public interface IWindowManager
extends IInterface {
    public void addAppToken(int var1, IApplicationToken var2, int var3, int var4, int var5, boolean var6, boolean var7, int var8, int var9, boolean var10, boolean var11) throws RemoteException;

    public void addWindowToken(IBinder var1, int var2) throws RemoteException;

    public void clearForcedDisplayDensity(int var1) throws RemoteException;

    public void clearForcedDisplaySize(int var1) throws RemoteException;

    public boolean clearWindowContentFrameStats(IBinder var1) throws RemoteException;

    public void closeSystemDialogs(String var1) throws RemoteException;

    public void disableKeyguard(IBinder var1, String var2) throws RemoteException;

    public void dismissKeyguard() throws RemoteException;

    public void enableScreenIfNeeded() throws RemoteException;

    public void executeAppTransition() throws RemoteException;

    public void exitKeyguardSecurely(IOnKeyguardExitResult var1) throws RemoteException;

    public void freezeRotation(int var1) throws RemoteException;

    public float getAnimationScale(int var1) throws RemoteException;

    public float[] getAnimationScales() throws RemoteException;

    public int getAppOrientation(IApplicationToken var1) throws RemoteException;

    public int getBaseDisplayDensity(int var1) throws RemoteException;

    public void getBaseDisplaySize(int var1, Point var2) throws RemoteException;

    public float getCurrentAnimatorScale() throws RemoteException;

    public Rect getDisplayMagnifiedRect(int var1) throws RemoteException;

    public int getInitialDisplayDensity(int var1) throws RemoteException;

    public void getInitialDisplaySize(int var1, Point var2) throws RemoteException;

    public int getKeyEventMetaState() throws RemoteException;

    public int getPendingAppTransition() throws RemoteException;

    public int getPreferredOptionsPanelGravity() throws RemoteException;

    public int getRotation() throws RemoteException;

    public WindowContentFrameStats getWindowContentFrameStats(IBinder var1) throws RemoteException;

    public boolean hasNavigationBar() throws RemoteException;

    public boolean inKeyguardRestrictedInputMode() throws RemoteException;

    public boolean inputMethodClientHasFocus(IInputMethodClient var1) throws RemoteException;

    public boolean isKeyguardLocked() throws RemoteException;

    public boolean isKeyguardSecure() throws RemoteException;

    public boolean isRotationFrozen() throws RemoteException;

    public boolean isSafeModeEnabled() throws RemoteException;

    public boolean isViewServerRunning() throws RemoteException;

    public void keyguardGoingAway(boolean var1, boolean var2) throws RemoteException;

    public void lockNow(Bundle var1) throws RemoteException;

    public IWindowSession openSession(IWindowSessionCallback var1, IInputMethodClient var2, IInputContext var3) throws RemoteException;

    public void overridePendingAppTransition(String var1, int var2, int var3, IRemoteCallback var4) throws RemoteException;

    public void overridePendingAppTransitionAspectScaledThumb(Bitmap var1, int var2, int var3, int var4, int var5, IRemoteCallback var6, boolean var7) throws RemoteException;

    public void overridePendingAppTransitionScaleUp(int var1, int var2, int var3, int var4) throws RemoteException;

    public void overridePendingAppTransitionThumb(Bitmap var1, int var2, int var3, IRemoteCallback var4, boolean var5) throws RemoteException;

    public void pauseKeyDispatching(IBinder var1) throws RemoteException;

    public void prepareAppTransition(int var1, boolean var2) throws RemoteException;

    public void reenableKeyguard(IBinder var1) throws RemoteException;

    public void removeAppToken(IBinder var1) throws RemoteException;

    public void removeRotationWatcher(IRotationWatcher var1) throws RemoteException;

    public void removeWindowToken(IBinder var1) throws RemoteException;

    public void resumeKeyDispatching(IBinder var1) throws RemoteException;

    public Bitmap screenshotApplications(IBinder var1, int var2, int var3, int var4, boolean var5) throws RemoteException;

    public void setAnimationScale(int var1, float var2) throws RemoteException;

    public void setAnimationScales(float[] var1) throws RemoteException;

    public void setAppGroupId(IBinder var1, int var2) throws RemoteException;

    public void setAppOrientation(IApplicationToken var1, int var2) throws RemoteException;

    public void setAppStartingWindow(IBinder var1, String var2, int var3, CompatibilityInfo var4, CharSequence var5, int var6, int var7, int var8, int var9, IBinder var10, boolean var11) throws RemoteException;

    public void setAppVisibility(IBinder var1, boolean var2) throws RemoteException;

    public void setAppWillBeHidden(IBinder var1) throws RemoteException;

    public void setEventDispatching(boolean var1) throws RemoteException;

    public void setFocusedApp(IBinder var1, boolean var2) throws RemoteException;

    public void setForcedDisplayDensity(int var1, int var2) throws RemoteException;

    public void setForcedDisplaySize(int var1, int var2, int var3) throws RemoteException;

    public void setInTouchMode(boolean var1) throws RemoteException;

    public void setNewConfiguration(Configuration var1) throws RemoteException;

    public void setOverscan(int var1, int var2, int var3, int var4, int var5) throws RemoteException;

    public void setScreenCaptureDisabled(int var1, boolean var2) throws RemoteException;

    public void setStrictModeVisualIndicatorPreference(String var1) throws RemoteException;

    public void showStrictModeViolation(boolean var1) throws RemoteException;

    public void startAppFreezingScreen(IBinder var1, int var2) throws RemoteException;

    public void startFreezingScreen(int var1, int var2) throws RemoteException;

    public boolean startViewServer(int var1) throws RemoteException;

    public void statusBarVisibilityChanged(int var1) throws RemoteException;

    public void stopAppFreezingScreen(IBinder var1, boolean var2) throws RemoteException;

    public void stopFreezingScreen() throws RemoteException;

    public boolean stopViewServer() throws RemoteException;

    public void thawRotation() throws RemoteException;

    public Configuration updateOrientationFromAppTokens(Configuration var1, IBinder var2) throws RemoteException;

    public void updateRotation(boolean var1, boolean var2) throws RemoteException;

    public int watchRotation(IRotationWatcher var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWindowManager {
        private static final String DESCRIPTOR = "android.view.IWindowManager";
        static final int TRANSACTION_addAppToken = 20;
        static final int TRANSACTION_addWindowToken = 18;
        static final int TRANSACTION_clearForcedDisplayDensity = 13;
        static final int TRANSACTION_clearForcedDisplaySize = 9;
        static final int TRANSACTION_clearWindowContentFrameStats = 74;
        static final int TRANSACTION_closeSystemDialogs = 50;
        static final int TRANSACTION_disableKeyguard = 42;
        static final int TRANSACTION_dismissKeyguard = 48;
        static final int TRANSACTION_enableScreenIfNeeded = 73;
        static final int TRANSACTION_executeAppTransition = 31;
        static final int TRANSACTION_exitKeyguardSecurely = 44;
        static final int TRANSACTION_freezeRotation = 65;
        static final int TRANSACTION_getAnimationScale = 51;
        static final int TRANSACTION_getAnimationScales = 52;
        static final int TRANSACTION_getAppOrientation = 23;
        static final int TRANSACTION_getBaseDisplayDensity = 11;
        static final int TRANSACTION_getBaseDisplaySize = 7;
        static final int TRANSACTION_getCurrentAnimatorScale = 55;
        static final int TRANSACTION_getDisplayMagnifiedRect = 77;
        static final int TRANSACTION_getInitialDisplayDensity = 10;
        static final int TRANSACTION_getInitialDisplaySize = 6;
        static final int TRANSACTION_getKeyEventMetaState = 76;
        static final int TRANSACTION_getPendingAppTransition = 26;
        static final int TRANSACTION_getPreferredOptionsPanelGravity = 64;
        static final int TRANSACTION_getRotation = 61;
        static final int TRANSACTION_getWindowContentFrameStats = 75;
        static final int TRANSACTION_hasNavigationBar = 70;
        static final int TRANSACTION_inKeyguardRestrictedInputMode = 47;
        static final int TRANSACTION_inputMethodClientHasFocus = 5;
        static final int TRANSACTION_isKeyguardLocked = 45;
        static final int TRANSACTION_isKeyguardSecure = 46;
        static final int TRANSACTION_isRotationFrozen = 67;
        static final int TRANSACTION_isSafeModeEnabled = 72;
        static final int TRANSACTION_isViewServerRunning = 3;
        static final int TRANSACTION_keyguardGoingAway = 49;
        static final int TRANSACTION_lockNow = 71;
        static final int TRANSACTION_openSession = 4;
        static final int TRANSACTION_overridePendingAppTransition = 27;
        static final int TRANSACTION_overridePendingAppTransitionAspectScaledThumb = 30;
        static final int TRANSACTION_overridePendingAppTransitionScaleUp = 28;
        static final int TRANSACTION_overridePendingAppTransitionThumb = 29;
        static final int TRANSACTION_pauseKeyDispatching = 15;
        static final int TRANSACTION_prepareAppTransition = 25;
        static final int TRANSACTION_reenableKeyguard = 43;
        static final int TRANSACTION_removeAppToken = 37;
        static final int TRANSACTION_removeRotationWatcher = 63;
        static final int TRANSACTION_removeWindowToken = 19;
        static final int TRANSACTION_resumeKeyDispatching = 16;
        static final int TRANSACTION_screenshotApplications = 68;
        static final int TRANSACTION_setAnimationScale = 53;
        static final int TRANSACTION_setAnimationScales = 54;
        static final int TRANSACTION_setAppGroupId = 21;
        static final int TRANSACTION_setAppOrientation = 22;
        static final int TRANSACTION_setAppStartingWindow = 32;
        static final int TRANSACTION_setAppVisibility = 34;
        static final int TRANSACTION_setAppWillBeHidden = 33;
        static final int TRANSACTION_setEventDispatching = 17;
        static final int TRANSACTION_setFocusedApp = 24;
        static final int TRANSACTION_setForcedDisplayDensity = 12;
        static final int TRANSACTION_setForcedDisplaySize = 8;
        static final int TRANSACTION_setInTouchMode = 56;
        static final int TRANSACTION_setNewConfiguration = 39;
        static final int TRANSACTION_setOverscan = 14;
        static final int TRANSACTION_setScreenCaptureDisabled = 59;
        static final int TRANSACTION_setStrictModeVisualIndicatorPreference = 58;
        static final int TRANSACTION_showStrictModeViolation = 57;
        static final int TRANSACTION_startAppFreezingScreen = 35;
        static final int TRANSACTION_startFreezingScreen = 40;
        static final int TRANSACTION_startViewServer = 1;
        static final int TRANSACTION_statusBarVisibilityChanged = 69;
        static final int TRANSACTION_stopAppFreezingScreen = 36;
        static final int TRANSACTION_stopFreezingScreen = 41;
        static final int TRANSACTION_stopViewServer = 2;
        static final int TRANSACTION_thawRotation = 66;
        static final int TRANSACTION_updateOrientationFromAppTokens = 38;
        static final int TRANSACTION_updateRotation = 60;
        static final int TRANSACTION_watchRotation = 62;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IWindowManager asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IWindowManager) {
                return (IWindowManager)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.startViewServer(parcel.readInt());
                    parcel2.writeNoException();
                    int n3 = bl ? 1 : 0;
                    parcel2.writeInt(n3);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.stopViewServer();
                    parcel2.writeNoException();
                    int n4 = bl ? 1 : 0;
                    parcel2.writeInt(n4);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isViewServerRunning();
                    parcel2.writeNoException();
                    int n5 = bl ? 1 : 0;
                    parcel2.writeInt(n5);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IWindowSession iWindowSession = this.openSession(IWindowSessionCallback.Stub.asInterface(parcel.readStrongBinder()), IInputMethodClient.Stub.asInterface(parcel.readStrongBinder()), IInputContext.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    IBinder iBinder = iWindowSession != null ? iWindowSession.asBinder() : null;
                    parcel2.writeStrongBinder(iBinder);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.inputMethodClientHasFocus(IInputMethodClient.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    int n6 = bl ? 1 : 0;
                    parcel2.writeInt(n6);
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n7 = parcel.readInt();
                    Point point = new Point();
                    this.getInitialDisplaySize(n7, point);
                    parcel2.writeNoException();
                    if (point != null) {
                        parcel2.writeInt(1);
                        point.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n8 = parcel.readInt();
                    Point point = new Point();
                    this.getBaseDisplaySize(n8, point);
                    parcel2.writeNoException();
                    if (point != null) {
                        parcel2.writeInt(1);
                        point.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setForcedDisplaySize(parcel.readInt(), parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.clearForcedDisplaySize(parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n9 = this.getInitialDisplayDensity(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeInt(n9);
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n10 = this.getBaseDisplayDensity(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeInt(n10);
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setForcedDisplayDensity(parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 13: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.clearForcedDisplayDensity(parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 14: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setOverscan(parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 15: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.pauseKeyDispatching(parcel.readStrongBinder());
                    parcel2.writeNoException();
                    return true;
                }
                case 16: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.resumeKeyDispatching(parcel.readStrongBinder());
                    parcel2.writeNoException();
                    return true;
                }
                case 17: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    this.setEventDispatching(bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 18: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.addWindowToken(parcel.readStrongBinder(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 19: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.removeWindowToken(parcel.readStrongBinder());
                    parcel2.writeNoException();
                    return true;
                }
                case 20: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n11 = parcel.readInt();
                    IApplicationToken iApplicationToken = IApplicationToken.Stub.asInterface(parcel.readStrongBinder());
                    int n12 = parcel.readInt();
                    int n13 = parcel.readInt();
                    int n14 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    boolean bl2 = parcel.readInt() != 0;
                    int n15 = parcel.readInt();
                    int n16 = parcel.readInt();
                    boolean bl3 = parcel.readInt() != 0;
                    boolean bl4 = parcel.readInt() != 0;
                    this.addAppToken(n11, iApplicationToken, n12, n13, n14, bl, bl2, n15, n16, bl3, bl4);
                    parcel2.writeNoException();
                    return true;
                }
                case 21: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setAppGroupId(parcel.readStrongBinder(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 22: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setAppOrientation(IApplicationToken.Stub.asInterface(parcel.readStrongBinder()), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 23: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n17 = this.getAppOrientation(IApplicationToken.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    parcel2.writeInt(n17);
                    return true;
                }
                case 24: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IBinder iBinder = parcel.readStrongBinder();
                    boolean bl = parcel.readInt() != 0;
                    this.setFocusedApp(iBinder, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 25: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n18 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    this.prepareAppTransition(n18, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 26: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n19 = this.getPendingAppTransition();
                    parcel2.writeNoException();
                    parcel2.writeInt(n19);
                    return true;
                }
                case 27: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.overridePendingAppTransition(parcel.readString(), parcel.readInt(), parcel.readInt(), IRemoteCallback.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 28: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.overridePendingAppTransitionScaleUp(parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 29: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Bitmap bitmap = parcel.readInt() != 0 ? Bitmap.CREATOR.createFromParcel(parcel) : null;
                    int n20 = parcel.readInt();
                    int n21 = parcel.readInt();
                    IRemoteCallback iRemoteCallback = IRemoteCallback.Stub.asInterface(parcel.readStrongBinder());
                    boolean bl = parcel.readInt() != 0;
                    this.overridePendingAppTransitionThumb(bitmap, n20, n21, iRemoteCallback, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 30: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Bitmap bitmap = parcel.readInt() != 0 ? Bitmap.CREATOR.createFromParcel(parcel) : null;
                    int n22 = parcel.readInt();
                    int n23 = parcel.readInt();
                    int n24 = parcel.readInt();
                    int n25 = parcel.readInt();
                    IRemoteCallback iRemoteCallback = IRemoteCallback.Stub.asInterface(parcel.readStrongBinder());
                    boolean bl = parcel.readInt() != 0;
                    this.overridePendingAppTransitionAspectScaledThumb(bitmap, n22, n23, n24, n25, iRemoteCallback, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 31: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.executeAppTransition();
                    parcel2.writeNoException();
                    return true;
                }
                case 32: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IBinder iBinder = parcel.readStrongBinder();
                    String string2 = parcel.readString();
                    int n26 = parcel.readInt();
                    CompatibilityInfo compatibilityInfo = parcel.readInt() != 0 ? CompatibilityInfo.CREATOR.createFromParcel(parcel) : null;
                    CharSequence charSequence = parcel.readInt() != 0 ? TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel) : null;
                    int n27 = parcel.readInt();
                    int n28 = parcel.readInt();
                    int n29 = parcel.readInt();
                    int n30 = parcel.readInt();
                    IBinder iBinder2 = parcel.readStrongBinder();
                    boolean bl = parcel.readInt() != 0;
                    this.setAppStartingWindow(iBinder, string2, n26, compatibilityInfo, charSequence, n27, n28, n29, n30, iBinder2, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 33: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setAppWillBeHidden(parcel.readStrongBinder());
                    parcel2.writeNoException();
                    return true;
                }
                case 34: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IBinder iBinder = parcel.readStrongBinder();
                    boolean bl = parcel.readInt() != 0;
                    this.setAppVisibility(iBinder, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 35: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.startAppFreezingScreen(parcel.readStrongBinder(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 36: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IBinder iBinder = parcel.readStrongBinder();
                    boolean bl = parcel.readInt() != 0;
                    this.stopAppFreezingScreen(iBinder, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 37: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.removeAppToken(parcel.readStrongBinder());
                    parcel2.writeNoException();
                    return true;
                }
                case 38: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Configuration configuration = parcel.readInt() != 0 ? Configuration.CREATOR.createFromParcel(parcel) : null;
                    Configuration configuration2 = this.updateOrientationFromAppTokens(configuration, parcel.readStrongBinder());
                    parcel2.writeNoException();
                    if (configuration2 != null) {
                        parcel2.writeInt(1);
                        configuration2.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 39: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Configuration configuration = parcel.readInt() != 0 ? Configuration.CREATOR.createFromParcel(parcel) : null;
                    this.setNewConfiguration(configuration);
                    parcel2.writeNoException();
                    return true;
                }
                case 40: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.startFreezingScreen(parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 41: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.stopFreezingScreen();
                    parcel2.writeNoException();
                    return true;
                }
                case 42: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.disableKeyguard(parcel.readStrongBinder(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 43: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.reenableKeyguard(parcel.readStrongBinder());
                    parcel2.writeNoException();
                    return true;
                }
                case 44: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.exitKeyguardSecurely(IOnKeyguardExitResult.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 45: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isKeyguardLocked();
                    parcel2.writeNoException();
                    int n31 = bl ? 1 : 0;
                    parcel2.writeInt(n31);
                    return true;
                }
                case 46: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isKeyguardSecure();
                    parcel2.writeNoException();
                    int n32 = bl ? 1 : 0;
                    parcel2.writeInt(n32);
                    return true;
                }
                case 47: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.inKeyguardRestrictedInputMode();
                    parcel2.writeNoException();
                    int n33 = bl ? 1 : 0;
                    parcel2.writeInt(n33);
                    return true;
                }
                case 48: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.dismissKeyguard();
                    parcel2.writeNoException();
                    return true;
                }
                case 49: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    boolean bl5 = parcel.readInt() != 0;
                    this.keyguardGoingAway(bl, bl5);
                    parcel2.writeNoException();
                    return true;
                }
                case 50: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.closeSystemDialogs(parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 51: {
                    parcel.enforceInterface(DESCRIPTOR);
                    float f = this.getAnimationScale(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeFloat(f);
                    return true;
                }
                case 52: {
                    parcel.enforceInterface(DESCRIPTOR);
                    float[] fArray = this.getAnimationScales();
                    parcel2.writeNoException();
                    parcel2.writeFloatArray(fArray);
                    return true;
                }
                case 53: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setAnimationScale(parcel.readInt(), parcel.readFloat());
                    parcel2.writeNoException();
                    return true;
                }
                case 54: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setAnimationScales(parcel.createFloatArray());
                    parcel2.writeNoException();
                    return true;
                }
                case 55: {
                    parcel.enforceInterface(DESCRIPTOR);
                    float f = this.getCurrentAnimatorScale();
                    parcel2.writeNoException();
                    parcel2.writeFloat(f);
                    return true;
                }
                case 56: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    this.setInTouchMode(bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 57: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    this.showStrictModeViolation(bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 58: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setStrictModeVisualIndicatorPreference(parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 59: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n34 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    this.setScreenCaptureDisabled(n34, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 60: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    boolean bl6 = parcel.readInt() != 0;
                    this.updateRotation(bl, bl6);
                    parcel2.writeNoException();
                    return true;
                }
                case 61: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n35 = this.getRotation();
                    parcel2.writeNoException();
                    parcel2.writeInt(n35);
                    return true;
                }
                case 62: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n36 = this.watchRotation(IRotationWatcher.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    parcel2.writeInt(n36);
                    return true;
                }
                case 63: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.removeRotationWatcher(IRotationWatcher.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 64: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n37 = this.getPreferredOptionsPanelGravity();
                    parcel2.writeNoException();
                    parcel2.writeInt(n37);
                    return true;
                }
                case 65: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.freezeRotation(parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 66: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.thawRotation();
                    parcel2.writeNoException();
                    return true;
                }
                case 67: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isRotationFrozen();
                    parcel2.writeNoException();
                    int n38 = bl ? 1 : 0;
                    parcel2.writeInt(n38);
                    return true;
                }
                case 68: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IBinder iBinder = parcel.readStrongBinder();
                    int n39 = parcel.readInt();
                    int n40 = parcel.readInt();
                    int n41 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    Bitmap bitmap = this.screenshotApplications(iBinder, n39, n40, n41, bl);
                    parcel2.writeNoException();
                    if (bitmap != null) {
                        parcel2.writeInt(1);
                        bitmap.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 69: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.statusBarVisibilityChanged(parcel.readInt());
                    return true;
                }
                case 70: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.hasNavigationBar();
                    parcel2.writeNoException();
                    int n42 = bl ? 1 : 0;
                    parcel2.writeInt(n42);
                    return true;
                }
                case 71: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Bundle bundle = parcel.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel) : null;
                    this.lockNow(bundle);
                    parcel2.writeNoException();
                    return true;
                }
                case 72: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isSafeModeEnabled();
                    parcel2.writeNoException();
                    int n43 = bl ? 1 : 0;
                    parcel2.writeInt(n43);
                    return true;
                }
                case 73: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.enableScreenIfNeeded();
                    parcel2.writeNoException();
                    return true;
                }
                case 74: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.clearWindowContentFrameStats(parcel.readStrongBinder());
                    parcel2.writeNoException();
                    int n44 = bl ? 1 : 0;
                    parcel2.writeInt(n44);
                    return true;
                }
                case 75: {
                    parcel.enforceInterface(DESCRIPTOR);
                    WindowContentFrameStats windowContentFrameStats = this.getWindowContentFrameStats(parcel.readStrongBinder());
                    parcel2.writeNoException();
                    if (windowContentFrameStats != null) {
                        parcel2.writeInt(1);
                        windowContentFrameStats.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 76: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n45 = this.getKeyEventMetaState();
                    parcel2.writeNoException();
                    parcel2.writeInt(n45);
                    return true;
                }
                case 77: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            Rect rect = this.getDisplayMagnifiedRect(parcel.readInt());
            parcel2.writeNoException();
            if (rect != null) {
                parcel2.writeInt(1);
                rect.writeToParcel(parcel2, 1);
                return true;
            }
            parcel2.writeInt(0);
            return true;
        }

        private static class Proxy
        implements IWindowManager {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void addAppToken(int n, IApplicationToken iApplicationToken, int n2, int n3, int n4, boolean bl, boolean bl2, int n5, int n6, boolean bl3, boolean bl4) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    IBinder iBinder = iApplicationToken != null ? iApplicationToken.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    parcel.writeInt(n4);
                    int n7 = bl ? 1 : 0;
                    parcel.writeInt(n7);
                    int n8 = bl2 ? 1 : 0;
                    parcel.writeInt(n8);
                    parcel.writeInt(n5);
                    parcel.writeInt(n6);
                    int n9 = bl3 ? 1 : 0;
                    parcel.writeInt(n9);
                    int n10 = bl4 ? 1 : 0;
                    parcel.writeInt(n10);
                    this.mRemote.transact(20, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void addWindowToken(IBinder iBinder, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    this.mRemote.transact(18, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            @Override
            public void clearForcedDisplayDensity(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(13, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void clearForcedDisplaySize(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean clearWindowContentFrameStats(IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(74, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void closeSystemDialogs(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(50, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void disableKeyguard(IBinder iBinder, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeString(string2);
                    this.mRemote.transact(42, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void dismissKeyguard() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(48, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void enableScreenIfNeeded() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(73, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void executeAppTransition() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(31, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void exitKeyguardSecurely(IOnKeyguardExitResult iOnKeyguardExitResult) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iOnKeyguardExitResult != null ? iOnKeyguardExitResult.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(44, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void freezeRotation(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(65, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public float getAnimationScale(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(51, parcel, parcel2, 0);
                    parcel2.readException();
                    float f = parcel2.readFloat();
                    return f;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public float[] getAnimationScales() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(52, parcel, parcel2, 0);
                    parcel2.readException();
                    float[] fArray = parcel2.createFloatArray();
                    return fArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int getAppOrientation(IApplicationToken iApplicationToken) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iApplicationToken != null ? iApplicationToken.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(23, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    parcel2.recycle();
                    parcel.recycle();
                    return n;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public int getBaseDisplayDensity(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void getBaseDisplaySize(int n, Point point) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    if (parcel2.readInt() != 0) {
                        point.readFromParcel(parcel2);
                    }
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public float getCurrentAnimatorScale() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(55, parcel, parcel2, 0);
                    parcel2.readException();
                    float f = parcel2.readFloat();
                    return f;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Rect getDisplayMagnifiedRect(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(77, parcel, parcel2, 0);
                    parcel2.readException();
                    Rect rect = parcel2.readInt() != 0 ? Rect.CREATOR.createFromParcel(parcel2) : null;
                    return rect;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getInitialDisplayDensity(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void getInitialDisplaySize(int n, Point point) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    if (parcel2.readInt() != 0) {
                        point.readFromParcel(parcel2);
                    }
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public int getKeyEventMetaState() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(76, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getPendingAppTransition() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(26, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getPreferredOptionsPanelGravity() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(64, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getRotation() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(61, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public WindowContentFrameStats getWindowContentFrameStats(IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(75, parcel, parcel2, 0);
                    parcel2.readException();
                    WindowContentFrameStats windowContentFrameStats = parcel2.readInt() != 0 ? WindowContentFrameStats.CREATOR.createFromParcel(parcel2) : null;
                    return windowContentFrameStats;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean hasNavigationBar() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(70, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean inKeyguardRestrictedInputMode() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(47, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean inputMethodClientHasFocus(IInputMethodClient iInputMethodClient) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iInputMethodClient != null ? iInputMethodClient.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isKeyguardLocked() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(45, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isKeyguardSecure() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(46, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isRotationFrozen() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(67, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isSafeModeEnabled() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(72, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isViewServerRunning() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void keyguardGoingAway(boolean bl, boolean bl2) throws RemoteException {
                int n = 1;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    int n2 = bl ? n : 0;
                    parcel.writeInt(n2);
                    if (!bl2) {
                        n = 0;
                    }
                    parcel.writeInt(n);
                    this.mRemote.transact(49, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void lockNow(Bundle bundle) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(71, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public IWindowSession openSession(IWindowSessionCallback iWindowSessionCallback, IInputMethodClient iInputMethodClient, IInputContext iInputContext) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iWindowSessionCallback != null ? iWindowSessionCallback.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    IBinder iBinder2 = iInputMethodClient != null ? iInputMethodClient.asBinder() : null;
                    parcel.writeStrongBinder(iBinder2);
                    IBinder iBinder3 = null;
                    if (iInputContext != null) {
                        iBinder3 = iInputContext.asBinder();
                    }
                    parcel.writeStrongBinder(iBinder3);
                    this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    IWindowSession iWindowSession = IWindowSession.Stub.asInterface(parcel2.readStrongBinder());
                    parcel2.recycle();
                    parcel.recycle();
                    return iWindowSession;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void overridePendingAppTransition(String string2, int n, int n2, IRemoteCallback iRemoteCallback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    IBinder iBinder = iRemoteCallback != null ? iRemoteCallback.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(27, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void overridePendingAppTransitionAspectScaledThumb(Bitmap bitmap, int n, int n2, int n3, int n4, IRemoteCallback iRemoteCallback, boolean bl) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                int n5;
                block6: {
                    block5: {
                        n5 = 1;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            if (bitmap != null) {
                                parcel2.writeInt(1);
                                bitmap.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            parcel2.writeInt(n);
                            parcel2.writeInt(n2);
                            parcel2.writeInt(n3);
                            parcel2.writeInt(n4);
                            IBinder iBinder = iRemoteCallback != null ? iRemoteCallback.asBinder() : null;
                            parcel2.writeStrongBinder(iBinder);
                            if (!bl) break block5;
                            break block6;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    n5 = 0;
                }
                parcel2.writeInt(n5);
                this.mRemote.transact(30, parcel2, parcel, 0);
                parcel.readException();
                parcel.recycle();
                parcel2.recycle();
            }

            @Override
            public void overridePendingAppTransitionScaleUp(int n, int n2, int n3, int n4) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    parcel.writeInt(n4);
                    this.mRemote.transact(28, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void overridePendingAppTransitionThumb(Bitmap bitmap, int n, int n2, IRemoteCallback iRemoteCallback, boolean bl) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                int n3;
                block6: {
                    block5: {
                        n3 = 1;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            if (bitmap != null) {
                                parcel2.writeInt(1);
                                bitmap.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            parcel2.writeInt(n);
                            parcel2.writeInt(n2);
                            IBinder iBinder = iRemoteCallback != null ? iRemoteCallback.asBinder() : null;
                            parcel2.writeStrongBinder(iBinder);
                            if (!bl) break block5;
                            break block6;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    n3 = 0;
                }
                parcel2.writeInt(n3);
                this.mRemote.transact(29, parcel2, parcel, 0);
                parcel.readException();
                parcel.recycle();
                parcel2.recycle();
            }

            @Override
            public void pauseKeyDispatching(IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(15, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void prepareAppTransition(int n, boolean bl) throws RemoteException {
                int n2;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeInt(n);
                    n2 = 0;
                    if (!bl) break block4;
                    n2 = 1;
                }
                try {
                    parcel2.writeInt(n2);
                    this.mRemote.transact(25, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void reenableKeyguard(IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(43, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void removeAppToken(IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(37, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void removeRotationWatcher(IRotationWatcher iRotationWatcher) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iRotationWatcher != null ? iRotationWatcher.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(63, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void removeWindowToken(IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(19, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void resumeKeyDispatching(IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(16, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Bitmap screenshotApplications(IBinder iBinder, int n, int n2, int n3, boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    int n4 = 0;
                    if (bl) {
                        n4 = 1;
                    }
                    parcel.writeInt(n4);
                    this.mRemote.transact(68, parcel, parcel2, 0);
                    parcel2.readException();
                    Bitmap bitmap = parcel2.readInt() != 0 ? Bitmap.CREATOR.createFromParcel(parcel2) : null;
                    return bitmap;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setAnimationScale(int n, float f) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeFloat(f);
                    this.mRemote.transact(53, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setAnimationScales(float[] fArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeFloatArray(fArray);
                    this.mRemote.transact(54, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setAppGroupId(IBinder iBinder, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    this.mRemote.transact(21, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setAppOrientation(IApplicationToken iApplicationToken, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iApplicationToken != null ? iApplicationToken.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    this.mRemote.transact(22, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setAppStartingWindow(IBinder iBinder, String string2, int n, CompatibilityInfo compatibilityInfo, CharSequence charSequence, int n2, int n3, int n4, int n5, IBinder iBinder2, boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    if (compatibilityInfo != null) {
                        parcel.writeInt(1);
                        compatibilityInfo.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (charSequence != null) {
                        parcel.writeInt(1);
                        TextUtils.writeToParcel(charSequence, parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    parcel.writeInt(n4);
                    parcel.writeInt(n5);
                    parcel.writeStrongBinder(iBinder2);
                    int n6 = bl ? 1 : 0;
                    parcel.writeInt(n6);
                    this.mRemote.transact(32, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void setAppVisibility(IBinder iBinder, boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeStrongBinder(iBinder);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(34, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void setAppWillBeHidden(IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(33, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setEventDispatching(boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(17, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void setFocusedApp(IBinder iBinder, boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeStrongBinder(iBinder);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(24, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void setForcedDisplayDensity(int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setForcedDisplaySize(int n, int n2, int n3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    this.mRemote.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setInTouchMode(boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(56, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setNewConfiguration(Configuration configuration) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (configuration != null) {
                        parcel.writeInt(1);
                        configuration.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(39, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setOverscan(int n, int n2, int n3, int n4, int n5) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    parcel.writeInt(n4);
                    parcel.writeInt(n5);
                    this.mRemote.transact(14, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setScreenCaptureDisabled(int n, boolean bl) throws RemoteException {
                int n2;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeInt(n);
                    n2 = 0;
                    if (!bl) break block4;
                    n2 = 1;
                }
                try {
                    parcel2.writeInt(n2);
                    this.mRemote.transact(59, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void setStrictModeVisualIndicatorPreference(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(58, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void showStrictModeViolation(boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(57, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void startAppFreezingScreen(IBinder iBinder, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    this.mRemote.transact(35, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void startFreezingScreen(int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(40, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean startViewServer(int n) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block3: {
                    block2: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            parcel2.writeInt(n);
                            this.mRemote.transact(1, parcel2, parcel, 0);
                            parcel.readException();
                            int n2 = parcel.readInt();
                            if (n2 == 0) break block2;
                            break block3;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }

            @Override
            public void statusBarVisibilityChanged(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(69, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void stopAppFreezingScreen(IBinder iBinder, boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeStrongBinder(iBinder);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(36, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void stopFreezingScreen() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(41, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean stopViewServer() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void thawRotation() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(66, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Configuration updateOrientationFromAppTokens(Configuration configuration, IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (configuration != null) {
                        parcel.writeInt(1);
                        configuration.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(38, parcel, parcel2, 0);
                    parcel2.readException();
                    Configuration configuration2 = parcel2.readInt() != 0 ? Configuration.CREATOR.createFromParcel(parcel2) : null;
                    return configuration2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void updateRotation(boolean bl, boolean bl2) throws RemoteException {
                int n = 1;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    int n2 = bl ? n : 0;
                    parcel.writeInt(n2);
                    if (!bl2) {
                        n = 0;
                    }
                    parcel.writeInt(n);
                    this.mRemote.transact(60, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int watchRotation(IRotationWatcher iRotationWatcher) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iRotationWatcher != null ? iRotationWatcher.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(62, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    parcel2.recycle();
                    parcel.recycle();
                    return n;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }
        }
    }
}

