/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.ComponentCallbacks;
import android.content.res.Configuration;
import android.view.ViewRootImpl;
import java.text.BreakIterator;
import java.util.Locale;

public final class AccessibilityIterators {

    public static abstract class AbstractTextSegmentIterator
    implements TextSegmentIterator {
        private final int[] mSegment = new int[2];
        protected String mText;

        protected int[] getRange(int n, int n2) {
            if (n < 0 || n2 < 0 || n == n2) {
                return null;
            }
            this.mSegment[0] = n;
            this.mSegment[1] = n2;
            return this.mSegment;
        }

        public void initialize(String string2) {
            this.mText = string2;
        }
    }

    static class CharacterTextSegmentIterator
    extends AbstractTextSegmentIterator
    implements ComponentCallbacks {
        private static CharacterTextSegmentIterator sInstance;
        protected BreakIterator mImpl;
        private Locale mLocale;

        private CharacterTextSegmentIterator(Locale locale) {
            this.mLocale = locale;
            this.onLocaleChanged(locale);
            ViewRootImpl.addConfigCallback(this);
        }

        public static CharacterTextSegmentIterator getInstance(Locale locale) {
            if (sInstance == null) {
                sInstance = new CharacterTextSegmentIterator(locale);
            }
            return sInstance;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int[] following(int n) {
            int n2;
            int n3;
            block6: {
                block5: {
                    int n4 = this.mText.length();
                    if (n4 <= 0 || n >= n4) break block5;
                    n3 = n;
                    if (n3 < 0) {
                        n3 = 0;
                    }
                    while (!this.mImpl.isBoundary(n3)) {
                        if ((n3 = this.mImpl.following(n3)) != -1) continue;
                        return null;
                    }
                    n2 = this.mImpl.following(n3);
                    if (n2 != -1) break block6;
                }
                return null;
            }
            return this.getRange(n3, n2);
        }

        @Override
        public void initialize(String string2) {
            super.initialize(string2);
            this.mImpl.setText(string2);
        }

        @Override
        public void onConfigurationChanged(Configuration configuration) {
            Locale locale = configuration.locale;
            if (!this.mLocale.equals(locale)) {
                this.mLocale = locale;
                this.onLocaleChanged(locale);
            }
        }

        protected void onLocaleChanged(Locale locale) {
            this.mImpl = BreakIterator.getCharacterInstance(locale);
        }

        @Override
        public void onLowMemory() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int[] preceding(int n) {
            int n2;
            int n3;
            block6: {
                block5: {
                    int n4 = this.mText.length();
                    if (n4 <= 0 || n <= 0) break block5;
                    n3 = n;
                    if (n3 > n4) {
                        n3 = n4;
                    }
                    while (!this.mImpl.isBoundary(n3)) {
                        if ((n3 = this.mImpl.preceding(n3)) != -1) continue;
                        return null;
                    }
                    n2 = this.mImpl.preceding(n3);
                    if (n2 != -1) break block6;
                }
                return null;
            }
            return this.getRange(n2, n3);
        }
    }

    static class ParagraphTextSegmentIterator
    extends AbstractTextSegmentIterator {
        private static ParagraphTextSegmentIterator sInstance;

        ParagraphTextSegmentIterator() {
        }

        public static ParagraphTextSegmentIterator getInstance() {
            if (sInstance == null) {
                sInstance = new ParagraphTextSegmentIterator();
            }
            return sInstance;
        }

        private boolean isEndBoundary(int n) {
            return n > 0 && this.mText.charAt(n - 1) != '\n' && (n == this.mText.length() || this.mText.charAt(n) == '\n');
        }

        private boolean isStartBoundary(int n) {
            return this.mText.charAt(n) != '\n' && (n == 0 || this.mText.charAt(n - 1) == '\n');
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int[] following(int n) {
            int n2;
            int n3;
            int n4;
            block7: {
                block6: {
                    n4 = this.mText.length();
                    if (n4 <= 0 || n >= n4) break block6;
                    n3 = n;
                    if (n3 < 0) {
                        n3 = 0;
                    }
                    while (n3 < n4 && this.mText.charAt(n3) == '\n' && !this.isStartBoundary(n3)) {
                        ++n3;
                    }
                    if (n3 < n4) break block7;
                }
                return null;
            }
            for (n2 = n3 + 1; n2 < n4 && !this.isEndBoundary(n2); ++n2) {
            }
            return this.getRange(n3, n2);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int[] preceding(int n) {
            int n2;
            int n3;
            block7: {
                block6: {
                    int n4 = this.mText.length();
                    if (n4 <= 0 || n <= 0) break block6;
                    n3 = n;
                    if (n3 > n4) {
                        n3 = n4;
                    }
                    while (n3 > 0 && this.mText.charAt(n3 - 1) == '\n' && !this.isEndBoundary(n3)) {
                        --n3;
                    }
                    if (n3 > 0) break block7;
                }
                return null;
            }
            for (n2 = n3 - 1; n2 > 0 && !this.isStartBoundary(n2); --n2) {
            }
            return this.getRange(n2, n3);
        }
    }

    public static interface TextSegmentIterator {
        public int[] following(int var1);

        public int[] preceding(int var1);
    }

    static class WordTextSegmentIterator
    extends CharacterTextSegmentIterator {
        private static WordTextSegmentIterator sInstance;

        private WordTextSegmentIterator(Locale locale) {
            super(locale);
        }

        public static WordTextSegmentIterator getInstance(Locale locale) {
            if (sInstance == null) {
                sInstance = new WordTextSegmentIterator(locale);
            }
            return sInstance;
        }

        private boolean isEndBoundary(int n) {
            return n > 0 && this.isLetterOrDigit(n - 1) && (n == this.mText.length() || !this.isLetterOrDigit(n));
        }

        private boolean isLetterOrDigit(int n) {
            if (n >= 0 && n < this.mText.length()) {
                return Character.isLetterOrDigit(this.mText.codePointAt(n));
            }
            return false;
        }

        private boolean isStartBoundary(int n) {
            return this.isLetterOrDigit(n) && (n == 0 || !this.isLetterOrDigit(n - 1));
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int[] following(int n) {
            int n2;
            int n3;
            block6: {
                block5: {
                    if (this.mText.length() <= 0 || n >= this.mText.length()) break block5;
                    n3 = n;
                    if (n3 < 0) {
                        n3 = 0;
                    }
                    while (!this.isLetterOrDigit(n3) && !this.isStartBoundary(n3)) {
                        if ((n3 = this.mImpl.following(n3)) != -1) continue;
                        return null;
                    }
                    n2 = this.mImpl.following(n3);
                    if (n2 != -1 && this.isEndBoundary(n2)) break block6;
                }
                return null;
            }
            return this.getRange(n3, n2);
        }

        @Override
        protected void onLocaleChanged(Locale locale) {
            this.mImpl = BreakIterator.getWordInstance(locale);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int[] preceding(int n) {
            int n2;
            int n3;
            block6: {
                block5: {
                    int n4 = this.mText.length();
                    if (n4 <= 0 || n <= 0) break block5;
                    n3 = n;
                    if (n3 > n4) {
                        n3 = n4;
                    }
                    while (n3 > 0 && !this.isLetterOrDigit(n3 - 1) && !this.isEndBoundary(n3)) {
                        if ((n3 = this.mImpl.preceding(n3)) != -1) continue;
                        return null;
                    }
                    n2 = this.mImpl.preceding(n3);
                    if (n2 != -1 && this.isStartBoundary(n2)) break block6;
                }
                return null;
            }
            return this.getRange(n2, n3);
        }
    }
}

