/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.content.res.Resources;
import android.os.SystemClock;
import android.util.Log;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import libcore.util.ZoneInfoDB;
import org.xmlpull.v1.XmlPullParserException;

public class TimeUtils {
    private static final boolean DBG = false;
    public static final int HUNDRED_DAY_FIELD_LEN = 19;
    private static final long LARGEST_DURATION = 86399999999L;
    public static final long NANOS_PER_MS = 1000000L;
    private static final int SECONDS_PER_DAY = 86400;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final String TAG = "TimeUtils";
    private static char[] sFormatStr;
    private static final Object sFormatSync;
    private static String sLastCountry;
    private static final Object sLastLockObj;
    private static String sLastUniqueCountry;
    private static final Object sLastUniqueLockObj;
    private static ArrayList<TimeZone> sLastUniqueZoneOffsets;
    private static ArrayList<TimeZone> sLastZones;

    static {
        sLastLockObj = new Object();
        sLastZones = null;
        sLastCountry = null;
        sLastUniqueLockObj = new Object();
        sLastUniqueZoneOffsets = null;
        sLastUniqueCountry = null;
        sFormatSync = new Object();
        sFormatStr = new char[24];
    }

    private static int accumField(int n, int n2, boolean bl, int n3) {
        if (n > 99 || bl && n3 >= 3) {
            return n2 + 3;
        }
        if (n > 9 || bl && n3 >= 2) {
            return n2 + 2;
        }
        if (bl || n > 0) {
            return n2 + 1;
        }
        return 0;
    }

    public static void formatDuration(long l, long l2, PrintWriter printWriter) {
        if (l == 0L) {
            printWriter.print("--");
            return;
        }
        TimeUtils.formatDuration(l - l2, printWriter, 0);
    }

    public static void formatDuration(long l, PrintWriter printWriter) {
        TimeUtils.formatDuration(l, printWriter, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void formatDuration(long l, PrintWriter printWriter, int n) {
        Object object = sFormatSync;
        synchronized (object) {
            int n2 = TimeUtils.formatDurationLocked(l, n);
            printWriter.print(new String(sFormatStr, 0, n2));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void formatDuration(long l, StringBuilder stringBuilder) {
        Object object = sFormatSync;
        synchronized (object) {
            int n = TimeUtils.formatDurationLocked(l, 0);
            stringBuilder.append(sFormatStr, 0, n);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int formatDurationLocked(long l, int n) {
        int n2;
        int n3;
        if (sFormatStr.length < n) {
            sFormatStr = new char[n];
        }
        char[] cArray = sFormatStr;
        if (l == 0L) {
            int n4 = n - 1;
            int n5 = 0;
            while (true) {
                if (n5 >= n4) {
                    cArray[n5] = 48;
                    return n5 + 1;
                }
                int n6 = n5 + 1;
                cArray[n5] = 32;
                n5 = n6;
            }
        }
        if (l > 0L) {
            n3 = 43;
        } else {
            n3 = 45;
            l = -l;
        }
        if (l > 86399999999L) {
            l = 86399999999L;
        }
        int n7 = (int)(l % 1000L);
        int n8 = n2 = (int)Math.floor(l / 1000L);
        int n9 = 0;
        if (n8 > 86400) {
            n9 = n2 / 86400;
            n2 -= 86400 * n9;
        }
        int n10 = n2;
        int n11 = 0;
        if (n10 > 3600) {
            n11 = n2 / 3600;
            n2 -= n11 * 3600;
        }
        int n12 = n2;
        int n13 = 0;
        if (n12 > 60) {
            n13 = n2 / 60;
            n2 -= n13 * 60;
        }
        int n14 = 0;
        if (n != 0) {
            int n15 = TimeUtils.accumField(n9, 1, false, 0);
            boolean bl = n15 > 0;
            int n16 = n15 + TimeUtils.accumField(n11, 1, bl, 2);
            boolean bl2 = n16 > 0;
            int n17 = n16 + TimeUtils.accumField(n13, 1, bl2, 2);
            boolean bl3 = n17 > 0;
            int n18 = n17 + TimeUtils.accumField(n2, 1, bl3, 2);
            int n19 = n18 > 0 ? 3 : 0;
            for (int i = n18 + (1 + TimeUtils.accumField(n7, 2, true, n19)); i < n; ++n14, ++i) {
                cArray[n14] = 32;
            }
        }
        cArray[n14] = n3;
        int n20 = n14 + 1;
        boolean bl = n != 0;
        int n21 = TimeUtils.printField(cArray, n9, 'd', n20, false, 0);
        boolean bl4 = n21 != n20;
        int n22 = bl ? 2 : 0;
        int n23 = TimeUtils.printField(cArray, n11, 'h', n21, bl4, n22);
        boolean bl5 = n23 != n20;
        int n24 = bl ? 2 : 0;
        int n25 = TimeUtils.printField(cArray, n13, 'm', n23, bl5, n24);
        boolean bl6 = n25 != n20;
        int n26 = bl ? 2 : 0;
        int n27 = TimeUtils.printField(cArray, n2, 's', n25, bl6, n26);
        int n28 = bl && n27 != n20 ? 3 : 0;
        int n29 = TimeUtils.printField(cArray, n7, 'm', n27, true, n28);
        cArray[n29] = 115;
        return n29 + 1;
    }

    public static String formatUptime(long l) {
        long l2 = l - SystemClock.uptimeMillis();
        if (l2 > 0L) {
            return l + " (in " + l2 + " ms)";
        }
        if (l2 < 0L) {
            return l + " (" + -l2 + " ms ago)";
        }
        return l + " (now)";
    }

    public static TimeZone getTimeZone(int n, boolean bl, long l, String string2) {
        TimeZone timeZone = null;
        Date date = new Date(l);
        TimeZone timeZone2 = TimeZone.getDefault();
        String string3 = timeZone2.getID();
        int n2 = timeZone2.getOffset(l);
        boolean bl2 = timeZone2.inDaylightTime(date);
        for (TimeZone timeZone3 : TimeUtils.getTimeZones(string2)) {
            if (timeZone3.getID().equals(string3) && n2 == n && bl2 == bl) {
                return timeZone2;
            }
            if (timeZone != null || timeZone3.getOffset(l) != n || timeZone3.inDaylightTime(date) != bl) continue;
            timeZone = timeZone3;
        }
        return timeZone;
    }

    public static String getTimeZoneDatabaseVersion() {
        return ZoneInfoDB.getInstance().getVersion();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ArrayList<TimeZone> getTimeZones(String var0) {
        var1_1 = TimeUtils.sLastLockObj;
        synchronized (var1_1) {
            if (var0 != null && var0.equals(TimeUtils.sLastCountry)) {
                return TimeUtils.sLastZones;
            }
        }
        var3_3 = new ArrayList<TimeZone>();
        if (var0 == null) return var3_3;
        var4_4 = Resources.getSystem().getXml(0x1110014);
        try {
            XmlUtils.beginDocument(var4_4, "timezones");
            while (true) {
                XmlUtils.nextElement(var4_4);
                var13_5 = var4_4.getName();
                if (var13_5 == null || !(var14_6 = var13_5.equals("timezone"))) {
                    var4_4.close();
                    break;
                }
                if (!var0.equals(var4_4.getAttributeValue(null, "code")) || var4_4.next() != 4 || (var15_7 = TimeZone.getTimeZone(var4_4.getText())).getID().startsWith("GMT")) continue;
                var3_3.add(var15_7);
                continue;
                break;
            }
        }
        catch (XmlPullParserException var11_10) {
            Log.e("TimeUtils", "Got xml parser exception getTimeZone('" + var0 + "'): e=", var11_10);
            var4_4.close();
        }
        catch (IOException var6_11) {
            Log.e("TimeUtils", "Got IO exception getTimeZone('" + var0 + "'): e=", var6_11);
        }
lbl34:
        // 2 sources

        while (true) {
            var8_8 = TimeUtils.sLastLockObj;
            synchronized (var8_8) {
                TimeUtils.sLastZones = var3_3;
                TimeUtils.sLastCountry = var0;
                return TimeUtils.sLastZones;
            }
            break;
        }
        finally {
            var4_4.close();
            ** continue;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ArrayList<TimeZone> getTimeZonesWithUniqueOffsets(String string2) {
        Object object = sLastUniqueLockObj;
        synchronized (object) {
            if (string2 != null && string2.equals(sLastUniqueCountry)) {
                return sLastUniqueZoneOffsets;
            }
        }
        ArrayList<TimeZone> arrayList = TimeUtils.getTimeZones(string2);
        ArrayList<TimeZone> arrayList2 = new ArrayList<TimeZone>();
        Iterator iterator = arrayList.iterator();
        block5: while (true) {
            if (!iterator.hasNext()) {
                Object object2 = sLastUniqueLockObj;
                synchronized (object2) {
                    sLastUniqueZoneOffsets = arrayList2;
                    sLastUniqueCountry = string2;
                    return sLastUniqueZoneOffsets;
                }
            }
            TimeZone timeZone = (TimeZone)iterator.next();
            int n = 0;
            while (true) {
                block13: {
                    boolean bl;
                    block12: {
                        int n2 = arrayList2.size();
                        bl = false;
                        if (n >= n2) break block12;
                        if (((TimeZone)arrayList2.get(n)).getRawOffset() != timeZone.getRawOffset()) break block13;
                        bl = true;
                    }
                    if (bl) continue block5;
                    arrayList2.add(timeZone);
                    continue block5;
                }
                ++n;
            }
            break;
        }
    }

    public static String logTimeOfDay(long l) {
        Calendar calendar = Calendar.getInstance();
        if (l >= 0L) {
            calendar.setTimeInMillis(l);
            return String.format("%tm-%td %tH:%tM:%tS.%tL", calendar, calendar, calendar, calendar, calendar, calendar);
        }
        return Long.toString(l);
    }

    private static int printField(char[] cArray, int n, char c, int n2, boolean bl, int n3) {
        if (bl || n > 0) {
            int n4 = n2;
            if (bl && n3 >= 3 || n > 99) {
                int n5 = n / 100;
                cArray[n2] = (char)(n5 + 48);
                ++n2;
                n -= n5 * 100;
            }
            if (bl && n3 >= 2 || n > 9 || n4 != n2) {
                int n6 = n / 10;
                cArray[n2] = (char)(n6 + 48);
                ++n2;
                n -= n6 * 10;
            }
            cArray[n2] = (char)(n + 48);
            int n7 = n2 + 1;
            cArray[n7] = c;
            n2 = n7 + 1;
        }
        return n2;
    }
}

