/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.hardware.camera2.utils.HashCodeHelpers;
import com.android.internal.util.Preconditions;

public final class Range<T extends Comparable<? super T>> {
    private final T mLower;
    private final T mUpper;

    public Range(T t, T t2) {
        this.mLower = (Comparable)Preconditions.checkNotNull(t, "lower must not be null");
        this.mUpper = (Comparable)Preconditions.checkNotNull(t2, "upper must not be null");
        if (t.compareTo(t2) > 0) {
            throw new IllegalArgumentException("lower must be less than or equal to upper");
        }
    }

    public static <T extends Comparable<? super T>> Range<T> create(T t, T t2) {
        return new Range<T>(t, t2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public T clamp(T t) {
        Preconditions.checkNotNull(t, "value must not be null");
        if (t.compareTo(this.mLower) < 0) {
            t = this.mLower;
            return t;
        } else {
            if (t.compareTo(this.mUpper) <= 0) return t;
            return this.mUpper;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean contains(Range<T> range) {
        Preconditions.checkNotNull(range, "value must not be null");
        boolean bl = range.mLower.compareTo(this.mLower) >= 0;
        boolean bl2 = range.mUpper.compareTo(this.mUpper) <= 0;
        return bl && bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean contains(T t) {
        Preconditions.checkNotNull(t, "value must not be null");
        boolean bl = t.compareTo(this.mLower) >= 0;
        boolean bl2 = t.compareTo(this.mUpper) <= 0;
        return bl && bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl = true;
        if (object == null) {
            return false;
        }
        if (this == object) {
            return bl;
        }
        if (!(object instanceof Range)) return false;
        Range range = (Range)object;
        if (!this.mLower.equals(range.mLower)) return false;
        if (!this.mUpper.equals(range.mUpper)) return false;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Range<T> extend(Range<T> range) {
        T t;
        Preconditions.checkNotNull(range, "range must not be null");
        int n = range.mLower.compareTo(this.mLower);
        int n2 = range.mUpper.compareTo(this.mUpper);
        if (n <= 0 && n2 >= 0) {
            return range;
        }
        if (n >= 0 && n2 <= 0) {
            return this;
        }
        T t2 = n >= 0 ? this.mLower : range.mLower;
        if (n2 <= 0) {
            t = this.mUpper;
            return Range.create(t2, t);
        }
        t = range.mUpper;
        return Range.create(t2, t);
    }

    public Range<T> extend(T t) {
        Preconditions.checkNotNull(t, "value must not be null");
        return this.extend(t, t);
    }

    public Range<T> extend(T t, T t2) {
        Preconditions.checkNotNull(t, "lower must not be null");
        Preconditions.checkNotNull(t2, "upper must not be null");
        int n = t.compareTo(this.mLower);
        int n2 = t2.compareTo(this.mUpper);
        if (n >= 0 && n2 <= 0) {
            return this;
        }
        if (n >= 0) {
            t = this.mLower;
        }
        if (n2 <= 0) {
            t2 = this.mUpper;
        }
        return Range.create(t, t2);
    }

    public T getLower() {
        return this.mLower;
    }

    public T getUpper() {
        return this.mUpper;
    }

    public int hashCode() {
        return HashCodeHelpers.hashCode(this.mLower, this.mUpper);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Range<T> intersect(Range<T> range) {
        T t;
        Preconditions.checkNotNull(range, "range must not be null");
        int n = range.mLower.compareTo(this.mLower);
        int n2 = range.mUpper.compareTo(this.mUpper);
        if (n <= 0 && n2 >= 0) {
            return this;
        }
        if (n >= 0 && n2 <= 0) {
            return range;
        }
        T t2 = n <= 0 ? this.mLower : range.mLower;
        if (n2 >= 0) {
            t = this.mUpper;
            return Range.create(t2, t);
        }
        t = range.mUpper;
        return Range.create(t2, t);
    }

    public Range<T> intersect(T t, T t2) {
        Preconditions.checkNotNull(t, "lower must not be null");
        Preconditions.checkNotNull(t2, "upper must not be null");
        int n = t.compareTo(this.mLower);
        int n2 = t2.compareTo(this.mUpper);
        if (n <= 0 && n2 >= 0) {
            return this;
        }
        if (n <= 0) {
            t = this.mLower;
        }
        if (n2 >= 0) {
            t2 = this.mUpper;
        }
        return Range.create(t, t2);
    }

    public String toString() {
        Object[] objectArray = new Object[]{this.mLower, this.mUpper};
        return String.format("[%s, %s]", objectArray);
    }
}

