/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.graphics.Path;
import android.util.Log;
import java.util.ArrayList;
import java.util.Arrays;

public class PathParser {
    static final String LOGTAG = PathParser.class.getSimpleName();

    private static void addNode(ArrayList<PathDataNode> arrayList, char c, float[] fArray) {
        arrayList.add(new PathDataNode(c, fArray));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean canMorph(PathDataNode[] pathDataNodeArray, PathDataNode[] pathDataNodeArray2) {
        if (pathDataNodeArray != null && pathDataNodeArray2 != null && pathDataNodeArray.length == pathDataNodeArray2.length) {
            int n = 0;
            while (true) {
                if (n >= pathDataNodeArray.length) {
                    return true;
                }
                if (pathDataNodeArray[n].mType != pathDataNodeArray2[n].mType || pathDataNodeArray[n].mParams.length != pathDataNodeArray2[n].mParams.length) break;
                ++n;
            }
        }
        return false;
    }

    public static PathDataNode[] createNodesFromPathData(String string2) {
        if (string2 == null) {
            return null;
        }
        int n = 0;
        int n2 = 1;
        ArrayList<PathDataNode> arrayList = new ArrayList<PathDataNode>();
        while (n2 < string2.length()) {
            int n3 = PathParser.nextStart(string2, n2);
            String string3 = string2.substring(n, n3).trim();
            if (string3.length() > 0) {
                float[] fArray = PathParser.getFloats(string3);
                PathParser.addNode(arrayList, string3.charAt(0), fArray);
            }
            n = n3;
            n2 = n3 + 1;
        }
        if (n2 - n == 1 && n < string2.length()) {
            PathParser.addNode(arrayList, string2.charAt(n), new float[0]);
        }
        return arrayList.toArray(new PathDataNode[arrayList.size()]);
    }

    public static Path createPathFromPathData(String string2) {
        Path path = new Path();
        PathDataNode[] pathDataNodeArray = PathParser.createNodesFromPathData(string2);
        if (pathDataNodeArray != null) {
            PathDataNode.nodesToPath(pathDataNodeArray, path);
            return path;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PathDataNode[] deepCopyNodes(PathDataNode[] pathDataNodeArray) {
        if (pathDataNodeArray == null) {
            return null;
        }
        PathDataNode[] pathDataNodeArray2 = new PathDataNode[pathDataNodeArray.length];
        int n = 0;
        while (n < pathDataNodeArray.length) {
            pathDataNodeArray2[n] = new PathDataNode(pathDataNodeArray[n]);
            ++n;
        }
        return pathDataNodeArray2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void extract(String string2, int n, ExtractFloatResult extractFloatResult) {
        int n2;
        boolean bl = false;
        extractFloatResult.mEndWithNegSign = false;
        for (n2 = n; n2 < string2.length(); ++n2) {
            switch (string2.charAt(n2)) {
                case ' ': 
                case ',': {
                    bl = true;
                    break;
                }
                case '-': {
                    if (n2 == n) break;
                    bl = true;
                    extractFloatResult.mEndWithNegSign = true;
                }
            }
            if (bl) break;
        }
        extractFloatResult.mEndPosition = n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static float[] getFloats(String string2) {
        int n;
        int n2;
        ExtractFloatResult extractFloatResult;
        int n3;
        float[] fArray;
        boolean bl = true;
        boolean bl2 = string2.charAt(0) == 'z' ? bl : false;
        if (string2.charAt(0) != 'Z') {
            bl = false;
        }
        if (bl2 | bl) {
            return new float[0];
        }
        try {
            fArray = new float[string2.length()];
            n3 = 1;
            extractFloatResult = new ExtractFloatResult();
            n2 = string2.length();
            n = 0;
        }
        catch (NumberFormatException numberFormatException) {
            Log.e(LOGTAG, "error in parsing \"" + string2 + "\"");
            throw numberFormatException;
        }
        while (n3 < n2) {
            int n4;
            PathParser.extract(string2, n3, extractFloatResult);
            int n5 = extractFloatResult.mEndPosition;
            if (n3 < n5) {
                n4 = n + 1;
                fArray[n] = Float.parseFloat(string2.substring(n3, n5));
            } else {
                n4 = n;
            }
            if (extractFloatResult.mEndWithNegSign) {
                n3 = n5;
                n = n4;
                continue;
            }
            n3 = n5 + 1;
            n = n4;
        }
        return Arrays.copyOf(fArray, n);
    }

    private static int nextStart(String string2, int n) {
        char c;
        while (n < string2.length() && ((c = string2.charAt(n)) - 65) * (c - 90) > 0 && (c - 97) * (c - 122) > 0) {
            ++n;
        }
        return n;
    }

    public static void updateNodes(PathDataNode[] pathDataNodeArray, PathDataNode[] pathDataNodeArray2) {
        for (int i = 0; i < pathDataNodeArray2.length; ++i) {
            PathDataNode.access$102(pathDataNodeArray[i], pathDataNodeArray2[i].mType);
            for (int j = 0; j < pathDataNodeArray2[i].mParams.length; ++j) {
                ((PathDataNode)pathDataNodeArray[i]).mParams[j] = pathDataNodeArray2[i].mParams[j];
            }
        }
    }

    private static class ExtractFloatResult {
        int mEndPosition;
        boolean mEndWithNegSign;

        private ExtractFloatResult() {
        }
    }

    public static class PathDataNode {
        private float[] mParams;
        private char mType;

        private PathDataNode(char c, float[] fArray) {
            this.mType = c;
            this.mParams = fArray;
        }

        private PathDataNode(PathDataNode pathDataNode) {
            this.mType = pathDataNode.mType;
            this.mParams = Arrays.copyOf(pathDataNode.mParams, pathDataNode.mParams.length);
        }

        static /* synthetic */ char access$102(PathDataNode pathDataNode, char c) {
            pathDataNode.mType = c;
            return c;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         */
        private static void addCommand(Path var0, float[] var1_1, char var2_2, char var3_3, float[] var4_4) {
            var5_5 = 2;
            var6_6 = var1_1[0];
            var7_7 = var1_1[1];
            var8_8 = var1_1[2];
            var9_9 = var1_1[3];
            switch (var3_3) {
                case 'Z': 
                case 'z': {
                    var0.close();
                    return;
                }
                case 'L': 
                case 'M': 
                case 'T': 
                case 'l': 
                case 'm': 
                case 't': {
                    var5_5 = 2;
                    break;
                }
                case 'H': 
                case 'V': 
                case 'h': 
                case 'v': {
                    var5_5 = 1;
                    break;
                }
                case 'C': 
                case 'c': {
                    var5_5 = 6;
                    break;
                }
                case 'Q': 
                case 'S': 
                case 'q': 
                case 's': {
                    var5_5 = 4;
                    break;
                }
                case 'A': 
                case 'a': {
                    var5_5 = 7;
                    break;
                }
            }
            for (var10_10 = 0; var10_10 < (var11_11 = var4_4.length); var10_10 += var5_5) {
                block38: {
                    switch (var3_3) {
                        case 'm': {
                            var0.rMoveTo(var4_4[var10_10 + 0], var4_4[var10_10 + 1]);
                            var6_6 += var4_4[var10_10 + 0];
                            var7_7 += var4_4[var10_10 + 1];
                            ** break;
                        }
                        case 'M': {
                            var0.moveTo(var4_4[var10_10 + 0], var4_4[var10_10 + 1]);
                            var6_6 = var4_4[var10_10 + 0];
                            var7_7 = var4_4[var10_10 + 1];
                            ** break;
                        }
                        case 'l': {
                            var0.rLineTo(var4_4[var10_10 + 0], var4_4[var10_10 + 1]);
                            var6_6 += var4_4[var10_10 + 0];
                            var7_7 += var4_4[var10_10 + 1];
                            ** break;
                        }
                        case 'L': {
                            var0.lineTo(var4_4[var10_10 + 0], var4_4[var10_10 + 1]);
                            var6_6 = var4_4[var10_10 + 0];
                            var7_7 = var4_4[var10_10 + 1];
                            ** break;
                        }
                        case 'Z': 
                        case 'z': {
                            var0.close();
                            ** break;
                        }
                        case 'h': {
                            var0.rLineTo(var4_4[var10_10 + 0], 0.0f);
                            var6_6 += var4_4[var10_10 + 0];
                            ** break;
                        }
                        case 'H': {
                            var0.lineTo(var4_4[var10_10 + 0], var7_7);
                            var6_6 = var4_4[var10_10 + 0];
                            ** break;
                        }
                        case 'v': {
                            var0.rLineTo(0.0f, var4_4[var10_10 + 0]);
                            var7_7 += var4_4[var10_10 + 0];
                            ** break;
                        }
                        case 'V': {
                            var36_36 = var4_4[var10_10 + 0];
                            var0.lineTo(var6_6, var36_36);
                            var7_7 = var4_4[var10_10 + 0];
                            ** break;
                        }
                        case 'c': {
                            var0.rCubicTo(var4_4[var10_10 + 0], var4_4[var10_10 + 1], var4_4[var10_10 + 2], var4_4[var10_10 + 3], var4_4[var10_10 + 4], var4_4[var10_10 + 5]);
                            var8_8 = var6_6 + var4_4[var10_10 + 2];
                            var9_9 = var7_7 + var4_4[var10_10 + 3];
                            var6_6 += var4_4[var10_10 + 4];
                            var7_7 += var4_4[var10_10 + 5];
                            ** break;
                        }
                        case 'C': {
                            var0.cubicTo(var4_4[var10_10 + 0], var4_4[var10_10 + 1], var4_4[var10_10 + 2], var4_4[var10_10 + 3], var4_4[var10_10 + 4], var4_4[var10_10 + 5]);
                            var6_6 = var4_4[var10_10 + 4];
                            var7_7 = var4_4[var10_10 + 5];
                            var8_8 = var4_4[var10_10 + 2];
                            var9_9 = var4_4[var10_10 + 3];
                            ** break;
                        }
                        case 's': {
                            if (var2_2 == 'c' || var2_2 == 's' || var2_2 == 'C') ** GOTO lbl87
                            var35_35 = var2_2;
                            var33_33 = 0.0f;
                            var34_34 = 0.0f;
                            if (var35_35 != 'S') ** GOTO lbl89
lbl87:
                            // 2 sources

                            var33_33 = var6_6 - var8_8;
                            var34_34 = var7_7 - var9_9;
lbl89:
                            // 2 sources

                            var0.rCubicTo(var33_33, var34_34, var4_4[var10_10 + 0], var4_4[var10_10 + 1], var4_4[var10_10 + 2], var4_4[var10_10 + 3]);
                            var8_8 = var6_6 + var4_4[var10_10 + 0];
                            var9_9 = var7_7 + var4_4[var10_10 + 1];
                            var6_6 += var4_4[var10_10 + 2];
                            var7_7 += var4_4[var10_10 + 3];
                            ** break;
                        }
                        case 'S': {
                            var31_31 = var6_6;
                            var32_32 = var7_7;
                            if (var2_2 == 'c' || var2_2 == 's' || var2_2 == 'C' || var2_2 == 'S') {
                                var31_31 = 2.0f * var6_6 - var8_8;
                                var32_32 = 2.0f * var7_7 - var9_9;
                            }
                            var0.cubicTo(var31_31, var32_32, var4_4[var10_10 + 0], var4_4[var10_10 + 1], var4_4[var10_10 + 2], var4_4[var10_10 + 3]);
                            var8_8 = var4_4[var10_10 + 0];
                            var9_9 = var4_4[var10_10 + 1];
                            var6_6 = var4_4[var10_10 + 2];
                            var7_7 = var4_4[var10_10 + 3];
                            ** break;
                        }
                        case 'q': {
                            var0.rQuadTo(var4_4[var10_10 + 0], var4_4[var10_10 + 1], var4_4[var10_10 + 2], var4_4[var10_10 + 3]);
                            var8_8 = var6_6 + var4_4[var10_10 + 0];
                            var9_9 = var7_7 + var4_4[var10_10 + 1];
                            var6_6 += var4_4[var10_10 + 2];
                            var7_7 += var4_4[var10_10 + 3];
                            ** break;
                        }
                        case 'Q': {
                            var0.quadTo(var4_4[var10_10 + 0], var4_4[var10_10 + 1], var4_4[var10_10 + 2], var4_4[var10_10 + 3]);
                            var8_8 = var4_4[var10_10 + 0];
                            var9_9 = var4_4[var10_10 + 1];
                            var6_6 = var4_4[var10_10 + 2];
                            var7_7 = var4_4[var10_10 + 3];
                            ** break;
                        }
                        case 't': {
                            if (var2_2 == 'q' || var2_2 == 't' || var2_2 == 'Q') ** GOTO lbl127
                            var30_30 = var2_2;
                            var28_28 = 0.0f;
                            var29_29 = 0.0f;
                            if (var30_30 != 'T') ** GOTO lbl129
lbl127:
                            // 2 sources

                            var28_28 = var6_6 - var8_8;
                            var29_29 = var7_7 - var9_9;
lbl129:
                            // 2 sources

                            var0.rQuadTo(var28_28, var29_29, var4_4[var10_10 + 0], var4_4[var10_10 + 1]);
                            var8_8 = var6_6 + var28_28;
                            var9_9 = var7_7 + var29_29;
                            var6_6 += var4_4[var10_10 + 0];
                            var7_7 += var4_4[var10_10 + 1];
                            ** break;
                        }
                        case 'T': {
                            var26_26 = var6_6;
                            var27_27 = var7_7;
                            if (var2_2 == 'q' || var2_2 == 't' || var2_2 == 'Q' || var2_2 == 'T') {
                                var26_26 = 2.0f * var6_6 - var8_8;
                                var27_27 = 2.0f * var7_7 - var9_9;
                            }
                            var0.quadTo(var26_26, var27_27, var4_4[var10_10 + 0], var4_4[var10_10 + 1]);
                            var8_8 = var26_26;
                            var9_9 = var27_27;
                            var6_6 = var4_4[var10_10 + 0];
                            var7_7 = var4_4[var10_10 + 1];
                            ** break;
                        }
                        case 'a': {
                            var19_19 = var6_6 + var4_4[var10_10 + 5];
                            var20_20 = var7_7 + var4_4[var10_10 + 6];
                            var21_21 = var4_4[var10_10 + 0];
                            var22_22 = var4_4[var10_10 + 1];
                            var23_23 = var4_4[var10_10 + 2];
                            var24_24 = var4_4[var10_10 + 3] != 0.0f;
                            var25_25 = var4_4[var10_10 + 4] != 0.0f;
                            PathDataNode.drawArc(var0, var6_6, var7_7, var19_19, var20_20, var21_21, var22_22, var23_23, var24_24, var25_25);
                            var8_8 = var6_6 += var4_4[var10_10 + 5];
                            var9_9 = var7_7 += var4_4[var10_10 + 6];
                        }
lbl158:
                        // 19 sources

                        default: {
                            break block38;
                        }
                        case 'A': 
                    }
                    var12_12 = var4_4[var10_10 + 5];
                    var13_13 = var4_4[var10_10 + 6];
                    var14_14 = var4_4[var10_10 + 0];
                    var15_15 = var4_4[var10_10 + 1];
                    var16_16 = var4_4[var10_10 + 2];
                    var17_17 = var4_4[var10_10 + 3] != 0.0f;
                    var18_18 = var4_4[var10_10 + 4] != 0.0f;
                    PathDataNode.drawArc(var0, var6_6, var7_7, var12_12, var13_13, var14_14, var15_15, var16_16, var17_17, var18_18);
                    var6_6 = var4_4[var10_10 + 5];
                    var7_7 = var4_4[var10_10 + 6];
                    var8_8 = var6_6;
                    var9_9 = var7_7;
                }
                var2_2 = var3_3;
            }
            var1_1[0] = var6_6;
            var1_1[1] = var7_7;
            var1_1[2] = var8_8;
            var1_1[3] = var9_9;
        }

        private static void arcToBezier(Path path, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
            int n = Math.abs((int)Math.ceil(4.0 * d9 / Math.PI));
            double d10 = d8;
            double d11 = Math.cos(d7);
            double d12 = Math.sin(d7);
            double d13 = Math.cos(d10);
            double d14 = Math.sin(d10);
            double d15 = d14 * (d11 * -d3) - d13 * (d4 * d12);
            double d16 = d14 * (d12 * -d3) + d13 * (d4 * d11);
            double d17 = d9 / (double)n;
            for (int i = 0; i < n; ++i) {
                double d18 = d10 + d17;
                double d19 = Math.sin(d18);
                double d20 = Math.cos(d18);
                double d21 = d + d20 * (d3 * d11) - d19 * (d4 * d12);
                double d22 = d2 + d20 * (d3 * d12) + d19 * (d4 * d11);
                double d23 = d19 * (d11 * -d3) - d20 * (d4 * d12);
                double d24 = d19 * (d12 * -d3) + d20 * (d4 * d11);
                double d25 = Math.tan((d18 - d10) / 2.0);
                double d26 = Math.sin(d18 - d10) * (Math.sqrt(4.0 + d25 * (3.0 * d25)) - 1.0) / 3.0;
                double d27 = d5 + d26 * d15;
                double d28 = d6 + d26 * d16;
                double d29 = d21 - d26 * d23;
                double d30 = d22 - d26 * d24;
                path.cubicTo((float)d27, (float)d28, (float)d29, (float)d30, (float)d21, (float)d22);
                d10 = d18;
                d5 = d21;
                d6 = d22;
                d15 = d23;
                d16 = d24;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private static void drawArc(Path path, float f, float f2, float f3, float f4, float f5, float f6, float f7, boolean bl, boolean bl2) {
            double d;
            double d2;
            double d3 = Math.toRadians(f7);
            double d4 = Math.cos(d3);
            double d5 = Math.sin(d3);
            double d6 = (d4 * (double)f + d5 * (double)f2) / (double)f5;
            double d7 = (d5 * (double)(-f) + d4 * (double)f2) / (double)f6;
            double d8 = (d4 * (double)f3 + d5 * (double)f4) / (double)f5;
            double d9 = (d5 * (double)(-f3) + d4 * (double)f4) / (double)f6;
            double d10 = d6 - d8;
            double d11 = d7 - d9;
            double d12 = (d6 + d8) / 2.0;
            double d13 = (d7 + d9) / 2.0;
            double d14 = d10 * d10 + d11 * d11;
            if (d14 == 0.0) {
                Log.w(LOGTAG, " Points are coincident");
                return;
            }
            double d15 = 1.0 / d14 - 0.25;
            if (d15 < 0.0) {
                Log.w(LOGTAG, "Points are too far apart " + d14);
                float f8 = (float)(Math.sqrt(d14) / 1.99999);
                PathDataNode.drawArc(path, f, f2, f3, f4, f5 * f8, f6 * f8, f7, bl, bl2);
                return;
            }
            double d16 = Math.sqrt(d15);
            double d17 = d16 * d10;
            double d18 = d16 * d11;
            if (bl == bl2) {
                d2 = d12 - d18;
                d = d13 + d17;
            } else {
                d2 = d12 + d18;
                d = d13 - d17;
            }
            double d19 = Math.atan2(d7 - d, d6 - d2);
            double d20 = Math.atan2(d9 - d, d8 - d2) - d19;
            boolean bl3 = d20 >= 0.0;
            if (bl2 != bl3) {
                d20 = d20 > 0.0 ? (d20 -= Math.PI * 2) : (d20 += Math.PI * 2);
            }
            double d21 = d2 * (double)f5;
            double d22 = d * (double)f6;
            PathDataNode.arcToBezier(path, d21 * d4 - d22 * d5, d21 * d5 + d22 * d4, f5, f6, f, f2, d3, d19, d20);
        }

        public static void nodesToPath(PathDataNode[] pathDataNodeArray, Path path) {
            float[] fArray = new float[4];
            char c = 'm';
            for (int i = 0; i < pathDataNodeArray.length; ++i) {
                PathDataNode.addCommand(path, fArray, c, pathDataNodeArray[i].mType, pathDataNodeArray[i].mParams);
                c = pathDataNodeArray[i].mType;
            }
        }

        public void interpolatePathDataNode(PathDataNode pathDataNode, PathDataNode pathDataNode2, float f) {
            for (int i = 0; i < pathDataNode.mParams.length; ++i) {
                this.mParams[i] = pathDataNode.mParams[i] * (1.0f - f) + f * pathDataNode2.mParams[i];
            }
        }
    }
}

