/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import com.android.internal.util.ArrayUtils;
import libcore.util.EmptyArray;

public class LongArray
implements Cloneable {
    private static final int MIN_CAPACITY_INCREMENT = 12;
    private int mSize;
    private long[] mValues;

    public LongArray() {
        this(10);
    }

    /*
     * Enabled aggressive block sorting
     */
    public LongArray(int n) {
        this.mValues = n == 0 ? EmptyArray.LONG : ArrayUtils.newUnpaddedLongArray(n);
        this.mSize = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void ensureCapacity(int n) {
        int n2 = this.mSize;
        int n3 = n2 + n;
        if (n3 >= this.mValues.length) {
            int n4 = n2 < 6 ? 12 : n2 >> 1;
            int n5 = n2 + n4;
            int n6 = n5 > n3 ? n5 : n3;
            long[] lArray = ArrayUtils.newUnpaddedLongArray(n6);
            System.arraycopy((long[])this.mValues, (int)0, (long[])lArray, (int)0, (int)n2);
            this.mValues = lArray;
        }
    }

    public void add(int n, long l) {
        if (n < 0 || n > this.mSize) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(1);
        if (this.mSize - n != 0) {
            System.arraycopy((long[])this.mValues, (int)n, (long[])this.mValues, (int)(n + 1), (int)(this.mSize - n));
        }
        this.mValues[n] = l;
        this.mSize = 1 + this.mSize;
    }

    public void add(long l) {
        this.add(this.mSize, l);
    }

    public void addAll(LongArray longArray) {
        int n = longArray.mSize;
        this.ensureCapacity(n);
        System.arraycopy((long[])longArray.mValues, (int)0, (long[])this.mValues, (int)this.mSize, (int)n);
        this.mSize = n + this.mSize;
    }

    public void clear() {
        this.mSize = 0;
    }

    public LongArray clone() {
        LongArray longArray = null;
        try {
            longArray = (LongArray)super.clone();
            longArray.mValues = (long[])this.mValues.clone();
            return longArray;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return longArray;
        }
    }

    public long get(int n) {
        if (n >= this.mSize) {
            throw new ArrayIndexOutOfBoundsException(this.mSize, n);
        }
        return this.mValues[n];
    }

    public int indexOf(long l) {
        int n = this.mSize;
        for (int i = 0; i < n; ++i) {
            if (this.mValues[i] != l) continue;
            return i;
        }
        return -1;
    }

    public void remove(int n) {
        if (n >= this.mSize) {
            throw new ArrayIndexOutOfBoundsException(this.mSize, n);
        }
        System.arraycopy((long[])this.mValues, (int)(n + 1), (long[])this.mValues, (int)n, (int)(-1 + (this.mSize - n)));
        this.mSize = -1 + this.mSize;
    }

    public int size() {
        return this.mSize;
    }
}

