/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.JsonScope;
import android.util.JsonToken;
import android.util.MalformedJsonException;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import libcore.internal.StringPool;

public final class JsonReader
implements Closeable {
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    private final char[] buffer;
    private int bufferStartColumn = 1;
    private int bufferStartLine = 1;
    private final Reader in;
    private boolean lenient = false;
    private int limit = 0;
    private String name;
    private int pos = 0;
    private boolean skipping;
    private final List<JsonScope> stack;
    private final StringPool stringPool = new StringPool();
    private JsonToken token;
    private String value;
    private int valueLength;
    private int valuePos;

    public JsonReader(Reader reader) {
        this.buffer = new char[1024];
        this.stack = new ArrayList<JsonScope>();
        this.push(JsonScope.EMPTY_DOCUMENT);
        this.skipping = false;
        if (reader == null) {
            throw new NullPointerException("in == null");
        }
        this.in = reader;
    }

    private JsonToken advance() throws IOException {
        this.peek();
        JsonToken jsonToken = this.token;
        this.token = null;
        this.value = null;
        this.name = null;
        return jsonToken;
    }

    private void checkLenient() throws IOException {
        if (!this.lenient) {
            throw this.syntaxError("Use JsonReader.setLenient(true) to accept malformed JSON");
        }
    }

    private JsonToken decodeLiteral() throws IOException {
        if (this.valuePos == -1) {
            return JsonToken.STRING;
        }
        if (!(this.valueLength != 4 || 'n' != this.buffer[this.valuePos] && 'N' != this.buffer[this.valuePos] || 'u' != this.buffer[1 + this.valuePos] && 'U' != this.buffer[1 + this.valuePos] || 'l' != this.buffer[2 + this.valuePos] && 'L' != this.buffer[2 + this.valuePos] || 'l' != this.buffer[3 + this.valuePos] && 'L' != this.buffer[3 + this.valuePos])) {
            this.value = "null";
            return JsonToken.NULL;
        }
        if (!(this.valueLength != 4 || 't' != this.buffer[this.valuePos] && 'T' != this.buffer[this.valuePos] || 'r' != this.buffer[1 + this.valuePos] && 'R' != this.buffer[1 + this.valuePos] || 'u' != this.buffer[2 + this.valuePos] && 'U' != this.buffer[2 + this.valuePos] || 'e' != this.buffer[3 + this.valuePos] && 'E' != this.buffer[3 + this.valuePos])) {
            this.value = TRUE;
            return JsonToken.BOOLEAN;
        }
        if (!(this.valueLength != 5 || 'f' != this.buffer[this.valuePos] && 'F' != this.buffer[this.valuePos] || 'a' != this.buffer[1 + this.valuePos] && 'A' != this.buffer[1 + this.valuePos] || 'l' != this.buffer[2 + this.valuePos] && 'L' != this.buffer[2 + this.valuePos] || 's' != this.buffer[3 + this.valuePos] && 'S' != this.buffer[3 + this.valuePos] || 'e' != this.buffer[4 + this.valuePos] && 'E' != this.buffer[4 + this.valuePos])) {
            this.value = FALSE;
            return JsonToken.BOOLEAN;
        }
        this.value = this.stringPool.get(this.buffer, this.valuePos, this.valueLength);
        return this.decodeNumber(this.buffer, this.valuePos, this.valueLength);
    }

    /*
     * Enabled aggressive block sorting
     */
    private JsonToken decodeNumber(char[] cArray, int n, int n2) {
        char c;
        int n3;
        int n4 = n;
        char c2 = cArray[n4];
        if (c2 == '-') {
            c2 = cArray[++n4];
        }
        if (c2 == '0') {
            n3 = n4 + 1;
            c = cArray[n3];
        } else {
            if (c2 < '1' || c2 > '9') return JsonToken.STRING;
            n3 = n4 + 1;
            c = cArray[n3];
            while (c >= '0' && c <= '9') {
                c = cArray[++n3];
            }
        }
        if (c == '.') {
            c = cArray[++n3];
            while (c >= '0' && c <= '9') {
                c = cArray[++n3];
            }
        }
        if (c == 'e' || c == 'E') {
            int n5 = n3 + 1;
            char c3 = cArray[n5];
            if (c3 == '+' || c3 == '-') {
                c3 = cArray[++n5];
            }
            if (c3 < '0' || c3 > '9') return JsonToken.STRING;
            n3 = n5 + 1;
            char c4 = cArray[n3];
            while (c4 >= '0' && c4 <= '9') {
                c4 = cArray[++n3];
            }
        }
        if (n3 != n + n2) return JsonToken.STRING;
        return JsonToken.NUMBER;
    }

    private void expect(JsonToken jsonToken) throws IOException {
        this.peek();
        if (this.token != jsonToken) {
            throw new IllegalStateException("Expected " + (Object)((Object)jsonToken) + " but was " + (Object)((Object)this.peek()));
        }
        this.advance();
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean fillBuffer(int n) throws IOException {
        for (int i = 0; i < this.pos; ++i) {
            if (this.buffer[i] == '\n') {
                this.bufferStartLine = 1 + this.bufferStartLine;
                this.bufferStartColumn = 1;
                continue;
            }
            this.bufferStartColumn = 1 + this.bufferStartColumn;
        }
        if (this.limit != this.pos) {
            this.limit -= this.pos;
            System.arraycopy((char[])this.buffer, (int)this.pos, (char[])this.buffer, (int)0, (int)this.limit);
        } else {
            this.limit = 0;
        }
        this.pos = 0;
        do {
            int n2;
            if ((n2 = this.in.read(this.buffer, this.limit, this.buffer.length - this.limit)) == -1) {
                return false;
            }
            this.limit = n2 + this.limit;
            if (this.bufferStartLine != 1 || this.bufferStartColumn != 1 || this.limit <= 0 || this.buffer[0] != '\ufeff') continue;
            this.pos = 1 + this.pos;
            this.bufferStartColumn = -1 + this.bufferStartColumn;
        } while (this.limit < n);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getColumnNumber() {
        int n = this.bufferStartColumn;
        int n2 = 0;
        while (n2 < this.pos) {
            n = this.buffer[n2] == '\n' ? 1 : ++n;
            ++n2;
        }
        return n;
    }

    private int getLineNumber() {
        int n = this.bufferStartLine;
        for (int i = 0; i < this.pos; ++i) {
            if (this.buffer[i] != '\n') continue;
            ++n;
        }
        return n;
    }

    private CharSequence getSnippet() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = Math.min(this.pos, 20);
        stringBuilder.append(this.buffer, this.pos - n, n);
        int n2 = Math.min(this.limit - this.pos, 20);
        stringBuilder.append(this.buffer, this.pos, n2);
        return stringBuilder;
    }

    /*
     * Enabled aggressive block sorting
     */
    private JsonToken nextInArray(boolean bl) throws IOException {
        JsonToken jsonToken;
        if (bl) {
            this.replaceTop(JsonScope.NONEMPTY_ARRAY);
        } else {
            switch (this.nextNonWhitespace()) {
                case 44: {
                    break;
                }
                default: {
                    throw this.syntaxError("Unterminated array");
                }
                case 93: {
                    JsonToken jsonToken2;
                    this.pop();
                    this.token = jsonToken2 = JsonToken.END_ARRAY;
                    return jsonToken2;
                }
                case 59: {
                    this.checkLenient();
                }
            }
        }
        switch (this.nextNonWhitespace()) {
            default: {
                this.pos = -1 + this.pos;
                return this.nextValue();
            }
            case 93: {
                JsonToken jsonToken3;
                if (!bl) break;
                this.pop();
                this.token = jsonToken3 = JsonToken.END_ARRAY;
                return jsonToken3;
            }
            case 44: 
            case 59: 
        }
        this.checkLenient();
        this.pos = -1 + this.pos;
        this.value = "null";
        this.token = jsonToken = JsonToken.NULL;
        return jsonToken;
    }

    /*
     * Exception decompiling
     */
    private JsonToken nextInObject(boolean var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[CASE]], but top level block is 3[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     */
    private String nextLiteral(boolean bl) throws IOException {
        String string2;
        int n;
        StringBuilder stringBuilder;
        block14: {
            stringBuilder = null;
            this.valuePos = -1;
            this.valueLength = 0;
            n = 0;
            block4: while (true) {
                if (n + this.pos < this.limit) {
                    switch (this.buffer[n + this.pos]) {
                        default: {
                            ++n;
                            continue block4;
                        }
                        case '#': 
                        case '/': 
                        case ';': 
                        case '=': 
                        case '\\': {
                            this.checkLenient();
                            break;
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': 
                        case ',': 
                        case ':': 
                        case '[': 
                        case ']': 
                        case '{': 
                        case '}': {
                            break;
                        }
                    }
                    break block14;
                }
                if (n < this.buffer.length) {
                    if (this.fillBuffer(n + 1)) continue;
                    this.buffer[this.limit] = '\u0000';
                    break block14;
                }
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder();
                }
                stringBuilder.append(this.buffer, this.pos, n);
                this.valueLength = n + this.valueLength;
                this.pos = n + this.pos;
                boolean bl2 = this.fillBuffer(1);
                n = 0;
                if (!bl2) break;
            }
            n = 0;
        }
        if (bl && stringBuilder == null) {
            this.valuePos = this.pos;
            string2 = null;
        } else if (this.skipping) {
            string2 = "skipped!";
        } else if (stringBuilder == null) {
            string2 = this.stringPool.get(this.buffer, this.pos, n);
        } else {
            stringBuilder.append(this.buffer, this.pos, n);
            string2 = stringBuilder.toString();
        }
        this.valueLength = n + this.valueLength;
        this.pos = n + this.pos;
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int nextNonWhitespace() throws IOException {
        char c;
        block9: while (true) {
            if (this.pos >= this.limit && !this.fillBuffer(1)) {
                throw new EOFException("End of input");
            }
            char[] cArray = this.buffer;
            int n = this.pos;
            this.pos = n + 1;
            c = cArray[n];
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block9;
                }
                case '/': {
                    if (this.pos == this.limit && !this.fillBuffer(1)) break block9;
                    this.checkLenient();
                    switch (this.buffer[this.pos]) {
                        default: {
                            return c;
                        }
                        case '*': {
                            this.pos = 1 + this.pos;
                            if (!this.skipTo("*/")) {
                                throw this.syntaxError("Unterminated comment");
                            }
                            this.pos = 2 + this.pos;
                            continue block9;
                        }
                        case '/': 
                    }
                    this.pos = 1 + this.pos;
                    this.skipToEndOfLine();
                    continue block9;
                }
                case '#': {
                    this.checkLenient();
                    this.skipToEndOfLine();
                    continue block9;
                }
            }
            break;
        }
        return c;
    }

    private String nextString(char c) throws IOException {
        StringBuilder stringBuilder = null;
        do {
            int n = this.pos;
            while (this.pos < this.limit) {
                char[] cArray = this.buffer;
                int n2 = this.pos;
                this.pos = n2 + 1;
                char c2 = cArray[n2];
                if (c2 == c) {
                    if (this.skipping) {
                        return "skipped!";
                    }
                    if (stringBuilder == null) {
                        return this.stringPool.get(this.buffer, n, -1 + (this.pos - n));
                    }
                    stringBuilder.append(this.buffer, n, -1 + (this.pos - n));
                    return stringBuilder.toString();
                }
                if (c2 != '\\') continue;
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder();
                }
                stringBuilder.append(this.buffer, n, -1 + (this.pos - n));
                stringBuilder.append(this.readEscapeCharacter());
                n = this.pos;
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(this.buffer, n, this.pos - n);
        } while (this.fillBuffer(1));
        throw this.syntaxError("Unterminated string");
    }

    private JsonToken nextValue() throws IOException {
        JsonToken jsonToken;
        int n = this.nextNonWhitespace();
        switch (n) {
            default: {
                this.pos = -1 + this.pos;
                return this.readLiteral();
            }
            case 123: {
                JsonToken jsonToken2;
                this.push(JsonScope.EMPTY_OBJECT);
                this.token = jsonToken2 = JsonToken.BEGIN_OBJECT;
                return jsonToken2;
            }
            case 91: {
                JsonToken jsonToken3;
                this.push(JsonScope.EMPTY_ARRAY);
                this.token = jsonToken3 = JsonToken.BEGIN_ARRAY;
                return jsonToken3;
            }
            case 39: {
                this.checkLenient();
            }
            case 34: 
        }
        this.value = this.nextString((char)n);
        this.token = jsonToken = JsonToken.STRING;
        return jsonToken;
    }

    private JsonToken objectValue() throws IOException {
        switch (this.nextNonWhitespace()) {
            default: {
                throw this.syntaxError("Expected ':'");
            }
            case 61: {
                this.checkLenient();
                if (this.pos >= this.limit && !this.fillBuffer(1) || this.buffer[this.pos] != '>') break;
                this.pos = 1 + this.pos;
            }
            case 58: 
        }
        this.replaceTop(JsonScope.NONEMPTY_OBJECT);
        return this.nextValue();
    }

    private JsonScope peekStack() {
        return this.stack.get(-1 + this.stack.size());
    }

    private JsonScope pop() {
        return this.stack.remove(-1 + this.stack.size());
    }

    private void push(JsonScope jsonScope) {
        this.stack.add(jsonScope);
    }

    private char readEscapeCharacter() throws IOException {
        if (this.pos == this.limit && !this.fillBuffer(1)) {
            throw this.syntaxError("Unterminated escape sequence");
        }
        char[] cArray = this.buffer;
        int n = this.pos;
        this.pos = n + 1;
        char c = cArray[n];
        switch (c) {
            default: {
                return c;
            }
            case 'u': {
                if (4 + this.pos > this.limit && !this.fillBuffer(4)) {
                    throw this.syntaxError("Unterminated escape sequence");
                }
                String string2 = this.stringPool.get(this.buffer, this.pos, 4);
                this.pos = 4 + this.pos;
                return (char)Integer.parseInt(string2, 16);
            }
            case 't': {
                return '\t';
            }
            case 'b': {
                return '\b';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 'f': 
        }
        return '\f';
    }

    private JsonToken readLiteral() throws IOException {
        this.value = this.nextLiteral(true);
        if (this.valueLength == 0) {
            throw this.syntaxError("Expected literal value");
        }
        this.token = this.decodeLiteral();
        if (this.token == JsonToken.STRING) {
            this.checkLenient();
        }
        return this.token;
    }

    private void replaceTop(JsonScope jsonScope) {
        this.stack.set(-1 + this.stack.size(), jsonScope);
    }

    private boolean skipTo(String string2) throws IOException {
        block0: while (this.pos + string2.length() <= this.limit || this.fillBuffer(string2.length())) {
            for (int i = 0; i < string2.length(); ++i) {
                if (this.buffer[i + this.pos] == string2.charAt(i)) continue;
                this.pos = 1 + this.pos;
                continue block0;
            }
            return true;
        }
        return false;
    }

    private void skipToEndOfLine() throws IOException {
        while (this.pos < this.limit || this.fillBuffer(1)) {
            char[] cArray = this.buffer;
            int n = this.pos;
            this.pos = n + 1;
            char c = cArray[n];
            if (c != '\r' && c != '\n') continue;
        }
    }

    private IOException syntaxError(String string2) throws IOException {
        throw new MalformedJsonException(string2 + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
    }

    public void beginArray() throws IOException {
        this.expect(JsonToken.BEGIN_ARRAY);
    }

    public void beginObject() throws IOException {
        this.expect(JsonToken.BEGIN_OBJECT);
    }

    @Override
    public void close() throws IOException {
        this.value = null;
        this.token = null;
        this.stack.clear();
        this.stack.add(JsonScope.CLOSED);
        this.in.close();
    }

    public void endArray() throws IOException {
        this.expect(JsonToken.END_ARRAY);
    }

    public void endObject() throws IOException {
        this.expect(JsonToken.END_OBJECT);
    }

    public boolean hasNext() throws IOException {
        this.peek();
        return this.token != JsonToken.END_OBJECT && this.token != JsonToken.END_ARRAY;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean nextBoolean() throws IOException {
        this.peek();
        if (this.token != JsonToken.BOOLEAN) {
            throw new IllegalStateException("Expected a boolean but was " + (Object)((Object)this.token));
        }
        boolean bl = this.value == TRUE;
        this.advance();
        return bl;
    }

    public double nextDouble() throws IOException {
        this.peek();
        if (this.token != JsonToken.STRING && this.token != JsonToken.NUMBER) {
            throw new IllegalStateException("Expected a double but was " + (Object)((Object)this.token));
        }
        double d = Double.parseDouble(this.value);
        this.advance();
        return d;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int nextInt() throws IOException {
        int n;
        block3: {
            this.peek();
            if (this.token != JsonToken.STRING && this.token != JsonToken.NUMBER) {
                throw new IllegalStateException("Expected an int but was " + (Object)((Object)this.token));
            }
            try {
                int n2;
                n = n2 = Integer.parseInt(this.value);
            }
            catch (NumberFormatException numberFormatException) {
                double d = Double.parseDouble(this.value);
                n = (int)d;
                if ((double)n == d) break block3;
                throw new NumberFormatException(this.value);
            }
        }
        this.advance();
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long nextLong() throws IOException {
        long l;
        block3: {
            this.peek();
            if (this.token != JsonToken.STRING && this.token != JsonToken.NUMBER) {
                throw new IllegalStateException("Expected a long but was " + (Object)((Object)this.token));
            }
            try {
                long l2;
                l = l2 = Long.parseLong(this.value);
            }
            catch (NumberFormatException numberFormatException) {
                double d = Double.parseDouble(this.value);
                l = (long)d;
                if ((double)l == d) break block3;
                throw new NumberFormatException(this.value);
            }
        }
        this.advance();
        return l;
    }

    public String nextName() throws IOException {
        this.peek();
        if (this.token != JsonToken.NAME) {
            throw new IllegalStateException("Expected a name but was " + (Object)((Object)this.peek()));
        }
        String string2 = this.name;
        this.advance();
        return string2;
    }

    public void nextNull() throws IOException {
        this.peek();
        if (this.token != JsonToken.NULL) {
            throw new IllegalStateException("Expected null but was " + (Object)((Object)this.token));
        }
        this.advance();
    }

    public String nextString() throws IOException {
        this.peek();
        if (this.token != JsonToken.STRING && this.token != JsonToken.NUMBER) {
            throw new IllegalStateException("Expected a string but was " + (Object)((Object)this.peek()));
        }
        String string2 = this.value;
        this.advance();
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonToken peek() throws IOException {
        if (this.token != null) {
            return this.token;
        }
        switch (1.$SwitchMap$android$util$JsonScope[this.peekStack().ordinal()]) {
            default: {
                throw new AssertionError();
            }
            case 1: {
                this.replaceTop(JsonScope.NONEMPTY_DOCUMENT);
                JsonToken jsonToken = this.nextValue();
                if (this.lenient) return jsonToken;
                if (this.token == JsonToken.BEGIN_ARRAY) return jsonToken;
                if (this.token == JsonToken.BEGIN_OBJECT) return jsonToken;
                throw new IOException("Expected JSON document to start with '[' or '{' but was " + (Object)((Object)this.token));
            }
            case 2: {
                return this.nextInArray(true);
            }
            case 3: {
                return this.nextInArray(false);
            }
            case 4: {
                return this.nextInObject(true);
            }
            case 5: {
                return this.objectValue();
            }
            case 6: {
                return this.nextInObject(false);
            }
            case 7: {
                try {
                    JsonToken jsonToken = this.nextValue();
                    if (!this.lenient) throw this.syntaxError("Expected EOF");
                    return jsonToken;
                }
                catch (EOFException eOFException) {
                    JsonToken jsonToken;
                    this.token = jsonToken = JsonToken.END_DOCUMENT;
                    return jsonToken;
                }
            }
            case 8: 
        }
        throw new IllegalStateException("JsonReader is closed");
    }

    public void setLenient(boolean bl) {
        this.lenient = bl;
    }

    /*
     * Exception decompiling
     */
    public void skipValue() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [2 : 43->60)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String toString() {
        return this.getClass().getSimpleName() + " near " + this.getSnippet();
    }
}

