/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.ContainerHelpers;
import android.util.MapCollections;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import libcore.util.EmptyArray;

public final class ArraySet<E>
implements Collection<E>,
Set<E> {
    private static final int BASE_SIZE = 4;
    private static final int CACHE_SIZE = 10;
    private static final boolean DEBUG = false;
    private static final String TAG = "ArraySet";
    static Object[] mBaseCache;
    static int mBaseCacheSize;
    static Object[] mTwiceBaseCache;
    static int mTwiceBaseCacheSize;
    Object[] mArray;
    MapCollections<E, E> mCollections;
    int[] mHashes;
    int mSize;

    public ArraySet() {
        this.mHashes = EmptyArray.INT;
        this.mArray = EmptyArray.OBJECT;
        this.mSize = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ArraySet(int n) {
        if (n == 0) {
            this.mHashes = EmptyArray.INT;
            this.mArray = EmptyArray.OBJECT;
        } else {
            this.allocArrays(n);
        }
        this.mSize = 0;
    }

    public ArraySet(ArraySet arraySet) {
        this();
        if (arraySet != null) {
            this.addAll(arraySet);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void allocArrays(int n) {
        if (n == 8) {
            synchronized (ArraySet.class) {
                if (mTwiceBaseCache != null) {
                    Object[] objectArray = mTwiceBaseCache;
                    this.mArray = objectArray;
                    mTwiceBaseCache = (Object[])objectArray[0];
                    this.mHashes = (int[])objectArray[1];
                    objectArray[1] = null;
                    objectArray[0] = null;
                    mTwiceBaseCacheSize = -1 + mTwiceBaseCacheSize;
                    return;
                }
            }
        } else if (n == 4) {
            synchronized (ArraySet.class) {
                if (mBaseCache != null) {
                    Object[] objectArray = mBaseCache;
                    this.mArray = objectArray;
                    mBaseCache = (Object[])objectArray[0];
                    this.mHashes = (int[])objectArray[1];
                    objectArray[1] = null;
                    objectArray[0] = null;
                    mBaseCacheSize = -1 + mBaseCacheSize;
                    return;
                }
            }
        }
        this.mHashes = new int[n];
        this.mArray = new Object[n];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void freeArrays(int[] nArray, Object[] objectArray, int n) {
        if (nArray.length == 8) {
            synchronized (ArraySet.class) {
                if (mTwiceBaseCacheSize < 10) {
                    objectArray[0] = mTwiceBaseCache;
                    objectArray[1] = nArray;
                    for (int i = n - 1; i >= 2; --i) {
                        objectArray[i] = null;
                    }
                    mTwiceBaseCache = objectArray;
                    mTwiceBaseCacheSize = 1 + mTwiceBaseCacheSize;
                }
                return;
            }
        }
        if (nArray.length != 4) {
            return;
        }
        synchronized (ArraySet.class) {
            if (mBaseCacheSize < 10) {
                objectArray[0] = mBaseCache;
                objectArray[1] = nArray;
                for (int i = n - 1; i >= 2; --i) {
                    objectArray[i] = null;
                }
                mBaseCache = objectArray;
                mBaseCacheSize = 1 + mBaseCacheSize;
            }
            return;
        }
    }

    private MapCollections<E, E> getCollection() {
        if (this.mCollections == null) {
            this.mCollections = new MapCollections<E, E>(){

                @Override
                protected void colClear() {
                    ArraySet.this.clear();
                }

                @Override
                protected Object colGetEntry(int n, int n2) {
                    return ArraySet.this.mArray[n];
                }

                @Override
                protected Map<E, E> colGetMap() {
                    throw new UnsupportedOperationException("not a map");
                }

                @Override
                protected int colGetSize() {
                    return ArraySet.this.mSize;
                }

                @Override
                protected int colIndexOfKey(Object object) {
                    return ArraySet.this.indexOf(object);
                }

                @Override
                protected int colIndexOfValue(Object object) {
                    return ArraySet.this.indexOf(object);
                }

                @Override
                protected void colPut(E e, E e2) {
                    ArraySet.this.add(e);
                }

                @Override
                protected void colRemoveAt(int n) {
                    ArraySet.this.removeAt(n);
                }

                @Override
                protected E colSetValue(int n, E e) {
                    throw new UnsupportedOperationException("not a map");
                }
            };
        }
        return this.mCollections;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int indexOf(Object object, int n) {
        int n2;
        int n3 = this.mSize;
        if (n3 == 0) {
            return -1;
        }
        int n4 = ContainerHelpers.binarySearch(this.mHashes, n3, n);
        if (n4 < 0) return n4;
        if (object.equals(this.mArray[n4])) return n4;
        for (n2 = n4 + 1; n2 < n3 && this.mHashes[n2] == n; ++n2) {
            if (!object.equals(this.mArray[n2])) continue;
            return n2;
        }
        int n5 = n4 - 1;
        while (n5 >= 0) {
            if (this.mHashes[n5] != n) return ~n2;
            if (object.equals(this.mArray[n5])) {
                return n5;
            }
            --n5;
        }
        return ~n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int indexOfNull() {
        int n;
        int n2 = this.mSize;
        if (n2 == 0) {
            return -1;
        }
        int n3 = ContainerHelpers.binarySearch(this.mHashes, n2, 0);
        if (n3 < 0) return n3;
        if (this.mArray[n3] == null) return n3;
        for (n = n3 + 1; n < n2 && this.mHashes[n] == 0; ++n) {
            if (this.mArray[n] != null) continue;
            return n;
        }
        int n4 = n3 - 1;
        while (n4 >= 0) {
            if (this.mHashes[n4] != 0) return ~n;
            if (this.mArray[n4] == null) {
                return n4;
            }
            --n4;
        }
        return ~n;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean add(E e) {
        int n;
        int n2;
        int n3 = 8;
        if (e == null) {
            n2 = 0;
            n = this.indexOfNull();
        } else {
            n2 = e.hashCode();
            n = this.indexOf(e, n2);
        }
        if (n >= 0) {
            return false;
        }
        int n4 = ~n;
        if (this.mSize >= this.mHashes.length) {
            if (this.mSize >= n3) {
                n3 = this.mSize + (this.mSize >> 1);
            } else if (this.mSize < 4) {
                n3 = 4;
            }
            int[] nArray = this.mHashes;
            Object[] objectArray = this.mArray;
            this.allocArrays(n3);
            if (this.mHashes.length > 0) {
                System.arraycopy((int[])nArray, (int)0, (int[])this.mHashes, (int)0, (int)nArray.length);
                System.arraycopy(objectArray, 0, this.mArray, 0, objectArray.length);
            }
            ArraySet.freeArrays(nArray, objectArray, this.mSize);
        }
        if (n4 < this.mSize) {
            System.arraycopy((int[])this.mHashes, (int)n4, (int[])this.mHashes, (int)(n4 + 1), (int)(this.mSize - n4));
            System.arraycopy(this.mArray, n4, this.mArray, n4 + 1, this.mSize - n4);
        }
        this.mHashes[n4] = n2;
        this.mArray[n4] = e;
        this.mSize = 1 + this.mSize;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addAll(ArraySet<? extends E> arraySet) {
        int n = arraySet.mSize;
        this.ensureCapacity(n + this.mSize);
        if (this.mSize == 0) {
            if (n <= 0) return;
            System.arraycopy((int[])arraySet.mHashes, (int)0, (int[])this.mHashes, (int)0, (int)n);
            System.arraycopy(arraySet.mArray, 0, this.mArray, 0, n);
            this.mSize = n;
            return;
        } else {
            for (int i = 0; i < n; ++i) {
                this.add(arraySet.valueAt(i));
            }
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        this.ensureCapacity(this.mSize + collection.size());
        boolean bl = false;
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl |= this.add(iterator.next());
        }
        return bl;
    }

    @Override
    public void clear() {
        if (this.mSize != 0) {
            ArraySet.freeArrays(this.mHashes, this.mArray, this.mSize);
            this.mHashes = EmptyArray.INT;
            this.mArray = EmptyArray.OBJECT;
            this.mSize = 0;
        }
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public void ensureCapacity(int n) {
        if (this.mHashes.length < n) {
            int[] nArray = this.mHashes;
            Object[] objectArray = this.mArray;
            this.allocArrays(n);
            if (this.mSize > 0) {
                System.arraycopy((int[])nArray, (int)0, (int[])this.mHashes, (int)0, (int)this.mSize);
                System.arraycopy(objectArray, 0, this.mArray, 0, this.mSize);
            }
            ArraySet.freeArrays(nArray, objectArray, this.mSize);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean equals(Object object) {
        if (this == object) return true;
        if (!(object instanceof Set)) {
            return false;
        }
        Set set = (Set)object;
        if (this.size() != set.size()) {
            return false;
        }
        try {
            for (int i = 0; i < this.mSize; ++i) {
                boolean bl = set.contains(this.valueAt(i));
                if (bl) continue;
                return false;
            }
            return true;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        int[] nArray = this.mHashes;
        int n = 0;
        int n2 = this.mSize;
        for (int i = 0; i < n2; ++i) {
            n += nArray[i];
        }
        return n;
    }

    public int indexOf(Object object) {
        if (object == null) {
            return this.indexOfNull();
        }
        return this.indexOf(object, object.hashCode());
    }

    @Override
    public boolean isEmpty() {
        return this.mSize <= 0;
    }

    @Override
    public Iterator<E> iterator() {
        return this.getCollection().getKeySet().iterator();
    }

    @Override
    public boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n >= 0) {
            this.removeAt(n);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl |= this.remove(iterator.next());
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public E removeAt(int n) {
        int n2 = 8;
        Object object = this.mArray[n];
        if (this.mSize <= 1) {
            ArraySet.freeArrays(this.mHashes, this.mArray, this.mSize);
            this.mHashes = EmptyArray.INT;
            this.mArray = EmptyArray.OBJECT;
            this.mSize = 0;
            return (E)object;
        }
        if (this.mHashes.length > n2 && this.mSize < this.mHashes.length / 3) {
            if (this.mSize > n2) {
                n2 = this.mSize + (this.mSize >> 1);
            }
            int[] nArray = this.mHashes;
            Object[] objectArray = this.mArray;
            this.allocArrays(n2);
            this.mSize = -1 + this.mSize;
            if (n > 0) {
                System.arraycopy((int[])nArray, (int)0, (int[])this.mHashes, (int)0, (int)n);
                System.arraycopy(objectArray, 0, this.mArray, 0, n);
            }
            if (n >= this.mSize) return (E)object;
            System.arraycopy((int[])nArray, (int)(n + 1), (int[])this.mHashes, (int)n, (int)(this.mSize - n));
            System.arraycopy(objectArray, n + 1, this.mArray, n, this.mSize - n);
            return (E)object;
        }
        this.mSize = -1 + this.mSize;
        if (n < this.mSize) {
            System.arraycopy((int[])this.mHashes, (int)(n + 1), (int[])this.mHashes, (int)n, (int)(this.mSize - n));
            System.arraycopy(this.mArray, n + 1, this.mArray, n, this.mSize - n);
        }
        this.mArray[this.mSize] = null;
        return (E)object;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl = false;
        for (int i = -1 + this.mSize; i >= 0; --i) {
            if (collection.contains(this.mArray[i])) continue;
            this.removeAt(i);
            bl = true;
        }
        return bl;
    }

    @Override
    public int size() {
        return this.mSize;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.mSize];
        System.arraycopy(this.mArray, 0, objectArray, 0, this.mSize);
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        if (objectArray.length < this.mSize) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.mSize);
        }
        System.arraycopy(this.mArray, 0, objectArray, 0, this.mSize);
        if (objectArray.length > this.mSize) {
            objectArray[this.mSize] = null;
        }
        return objectArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(14 * this.mSize);
        stringBuilder.append('{');
        int n = 0;
        while (true) {
            E e;
            if (n >= this.mSize) {
                stringBuilder.append('}');
                return stringBuilder.toString();
            }
            if (n > 0) {
                stringBuilder.append(", ");
            }
            if ((e = this.valueAt(n)) != this) {
                stringBuilder.append(e);
            } else {
                stringBuilder.append("(this Set)");
            }
            ++n;
        }
    }

    public E valueAt(int n) {
        return (E)this.mArray[n];
    }
}

