/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.transition.TransitionPropagation;
import android.transition.TransitionValues;
import android.view.View;

public abstract class VisibilityPropagation
extends TransitionPropagation {
    private static final String PROPNAME_VIEW_CENTER = "android:visibilityPropagation:center";
    private static final String PROPNAME_VISIBILITY = "android:visibilityPropagation:visibility";
    private static final String[] VISIBILITY_PROPAGATION_VALUES = new String[]{"android:visibilityPropagation:visibility", "android:visibilityPropagation:center"};

    private static int getViewCoordinate(TransitionValues transitionValues, int n) {
        if (transitionValues == null) {
            return -1;
        }
        int[] nArray = (int[])transitionValues.values.get(PROPNAME_VIEW_CENTER);
        if (nArray == null) {
            return -1;
        }
        return nArray[n];
    }

    @Override
    public void captureValues(TransitionValues transitionValues) {
        View view = transitionValues.view;
        Integer n = (Integer)transitionValues.values.get("android:visibility:visibility");
        if (n == null) {
            n = view.getVisibility();
        }
        transitionValues.values.put(PROPNAME_VISIBILITY, n);
        int[] nArray = new int[2];
        view.getLocationOnScreen(nArray);
        nArray[0] = nArray[0] + Math.round(view.getTranslationX());
        nArray[0] = nArray[0] + view.getWidth() / 2;
        nArray[1] = nArray[1] + Math.round(view.getTranslationY());
        nArray[1] = nArray[1] + view.getHeight() / 2;
        transitionValues.values.put(PROPNAME_VIEW_CENTER, nArray);
    }

    @Override
    public String[] getPropagationProperties() {
        return VISIBILITY_PROPAGATION_VALUES;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getViewVisibility(TransitionValues transitionValues) {
        Integer n;
        if (transitionValues == null || (n = (Integer)transitionValues.values.get(PROPNAME_VISIBILITY)) == null) {
            return 8;
        }
        return n;
    }

    public int getViewX(TransitionValues transitionValues) {
        return VisibilityPropagation.getViewCoordinate(transitionValues, 0);
    }

    public int getViewY(TransitionValues transitionValues) {
        return VisibilityPropagation.getViewCoordinate(transitionValues, 1);
    }
}

