/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.transition.PathMotion;
import android.util.AttributeSet;
import android.util.FloatMath;
import android.util.PathParser;
import com.android.internal.R;

public class PatternPathMotion
extends PathMotion {
    private Path mOriginalPatternPath;
    private final Path mPatternPath = new Path();
    private final Matrix mTempMatrix = new Matrix();

    public PatternPathMotion() {
        this.mPatternPath.lineTo(1.0f, 0.0f);
        this.mOriginalPatternPath = this.mPatternPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PatternPathMotion(Context context, AttributeSet attributeSet) {
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.PatternPathMotion);
        try {
            String string2 = typedArray.getString(0);
            if (string2 == null) {
                throw new RuntimeException("pathData must be supplied for patternPathMotion");
            }
            this.setPatternPath(PathParser.createPathFromPathData(string2));
            return;
        }
        finally {
            typedArray.recycle();
        }
    }

    public PatternPathMotion(Path path) {
        this.setPatternPath(path);
    }

    private static float distance(float f, float f2) {
        return FloatMath.sqrt(f * f + f2 * f2);
    }

    @Override
    public Path getPath(float f, float f2, float f3, float f4) {
        float f5 = f3 - f;
        float f6 = f4 - f2;
        float f7 = PatternPathMotion.distance(f5, f6);
        double d = Math.atan2(f6, f5);
        this.mTempMatrix.setScale(f7, f7);
        this.mTempMatrix.postRotate((float)Math.toDegrees(d));
        this.mTempMatrix.postTranslate(f, f2);
        Path path = new Path();
        this.mPatternPath.transform(this.mTempMatrix, path);
        return path;
    }

    public Path getPatternPath() {
        return this.mOriginalPatternPath;
    }

    public void setPatternPath(Path path) {
        PathMeasure pathMeasure = new PathMeasure(path, false);
        float f = pathMeasure.getLength();
        float[] fArray = new float[2];
        pathMeasure.getPosTan(f, fArray, null);
        float f2 = fArray[0];
        float f3 = fArray[1];
        pathMeasure.getPosTan(0.0f, fArray, null);
        float f4 = fArray[0];
        float f5 = fArray[1];
        if (f4 == f2 && f5 == f3) {
            throw new IllegalArgumentException("pattern must not end at the starting point");
        }
        this.mTempMatrix.setTranslate(-f4, -f5);
        float f6 = f2 - f4;
        float f7 = f3 - f5;
        float f8 = 1.0f / PatternPathMotion.distance(f6, f7);
        this.mTempMatrix.postScale(f8, f8);
        double d = Math.atan2(f7, f6);
        this.mTempMatrix.postRotate((float)Math.toDegrees(-d));
        path.transform(this.mTempMatrix, this.mPatternPath);
        this.mOriginalPatternPath = path;
    }
}

