/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.RectEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.transition.Transition;
import android.transition.TransitionValues;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOverlay;
import java.util.Map;

public class Crossfade
extends Transition {
    public static final int FADE_BEHAVIOR_CROSSFADE = 0;
    public static final int FADE_BEHAVIOR_OUT_IN = 2;
    public static final int FADE_BEHAVIOR_REVEAL = 1;
    private static final String LOG_TAG = "Crossfade";
    private static final String PROPNAME_BITMAP = "android:crossfade:bitmap";
    private static final String PROPNAME_BOUNDS = "android:crossfade:bounds";
    private static final String PROPNAME_DRAWABLE = "android:crossfade:drawable";
    public static final int RESIZE_BEHAVIOR_NONE = 0;
    public static final int RESIZE_BEHAVIOR_SCALE = 1;
    private static RectEvaluator sRectEvaluator = new RectEvaluator();
    private int mFadeBehavior = 1;
    private int mResizeBehavior = 1;

    /*
     * Enabled aggressive block sorting
     */
    private void captureValues(TransitionValues transitionValues) {
        View view = transitionValues.view;
        Rect rect = new Rect(0, 0, view.getWidth(), view.getHeight());
        if (this.mFadeBehavior != 1) {
            rect.offset(view.getLeft(), view.getTop());
        }
        transitionValues.values.put(PROPNAME_BOUNDS, rect);
        Bitmap bitmap = Bitmap.createBitmap(view.getWidth(), view.getHeight(), Bitmap.Config.ARGB_8888);
        if (view instanceof TextureView) {
            bitmap = ((TextureView)view).getBitmap();
        } else {
            view.draw(new Canvas(bitmap));
        }
        transitionValues.values.put(PROPNAME_BITMAP, bitmap);
        BitmapDrawable bitmapDrawable = new BitmapDrawable(bitmap);
        bitmapDrawable.setBounds(rect);
        transitionValues.values.put(PROPNAME_DRAWABLE, bitmapDrawable);
    }

    @Override
    public void captureEndValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    @Override
    public void captureStartValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Animator createAnimator(ViewGroup viewGroup, TransitionValues transitionValues, TransitionValues transitionValues2) {
        ObjectAnimator objectAnimator;
        if (transitionValues == null) return null;
        if (transitionValues2 == null) {
            return null;
        }
        final boolean bl = this.mFadeBehavior != 1;
        final View view = transitionValues2.view;
        Map<String, Object> map = transitionValues.values;
        Map<String, Object> map2 = transitionValues2.values;
        Rect rect = (Rect)map.get(PROPNAME_BOUNDS);
        Rect rect2 = (Rect)map2.get(PROPNAME_BOUNDS);
        Bitmap bitmap = (Bitmap)map.get(PROPNAME_BITMAP);
        Bitmap bitmap2 = (Bitmap)map2.get(PROPNAME_BITMAP);
        final BitmapDrawable bitmapDrawable = (BitmapDrawable)map.get(PROPNAME_DRAWABLE);
        final BitmapDrawable bitmapDrawable2 = (BitmapDrawable)map2.get(PROPNAME_DRAWABLE);
        if (bitmapDrawable == null) return null;
        if (bitmapDrawable2 == null) return null;
        if (bitmap.sameAs(bitmap2)) return null;
        ViewOverlay viewOverlay = bl ? ((ViewGroup)view.getParent()).getOverlay() : view.getOverlay();
        if (this.mFadeBehavior == 1) {
            viewOverlay.add(bitmapDrawable2);
        }
        viewOverlay.add(bitmapDrawable);
        ObjectAnimator objectAnimator2 = this.mFadeBehavior == 2 ? ObjectAnimator.ofInt((Object)bitmapDrawable, "alpha", 255, 0, 0) : ObjectAnimator.ofInt((Object)bitmapDrawable, "alpha", 0);
        objectAnimator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            @Override
            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                view.invalidate(bitmapDrawable.getBounds());
            }
        });
        if (this.mFadeBehavior == 2) {
            objectAnimator = ObjectAnimator.ofFloat(view, View.ALPHA, 0.0f, 0.0f, 1.0f);
        } else {
            int n = this.mFadeBehavior;
            objectAnimator = null;
            if (n == 0) {
                objectAnimator = ObjectAnimator.ofFloat(view, View.ALPHA, 0.0f, 1.0f);
            }
        }
        objectAnimator2.addListener(new AnimatorListenerAdapter(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onAnimationEnd(Animator animator2) {
                ViewOverlay viewOverlay = bl ? ((ViewGroup)view.getParent()).getOverlay() : view.getOverlay();
                viewOverlay.remove(bitmapDrawable);
                if (Crossfade.this.mFadeBehavior == 1) {
                    viewOverlay.remove(bitmapDrawable2);
                }
            }
        });
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(objectAnimator2);
        if (objectAnimator != null) {
            animatorSet.playTogether(objectAnimator);
        }
        if (this.mResizeBehavior != 1) return animatorSet;
        if (rect.equals(rect2)) return animatorSet;
        animatorSet.playTogether(ObjectAnimator.ofObject((Object)bitmapDrawable, "bounds", (TypeEvaluator)sRectEvaluator, rect, rect2));
        if (this.mResizeBehavior != 1) return animatorSet;
        animatorSet.playTogether(ObjectAnimator.ofObject((Object)bitmapDrawable2, "bounds", (TypeEvaluator)sRectEvaluator, rect, rect2));
        return animatorSet;
    }

    public int getFadeBehavior() {
        return this.mFadeBehavior;
    }

    public int getResizeBehavior() {
        return this.mResizeBehavior;
    }

    public Crossfade setFadeBehavior(int n) {
        if (n >= 0 && n <= 2) {
            this.mFadeBehavior = n;
        }
        return this;
    }

    public Crossfade setResizeBehavior(int n) {
        if (n >= 0 && n <= 1) {
            this.mResizeBehavior = n;
        }
        return this;
    }
}

