/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.graphics.Rect;
import android.transition.Transition;
import android.transition.TransitionValues;
import android.transition.VisibilityPropagation;
import android.util.FloatMath;
import android.view.ViewGroup;

public class CircularPropagation
extends VisibilityPropagation {
    private static final String TAG = "CircularPropagation";
    private float mPropagationSpeed = 3.0f;

    private static float distance(float f, float f2, float f3, float f4) {
        float f5 = f3 - f;
        float f6 = f4 - f2;
        return FloatMath.sqrt(f5 * f5 + f6 * f6);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public long getStartDelay(ViewGroup viewGroup, Transition transition2, TransitionValues transitionValues, TransitionValues transitionValues2) {
        int n;
        int n2;
        TransitionValues transitionValues3;
        if (transitionValues == null && transitionValues2 == null) {
            return 0L;
        }
        int n3 = 1;
        if (transitionValues2 == null || this.getViewVisibility(transitionValues) == 0) {
            transitionValues3 = transitionValues;
            n3 = -1;
        } else {
            transitionValues3 = transitionValues2;
        }
        int n4 = this.getViewX(transitionValues3);
        int n5 = this.getViewY(transitionValues3);
        Rect rect = transition2.getEpicenter();
        if (rect != null) {
            n2 = rect.centerX();
            n = rect.centerY();
        } else {
            int[] nArray = new int[2];
            viewGroup.getLocationOnScreen(nArray);
            n2 = Math.round((float)(nArray[0] + viewGroup.getWidth() / 2) + viewGroup.getTranslationX());
            n = Math.round((float)(nArray[1] + viewGroup.getHeight() / 2) + viewGroup.getTranslationY());
        }
        float f = CircularPropagation.distance(n4, n5, n2, n) / CircularPropagation.distance(0.0f, 0.0f, viewGroup.getWidth(), viewGroup.getHeight());
        long l = transition2.getDuration();
        if (l < 0L) {
            l = 300L;
        }
        return Math.round(f * ((float)(l * (long)n3) / this.mPropagationSpeed));
    }

    public void setPropagationSpeed(float f) {
        if (f == 0.0f) {
            throw new IllegalArgumentException("propagationSpeed may not be 0");
        }
        this.mPropagationSpeed = f;
    }
}

