/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Matrix;
import android.transition.Transition;
import android.transition.TransitionUtils;
import android.transition.TransitionValues;
import android.util.AttributeSet;
import android.util.Property;
import android.view.GhostView;
import android.view.View;
import android.view.ViewGroup;
import com.android.internal.R;

public class ChangeTransform
extends Transition {
    private static final Property<View, Matrix> ANIMATION_MATRIX_PROPERTY;
    private static final String PROPNAME_INTERMEDIATE_MATRIX = "android:changeTransform:intermediateMatrix";
    private static final String PROPNAME_INTERMEDIATE_PARENT_MATRIX = "android:changeTransform:intermediateParentMatrix";
    private static final String PROPNAME_MATRIX = "android:changeTransform:matrix";
    private static final String PROPNAME_PARENT = "android:changeTransform:parent";
    private static final String PROPNAME_PARENT_MATRIX = "android:changeTransform:parentMatrix";
    private static final String PROPNAME_TRANSFORMS = "android:changeTransform:transforms";
    private static final String TAG = "ChangeTransform";
    private static final String[] sTransitionProperties;
    private boolean mReparent = true;
    private Matrix mTempMatrix = new Matrix();
    private boolean mUseOverlay = true;

    static {
        sTransitionProperties = new String[]{PROPNAME_MATRIX, PROPNAME_TRANSFORMS, PROPNAME_PARENT_MATRIX};
        ANIMATION_MATRIX_PROPERTY = new Property<View, Matrix>(Matrix.class, "animationMatrix"){

            @Override
            public Matrix get(View view) {
                return null;
            }

            @Override
            public void set(View view, Matrix matrix) {
                view.setAnimationMatrix(matrix);
            }
        };
    }

    public ChangeTransform() {
    }

    public ChangeTransform(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ChangeTransform);
        this.mUseOverlay = typedArray.getBoolean(1, true);
        this.mReparent = typedArray.getBoolean(0, true);
        typedArray.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void captureValues(TransitionValues transitionValues) {
        View view;
        block3: {
            block2: {
                view = transitionValues.view;
                if (view.getVisibility() == 8) break block2;
                transitionValues.values.put(PROPNAME_PARENT, view.getParent());
                Transforms transforms = new Transforms(view);
                transitionValues.values.put(PROPNAME_TRANSFORMS, transforms);
                Matrix matrix = view.getMatrix();
                Matrix matrix2 = matrix == null || matrix.isIdentity() ? null : new Matrix(matrix);
                transitionValues.values.put(PROPNAME_MATRIX, matrix2);
                if (this.mReparent) break block3;
            }
            return;
        }
        Matrix matrix = new Matrix();
        ViewGroup viewGroup = (ViewGroup)view.getParent();
        viewGroup.transformMatrixToGlobal(matrix);
        matrix.preTranslate(-viewGroup.getScrollX(), -viewGroup.getScrollY());
        transitionValues.values.put(PROPNAME_PARENT_MATRIX, matrix);
        transitionValues.values.put(PROPNAME_INTERMEDIATE_MATRIX, view.getTag(16908358));
        transitionValues.values.put(PROPNAME_INTERMEDIATE_PARENT_MATRIX, view.getTag(16908359));
    }

    private void createGhostView(ViewGroup viewGroup, TransitionValues transitionValues, TransitionValues transitionValues2) {
        View view = transitionValues2.view;
        Matrix matrix = (Matrix)transitionValues2.values.get(PROPNAME_PARENT_MATRIX);
        Matrix matrix2 = new Matrix(matrix);
        viewGroup.transformMatrixToLocal(matrix2);
        GhostView ghostView = GhostView.addGhost(view, viewGroup, matrix2);
        Transition transition2 = this;
        while (transition2.mParent != null) {
            transition2 = transition2.mParent;
        }
        transition2.addListener(new GhostListener(view, ghostView, matrix));
        if (transitionValues.view != transitionValues2.view) {
            transitionValues.view.setTransitionAlpha(0.0f);
        }
        view.setTransitionAlpha(1.0f);
    }

    private ObjectAnimator createTransformAnimator(TransitionValues transitionValues, TransitionValues transitionValues2, final boolean bl) {
        Matrix matrix = (Matrix)transitionValues.values.get(PROPNAME_MATRIX);
        final Matrix matrix2 = (Matrix)transitionValues2.values.get(PROPNAME_MATRIX);
        if (matrix == null) {
            matrix = Matrix.IDENTITY_MATRIX;
        }
        if (matrix2 == null) {
            matrix2 = Matrix.IDENTITY_MATRIX;
        }
        if (matrix.equals(matrix2)) {
            return null;
        }
        final Transforms transforms = (Transforms)transitionValues2.values.get(PROPNAME_TRANSFORMS);
        final View view = transitionValues2.view;
        ChangeTransform.setIdentityTransforms(view);
        ObjectAnimator objectAnimator = ObjectAnimator.ofObject(view, ANIMATION_MATRIX_PROPERTY, new TransitionUtils.MatrixEvaluator(), matrix, matrix2);
        AnimatorListenerAdapter animatorListenerAdapter = new AnimatorListenerAdapter(){
            private boolean mIsCanceled;
            private Matrix mTempMatrix = new Matrix();

            private void setCurrentMatrix(Matrix matrix) {
                this.mTempMatrix.set(matrix);
                view.setTagInternal(16908358, this.mTempMatrix);
                transforms.restore(view);
            }

            @Override
            public void onAnimationCancel(Animator animator2) {
                this.mIsCanceled = true;
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onAnimationEnd(Animator animator2) {
                if (!this.mIsCanceled) {
                    if (bl && ChangeTransform.this.mUseOverlay) {
                        this.setCurrentMatrix(matrix2);
                    } else {
                        view.setTagInternal(16908358, null);
                        view.setTagInternal(16908359, null);
                    }
                }
                ANIMATION_MATRIX_PROPERTY.set(view, null);
                transforms.restore(view);
            }

            @Override
            public void onAnimationPause(Animator animator2) {
                this.setCurrentMatrix((Matrix)((ValueAnimator)animator2).getAnimatedValue());
            }

            @Override
            public void onAnimationResume(Animator animator2) {
                ChangeTransform.setIdentityTransforms(view);
            }
        };
        objectAnimator.addListener(animatorListenerAdapter);
        objectAnimator.addPauseListener(animatorListenerAdapter);
        return objectAnimator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parentsMatch(ViewGroup viewGroup, ViewGroup viewGroup2) {
        if (!this.isValidTarget(viewGroup) || !this.isValidTarget(viewGroup2)) {
            if (viewGroup != viewGroup2) return false;
            return true;
        }
        TransitionValues transitionValues = this.getMatchedTransitionValues(viewGroup, true);
        boolean bl = false;
        if (transitionValues == null) return bl;
        if (viewGroup2 != transitionValues.view) return false;
        return true;
    }

    private static void setIdentityTransforms(View view) {
        ChangeTransform.setTransforms(view, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
    }

    private void setMatricesForParent(TransitionValues transitionValues, TransitionValues transitionValues2) {
        Matrix matrix = (Matrix)transitionValues2.values.get(PROPNAME_PARENT_MATRIX);
        transitionValues2.view.setTagInternal(16908359, matrix);
        Matrix matrix2 = this.mTempMatrix;
        matrix2.reset();
        matrix.invert(matrix2);
        Matrix matrix3 = (Matrix)transitionValues.values.get(PROPNAME_MATRIX);
        if (matrix3 == null) {
            matrix3 = new Matrix();
            transitionValues.values.put(PROPNAME_MATRIX, matrix3);
        }
        matrix3.postConcat((Matrix)transitionValues.values.get(PROPNAME_PARENT_MATRIX));
        matrix3.postConcat(matrix2);
    }

    private static void setTransforms(View view, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        view.setTranslationX(f);
        view.setTranslationY(f2);
        view.setTranslationZ(f3);
        view.setScaleX(f4);
        view.setScaleY(f5);
        view.setRotationX(f6);
        view.setRotationY(f7);
        view.setRotation(f8);
    }

    @Override
    public void captureEndValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    @Override
    public void captureStartValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Animator createAnimator(ViewGroup viewGroup, TransitionValues transitionValues, TransitionValues transitionValues2) {
        Matrix matrix;
        if (transitionValues == null) return null;
        if (transitionValues2 == null) return null;
        if (!transitionValues.values.containsKey(PROPNAME_PARENT)) return null;
        if (!transitionValues2.values.containsKey(PROPNAME_PARENT)) {
            return null;
        }
        ViewGroup viewGroup2 = (ViewGroup)transitionValues.values.get(PROPNAME_PARENT);
        ViewGroup viewGroup3 = (ViewGroup)transitionValues2.values.get(PROPNAME_PARENT);
        boolean bl = this.mReparent && !this.parentsMatch(viewGroup2, viewGroup3);
        Matrix matrix2 = (Matrix)transitionValues.values.get(PROPNAME_INTERMEDIATE_MATRIX);
        if (matrix2 != null) {
            transitionValues.values.put(PROPNAME_MATRIX, matrix2);
        }
        if ((matrix = (Matrix)transitionValues.values.get(PROPNAME_INTERMEDIATE_PARENT_MATRIX)) != null) {
            transitionValues.values.put(PROPNAME_PARENT_MATRIX, matrix);
        }
        if (bl) {
            this.setMatricesForParent(transitionValues, transitionValues2);
        }
        ObjectAnimator objectAnimator = this.createTransformAnimator(transitionValues, transitionValues2, bl);
        if (!bl) return objectAnimator;
        if (objectAnimator == null) return objectAnimator;
        if (!this.mUseOverlay) return objectAnimator;
        this.createGhostView(viewGroup, transitionValues, transitionValues2);
        return objectAnimator;
    }

    public boolean getReparent() {
        return this.mReparent;
    }

    public boolean getReparentWithOverlay() {
        return this.mUseOverlay;
    }

    @Override
    public String[] getTransitionProperties() {
        return sTransitionProperties;
    }

    public void setReparent(boolean bl) {
        this.mReparent = bl;
    }

    public void setReparentWithOverlay(boolean bl) {
        this.mUseOverlay = bl;
    }

    private static class GhostListener
    extends Transition.TransitionListenerAdapter {
        private Matrix mEndMatrix;
        private GhostView mGhostView;
        private View mView;

        public GhostListener(View view, GhostView ghostView, Matrix matrix) {
            this.mView = view;
            this.mGhostView = ghostView;
            this.mEndMatrix = matrix;
        }

        @Override
        public void onTransitionEnd(Transition transition2) {
            transition2.removeListener(this);
            GhostView.removeGhost(this.mView);
            this.mView.setTagInternal(16908358, null);
            this.mView.setTagInternal(16908359, null);
        }

        @Override
        public void onTransitionPause(Transition transition2) {
            this.mGhostView.setVisibility(4);
        }

        @Override
        public void onTransitionResume(Transition transition2) {
            this.mGhostView.setVisibility(0);
        }
    }

    private static class Transforms {
        public final float rotationX;
        public final float rotationY;
        public final float rotationZ;
        public final float scaleX;
        public final float scaleY;
        public final float translationX;
        public final float translationY;
        public final float translationZ;

        public Transforms(View view) {
            this.translationX = view.getTranslationX();
            this.translationY = view.getTranslationY();
            this.translationZ = view.getTranslationZ();
            this.scaleX = view.getScaleX();
            this.scaleY = view.getScaleY();
            this.rotationX = view.getRotationX();
            this.rotationY = view.getRotationY();
            this.rotationZ = view.getRotation();
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (!(object instanceof Transforms)) break block2;
                    Transforms transforms = (Transforms)object;
                    if (transforms.translationX == this.translationX && transforms.translationY == this.translationY && transforms.translationZ == this.translationZ && transforms.scaleX == this.scaleX && transforms.scaleY == this.scaleY && transforms.rotationX == this.rotationX && transforms.rotationY == this.rotationY && transforms.rotationZ == this.rotationZ) break block3;
                }
                return false;
            }
            return true;
        }

        public void restore(View view) {
            ChangeTransform.setTransforms(view, this.translationX, this.translationY, this.translationZ, this.scaleX, this.scaleY, this.rotationX, this.rotationY, this.rotationZ);
        }
    }
}

