/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Path;
import android.transition.PathMotion;
import android.util.AttributeSet;
import android.util.FloatMath;
import com.android.internal.R;

public class ArcMotion
extends PathMotion {
    private static final float DEFAULT_MAX_ANGLE_DEGREES = 70.0f;
    private static final float DEFAULT_MAX_TANGENT = (float)Math.tan(Math.toRadians(35.0));
    private static final float DEFAULT_MIN_ANGLE_DEGREES;
    private float mMaximumAngle = 70.0f;
    private float mMaximumTangent = DEFAULT_MAX_TANGENT;
    private float mMinimumHorizontalAngle = 0.0f;
    private float mMinimumHorizontalTangent = 0.0f;
    private float mMinimumVerticalAngle = 0.0f;
    private float mMinimumVerticalTangent = 0.0f;

    public ArcMotion() {
    }

    public ArcMotion(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ArcMotion);
        this.setMinimumVerticalAngle(typedArray.getFloat(1, 0.0f));
        this.setMinimumHorizontalAngle(typedArray.getFloat(0, 0.0f));
        this.setMaximumAngle(typedArray.getFloat(2, 70.0f));
        typedArray.recycle();
    }

    private static float toTangent(float f) {
        if (f < 0.0f || f > 90.0f) {
            throw new IllegalArgumentException("Arc must be between 0 and 90 degrees");
        }
        return (float)Math.tan(Math.toRadians(f / 2.0f));
    }

    public float getMaximumAngle() {
        return this.mMaximumAngle;
    }

    public float getMinimumHorizontalAngle() {
        return this.mMinimumHorizontalAngle;
    }

    public float getMinimumVerticalAngle() {
        return this.mMinimumVerticalAngle;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Path getPath(float f, float f2, float f3, float f4) {
        float f5;
        float f6;
        Path path = new Path();
        path.moveTo(f, f2);
        if (f2 == f4) {
            f6 = (f + f3) / 2.0f;
            f5 = f2 + this.mMinimumHorizontalTangent * Math.abs(f3 - f) / 2.0f;
        } else if (f == f3) {
            f6 = f + this.mMinimumVerticalTangent * Math.abs(f4 - f2) / 2.0f;
            f5 = (f2 + f4) / 2.0f;
        } else {
            float f7;
            float f8;
            float f9 = f3 - f;
            float f10 = f2 - f4;
            float f11 = f9 * f9 + f10 * f10;
            float f12 = (f + f3) / 2.0f;
            float f13 = (f2 + f4) / 2.0f;
            float f14 = f11 * 0.25f;
            if (Math.abs(f9) < Math.abs(f10)) {
                f5 = f4 + f11 / (2.0f * f10);
                f6 = f3;
                f8 = f14 * this.mMinimumVerticalTangent * this.mMinimumVerticalTangent;
            } else {
                f6 = f3 + f11 / (2.0f * f9);
                f5 = f4;
                f8 = f14 * this.mMinimumHorizontalTangent * this.mMinimumHorizontalTangent;
            }
            float f15 = f12 - f6;
            float f16 = f13 - f5;
            float f17 = f15 * f15 + f16 * f16;
            float f18 = f14 * this.mMaximumTangent * this.mMaximumTangent;
            if (f17 < f8) {
                f7 = f8;
            } else {
                float f19 = f17 == f18 ? 0 : (f17 > f18 ? 1 : -1);
                f7 = 0.0f;
                if (f19 > 0) {
                    f7 = f18;
                }
            }
            if (f7 != 0.0f) {
                float f20 = FloatMath.sqrt(f7 / f17);
                f6 = f12 + f20 * (f6 - f12);
                f5 = f13 + f20 * (f5 - f13);
            }
        }
        path.cubicTo((f + f6) / 2.0f, (f2 + f5) / 2.0f, (f6 + f3) / 2.0f, (f5 + f4) / 2.0f, f3, f4);
        return path;
    }

    public void setMaximumAngle(float f) {
        this.mMaximumAngle = f;
        this.mMaximumTangent = ArcMotion.toTangent(f);
    }

    public void setMinimumHorizontalAngle(float f) {
        this.mMinimumHorizontalAngle = f;
        this.mMinimumHorizontalTangent = ArcMotion.toTangent(f);
    }

    public void setMinimumVerticalAngle(float f) {
        this.mMinimumVerticalAngle = f;
        this.mMinimumVerticalTangent = ArcMotion.toTangent(f);
    }
}

