/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.Layout;
import android.text.Spanned;
import android.text.style.LeadingMarginSpan;
import android.text.style.LineHeightSpan;

public class IconMarginSpan
implements LeadingMarginSpan,
LineHeightSpan {
    private Bitmap mBitmap;
    private int mPad;

    public IconMarginSpan(Bitmap bitmap) {
        this.mBitmap = bitmap;
    }

    public IconMarginSpan(Bitmap bitmap, int n) {
        this.mBitmap = bitmap;
        this.mPad = n;
    }

    @Override
    public void chooseHeight(CharSequence charSequence, int n, int n2, int n3, int n4, Paint.FontMetricsInt fontMetricsInt) {
        if (n2 == ((Spanned)charSequence).getSpanEnd(this)) {
            int n5;
            int n6 = this.mBitmap.getHeight();
            int n7 = n6 - (n4 + fontMetricsInt.descent - fontMetricsInt.ascent - n3);
            if (n7 > 0) {
                fontMetricsInt.descent = n7 + fontMetricsInt.descent;
            }
            if ((n5 = n6 - (n4 + fontMetricsInt.bottom - fontMetricsInt.top - n3)) > 0) {
                fontMetricsInt.bottom = n5 + fontMetricsInt.bottom;
            }
        }
    }

    @Override
    public void drawLeadingMargin(Canvas canvas, Paint paint, int n, int n2, int n3, int n4, int n5, CharSequence charSequence, int n6, int n7, boolean bl, Layout layout2) {
        int n8 = layout2.getLineTop(layout2.getLineForOffset(((Spanned)charSequence).getSpanStart(this)));
        if (n2 < 0) {
            n -= this.mBitmap.getWidth();
        }
        canvas.drawBitmap(this.mBitmap, n, n8, paint);
    }

    @Override
    public int getLeadingMargin(boolean bl) {
        return this.mBitmap.getWidth() + this.mPad;
    }
}

