/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.style.ReplacementSpan;
import java.lang.ref.WeakReference;

public abstract class DynamicDrawableSpan
extends ReplacementSpan {
    public static final int ALIGN_BASELINE = 1;
    public static final int ALIGN_BOTTOM = 0;
    private static final String TAG = "DynamicDrawableSpan";
    private WeakReference<Drawable> mDrawableRef;
    protected final int mVerticalAlignment;

    public DynamicDrawableSpan() {
        this.mVerticalAlignment = 0;
    }

    protected DynamicDrawableSpan(int n) {
        this.mVerticalAlignment = n;
    }

    private Drawable getCachedDrawable() {
        WeakReference<Drawable> weakReference = this.mDrawableRef;
        Drawable drawable2 = null;
        if (weakReference != null) {
            drawable2 = (Drawable)weakReference.get();
        }
        if (drawable2 == null) {
            drawable2 = this.getDrawable();
            this.mDrawableRef = new WeakReference<Drawable>(drawable2);
        }
        return drawable2;
    }

    @Override
    public void draw(Canvas canvas, CharSequence charSequence, int n, int n2, float f, int n3, int n4, int n5, Paint paint) {
        Drawable drawable2 = this.getCachedDrawable();
        canvas.save();
        int n6 = n5 - drawable2.getBounds().bottom;
        if (this.mVerticalAlignment == 1) {
            n6 -= paint.getFontMetricsInt().descent;
        }
        canvas.translate(f, n6);
        drawable2.draw(canvas);
        canvas.restore();
    }

    public abstract Drawable getDrawable();

    @Override
    public int getSize(Paint paint, CharSequence charSequence, int n, int n2, Paint.FontMetricsInt fontMetricsInt) {
        Rect rect = this.getCachedDrawable().getBounds();
        if (fontMetricsInt != null) {
            fontMetricsInt.ascent = -rect.bottom;
            fontMetricsInt.descent = 0;
            fontMetricsInt.top = fontMetricsInt.ascent;
            fontMetricsInt.bottom = 0;
        }
        return rect.right;
    }

    public int getVerticalAlignment() {
        return this.mVerticalAlignment;
    }
}

