/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.text.AutoText;
import android.text.Editable;
import android.text.NoCopySpan;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextUtils;
import android.text.method.BaseKeyListener;
import android.text.method.CharacterPickerDialog;
import android.text.method.TextKeyListener;
import android.util.SparseArray;
import android.view.KeyEvent;
import android.view.View;

public class QwertyKeyListener
extends BaseKeyListener {
    private static SparseArray<String> PICKER_SETS;
    private static QwertyKeyListener sFullKeyboardInstance;
    private static QwertyKeyListener[] sInstance;
    private TextKeyListener.Capitalize mAutoCap;
    private boolean mAutoText;
    private boolean mFullKeyboard;

    static {
        sInstance = new QwertyKeyListener[2 * TextKeyListener.Capitalize.values().length];
        PICKER_SETS = new SparseArray();
        PICKER_SETS.put(65, "\u00c0\u00c1\u00c2\u00c4\u00c6\u00c3\u00c5\u0104\u0100");
        PICKER_SETS.put(67, "\u00c7\u0106\u010c");
        PICKER_SETS.put(68, "\u010e");
        PICKER_SETS.put(69, "\u00c8\u00c9\u00ca\u00cb\u0118\u011a\u0112");
        PICKER_SETS.put(71, "\u011e");
        PICKER_SETS.put(76, "\u0141");
        PICKER_SETS.put(73, "\u00cc\u00cd\u00ce\u00cf\u012a\u0130");
        PICKER_SETS.put(78, "\u00d1\u0143\u0147");
        PICKER_SETS.put(79, "\u00d8\u0152\u00d5\u00d2\u00d3\u00d4\u00d6\u014c");
        PICKER_SETS.put(82, "\u0158");
        PICKER_SETS.put(83, "\u015a\u0160\u015e");
        PICKER_SETS.put(84, "\u0164");
        PICKER_SETS.put(85, "\u00d9\u00da\u00db\u00dc\u016e\u016a");
        PICKER_SETS.put(89, "\u00dd\u0178");
        PICKER_SETS.put(90, "\u0179\u017b\u017d");
        PICKER_SETS.put(97, "\u00e0\u00e1\u00e2\u00e4\u00e6\u00e3\u00e5\u0105\u0101");
        PICKER_SETS.put(99, "\u00e7\u0107\u010d");
        PICKER_SETS.put(100, "\u010f");
        PICKER_SETS.put(101, "\u00e8\u00e9\u00ea\u00eb\u0119\u011b\u0113");
        PICKER_SETS.put(103, "\u011f");
        PICKER_SETS.put(105, "\u00ec\u00ed\u00ee\u00ef\u012b\u0131");
        PICKER_SETS.put(108, "\u0142");
        PICKER_SETS.put(110, "\u00f1\u0144\u0148");
        PICKER_SETS.put(111, "\u00f8\u0153\u00f5\u00f2\u00f3\u00f4\u00f6\u014d");
        PICKER_SETS.put(114, "\u0159");
        PICKER_SETS.put(115, "\u00a7\u00df\u015b\u0161\u015f");
        PICKER_SETS.put(116, "\u0165");
        PICKER_SETS.put(117, "\u00f9\u00fa\u00fb\u00fc\u016f\u016b");
        PICKER_SETS.put(121, "\u00fd\u00ff");
        PICKER_SETS.put(122, "\u017a\u017c\u017e");
        PICKER_SETS.put(61185, "\u2026\u00a5\u2022\u00ae\u00a9\u00b1[]{}\\|");
        PICKER_SETS.put(47, "\\");
        PICKER_SETS.put(49, "\u00b9\u00bd\u2153\u00bc\u215b");
        PICKER_SETS.put(50, "\u00b2\u2154");
        PICKER_SETS.put(51, "\u00b3\u00be\u215c");
        PICKER_SETS.put(52, "\u2074");
        PICKER_SETS.put(53, "\u215d");
        PICKER_SETS.put(55, "\u215e");
        PICKER_SETS.put(48, "\u207f\u2205");
        PICKER_SETS.put(36, "\u00a2\u00a3\u20ac\u00a5\u20a3\u20a4\u20b1");
        PICKER_SETS.put(37, "\u2030");
        PICKER_SETS.put(42, "\u2020\u2021");
        PICKER_SETS.put(45, "\u2013\u2014");
        PICKER_SETS.put(43, "\u00b1");
        PICKER_SETS.put(40, "[{<");
        PICKER_SETS.put(41, "]}>");
        PICKER_SETS.put(33, "\u00a1");
        PICKER_SETS.put(34, "\u201c\u201d\u00ab\u00bb\u02dd");
        PICKER_SETS.put(63, "\u00bf");
        PICKER_SETS.put(44, "\u201a\u201e");
        PICKER_SETS.put(61, "\u2260\u2248\u221e");
        PICKER_SETS.put(60, "\u2264\u00ab\u2039");
        PICKER_SETS.put(62, "\u2265\u00bb\u203a");
    }

    public QwertyKeyListener(TextKeyListener.Capitalize capitalize, boolean bl) {
        this(capitalize, bl, false);
    }

    private QwertyKeyListener(TextKeyListener.Capitalize capitalize, boolean bl, boolean bl2) {
        this.mAutoCap = capitalize;
        this.mAutoText = bl;
        this.mFullKeyboard = bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static QwertyKeyListener getInstance(boolean bl, TextKeyListener.Capitalize capitalize) {
        int n;
        int n2 = 2 * capitalize.ordinal();
        int n3 = n2 + (n = bl ? 1 : 0);
        if (sInstance[n3] == null) {
            QwertyKeyListener.sInstance[n3] = new QwertyKeyListener(capitalize, bl);
        }
        return sInstance[n3];
    }

    public static QwertyKeyListener getInstanceForFullKeyboard() {
        if (sFullKeyboardInstance == null) {
            sFullKeyboardInstance = new QwertyKeyListener(TextKeyListener.Capitalize.NONE, false, true);
        }
        return sFullKeyboardInstance;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String getReplacement(CharSequence charSequence, int n, int n2, View view) {
        int n3 = n2 - n;
        String string2 = AutoText.get(charSequence, n, n2, view);
        boolean bl = false;
        if (string2 == null) {
            string2 = AutoText.get(TextUtils.substring(charSequence, n, n2).toLowerCase(), 0, n2 - n, view);
            bl = true;
            if (string2 == null) {
                return null;
            }
        }
        int n4 = 0;
        if (bl) {
            for (int i = n; i < n2; ++i) {
                if (!Character.isUpperCase(charSequence.charAt(i))) continue;
                ++n4;
            }
        }
        String string3 = n4 == 0 ? string2 : (n4 == 1 ? QwertyKeyListener.toTitleCase(string2) : (n4 == n3 ? string2.toUpperCase() : QwertyKeyListener.toTitleCase(string2)));
        if (string3.length() != n3) return string3;
        if (!TextUtils.regionMatches(charSequence, n, string3, 0, n3)) return string3;
        return null;
    }

    public static void markAsReplaced(Spannable spannable, int n, int n2, String string2) {
        Replaced[] replacedArray = spannable.getSpans(0, spannable.length(), Replaced.class);
        for (int i = 0; i < replacedArray.length; ++i) {
            spannable.removeSpan(replacedArray[i]);
        }
        int n3 = string2.length();
        char[] cArray = new char[n3];
        string2.getChars(0, n3, cArray, 0);
        spannable.setSpan(new Replaced(cArray), n, n2, 33);
    }

    private boolean showCharacterPicker(View view, Editable editable, char c, boolean bl, int n) {
        String string2 = PICKER_SETS.get(c);
        if (string2 == null) {
            return false;
        }
        if (n == 1) {
            new CharacterPickerDialog(view.getContext(), view, editable, string2, bl).show();
        }
        return true;
    }

    private static String toTitleCase(String string2) {
        return Character.toUpperCase(string2.charAt(0)) + string2.substring(1);
    }

    @Override
    public int getInputType() {
        return QwertyKeyListener.makeTextContentType(this.mAutoCap, this.mAutoText);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean onKeyDown(View view, Editable editable, int n, KeyEvent keyEvent) {
        int n2;
        int n3;
        block38: {
            String string2;
            int n4;
            block40: {
                int n5;
                int n6;
                block39: {
                    char c;
                    int n7;
                    n3 = 0;
                    if (view != null) {
                        n3 = TextKeyListener.getInstance().getPrefs(view.getContext());
                    }
                    int n8 = Selection.getSelectionStart(editable);
                    int n9 = Selection.getSelectionEnd(editable);
                    n6 = Math.min(n8, n9);
                    n5 = Math.max(n8, n9);
                    if (n6 < 0 || n5 < 0) {
                        n5 = 0;
                        n6 = 0;
                        Selection.setSelection(editable, 0, 0);
                    }
                    int n10 = editable.getSpanStart(TextKeyListener.ACTIVE);
                    int n11 = editable.getSpanEnd(TextKeyListener.ACTIVE);
                    int n12 = keyEvent.getUnicodeChar(QwertyKeyListener.getMetaState((CharSequence)editable, keyEvent));
                    if (!this.mFullKeyboard && (n7 = keyEvent.getRepeatCount()) > 0 && n6 == n5 && n6 > 0 && ((c = editable.charAt(n6 - 1)) == n12 || c == Character.toUpperCase(n12)) && view != null && this.showCharacterPicker(view, editable, c, false, n7)) {
                        QwertyKeyListener.resetMetaState(editable);
                        return true;
                    }
                    if (n12 == 61185) {
                        if (view != null) {
                            this.showCharacterPicker(view, editable, '\uef01', true, 1);
                        }
                        QwertyKeyListener.resetMetaState(editable);
                        return true;
                    }
                    if (n12 == 61184) {
                        int n13;
                        if (n6 == n5) {
                            for (n13 = n5; n13 > 0 && n5 - n13 < 4 && Character.digit(editable.charAt(n13 - 1), 16) >= 0; --n13) {
                            }
                        } else {
                            n13 = n6;
                        }
                        int n14 = -1;
                        try {
                            int n15;
                            n14 = n15 = Integer.parseInt(TextUtils.substring(editable, n13, n5), 16);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        if (n14 >= 0) {
                            n6 = n13;
                            Selection.setSelection(editable, n6, n5);
                            n12 = n14;
                        } else {
                            n12 = 0;
                        }
                    }
                    if (n12 == 0) break block39;
                    int n16 = Integer.MIN_VALUE & n12;
                    boolean bl = false;
                    if (n16 != 0) {
                        bl = true;
                        n12 &= Integer.MAX_VALUE;
                    }
                    if (n10 == n6 && n11 == n5) {
                        int n17 = -1 + (n5 - n6);
                        boolean bl2 = false;
                        if (n17 == 0) {
                            int n18 = KeyEvent.getDeadChar(editable.charAt(n6), n12);
                            bl2 = false;
                            if (n18 != 0) {
                                n12 = n18;
                                bl2 = true;
                                bl = false;
                            }
                        }
                        if (!bl2) {
                            Selection.setSelection(editable, n5);
                            editable.removeSpan(TextKeyListener.ACTIVE);
                            n6 = n5;
                        }
                    }
                    if ((n3 & 1) != 0 && Character.isLowerCase(n12) && TextKeyListener.shouldCap(this.mAutoCap, editable, n6)) {
                        int n19 = editable.getSpanEnd(TextKeyListener.CAPPED);
                        int n20 = editable.getSpanFlags(TextKeyListener.CAPPED);
                        if (n19 == n6 && (0xFFFF & n20 >> 16) == n12) {
                            editable.removeSpan(TextKeyListener.CAPPED);
                        } else {
                            int n21 = n12 << 16;
                            n12 = Character.toUpperCase(n12);
                            if (n6 == 0) {
                                editable.setSpan(TextKeyListener.CAPPED, 0, 0, n21 | 0x11);
                            } else {
                                Object object = TextKeyListener.CAPPED;
                                int n22 = n6 - 1;
                                int n23 = n21 | 0x21;
                                editable.setSpan(object, n22, n6, n23);
                            }
                        }
                    }
                    if (n6 != n5) {
                        Selection.setSelection(editable, n5);
                    }
                    editable.setSpan(OLD_SEL_START, n6, n6, 17);
                    String string3 = String.valueOf((char)n12);
                    editable.replace(n6, n5, string3);
                    n4 = editable.getSpanStart(OLD_SEL_START);
                    int n24 = Selection.getSelectionEnd(editable);
                    if (n4 < n24) {
                        editable.setSpan(TextKeyListener.LAST_TYPED, n4, n24, 33);
                        if (bl) {
                            Selection.setSelection(editable, n4, n24);
                            editable.setSpan(TextKeyListener.ACTIVE, n4, n24, 33);
                        }
                    }
                    QwertyKeyListener.adjustMetaAfterKeypress(editable);
                    if ((n3 & 2) == 0 || !this.mAutoText || n12 != 32 && n12 != 9 && n12 != 10 && n12 != 44 && n12 != 46 && n12 != 33 && n12 != 63 && n12 != 34 && Character.getType(n12) != 22 || editable.getSpanEnd(TextKeyListener.INHIBIT_REPLACEMENT) == n4) break block38;
                    break block40;
                }
                if (n == 67 && (keyEvent.hasNoModifiers() || keyEvent.hasModifiers(2)) && n6 == n5) {
                    Replaced[] replacedArray;
                    int n25 = 1;
                    if (editable.getSpanEnd(TextKeyListener.LAST_TYPED) == n6 && editable.charAt(n6 - 1) != '\n') {
                        n25 = 2;
                    }
                    if ((replacedArray = editable.getSpans(n6 - n25, n6, Replaced.class)).length > 0) {
                        int n26 = editable.getSpanStart(replacedArray[0]);
                        int n27 = editable.getSpanEnd(replacedArray[0]);
                        String string4 = new String(replacedArray[0].mText);
                        editable.removeSpan(replacedArray[0]);
                        if (n6 < n27) {
                            QwertyKeyListener.adjustMetaAfterKeypress(editable);
                            return super.onKeyDown(view, editable, n, keyEvent);
                        }
                        editable.setSpan(TextKeyListener.INHIBIT_REPLACEMENT, n27, n27, 34);
                        editable.replace(n26, n27, string4);
                        int n28 = editable.getSpanStart(TextKeyListener.INHIBIT_REPLACEMENT);
                        if (n28 - 1 >= 0) {
                            editable.setSpan(TextKeyListener.INHIBIT_REPLACEMENT, n28 - 1, n28, 33);
                        } else {
                            editable.removeSpan(TextKeyListener.INHIBIT_REPLACEMENT);
                        }
                        QwertyKeyListener.adjustMetaAfterKeypress(editable);
                        return true;
                    }
                }
                return super.onKeyDown(view, editable, n, keyEvent);
            }
            int n29 = n4;
            while (true) {
                char c;
                if (n29 <= 0 || (c = editable.charAt(n29 - 1)) != '\'' && !Character.isLetter(c)) {
                    int n30;
                    string2 = this.getReplacement(editable, n29, n4, view);
                    if (string2 == null) break block38;
                    Replaced[] replacedArray = editable.getSpans(0, editable.length(), Replaced.class);
                    for (int i = 0; i < (n30 = replacedArray.length); ++i) {
                        editable.removeSpan(replacedArray[i]);
                    }
                    break;
                }
                --n29;
            }
            char[] cArray = new char[n4 - n29];
            TextUtils.getChars(editable, n29, n4, cArray, 0);
            editable.setSpan(new Replaced(cArray), n29, n4, 33);
            editable.replace(n29, n4, string2);
        }
        if ((n3 & 4) != 0 && this.mAutoText && (n2 = Selection.getSelectionEnd(editable)) - 3 >= 0 && editable.charAt(n2 - 1) == ' ' && editable.charAt(n2 - 2) == ' ') {
            char c = editable.charAt(n2 - 3);
            for (int i = n2 - 3; i > 0 && (c == '\"' || Character.getType(c) == 22); --i) {
                c = editable.charAt(i - 1);
            }
            if (Character.isLetter(c) || Character.isDigit(c)) {
                editable.replace(n2 - 2, n2 - 1, ".");
            }
        }
        return true;
    }

    static class Replaced
    implements NoCopySpan {
        private char[] mText;

        public Replaced(char[] cArray) {
            this.mText = cArray;
        }
    }
}

