/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.method.NumberKeyListener;

public class DigitsKeyListener
extends NumberKeyListener {
    private static final char[][] CHARACTERS = new char[][]{{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'}, {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '+'}, {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '.'}, {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '+', '.'}};
    private static final int DECIMAL = 2;
    private static final int SIGN = 1;
    private static DigitsKeyListener[] sInstance = new DigitsKeyListener[4];
    private char[] mAccepted;
    private boolean mDecimal;
    private boolean mSign;

    public DigitsKeyListener() {
        this(false, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public DigitsKeyListener(boolean bl, boolean bl2) {
        this.mSign = bl;
        this.mDecimal = bl2;
        int n = bl ? 1 : 0;
        int n2 = 0;
        if (bl2) {
            n2 = 2;
        }
        int n3 = n | n2;
        this.mAccepted = CHARACTERS[n3];
    }

    public static DigitsKeyListener getInstance() {
        return DigitsKeyListener.getInstance(false, false);
    }

    public static DigitsKeyListener getInstance(String string2) {
        DigitsKeyListener digitsKeyListener = new DigitsKeyListener();
        digitsKeyListener.mAccepted = new char[string2.length()];
        string2.getChars(0, string2.length(), digitsKeyListener.mAccepted, 0);
        return digitsKeyListener;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static DigitsKeyListener getInstance(boolean bl, boolean bl2) {
        int n;
        int n2 = bl ? 1 : 0;
        int n3 = 0;
        if (bl2) {
            n3 = 2;
        }
        if (sInstance[n = n2 | n3] != null) {
            return sInstance[n];
        }
        DigitsKeyListener.sInstance[n] = new DigitsKeyListener(bl, bl2);
        return sInstance[n];
    }

    private static boolean isDecimalPointChar(char c) {
        return c == '.';
    }

    private static boolean isSignChar(char c) {
        return c == '-' || c == '+';
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public CharSequence filter(CharSequence charSequence, int n, int n2, Spanned spanned, int n3, int n4) {
        block23: {
            CharSequence charSequence2;
            block21: {
                charSequence2 = super.filter(charSequence, n, n2, spanned, n3, n4);
                if (!this.mSign && !this.mDecimal) break block21;
                if (charSequence2 != null) {
                    charSequence = charSequence2;
                    n = 0;
                    n2 = charSequence2.length();
                }
                int n5 = -1;
                int n6 = -1;
                int n7 = spanned.length();
                for (int i = 0; i < n3; ++i) {
                    char c = spanned.charAt(i);
                    if (DigitsKeyListener.isSignChar(c)) {
                        n5 = i;
                        continue;
                    }
                    if (!DigitsKeyListener.isDecimalPointChar(c)) continue;
                    n6 = i;
                }
                for (int i = n4; i < n7; ++i) {
                    char c = spanned.charAt(i);
                    if (DigitsKeyListener.isSignChar(c)) {
                        return "";
                    }
                    if (!DigitsKeyListener.isDecimalPointChar(c)) continue;
                    n6 = i;
                }
                SpannableStringBuilder spannableStringBuilder = null;
                for (int i = n2 - 1; i >= n; --i) {
                    boolean bl;
                    block20: {
                        char c;
                        block22: {
                            c = charSequence.charAt(i);
                            if (!DigitsKeyListener.isSignChar(c)) break block22;
                            if (i != n || n3 != 0) {
                                bl = true;
                                break block20;
                            } else if (n5 >= 0) {
                                bl = true;
                                break block20;
                            } else {
                                n5 = i;
                                bl = false;
                            }
                            break block20;
                        }
                        boolean bl2 = DigitsKeyListener.isDecimalPointChar(c);
                        bl = false;
                        if (bl2) {
                            if (n6 >= 0) {
                                bl = true;
                            } else {
                                n6 = i;
                                bl = false;
                            }
                        }
                    }
                    if (!bl) continue;
                    if (n2 == n + 1) {
                        return "";
                    }
                    if (spannableStringBuilder == null) {
                        spannableStringBuilder = new SpannableStringBuilder(charSequence, n, n2);
                    }
                    spannableStringBuilder.delete(i - n, i + 1 - n);
                }
                if (spannableStringBuilder != null) {
                    return spannableStringBuilder;
                }
                if (charSequence2 == null) break block23;
            }
            return charSequence2;
        }
        return null;
    }

    @Override
    protected char[] getAcceptedChars() {
        return this.mAccepted;
    }

    @Override
    public int getInputType() {
        int n = 2;
        if (this.mSign) {
            n |= 0x1000;
        }
        if (this.mDecimal) {
            n |= 0x2000;
        }
        return n;
    }
}

