/*
 * Decompiled with CFR 0.152.
 */
package android.text.format;

import android.content.Context;
import android.provider.Settings;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.SpannedString;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import libcore.icu.ICU;
import libcore.icu.LocaleData;

public class DateFormat {
    @Deprecated
    public static final char AM_PM = 'a';
    @Deprecated
    public static final char CAPITAL_AM_PM = 'A';
    @Deprecated
    public static final char DATE = 'd';
    @Deprecated
    public static final char DAY = 'E';
    @Deprecated
    public static final char HOUR = 'h';
    @Deprecated
    public static final char HOUR_OF_DAY = 'k';
    @Deprecated
    public static final char MINUTE = 'm';
    @Deprecated
    public static final char MONTH = 'M';
    @Deprecated
    public static final char QUOTE = '\'';
    @Deprecated
    public static final char SECONDS = 's';
    @Deprecated
    public static final char STANDALONE_MONTH = 'L';
    @Deprecated
    public static final char TIME_ZONE = 'z';
    @Deprecated
    public static final char YEAR = 'y';
    private static boolean sIs24Hour;
    private static Locale sIs24HourLocale;
    private static final Object sLocaleLock;

    static {
        sLocaleLock = new Object();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int appendQuotedText(SpannableStringBuilder spannableStringBuilder, int n, int n2) {
        if (n + 1 < n2 && spannableStringBuilder.charAt(n + 1) == '\'') {
            spannableStringBuilder.delete(n, n + 1);
            return 1;
        }
        int n3 = 0;
        spannableStringBuilder.delete(n, n + 1);
        int n4 = n2 - 1;
        while (n < n4) {
            if (spannableStringBuilder.charAt(n) == '\'') {
                if (n + 1 < n4 && spannableStringBuilder.charAt(n + 1) == '\'') {
                    spannableStringBuilder.delete(n, n + 1);
                    --n4;
                    ++n3;
                    ++n;
                    continue;
                }
                spannableStringBuilder.delete(n, n + 1);
                return n3;
            }
            ++n;
            ++n3;
        }
        return n3;
    }

    public static CharSequence format(CharSequence charSequence, long l) {
        return DateFormat.format(charSequence, new Date(l));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static CharSequence format(CharSequence charSequence, Calendar calendar) {
        int n;
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder(charSequence);
        LocaleData localeData = LocaleData.get((Locale)Locale.getDefault());
        int n2 = charSequence.length();
        for (int i = 0; i < n2; i += n) {
            String string2;
            n = 1;
            char c = spannableStringBuilder.charAt(i);
            if (c == '\'') {
                n = DateFormat.appendQuotedText(spannableStringBuilder, i, n2);
                n2 = spannableStringBuilder.length();
                continue;
            }
            while (i + n < n2 && spannableStringBuilder.charAt(i + n) == c) {
                ++n;
            }
            switch (c) {
                default: {
                    string2 = null;
                    break;
                }
                case 'A': 
                case 'a': {
                    string2 = localeData.amPm[0 + calendar.get(9)];
                    break;
                }
                case 'd': {
                    string2 = DateFormat.zeroPad(calendar.get(5), n);
                    break;
                }
                case 'E': 
                case 'c': {
                    string2 = DateFormat.getDayOfWeekString(localeData, calendar.get(7), n, c);
                    break;
                }
                case 'K': 
                case 'h': {
                    int n3 = calendar.get(10);
                    if (c == 'h' && n3 == 0) {
                        n3 = 12;
                    }
                    string2 = DateFormat.zeroPad(n3, n);
                    break;
                }
                case 'H': 
                case 'k': {
                    string2 = DateFormat.zeroPad(calendar.get(11), n);
                    break;
                }
                case 'L': 
                case 'M': {
                    string2 = DateFormat.getMonthString(localeData, calendar.get(2), n, c);
                    break;
                }
                case 'm': {
                    string2 = DateFormat.zeroPad(calendar.get(12), n);
                    break;
                }
                case 's': {
                    string2 = DateFormat.zeroPad(calendar.get(13), n);
                    break;
                }
                case 'y': {
                    string2 = DateFormat.getYearString(calendar.get(1), n);
                    break;
                }
                case 'z': {
                    string2 = DateFormat.getTimeZoneString(calendar, n);
                }
            }
            if (string2 == null) continue;
            spannableStringBuilder.replace(i, i + n, string2);
            n = string2.length();
            n2 = spannableStringBuilder.length();
        }
        if (charSequence instanceof Spanned) {
            return new SpannedString(spannableStringBuilder);
        }
        return spannableStringBuilder.toString();
    }

    public static CharSequence format(CharSequence charSequence, Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        return DateFormat.format(charSequence, gregorianCalendar);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String formatZoneOffset(int n, int n2) {
        int n3 = n / 1000;
        StringBuilder stringBuilder = new StringBuilder();
        if (n3 < 0) {
            stringBuilder.insert(0, "-");
            n3 = -n3;
        } else {
            stringBuilder.insert(0, "+");
        }
        int n4 = n3 / 3600;
        int n5 = n3 % 3600 / 60;
        stringBuilder.append(DateFormat.zeroPad(n4, 2));
        stringBuilder.append(DateFormat.zeroPad(n5, 2));
        return stringBuilder.toString();
    }

    public static String getBestDateTimePattern(Locale locale, String string2) {
        return ICU.getBestDateTimePattern((String)string2, (Locale)locale);
    }

    public static java.text.DateFormat getDateFormat(Context context) {
        return DateFormat.getDateFormatForSetting(context, Settings.System.getString(context.getContentResolver(), "date_format"));
    }

    public static java.text.DateFormat getDateFormatForSetting(Context context, String string2) {
        return new SimpleDateFormat(DateFormat.getDateFormatStringForSetting(context, string2));
    }

    public static char[] getDateFormatOrder(Context context) {
        return ICU.getDateFormatOrder((String)DateFormat.getDateFormatString(context));
    }

    private static String getDateFormatString(Context context) {
        return DateFormat.getDateFormatStringForSetting(context, Settings.System.getString(context.getContentResolver(), "date_format"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getDateFormatStringForSetting(Context context, String string2) {
        if (string2 == null) return LocaleData.get((Locale)context.getResources().getConfiguration().locale).shortDateFormat4;
        int n = string2.indexOf(77);
        int n2 = string2.indexOf(100);
        int n3 = string2.indexOf(121);
        if (n < 0) return LocaleData.get((Locale)context.getResources().getConfiguration().locale).shortDateFormat4;
        if (n2 < 0) return LocaleData.get((Locale)context.getResources().getConfiguration().locale).shortDateFormat4;
        if (n3 < 0) return LocaleData.get((Locale)context.getResources().getConfiguration().locale).shortDateFormat4;
        String string3 = context.getString(17039447);
        if (n3 < n && n3 < n2) {
            if (n >= n2) return String.format(string3, "yyyy", "dd", "MM");
            return String.format(string3, "yyyy", "MM", "dd");
        }
        if (n < n2) {
            if (n2 >= n3) return String.format(string3, "MM", "yyyy", "dd");
            return String.format(string3, "MM", "dd", "yyyy");
        }
        if (n >= n3) return String.format(string3, "dd", "yyyy", "MM");
        return String.format(string3, "dd", "MM", "yyyy");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String getDayOfWeekString(LocaleData localeData, int n, int n2, int n3) {
        boolean bl = n3 == 99;
        if (n2 == 5) {
            if (bl) {
                return localeData.tinyStandAloneWeekdayNames[n];
            }
            return localeData.tinyWeekdayNames[n];
        }
        if (n2 == 4) {
            if (bl) {
                return localeData.longStandAloneWeekdayNames[n];
            }
            return localeData.longWeekdayNames[n];
        }
        if (bl) {
            return localeData.shortStandAloneWeekdayNames[n];
        }
        return localeData.shortWeekdayNames[n];
    }

    public static java.text.DateFormat getLongDateFormat(Context context) {
        return java.text.DateFormat.getDateInstance(1);
    }

    public static java.text.DateFormat getMediumDateFormat(Context context) {
        return java.text.DateFormat.getDateInstance(2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String getMonthString(LocaleData localeData, int n, int n2, int n3) {
        boolean bl = n3 == 76;
        if (n2 == 5) {
            if (bl) {
                return localeData.tinyStandAloneMonthNames[n];
            }
            return localeData.tinyMonthNames[n];
        }
        if (n2 == 4) {
            if (bl) {
                return localeData.longStandAloneMonthNames[n];
            }
            return localeData.longMonthNames[n];
        }
        if (n2 != 3) {
            return DateFormat.zeroPad(n + 1, n2);
        }
        if (bl) {
            return localeData.shortStandAloneMonthNames[n];
        }
        return localeData.shortMonthNames[n];
    }

    public static java.text.DateFormat getTimeFormat(Context context) {
        return new SimpleDateFormat(DateFormat.getTimeFormatString(context));
    }

    public static String getTimeFormatString(Context context) {
        LocaleData localeData = LocaleData.get((Locale)context.getResources().getConfiguration().locale);
        if (DateFormat.is24HourFormat(context)) {
            return localeData.timeFormat24;
        }
        return localeData.timeFormat12;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getTimeZoneString(Calendar calendar, int n) {
        boolean bl;
        TimeZone timeZone = calendar.getTimeZone();
        if (n < 2) {
            return DateFormat.formatZoneOffset(calendar.get(16) + calendar.get(15), n);
        }
        if (calendar.get(16) != 0) {
            bl = true;
            return timeZone.getDisplayName(bl, 0);
        }
        bl = false;
        return timeZone.getDisplayName(bl, 0);
    }

    private static String getYearString(int n, int n2) {
        if (n2 <= 2) {
            return DateFormat.zeroPad(n % 100, 2);
        }
        Locale locale = Locale.getDefault();
        Object[] objectArray = new Object[]{n};
        return String.format(locale, "%d", objectArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean hasDesignator(CharSequence charSequence, char c) {
        if (charSequence != null) {
            int n;
            int n2 = charSequence.length();
            for (int i = 0; i < n2; i += n) {
                n = 1;
                char c2 = charSequence.charAt(i);
                if (c2 == '\'') {
                    n = DateFormat.skipQuotedText(charSequence, i, n2);
                    continue;
                }
                if (c2 != c) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasSeconds(CharSequence charSequence) {
        return DateFormat.hasDesignator(charSequence, 's');
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean is24HourFormat(Context context) {
        String string2 = Settings.System.getString(context.getContentResolver(), "time_12_24");
        if (string2 != null) {
            return string2.equals("24");
        }
        Locale locale = context.getResources().getConfiguration().locale;
        Object object = sLocaleLock;
        synchronized (object) {
            if (sIs24HourLocale != null && sIs24HourLocale.equals(locale)) {
                return sIs24Hour;
            }
        }
        java.text.DateFormat dateFormat = java.text.DateFormat.getTimeInstance(1, locale);
        String string3 = dateFormat instanceof SimpleDateFormat ? (((SimpleDateFormat)dateFormat).toPattern().indexOf(72) >= 0 ? "24" : "12") : "12";
        Object object2 = sLocaleLock;
        synchronized (object2) {
            sIs24HourLocale = locale;
            sIs24Hour = string3.equals("24");
            return sIs24Hour;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int skipQuotedText(CharSequence charSequence, int n, int n2) {
        if (n + 1 < n2 && charSequence.charAt(n + 1) == '\'') {
            return 2;
        }
        int n3 = 1;
        int n4 = n + 1;
        while (n4 < n2) {
            if (charSequence.charAt(n4) == '\'') {
                ++n3;
                if (n4 + 1 >= n2) return n3;
                if (charSequence.charAt(n4 + 1) != '\'') return n3;
                ++n4;
                continue;
            }
            ++n4;
            ++n3;
        }
        return n3;
    }

    private static String zeroPad(int n, int n2) {
        Locale locale = Locale.getDefault();
        String string2 = "%0" + n2 + "d";
        Object[] objectArray = new Object[]{n};
        return String.format(locale, string2, objectArray);
    }
}

