/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.text.Spanned;
import java.lang.reflect.Array;

public class SpanSet<E> {
    private final Class<? extends E> classType;
    int numberOfSpans;
    int[] spanEnds;
    int[] spanFlags;
    int[] spanStarts;
    E[] spans;

    SpanSet(Class<? extends E> clazz) {
        this.classType = clazz;
        this.numberOfSpans = 0;
    }

    int getNextTransition(int n, int n2) {
        for (int i = 0; i < this.numberOfSpans; ++i) {
            int n3 = this.spanStarts[i];
            int n4 = this.spanEnds[i];
            if (n3 > n && n3 < n2) {
                n2 = n3;
            }
            if (n4 <= n || n4 >= n2) continue;
            n2 = n4;
        }
        return n2;
    }

    public boolean hasSpansIntersecting(int n, int n2) {
        for (int i = 0; i < this.numberOfSpans; ++i) {
            if (this.spanStarts[i] >= n2 || this.spanEnds[i] <= n) {
                continue;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void init(Spanned spanned, int n, int n2) {
        E[] EArray = spanned.getSpans(n, n2, this.classType);
        int n3 = EArray.length;
        if (n3 > 0 && (this.spans == null || this.spans.length < n3)) {
            this.spans = (Object[])Array.newInstance(this.classType, n3);
            this.spanStarts = new int[n3];
            this.spanEnds = new int[n3];
            this.spanFlags = new int[n3];
        }
        this.numberOfSpans = 0;
        int n4 = 0;
        while (n4 < n3) {
            int n5;
            E e = EArray[n4];
            int n6 = spanned.getSpanStart(e);
            if (n6 != (n5 = spanned.getSpanEnd(e))) {
                int n7 = spanned.getSpanFlags(e);
                this.spans[this.numberOfSpans] = e;
                this.spanStarts[this.numberOfSpans] = n6;
                this.spanEnds[this.numberOfSpans] = n5;
                this.spanFlags[this.numberOfSpans] = n7;
                this.numberOfSpans = 1 + this.numberOfSpans;
            }
            ++n4;
        }
        return;
    }

    public void recycle() {
        for (int i = 0; i < this.numberOfSpans; ++i) {
            this.spans[i] = null;
        }
    }
}

