/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;

class PackedIntVector {
    private final int mColumns;
    private int mRowGapLength;
    private int mRowGapStart;
    private int mRows;
    private int[] mValueGap;
    private int[] mValues;

    public PackedIntVector(int n) {
        this.mColumns = n;
        this.mRows = 0;
        this.mRowGapStart = 0;
        this.mRowGapLength = this.mRows;
        this.mValues = null;
        this.mValueGap = new int[n * 2];
    }

    private final void growBuffer() {
        int n = this.mColumns;
        int[] nArray = ArrayUtils.newUnpaddedIntArray(n * GrowingArrayUtils.growSize(this.size()));
        int n2 = nArray.length / n;
        int[] nArray2 = this.mValueGap;
        int n3 = this.mRowGapStart;
        int n4 = this.mRows - (n3 + this.mRowGapLength);
        if (this.mValues != null) {
            System.arraycopy((int[])this.mValues, (int)0, (int[])nArray, (int)0, (int)(n * n3));
            System.arraycopy((int[])this.mValues, (int)(n * (this.mRows - n4)), (int[])nArray, (int)(n * (n2 - n4)), (int)(n4 * n));
        }
        for (int i = 0; i < n; ++i) {
            if (nArray2[i] < n3) continue;
            nArray2[i] = nArray2[i] + (n2 - this.mRows);
            if (nArray2[i] >= n3) continue;
            nArray2[i] = n3;
        }
        this.mRowGapLength += n2 - this.mRows;
        this.mRows = n2;
        this.mValues = nArray;
    }

    private final void moveRowGapTo(int n) {
        if (n == this.mRowGapStart) {
            return;
        }
        if (n > this.mRowGapStart) {
            int n2;
            int n3 = n + this.mRowGapLength - (this.mRowGapStart + this.mRowGapLength);
            int n4 = this.mColumns;
            int[] nArray = this.mValueGap;
            int[] nArray2 = this.mValues;
            for (int i = n2 = this.mRowGapStart + this.mRowGapLength; i < n2 + n3; ++i) {
                int n5 = i - n2 + this.mRowGapStart;
                for (int j = 0; j < n4; ++j) {
                    int n6 = nArray2[j + i * n4];
                    if (i >= nArray[j]) {
                        n6 += nArray[j + n4];
                    }
                    if (n5 >= nArray[j]) {
                        n6 -= nArray[j + n4];
                    }
                    nArray2[j + n5 * n4] = n6;
                }
            }
        } else {
            int n7 = this.mRowGapStart - n;
            int n8 = this.mColumns;
            int[] nArray = this.mValueGap;
            int[] nArray3 = this.mValues;
            int n9 = this.mRowGapStart + this.mRowGapLength;
            for (int i = -1 + (n + n7); i >= n; --i) {
                int n10 = n9 + (i - n) - n7;
                for (int j = 0; j < n8; ++j) {
                    int n11 = nArray3[j + i * n8];
                    if (i >= nArray[j]) {
                        n11 += nArray[j + n8];
                    }
                    if (n10 >= nArray[j]) {
                        n11 -= nArray[j + n8];
                    }
                    nArray3[j + n10 * n8] = n11;
                }
            }
        }
        this.mRowGapStart = n;
    }

    private final void moveValueGapTo(int n, int n2) {
        int[] nArray = this.mValueGap;
        int[] nArray2 = this.mValues;
        int n3 = this.mColumns;
        if (n2 == nArray[n]) {
            return;
        }
        if (n2 > nArray[n]) {
            for (int i = nArray[n]; i < n2; ++i) {
                int n4 = n + i * n3;
                nArray2[n4] = nArray2[n4] + nArray[n + n3];
            }
        } else {
            for (int i = n2; i < nArray[n]; ++i) {
                int n5 = n + i * n3;
                nArray2[n5] = nArray2[n5] - nArray[n + n3];
            }
        }
        nArray[n] = n2;
    }

    private void setValueInternal(int n, int n2, int n3) {
        int[] nArray;
        if (n >= this.mRowGapStart) {
            n += this.mRowGapLength;
        }
        if (n >= (nArray = this.mValueGap)[n2]) {
            n3 -= nArray[n2 + this.mColumns];
        }
        this.mValues[n2 + n * this.mColumns] = n3;
    }

    public void adjustValuesBelow(int n, int n2, int n3) {
        if ((n | n2) < 0 || n > this.size() || n2 >= this.width()) {
            throw new IndexOutOfBoundsException(n + ", " + n2);
        }
        if (n >= this.mRowGapStart) {
            n += this.mRowGapLength;
        }
        this.moveValueGapTo(n2, n);
        int[] nArray = this.mValueGap;
        int n4 = n2 + this.mColumns;
        nArray[n4] = n3 + nArray[n4];
    }

    public void deleteAt(int n, int n2) {
        if ((n | n2) < 0 || n + n2 > this.size()) {
            throw new IndexOutOfBoundsException(n + ", " + n2);
        }
        this.moveRowGapTo(n + n2);
        this.mRowGapStart -= n2;
        this.mRowGapLength = n2 + this.mRowGapLength;
    }

    public int getValue(int n, int n2) {
        int n3 = this.mColumns;
        if ((n | n2) < 0 || n >= this.size() || n2 >= n3) {
            throw new IndexOutOfBoundsException(n + ", " + n2);
        }
        if (n >= this.mRowGapStart) {
            n += this.mRowGapLength;
        }
        int n4 = this.mValues[n2 + n * n3];
        int[] nArray = this.mValueGap;
        if (n >= nArray[n2]) {
            n4 += nArray[n2 + n3];
        }
        return n4;
    }

    public void insertAt(int n, int[] nArray) {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException("row " + n);
        }
        if (nArray != null && nArray.length < this.width()) {
            throw new IndexOutOfBoundsException("value count " + nArray.length);
        }
        this.moveRowGapTo(n);
        if (this.mRowGapLength == 0) {
            this.growBuffer();
        }
        this.mRowGapStart = 1 + this.mRowGapStart;
        this.mRowGapLength = -1 + this.mRowGapLength;
        if (nArray == null) {
            for (int i = -1 + this.mColumns; i >= 0; --i) {
                this.setValueInternal(n, i, 0);
            }
        } else {
            for (int i = -1 + this.mColumns; i >= 0; --i) {
                this.setValueInternal(n, i, nArray[i]);
            }
        }
    }

    public void setValue(int n, int n2, int n3) {
        int[] nArray;
        if ((n | n2) < 0 || n >= this.size() || n2 >= this.mColumns) {
            throw new IndexOutOfBoundsException(n + ", " + n2);
        }
        if (n >= this.mRowGapStart) {
            n += this.mRowGapLength;
        }
        if (n >= (nArray = this.mValueGap)[n2]) {
            n3 -= nArray[n2 + this.mColumns];
        }
        this.mValues[n2 + n * this.mColumns] = n3;
    }

    public int size() {
        return this.mRows - this.mRowGapLength;
    }

    public int width() {
        return this.mColumns;
    }
}

