/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.emoji.EmojiFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.text.AndroidBidi;
import android.text.GetChars;
import android.text.MeasuredText;
import android.text.SpanSet;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextLine;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.TextKeyListener;
import android.text.style.AlignmentSpan;
import android.text.style.LeadingMarginSpan;
import android.text.style.LineBackgroundSpan;
import android.text.style.ParagraphStyle;
import android.text.style.ReplacementSpan;
import android.text.style.TabStopSpan;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import java.util.Arrays;

public abstract class Layout {
    static final Directions DIRS_ALL_LEFT_TO_RIGHT;
    static final Directions DIRS_ALL_RIGHT_TO_LEFT;
    public static final int DIR_LEFT_TO_RIGHT = 1;
    static final int DIR_REQUEST_DEFAULT_LTR = 2;
    static final int DIR_REQUEST_DEFAULT_RTL = -2;
    static final int DIR_REQUEST_LTR = 1;
    static final int DIR_REQUEST_RTL = -1;
    public static final int DIR_RIGHT_TO_LEFT = -1;
    static final char[] ELLIPSIS_NORMAL;
    static final char[] ELLIPSIS_TWO_DOTS;
    static final EmojiFactory EMOJI_FACTORY;
    static final int MAX_EMOJI = 0;
    static final int MIN_EMOJI = 0;
    private static final ParagraphStyle[] NO_PARA_SPANS;
    static final int RUN_LENGTH_MASK = 0x3FFFFFF;
    static final int RUN_LEVEL_MASK = 63;
    static final int RUN_LEVEL_SHIFT = 26;
    static final int RUN_RTL_FLAG = 0x4000000;
    private static final int TAB_INCREMENT = 20;
    private static final Rect sTempRect;
    private Alignment mAlignment = Alignment.ALIGN_NORMAL;
    private SpanSet<LineBackgroundSpan> mLineBackgroundSpans;
    private TextPaint mPaint;
    private float mSpacingAdd;
    private float mSpacingMult;
    private boolean mSpannedText;
    private CharSequence mText;
    private TextDirectionHeuristic mTextDir;
    private int mWidth;
    TextPaint mWorkPaint;

    /*
     * Enabled aggressive block sorting
     */
    static {
        NO_PARA_SPANS = ArrayUtils.emptyArray(ParagraphStyle.class);
        EMOJI_FACTORY = EmojiFactory.newAvailableInstance();
        if (EMOJI_FACTORY != null) {
            MIN_EMOJI = EMOJI_FACTORY.getMinimumAndroidPua();
            MAX_EMOJI = EMOJI_FACTORY.getMaximumAndroidPua();
        } else {
            MIN_EMOJI = -1;
            MAX_EMOJI = -1;
        }
        sTempRect = new Rect();
        DIRS_ALL_LEFT_TO_RIGHT = new Directions(new int[]{0, 0x3FFFFFF});
        DIRS_ALL_RIGHT_TO_LEFT = new Directions(new int[]{0, 0x7FFFFFF});
        ELLIPSIS_NORMAL = new char[]{'\u2026'};
        ELLIPSIS_TWO_DOTS = new char[]{'\u2025'};
    }

    protected Layout(CharSequence charSequence, TextPaint textPaint, int n, Alignment alignment, float f, float f2) {
        this(charSequence, textPaint, n, alignment, TextDirectionHeuristics.FIRSTSTRONG_LTR, f, f2);
    }

    protected Layout(CharSequence charSequence, TextPaint textPaint, int n, Alignment alignment, TextDirectionHeuristic textDirectionHeuristic, float f, float f2) {
        if (n < 0) {
            throw new IllegalArgumentException("Layout: " + n + " < 0");
        }
        if (textPaint != null) {
            textPaint.bgColor = 0;
            textPaint.baselineShift = 0;
        }
        this.mText = charSequence;
        this.mPaint = textPaint;
        this.mWorkPaint = new TextPaint();
        this.mWidth = n;
        this.mAlignment = alignment;
        this.mSpacingMult = f;
        this.mSpacingAdd = f2;
        this.mSpannedText = charSequence instanceof Spanned;
        this.mTextDir = textDirectionHeuristic;
    }

    private void addSelection(int n, int n2, int n3, int n4, int n5, Path path) {
        int n6 = this.getLineStart(n);
        int n7 = this.getLineEnd(n);
        Directions directions = this.getLineDirections(n);
        if (n7 > n6 && this.mText.charAt(n7 - 1) == '\n') {
            --n7;
        }
        for (int i = 0; i < directions.mDirections.length; i += 2) {
            int n8;
            int n9;
            int n10 = n6 + directions.mDirections[i];
            int n11 = n10 + (0x3FFFFFF & directions.mDirections[i + 1]);
            if (n11 > n7) {
                n11 = n7;
            }
            if (n2 > n11 || n3 < n10 || (n9 = Math.max(n2, n10)) == (n8 = Math.min(n3, n11))) continue;
            float f = this.getHorizontal(n9, false, n, false);
            float f2 = this.getHorizontal(n8, true, n, false);
            float f3 = Math.min(f, f2);
            float f4 = Math.max(f, f2);
            path.addRect(f3, n4, f4, n5, Path.Direction.CW);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void ellipsize(int n, int n2, int n3, char[] cArray, int n4, TextUtils.TruncateAt truncateAt) {
        int n5 = this.getEllipsisCount(n3);
        if (n5 != 0) {
            int n6 = this.getEllipsisStart(n3);
            int n7 = this.getLineStart(n3);
            for (int i = n6; i < n6 + n5; ++i) {
                int n8 = i == n6 ? (int)this.getEllipsisChar(truncateAt) : 65279;
                int n9 = i + n7;
                if (n9 < n || n9 >= n2) continue;
                cArray[n4 + n9 - n] = n8;
            }
        }
    }

    public static float getDesiredWidth(CharSequence charSequence, int n, int n2, TextPaint textPaint) {
        float f = 0.0f;
        int n3 = n;
        while (n3 <= n2) {
            float f2;
            int n4 = TextUtils.indexOf(charSequence, '\n', n3, n2);
            if (n4 < 0) {
                n4 = n2;
            }
            if ((f2 = Layout.measurePara(textPaint, charSequence, n3, n4)) > f) {
                f = f2;
            }
            n3 = n4 + 1;
        }
        return f;
    }

    public static float getDesiredWidth(CharSequence charSequence, TextPaint textPaint) {
        textPaint.set(textPaint);
        return Layout.getDesiredWidth(charSequence, 0, charSequence.length(), textPaint);
    }

    private char getEllipsisChar(TextUtils.TruncateAt truncateAt) {
        if (truncateAt == TextUtils.TruncateAt.END_SMALL) {
            return ELLIPSIS_TWO_DOTS[0];
        }
        return ELLIPSIS_NORMAL[0];
    }

    private float getHorizontal(int n, boolean bl, int n2, boolean bl2) {
        int n3 = this.getLineStart(n2);
        int n4 = this.getLineEnd(n2);
        int n5 = this.getParagraphDirection(n2);
        boolean bl3 = this.getLineContainsTab(n2);
        Directions directions = this.getLineDirections(n2);
        TabStops tabStops = null;
        if (bl3) {
            boolean bl4 = this.mText instanceof Spanned;
            tabStops = null;
            if (bl4) {
                Object[] objectArray = Layout.getParagraphSpans((Spanned)this.mText, n3, n4, TabStopSpan.class);
                int n6 = objectArray.length;
                tabStops = null;
                if (n6 > 0) {
                    tabStops = new TabStops(20, objectArray);
                }
            }
        }
        TextLine textLine = TextLine.obtain();
        textLine.set(this.mPaint, this.mText, n3, n4, n5, directions, bl3, tabStops);
        float f = textLine.measure(n - n3, bl, null);
        TextLine.recycle(textLine);
        if (bl2 && f > (float)this.mWidth) {
            f = this.mWidth;
        }
        return f + (float)this.getLineStartPos(n2, this.getParagraphLeft(n2), this.getParagraphRight(n2));
    }

    private float getHorizontal(int n, boolean bl, boolean bl2) {
        return this.getHorizontal(n, bl, this.getLineForOffset(n), bl2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private float getLineExtent(int n, TabStops tabStops, boolean bl) {
        int n2 = this.getLineStart(n);
        int n3 = bl ? this.getLineEnd(n) : this.getLineVisibleEnd(n);
        boolean bl2 = this.getLineContainsTab(n);
        Directions directions = this.getLineDirections(n);
        int n4 = this.getParagraphDirection(n);
        TextLine textLine = TextLine.obtain();
        textLine.set(this.mPaint, this.mText, n2, n3, n4, directions, bl2, tabStops);
        float f = textLine.metrics(null);
        TextLine.recycle(textLine);
        return f;
    }

    /*
     * Enabled aggressive block sorting
     */
    private float getLineExtent(int n, boolean bl) {
        Directions directions;
        int n2 = this.getLineStart(n);
        int n3 = bl ? this.getLineEnd(n) : this.getLineVisibleEnd(n);
        boolean bl2 = this.getLineContainsTab(n);
        TabStops tabStops = null;
        if (bl2) {
            boolean bl3 = this.mText instanceof Spanned;
            tabStops = null;
            if (bl3) {
                Object[] objectArray = Layout.getParagraphSpans((Spanned)this.mText, n2, n3, TabStopSpan.class);
                int n4 = objectArray.length;
                tabStops = null;
                if (n4 > 0) {
                    tabStops = new TabStops(20, objectArray);
                }
            }
        }
        if ((directions = this.getLineDirections(n)) == null) {
            return 0.0f;
        }
        int n5 = this.getParagraphDirection(n);
        TextLine textLine = TextLine.obtain();
        textLine.set(this.mPaint, this.mText, n2, n3, n5, directions, bl2, tabStops);
        float f = textLine.metrics(null);
        TextLine.recycle(textLine);
        return f;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getLineStartPos(int n, int n2, int n3) {
        Alignment alignment = this.getParagraphAlignment(n);
        int n4 = this.getParagraphDirection(n);
        if (alignment == Alignment.ALIGN_LEFT) {
            alignment = n4 == 1 ? Alignment.ALIGN_NORMAL : Alignment.ALIGN_OPPOSITE;
        } else if (alignment == Alignment.ALIGN_RIGHT) {
            alignment = n4 == 1 ? Alignment.ALIGN_OPPOSITE : Alignment.ALIGN_NORMAL;
        }
        if (alignment == Alignment.ALIGN_NORMAL) {
            if (n4 == 1) {
                return n2;
            }
            return n3;
        }
        boolean bl = this.mSpannedText;
        TabStops tabStops = null;
        if (bl) {
            boolean bl2 = this.getLineContainsTab(n);
            tabStops = null;
            if (bl2) {
                Spanned spanned = (Spanned)this.mText;
                int n5 = this.getLineStart(n);
                Object[] objectArray = Layout.getParagraphSpans(spanned, n5, spanned.nextSpanTransition(n5, spanned.length(), TabStopSpan.class), TabStopSpan.class);
                int n6 = objectArray.length;
                tabStops = null;
                if (n6 > 0) {
                    tabStops = new TabStops(20, objectArray);
                }
            }
        }
        int n7 = (int)this.getLineExtent(n, tabStops, false);
        if (alignment != Alignment.ALIGN_OPPOSITE) {
            int n8 = n7 & 0xFFFFFFFE;
            return n2 + n3 - n8 >> 1;
        }
        if (n4 == 1) {
            return n3 - n7;
        }
        return n2 - n7;
    }

    /*
     * Unable to fully structure code
     */
    private int getLineVisibleEnd(int var1_1, int var2_2, int var3_3) {
        var4_4 = this.mText;
        if (var1_1 != -1 + this.getLineCount()) ** GOTO lbl5
        return var3_3;
lbl-1000:
        // 1 sources

        {
            --var3_3;
lbl5:
            // 2 sources

            if (var3_3 <= var2_2) break;
            var5_5 = var4_4.charAt(var3_3 - 1);
            if (var5_5 != '\n') continue;
            return var3_3 - 1;
            ** while (var5_5 == ' ' || var5_5 == '\t')
        }
lbl10:
        // 2 sources

        return var3_3;
    }

    private int getOffsetAtStartOf(int n) {
        char c;
        if (n == 0) {
            return 0;
        }
        CharSequence charSequence = this.mText;
        char c2 = charSequence.charAt(n);
        if (c2 >= '\udc00' && c2 <= '\udfff' && (c = charSequence.charAt(n - 1)) >= '\ud800' && c <= '\udbff') {
            --n;
        }
        if (this.mSpannedText) {
            ReplacementSpan[] replacementSpanArray = ((Spanned)charSequence).getSpans(n, n, ReplacementSpan.class);
            for (int i = 0; i < replacementSpanArray.length; ++i) {
                int n2 = ((Spanned)charSequence).getSpanStart(replacementSpanArray[i]);
                int n3 = ((Spanned)charSequence).getSpanEnd(replacementSpanArray[i]);
                if (n2 >= n || n3 <= n) continue;
                n = n2;
            }
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getOffsetToLeftRightOf(int n, boolean bl) {
        boolean bl2;
        int n2 = this.getLineForOffset(n);
        int n3 = this.getLineStart(n2);
        int n4 = this.getLineEnd(n2);
        int n5 = this.getParagraphDirection(n2);
        boolean bl3 = n5 == -1;
        boolean bl4 = bl == bl3;
        if (bl4) {
            bl2 = false;
            if (n == n4) {
                if (n2 >= -1 + this.getLineCount()) {
                    return n;
                }
                bl2 = true;
                ++n2;
            }
        } else {
            bl2 = false;
            if (n == n3) {
                if (n2 <= 0) {
                    return n;
                }
                bl2 = true;
                --n2;
            }
        }
        if (bl2) {
            n3 = this.getLineStart(n2);
            n4 = this.getLineEnd(n2);
            int n6 = this.getParagraphDirection(n2);
            if (n6 != n5) {
                bl = !bl;
                n5 = n6;
            }
        }
        Directions directions = this.getLineDirections(n2);
        TextLine textLine = TextLine.obtain();
        textLine.set(this.mPaint, this.mText, n3, n4, n5, directions, false, null);
        int n7 = n3 + textLine.getOffsetToLeftRightOf(n - n3, bl);
        TextLine.recycle(textLine);
        return n7;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getParagraphLeadingMargin(int n) {
        if (!this.mSpannedText) {
            return 0;
        }
        Spanned spanned = (Spanned)this.mText;
        int n2 = this.getLineStart(n);
        LeadingMarginSpan[] leadingMarginSpanArray = Layout.getParagraphSpans(spanned, n2, spanned.nextSpanTransition(n2, this.getLineEnd(n), LeadingMarginSpan.class), LeadingMarginSpan.class);
        if (leadingMarginSpanArray.length == 0) {
            return 0;
        }
        int n3 = 0;
        boolean bl = n2 == 0 || spanned.charAt(n2 - 1) == '\n';
        boolean bl2 = bl;
        for (int i = 0; i < leadingMarginSpanArray.length; ++i) {
            if (!(leadingMarginSpanArray[i] instanceof LeadingMarginSpan.LeadingMarginSpan2)) continue;
            boolean bl3 = n < this.getLineForOffset(spanned.getSpanStart(leadingMarginSpanArray[i])) + ((LeadingMarginSpan.LeadingMarginSpan2)leadingMarginSpanArray[i]).getLeadingMarginLineCount();
            bl2 |= bl3;
        }
        int n4 = 0;
        while (n4 < leadingMarginSpanArray.length) {
            n3 += leadingMarginSpanArray[n4].getLeadingMargin(bl2);
            ++n4;
        }
        return n3;
    }

    static <T> T[] getParagraphSpans(Spanned spanned, int n, int n2, Class<T> clazz) {
        if (n == n2 && n > 0) {
            return ArrayUtils.emptyArray(clazz);
        }
        return spanned.getSpans(n, n2, clazz);
    }

    /*
     * Unable to fully structure code
     */
    static float measurePara(TextPaint var0, CharSequence var1_1, int var2_2, int var3_3) {
        block15: {
            block14: {
                var4_4 = MeasuredText.obtain();
                var5_5 = TextLine.obtain();
                var4_4.setPara(var1_1, var2_2, var3_3, TextDirectionHeuristics.LTR);
                if (!var4_4.mEasy) break block14;
                var9_6 = Layout.DIRS_ALL_LEFT_TO_RIGHT;
                var10_7 = 1;
lbl8:
                // 2 sources

                while (true) {
                    var11_8 = var4_4.mChars;
                    var12_9 = var4_4.mLen;
                    var13_10 = var1_1 instanceof Spanned;
                    var14_11 = 0;
                    if (!var13_10) break block15;
                    var15_12 = Layout.getParagraphSpans((Spanned)var1_1, var2_2, var3_3, LeadingMarginSpan.class);
                    var16_13 = var15_12.length;
                    for (var17_14 = 0; var17_14 < var16_13; ++var17_14) {
                        var14_11 += var15_12[var17_14].getLeadingMargin(true);
                        continue;
                    }
                    break block15;
                    break;
                }
            }
            var9_6 = AndroidBidi.directions(var4_4.mDir, var4_4.mLevels, 0, var4_4.mChars, 0, var4_4.mLen);
            var10_7 = var4_4.mDir;
            ** continue;
lbl28:
            // 1 sources

            while (true) {
                block16: {
                    var19_16 = false;
                    var20_17 = null;
                    if (var18_15 >= var12_9) ** GOTO lbl53
                    try {
                        if (var11_8[var18_15] != '\t') break block16;
                        var19_16 = true;
                    }
                    catch (Throwable var6_25) {
                        TextLine.recycle(var5_5);
                        MeasuredText.recycle(var4_4);
                        throw var6_25;
                    }
                    var21_18 = var1_1 instanceof Spanned;
                    var20_17 = null;
                    if (!var21_18) ** GOTO lbl53
                    var22_19 = (Spanned)var1_1;
                    var23_20 = Layout.getParagraphSpans(var22_19, var2_2, var22_19.nextSpanTransition(var2_2, var3_3, TabStopSpan.class), TabStopSpan.class);
                    var24_21 = var23_20.length;
                    var20_17 = null;
                    if (var24_21 <= 0) ** GOTO lbl53
                    var20_17 = new TabStops(20, var23_20);
lbl53:
                    // 4 sources

                    var5_5.set(var0, var1_1, var2_2, var3_3, var10_7, var9_6, var19_16, var20_17);
                    var25_22 = var14_11;
                    var26_23 = var5_5.metrics(null);
                    var27_24 = var25_22 + var26_23;
                    TextLine.recycle(var5_5);
                    MeasuredText.recycle(var4_4);
                    return var27_24;
                }
                ++var18_15;
                continue;
                break;
            }
        }
        var18_15 = 0;
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    static float nextTab(CharSequence charSequence, int n, int n2, float f, Object[] objectArray) {
        float f2 = Float.MAX_VALUE;
        if (!(charSequence instanceof Spanned)) return 20 * (int)((f + 20.0f) / 20.0f);
        boolean bl = false;
        if (objectArray == null) {
            objectArray = Layout.getParagraphSpans((Spanned)charSequence, n, n2, TabStopSpan.class);
            bl = true;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            int n3;
            if (!bl && !(objectArray[i] instanceof TabStopSpan) || !((float)(n3 = ((TabStopSpan)objectArray[i]).getTabStop()) < f2) || !((float)n3 > f)) continue;
            f2 = n3;
        }
        if (f2 != Float.MAX_VALUE) {
            return f2;
        }
        return 20 * (int)((f + 20.0f) / 20.0f);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private boolean primaryIsTrailingPrevious(int var1_1) {
        block12: {
            block10: {
                block11: {
                    var2_2 = true;
                    var3_3 = this.getLineForOffset(var1_1);
                    var4_4 = this.getLineStart(var3_3);
                    var5_5 = this.getLineEnd(var3_3);
                    var6_6 = this.getLineDirections((int)var3_3).mDirections;
                    var7_7 = -1;
                    var8_8 = 0;
                    while (true) {
                        block14: {
                            block13: {
                                if (var8_8 >= var6_6.length) break block13;
                                var14_9 = var4_4 + var6_6[var8_8];
                                var15_10 = var14_9 + (0x3FFFFFF & var6_6[var8_8 + 1]);
                                if (var15_10 > var5_5) {
                                    var15_10 = var5_5;
                                }
                                if (var1_1 < var14_9 || var1_1 >= var15_10) break block14;
                                if (var1_1 > var14_9) {
                                    return false;
                                }
                                var7_7 = 63 & var6_6[var8_8 + 1] >>> 26;
                            }
                            if (var7_7 == -1) {
                                if (this.getParagraphDirection(var3_3) != var2_2) break;
                                var7_7 = 0;
                            }
lbl22:
                            // 4 sources

                            while (true) {
                                var9_11 = -1;
                                if (var1_1 != var4_4) break block10;
                                if (this.getParagraphDirection(var3_3) != var2_2) break block11;
                                var9_11 = 0;
lbl27:
                                // 4 sources

                                while (var9_11 < var7_7) lbl-1000:
                                // 2 sources

                                {
                                    return var2_2;
                                }
                                break block12;
                                break;
                            }
                        }
                        var8_8 += 2;
                    }
                    var7_7 = var2_2;
                    ** while (true)
                }
                var9_11 = var2_2;
                ** GOTO lbl27
            }
            var10_12 = var1_1 - 1;
            for (var11_13 = 0; var11_13 < var6_6.length; var11_13 += 2) {
                var12_14 = var4_4 + var6_6[var11_13];
                var13_15 = var12_14 + (0x3FFFFFF & var6_6[var11_13 + 1]);
                if (var13_15 > var5_5) {
                    var13_15 = var5_5;
                }
                if (var10_12 < var12_14 || var10_12 >= var13_15) continue;
                var9_11 = 63 & var6_6[var11_13 + 1] >>> 26;
                ** GOTO lbl27
            }
            ** GOTO lbl27
        }
        var2_2 = false;
        ** while (true)
    }

    public void draw(Canvas canvas) {
        this.draw(canvas, null, null, 0);
    }

    public void draw(Canvas canvas, Path path, Paint paint, int n) {
        long l = this.getLineRangeForDraw(canvas);
        int n2 = TextUtils.unpackRangeStartFromLong(l);
        int n3 = TextUtils.unpackRangeEndFromLong(l);
        if (n3 < 0) {
            return;
        }
        this.drawBackground(canvas, path, paint, n, n2, n3);
        this.drawText(canvas, n2, n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void drawBackground(Canvas canvas, Path path, Paint paint, int n, int n2, int n3) {
        block11: {
            block12: {
                if (!this.mSpannedText) break block11;
                if (this.mLineBackgroundSpans == null) {
                    this.mLineBackgroundSpans = new SpanSet<LineBackgroundSpan>(LineBackgroundSpan.class);
                }
                Spanned spanned = (Spanned)this.mText;
                int n4 = spanned.length();
                this.mLineBackgroundSpans.init(spanned, 0, n4);
                if (this.mLineBackgroundSpans.numberOfSpans <= 0) break block12;
                int n5 = this.getLineTop(n2);
                int n6 = this.getLineStart(n2);
                ParagraphStyle[] paragraphStyleArray = NO_PARA_SPANS;
                int n7 = 0;
                TextPaint textPaint = this.mPaint;
                int n8 = 0;
                int n9 = this.mWidth;
                for (int i = n2; i <= n3; ++i) {
                    int n10;
                    int n11;
                    int n12;
                    int n13;
                    int n14;
                    block13: {
                        block14: {
                            n14 = n6;
                            n6 = n13 = this.getLineStart(i + 1);
                            n12 = n5;
                            n5 = n11 = this.getLineTop(i + 1);
                            n10 = n11 - this.getLineDescent(i);
                            if (n14 < n8) break block13;
                            n8 = this.mLineBackgroundSpans.getNextTransition(n14, n4);
                            n7 = 0;
                            if (n14 != n13) break block14;
                            n7 = 0;
                            if (n14 != 0) break block13;
                        }
                        for (int j = 0; j < this.mLineBackgroundSpans.numberOfSpans; ++j) {
                            if (this.mLineBackgroundSpans.spanStarts[j] >= n13 || this.mLineBackgroundSpans.spanEnds[j] <= n14) continue;
                            LineBackgroundSpan lineBackgroundSpan = ((LineBackgroundSpan[])this.mLineBackgroundSpans.spans)[j];
                            paragraphStyleArray = GrowingArrayUtils.append(paragraphStyleArray, n7, lineBackgroundSpan);
                            ++n7;
                        }
                    }
                    for (int j = 0; j < n7; ++j) {
                        ((LineBackgroundSpan)paragraphStyleArray[j]).drawBackground(canvas, textPaint, 0, n9, n12, n10, n11, spanned, n14, n13, i);
                    }
                }
            }
            this.mLineBackgroundSpans.recycle();
        }
        if (path != null) {
            if (n != 0) {
                canvas.translate(0.0f, n);
            }
            canvas.drawPath(path, paint);
            if (n != 0) {
                canvas.translate(0.0f, -n);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void drawText(Canvas canvas, int n, int n2) {
        int n3 = this.getLineTop(n);
        int n4 = this.getLineStart(n);
        Object[] objectArray = NO_PARA_SPANS;
        int n5 = 0;
        TextPaint textPaint = this.mPaint;
        CharSequence charSequence = this.mText;
        Alignment alignment = this.mAlignment;
        boolean bl = false;
        TextLine textLine = TextLine.obtain();
        int n6 = n;
        TabStops tabStops = null;
        while (true) {
            Directions directions;
            int n7;
            Alignment alignment2;
            Alignment alignment3;
            Alignment alignment4;
            TabStops tabStops2;
            boolean bl2;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            block23: {
                boolean bl3;
                Spanned spanned;
                block24: {
                    if (n6 > n2) {
                        TextLine.recycle(textLine);
                        return;
                    }
                    n15 = n4;
                    n4 = this.getLineStart(n6 + 1);
                    n14 = this.getLineVisibleEnd(n6, n15, n4);
                    n13 = n3;
                    n3 = n12 = this.getLineTop(n6 + 1);
                    n11 = n12 - this.getLineDescent(n6);
                    n10 = this.getParagraphDirection(n6);
                    n9 = this.mWidth;
                    boolean bl4 = this.mSpannedText;
                    n8 = 0;
                    if (!bl4) break block23;
                    spanned = (Spanned)charSequence;
                    int n16 = charSequence.length();
                    bl3 = n15 == 0 || charSequence.charAt(n15 - 1) == '\n';
                    if (n15 < n5 || n6 != n && !bl3) break block24;
                    n5 = spanned.nextSpanTransition(n15, n16, ParagraphStyle.class);
                    objectArray = Layout.getParagraphSpans(spanned, n15, n5, ParagraphStyle.class);
                    alignment = this.mAlignment;
                    int n17 = -1 + objectArray.length;
                    while (true) {
                        block26: {
                            block25: {
                                if (n17 < 0) break block25;
                                if (!(objectArray[n17] instanceof AlignmentSpan)) break block26;
                                alignment = ((AlignmentSpan)objectArray[n17]).getAlignment();
                            }
                            bl = false;
                            break;
                        }
                        --n17;
                    }
                }
                int n18 = objectArray.length;
                boolean bl5 = bl3;
                int n19 = 0;
                while (true) {
                    int n20;
                    if (n19 >= n18) break;
                    if (objectArray[n19] instanceof LeadingMarginSpan.LeadingMarginSpan2 && n6 < (n20 = ((LeadingMarginSpan.LeadingMarginSpan2)objectArray[n19]).getLeadingMarginLineCount() + this.getLineForOffset(spanned.getSpanStart(objectArray[n19])))) {
                        bl5 = true;
                        break;
                    }
                    ++n19;
                }
                for (int i = 0; i < n18; ++i) {
                    if (!(objectArray[i] instanceof LeadingMarginSpan)) continue;
                    LeadingMarginSpan leadingMarginSpan = (LeadingMarginSpan)objectArray[i];
                    if (n10 == -1) {
                        leadingMarginSpan.drawLeadingMargin(canvas, textPaint, n9, n10, n13, n11, n12, charSequence, n15, n14, bl3, this);
                        n9 -= leadingMarginSpan.getLeadingMargin(bl5);
                        continue;
                    }
                    leadingMarginSpan.drawLeadingMargin(canvas, textPaint, n8, n10, n13, n11, n12, charSequence, n15, n14, bl3, this);
                    n8 += leadingMarginSpan.getLeadingMargin(bl5);
                }
            }
            if ((bl2 = this.getLineContainsTab(n6)) && !bl) {
                if (tabStops == null) {
                    tabStops2 = new TabStops(20, objectArray);
                } else {
                    tabStops.reset(20, objectArray);
                    tabStops2 = tabStops;
                }
                bl = true;
            } else {
                tabStops2 = tabStops;
            }
            if ((alignment4 = alignment) == (alignment3 = Alignment.ALIGN_LEFT)) {
                alignment4 = n10 == 1 ? Alignment.ALIGN_NORMAL : Alignment.ALIGN_OPPOSITE;
            } else {
                Alignment alignment5 = Alignment.ALIGN_RIGHT;
                if (alignment4 == alignment5) {
                    alignment4 = n10 == 1 ? Alignment.ALIGN_OPPOSITE : Alignment.ALIGN_NORMAL;
                }
            }
            if (alignment4 == (alignment2 = Alignment.ALIGN_NORMAL)) {
                n7 = n10 == 1 ? n8 : n9;
            } else {
                int n21 = (int)this.getLineExtent(n6, tabStops2, false);
                Alignment alignment6 = Alignment.ALIGN_OPPOSITE;
                if (alignment4 == alignment6) {
                    n7 = n10 == 1 ? n9 - n21 : n8 - n21;
                } else {
                    int n22 = n21 & 0xFFFFFFFE;
                    n7 = n9 + n8 - n22 >> 1;
                }
            }
            if ((directions = this.getLineDirections(n6)) == DIRS_ALL_LEFT_TO_RIGHT && !this.mSpannedText && !bl2) {
                canvas.drawText(charSequence, n15, n14, (float)n7, (float)n11, (Paint)textPaint);
            } else {
                textLine.set(textPaint, charSequence, n15, n14, n10, directions, bl2, tabStops2);
                textLine.draw(canvas, n7, n13, n11, n12);
            }
            ++n6;
            tabStops = tabStops2;
        }
    }

    public final Alignment getAlignment() {
        return this.mAlignment;
    }

    public abstract int getBottomPadding();

    /*
     * Enabled aggressive block sorting
     */
    public void getCursorPath(int n, Path path, CharSequence charSequence) {
        int n2;
        int n3;
        int n4;
        float f;
        float f2;
        int n5;
        int n6;
        block16: {
            block15: {
                path.reset();
                int n7 = this.getLineForOffset(n);
                n6 = this.getLineTop(n7);
                n5 = this.getLineTop(n7 + 1);
                boolean bl = this.shouldClampCursor(n7);
                f2 = this.getPrimaryHorizontal(n, bl) - 0.5f;
                f = this.isLevelBoundary(n) ? this.getSecondaryHorizontal(n, bl) - 0.5f : f2;
                n4 = TextKeyListener.getMetaState(charSequence, 1) | TextKeyListener.getMetaState(charSequence, 2048);
                n3 = TextKeyListener.getMetaState(charSequence, 2);
                if (n4 != 0) break block15;
                n2 = 0;
                if (n3 == 0) break block16;
            }
            n2 = n5 - n6 >> 2;
            if (n3 != 0) {
                n6 += n2;
            }
            if (n4 != 0) {
                n5 -= n2;
            }
        }
        if (f2 < 0.5f) {
            f2 = 0.5f;
        }
        if (f < 0.5f) {
            f = 0.5f;
        }
        if (Float.compare(f2, f) == 0) {
            path.moveTo(f2, n6);
            path.lineTo(f2, n5);
        } else {
            path.moveTo(f2, n6);
            path.lineTo(f2, n6 + n5 >> 1);
            path.moveTo(f, n6 + n5 >> 1);
            path.lineTo(f, n5);
        }
        if (n4 == 2) {
            path.moveTo(f, n5);
            path.lineTo(f - (float)n2, n5 + n2);
            path.lineTo(f, n5);
            path.lineTo(f + (float)n2, n5 + n2);
        } else if (n4 == 1) {
            path.moveTo(f, n5);
            path.lineTo(f - (float)n2, n5 + n2);
            path.moveTo(f - (float)n2, (float)(n5 + n2) - 0.5f);
            path.lineTo(f + (float)n2, (float)(n5 + n2) - 0.5f);
            path.moveTo(f + (float)n2, n5 + n2);
            path.lineTo(f, n5);
        }
        if (n3 == 2) {
            path.moveTo(f2, n6);
            path.lineTo(f2 - (float)n2, n6 - n2);
            path.lineTo(f2, n6);
            path.lineTo(f2 + (float)n2, n6 - n2);
            return;
        } else {
            if (n3 != 1) return;
            path.moveTo(f2, n6);
            path.lineTo(f2 - (float)n2, n6 - n2);
            path.moveTo(f2 - (float)n2, 0.5f + (float)(n6 - n2));
            path.lineTo(f2 + (float)n2, 0.5f + (float)(n6 - n2));
            path.moveTo(f2 + (float)n2, n6 - n2);
            path.lineTo(f2, n6);
            return;
        }
    }

    public abstract int getEllipsisCount(int var1);

    public abstract int getEllipsisStart(int var1);

    public int getEllipsizedWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.getLineTop(this.getLineCount());
    }

    public final int getLineAscent(int n) {
        return this.getLineTop(n) - (this.getLineTop(n + 1) - this.getLineDescent(n));
    }

    public final int getLineBaseline(int n) {
        return this.getLineTop(n + 1) - this.getLineDescent(n);
    }

    public final int getLineBottom(int n) {
        return this.getLineTop(n + 1);
    }

    public int getLineBounds(int n, Rect rect) {
        if (rect != null) {
            rect.left = 0;
            rect.top = this.getLineTop(n);
            rect.right = this.mWidth;
            rect.bottom = this.getLineTop(n + 1);
        }
        return this.getLineBaseline(n);
    }

    public abstract boolean getLineContainsTab(int var1);

    public abstract int getLineCount();

    public abstract int getLineDescent(int var1);

    public abstract Directions getLineDirections(int var1);

    public final int getLineEnd(int n) {
        return this.getLineStart(n + 1);
    }

    public int getLineForOffset(int n) {
        int n2 = this.getLineCount();
        int n3 = -1;
        while (n2 - n3 > 1) {
            int n4 = (n2 + n3) / 2;
            if (this.getLineStart(n4) > n) {
                n2 = n4;
                continue;
            }
            n3 = n4;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        return n3;
    }

    public int getLineForVertical(int n) {
        int n2 = this.getLineCount();
        int n3 = -1;
        while (n2 - n3 > 1) {
            int n4 = (n2 + n3) / 2;
            if (this.getLineTop(n4) > n) {
                n2 = n4;
                continue;
            }
            n3 = n4;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public float getLineLeft(int n) {
        int n2 = this.getParagraphDirection(n);
        Alignment alignment = this.getParagraphAlignment(n);
        if (alignment == Alignment.ALIGN_LEFT) return 0.0f;
        if (alignment == Alignment.ALIGN_NORMAL) {
            if (n2 != -1) return 0.0f;
            return (float)this.getParagraphRight(n) - this.getLineMax(n);
        }
        if (alignment == Alignment.ALIGN_RIGHT) {
            return (float)this.mWidth - this.getLineMax(n);
        }
        if (alignment != Alignment.ALIGN_OPPOSITE) {
            int n3 = this.getParagraphLeft(n);
            int n4 = this.getParagraphRight(n);
            int n5 = 0xFFFFFFFE & (int)this.getLineMax(n);
            return n3 + (n4 - n3 - n5) / 2;
        }
        if (n2 != -1) return (float)this.mWidth - this.getLineMax(n);
        return 0.0f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float getLineMax(int n) {
        float f = this.getParagraphLeadingMargin(n);
        float f2 = this.getLineExtent(n, false);
        if (f2 >= 0.0f) {
            return f + f2;
        }
        f2 = -f2;
        return f + f2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getLineRangeForDraw(Canvas canvas) {
        int n;
        int n2;
        Rect rect = sTempRect;
        synchronized (rect) {
            if (!canvas.getClipBounds(sTempRect)) {
                return TextUtils.packRangeInLong(0, -1);
            }
            n2 = Layout.sTempRect.top;
            n = Layout.sTempRect.bottom;
        }
        int n3 = Math.max(n2, 0);
        int n4 = Math.min(this.getLineTop(this.getLineCount()), n);
        if (n3 < n4) return TextUtils.packRangeInLong(this.getLineForVertical(n3), this.getLineForVertical(n4));
        return TextUtils.packRangeInLong(0, -1);
    }

    public float getLineRight(int n) {
        int n2 = this.getParagraphDirection(n);
        Alignment alignment = this.getParagraphAlignment(n);
        if (alignment == Alignment.ALIGN_LEFT) {
            return (float)this.getParagraphLeft(n) + this.getLineMax(n);
        }
        if (alignment == Alignment.ALIGN_NORMAL) {
            if (n2 == -1) {
                return this.mWidth;
            }
            return (float)this.getParagraphLeft(n) + this.getLineMax(n);
        }
        if (alignment == Alignment.ALIGN_RIGHT) {
            return this.mWidth;
        }
        if (alignment == Alignment.ALIGN_OPPOSITE) {
            if (n2 == -1) {
                return this.getLineMax(n);
            }
            return this.mWidth;
        }
        int n3 = this.getParagraphLeft(n);
        int n4 = this.getParagraphRight(n);
        int n5 = 0xFFFFFFFE & (int)this.getLineMax(n);
        return n4 - (n4 - n3 - n5) / 2;
    }

    public abstract int getLineStart(int var1);

    public abstract int getLineTop(int var1);

    public int getLineVisibleEnd(int n) {
        return this.getLineVisibleEnd(n, this.getLineStart(n), this.getLineStart(n + 1));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float getLineWidth(int n) {
        float f = this.getParagraphLeadingMargin(n);
        float f2 = this.getLineExtent(n, true);
        if (f2 >= 0.0f) {
            return f + f2;
        }
        f2 = -f2;
        return f + f2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getOffsetForHorizontal(int n, float f) {
        int n2 = -1 + this.getLineEnd(n);
        int n3 = this.getLineStart(n);
        Directions directions = this.getLineDirections(n);
        if (n == -1 + this.getLineCount()) {
            ++n2;
        }
        int n4 = n3;
        float f2 = Math.abs(this.getPrimaryHorizontal(n4) - f);
        int n5 = 0;
        while (true) {
            float f3;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            if (n5 < directions.mDirections.length) {
                n10 = n3 + directions.mDirections[n5];
                n9 = n10 + (0x3FFFFFF & directions.mDirections[n5 + 1]);
                n8 = (0x4000000 & directions.mDirections[n5 + 1]) != 0 ? -1 : 1;
                if (n9 > n2) {
                    n9 = n2;
                }
                n7 = 1 + (n9 - 1);
                n6 = -1 + (n10 + 1);
            } else {
                if (!(Math.abs(this.getPrimaryHorizontal(n2) - f) <= f2)) return n4;
                return n2;
            }
            while (n7 - n6 > 1) {
                int n11 = (n7 + n6) / 2;
                if (this.getPrimaryHorizontal(this.getOffsetAtStartOf(n11)) * (float)n8 >= f * (float)n8) {
                    n7 = n11;
                    continue;
                }
                n6 = n11;
            }
            if (n6 < n10 + 1) {
                n6 = n10 + 1;
            }
            if (n6 < n9) {
                float f4;
                int n12 = this.getOffsetAtStartOf(n6);
                float f5 = Math.abs(this.getPrimaryHorizontal(n12) - f);
                int n13 = TextUtils.getOffsetAfter(this.mText, n12);
                if (n13 < n9 && (f4 = Math.abs(this.getPrimaryHorizontal(n13) - f)) < f5) {
                    f5 = f4;
                    n12 = n13;
                }
                if (f5 < f2) {
                    f2 = f5;
                    n4 = n12;
                }
            }
            if ((f3 = Math.abs(this.getPrimaryHorizontal(n10) - f)) < f2) {
                f2 = f3;
                n4 = n10;
            }
            n5 += 2;
        }
    }

    public int getOffsetToLeftOf(int n) {
        return this.getOffsetToLeftRightOf(n, true);
    }

    public int getOffsetToRightOf(int n) {
        return this.getOffsetToLeftRightOf(n, false);
    }

    public final TextPaint getPaint() {
        return this.mPaint;
    }

    public final Alignment getParagraphAlignment(int n) {
        AlignmentSpan[] alignmentSpanArray;
        int n2;
        Alignment alignment = this.mAlignment;
        if (this.mSpannedText && (n2 = (alignmentSpanArray = Layout.getParagraphSpans((Spanned)this.mText, this.getLineStart(n), this.getLineEnd(n), AlignmentSpan.class)).length) > 0) {
            alignment = alignmentSpanArray[n2 - 1].getAlignment();
        }
        return alignment;
    }

    public abstract int getParagraphDirection(int var1);

    public final int getParagraphLeft(int n) {
        if (this.getParagraphDirection(n) == -1 || !this.mSpannedText) {
            return 0;
        }
        return this.getParagraphLeadingMargin(n);
    }

    public final int getParagraphRight(int n) {
        int n2 = this.mWidth;
        if (this.getParagraphDirection(n) == 1 || !this.mSpannedText) {
            return n2;
        }
        return n2 - this.getParagraphLeadingMargin(n);
    }

    public float getPrimaryHorizontal(int n) {
        return this.getPrimaryHorizontal(n, false);
    }

    public float getPrimaryHorizontal(int n, boolean bl) {
        return this.getHorizontal(n, this.primaryIsTrailingPrevious(n), bl);
    }

    public float getSecondaryHorizontal(int n) {
        return this.getSecondaryHorizontal(n, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float getSecondaryHorizontal(int n, boolean bl) {
        boolean bl2;
        if (!this.primaryIsTrailingPrevious(n)) {
            bl2 = true;
            return this.getHorizontal(n, bl2, bl);
        }
        bl2 = false;
        return this.getHorizontal(n, bl2, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void getSelectionPath(int n, int n2, Path path) {
        path.reset();
        if (n == n2) {
            return;
        }
        if (n2 < n) {
            int n3 = n2;
            n2 = n;
            n = n3;
        }
        int n4 = this.getLineForOffset(n);
        int n5 = this.getLineForOffset(n2);
        int n6 = this.getLineTop(n4);
        int n7 = this.getLineBottom(n5);
        if (n4 == n5) {
            this.addSelection(n4, n, n2, n6, n7, path);
            return;
        }
        float f = this.mWidth;
        int n8 = this.getLineEnd(n4);
        int n9 = this.getLineBottom(n4);
        this.addSelection(n4, n, n8, n6, n9, path);
        if (this.getParagraphDirection(n4) == -1) {
            path.addRect(this.getLineLeft(n4), n6, 0.0f, this.getLineBottom(n4), Path.Direction.CW);
        } else {
            path.addRect(this.getLineRight(n4), n6, f, this.getLineBottom(n4), Path.Direction.CW);
        }
        for (int i = n4 + 1; i < n5; ++i) {
            int n10 = this.getLineTop(i);
            int n11 = this.getLineBottom(i);
            path.addRect(0.0f, n10, f, n11, Path.Direction.CW);
        }
        int n12 = this.getLineTop(n5);
        int n13 = this.getLineBottom(n5);
        this.addSelection(n5, this.getLineStart(n5), n2, n12, n13, path);
        if (this.getParagraphDirection(n5) == -1) {
            path.addRect(f, n12, this.getLineRight(n5), n13, Path.Direction.CW);
            return;
        }
        path.addRect(0.0f, n12, this.getLineLeft(n5), n13, Path.Direction.CW);
    }

    public final float getSpacingAdd() {
        return this.mSpacingAdd;
    }

    public final float getSpacingMultiplier() {
        return this.mSpacingMult;
    }

    public final CharSequence getText() {
        return this.mText;
    }

    public final TextDirectionHeuristic getTextDirectionHeuristic() {
        return this.mTextDir;
    }

    public abstract int getTopPadding();

    public final int getWidth() {
        return this.mWidth;
    }

    public final void increaseWidthTo(int n) {
        if (n < this.mWidth) {
            throw new RuntimeException("attempted to reduce Layout width");
        }
        this.mWidth = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isLevelBoundary(int n) {
        int n2 = this.getLineForOffset(n);
        Directions directions = this.getLineDirections(n2);
        if (directions == DIRS_ALL_LEFT_TO_RIGHT || directions == DIRS_ALL_RIGHT_TO_LEFT) return false;
        int[] nArray = directions.mDirections;
        int n3 = this.getLineStart(n2);
        int n4 = this.getLineEnd(n2);
        if (n == n3 || n == n4) {
            int n5;
            int n6 = n == n3 ? 0 : -2 + nArray.length;
            if ((0x3F & nArray[n6 + 1] >>> 26) == (n5 = this.getParagraphDirection(n2) == 1 ? 0 : 1)) return false;
            return true;
        } else {
            int n7 = n - n3;
            for (int i = 0; i < nArray.length; i += 2) {
                if (n7 != nArray[i]) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isRtlCharAt(int n) {
        boolean bl = true;
        int n2 = this.getLineForOffset(n);
        Directions directions = this.getLineDirections(n2);
        if (directions == DIRS_ALL_LEFT_TO_RIGHT) {
            return false;
        }
        if (directions == DIRS_ALL_RIGHT_TO_LEFT) {
            return bl;
        }
        int[] nArray = directions.mDirections;
        int n3 = this.getLineStart(n2);
        int n4 = 0;
        while (n4 < nArray.length) {
            int n5 = n3 + nArray[n4];
            int n6 = n5 + (0x3FFFFFF & nArray[n4 + 1]);
            if (n >= n5 && n < n6) {
                if ((1 & (0x3F & nArray[n4 + 1] >>> 26)) == 0) return false;
                return bl;
            }
            n4 += 2;
        }
        return false;
    }

    protected final boolean isSpanned() {
        return this.mSpannedText;
    }

    void replaceWith(CharSequence charSequence, TextPaint textPaint, int n, Alignment alignment, float f, float f2) {
        if (n < 0) {
            throw new IllegalArgumentException("Layout: " + n + " < 0");
        }
        this.mText = charSequence;
        this.mPaint = textPaint;
        this.mWidth = n;
        this.mAlignment = alignment;
        this.mSpacingMult = f;
        this.mSpacingAdd = f2;
        this.mSpannedText = charSequence instanceof Spanned;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean shouldClampCursor(int n) {
        boolean bl = true;
        switch (1.$SwitchMap$android$text$Layout$Alignment[this.getParagraphAlignment(n).ordinal()]) {
            default: {
                bl = false;
            }
            case 1: {
                return bl;
            }
            case 2: {
                if (this.getParagraphDirection(n) > 0) return bl;
                return false;
            }
        }
    }

    public static final class Alignment
    extends Enum<Alignment> {
        private static final /* synthetic */ Alignment[] $VALUES;
        public static final /* enum */ Alignment ALIGN_CENTER;
        public static final /* enum */ Alignment ALIGN_LEFT;
        public static final /* enum */ Alignment ALIGN_NORMAL;
        public static final /* enum */ Alignment ALIGN_OPPOSITE;
        public static final /* enum */ Alignment ALIGN_RIGHT;

        static {
            ALIGN_NORMAL = new Alignment();
            ALIGN_OPPOSITE = new Alignment();
            ALIGN_CENTER = new Alignment();
            ALIGN_LEFT = new Alignment();
            ALIGN_RIGHT = new Alignment();
            Alignment[] alignmentArray = new Alignment[]{ALIGN_NORMAL, ALIGN_OPPOSITE, ALIGN_CENTER, ALIGN_LEFT, ALIGN_RIGHT};
            $VALUES = alignmentArray;
        }

        public static Alignment valueOf(String string2) {
            return Enum.valueOf(Alignment.class, string2);
        }

        public static Alignment[] values() {
            return (Alignment[])$VALUES.clone();
        }
    }

    public static class Directions {
        int[] mDirections;

        Directions(int[] nArray) {
            this.mDirections = nArray;
        }
    }

    static class Ellipsizer
    implements CharSequence,
    GetChars {
        Layout mLayout;
        TextUtils.TruncateAt mMethod;
        CharSequence mText;
        int mWidth;

        public Ellipsizer(CharSequence charSequence) {
            this.mText = charSequence;
        }

        @Override
        public char charAt(int n) {
            char[] cArray = TextUtils.obtain(1);
            this.getChars(n, n + 1, cArray, 0);
            char c = cArray[0];
            TextUtils.recycle(cArray);
            return c;
        }

        @Override
        public void getChars(int n, int n2, char[] cArray, int n3) {
            int n4 = this.mLayout.getLineForOffset(n);
            int n5 = this.mLayout.getLineForOffset(n2);
            TextUtils.getChars(this.mText, n, n2, cArray, n3);
            for (int i = n4; i <= n5; ++i) {
                this.mLayout.ellipsize(n, n2, i, cArray, n3, this.mMethod);
            }
        }

        @Override
        public int length() {
            return this.mText.length();
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            char[] cArray = new char[n2 - n];
            this.getChars(n, n2, cArray, 0);
            return new String(cArray);
        }

        @Override
        public String toString() {
            char[] cArray = new char[this.length()];
            this.getChars(0, this.length(), cArray, 0);
            return new String(cArray);
        }
    }

    static class SpannedEllipsizer
    extends Ellipsizer
    implements Spanned {
        private Spanned mSpanned;

        public SpannedEllipsizer(CharSequence charSequence) {
            super(charSequence);
            this.mSpanned = (Spanned)charSequence;
        }

        @Override
        public int getSpanEnd(Object object) {
            return this.mSpanned.getSpanEnd(object);
        }

        @Override
        public int getSpanFlags(Object object) {
            return this.mSpanned.getSpanFlags(object);
        }

        @Override
        public int getSpanStart(Object object) {
            return this.mSpanned.getSpanStart(object);
        }

        @Override
        public <T> T[] getSpans(int n, int n2, Class<T> clazz) {
            return this.mSpanned.getSpans(n, n2, clazz);
        }

        @Override
        public int nextSpanTransition(int n, int n2, Class clazz) {
            return this.mSpanned.nextSpanTransition(n, n2, clazz);
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            char[] cArray = new char[n2 - n];
            this.getChars(n, n2, cArray, 0);
            SpannableString spannableString = new SpannableString(new String(cArray));
            TextUtils.copySpansFrom(this.mSpanned, n, n2, Object.class, spannableString, 0);
            return spannableString;
        }
    }

    static class TabStops {
        private int mIncrement;
        private int mNumStops;
        private int[] mStops;

        TabStops(int n, Object[] objectArray) {
            this.reset(n, objectArray);
        }

        public static float nextDefaultStop(float f, int n) {
            return n * (int)((f + (float)n) / (float)n);
        }

        float nextTab(float f) {
            int n = this.mNumStops;
            if (n > 0) {
                int[] nArray = this.mStops;
                for (int i = 0; i < n; ++i) {
                    int n2 = nArray[i];
                    if (!((float)n2 > f)) continue;
                    return n2;
                }
            }
            return TabStops.nextDefaultStop(f, this.mIncrement);
        }

        /*
         * Enabled aggressive block sorting
         */
        void reset(int n, Object[] objectArray) {
            int n2;
            block7: {
                this.mIncrement = n;
                n2 = 0;
                if (objectArray == null) break block7;
                int[] nArray = this.mStops;
                int n3 = objectArray.length;
                int n4 = 0;
                int n5 = 0;
                while (true) {
                    int n6;
                    block10: {
                        block9: {
                            block8: {
                                if (n4 >= n3) break block8;
                                Object object = objectArray[n4];
                                if (!(object instanceof TabStopSpan)) break block9;
                                if (nArray == null) {
                                    nArray = new int[10];
                                } else if (n5 == nArray.length) {
                                    int[] nArray2 = new int[n5 * 2];
                                    for (int i = 0; i < n5; ++i) {
                                        nArray2[i] = nArray[i];
                                    }
                                    nArray = nArray2;
                                }
                                n6 = n5 + 1;
                                nArray[n5] = ((TabStopSpan)object).getTabStop();
                                break block10;
                            }
                            if (n5 > 1) {
                                Arrays.sort(nArray, 0, n5);
                            }
                            if (nArray != this.mStops) {
                                this.mStops = nArray;
                            }
                            n2 = n5;
                            break;
                        }
                        n6 = n5;
                    }
                    ++n4;
                    n5 = n6;
                }
            }
            this.mNumStops = n2;
        }
    }
}

