/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.drawable.Drawable;
import android.text.AndroidBidi;
import android.text.Editable;
import android.text.HtmlToSpannedConverter;
import android.text.Layout;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.AlignmentSpan;
import android.text.style.CharacterStyle;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.text.style.ParagraphStyle;
import android.text.style.QuoteSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import com.android.internal.util.ArrayUtils;
import org.ccil.cowan.tagsoup.HTMLSchema;
import org.ccil.cowan.tagsoup.Parser;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class Html {
    private Html() {
    }

    public static String escapeHtml(CharSequence charSequence) {
        StringBuilder stringBuilder = new StringBuilder();
        Html.withinStyle(stringBuilder, charSequence, 0, charSequence.length());
        return stringBuilder.toString();
    }

    public static Spanned fromHtml(String string2) {
        return Html.fromHtml(string2, null, null);
    }

    public static Spanned fromHtml(String string2, ImageGetter imageGetter, TagHandler tagHandler) {
        Parser parser = new Parser();
        try {
            parser.setProperty("http://www.ccil.org/~cowan/tagsoup/properties/schema", (Object)HtmlParser.schema);
            return new HtmlToSpannedConverter(string2, imageGetter, tagHandler, parser).convert();
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new RuntimeException(sAXNotRecognizedException);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new RuntimeException(sAXNotSupportedException);
        }
    }

    private static String getOpenParaTagWithDirection(Spanned spanned, int n, int n2) {
        int n3 = n2 - n;
        byte[] byArray = ArrayUtils.newUnpaddedByteArray(n3);
        char[] cArray = TextUtils.obtain(n3);
        TextUtils.getChars(spanned, n, n2, cArray, 0);
        switch (AndroidBidi.bidi(2, cArray, byArray, n3, false)) {
            default: {
                return "<p dir=\"ltr\">";
            }
            case -1: 
        }
        return "<p dir=\"rtl\">";
    }

    public static String toHtml(Spanned spanned) {
        StringBuilder stringBuilder = new StringBuilder();
        Html.withinHtml(stringBuilder, spanned);
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void withinBlockquote(StringBuilder stringBuilder, Spanned spanned, int n, int n2) {
        stringBuilder.append(Html.getOpenParaTagWithDirection(spanned, n, n2));
        int n3 = n;
        while (true) {
            if (n3 >= n2) {
                stringBuilder.append("</p>\n");
                return;
            }
            int n4 = TextUtils.indexOf((CharSequence)spanned, '\n', n3, n2);
            if (n4 < 0) {
                n4 = n2;
            }
            int n5 = 0;
            while (n4 < n2 && spanned.charAt(n4) == '\n') {
                ++n5;
                ++n4;
            }
            int n6 = n4 - n5;
            boolean bl = n4 == n2;
            Html.withinParagraph(stringBuilder, spanned, n3, n6, n5, bl);
            n3 = n4;
        }
    }

    private static void withinDiv(StringBuilder stringBuilder, Spanned spanned, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            int n4 = spanned.nextSpanTransition(n3, n2, QuoteSpan.class);
            QuoteSpan[] quoteSpanArray = spanned.getSpans(n3, n4, QuoteSpan.class);
            int n5 = quoteSpanArray.length;
            for (int i = 0; i < n5; ++i) {
                QuoteSpan cfr_ignored_0 = quoteSpanArray[i];
                stringBuilder.append("<blockquote>");
            }
            Html.withinBlockquote(stringBuilder, spanned, n3, n4);
            int n6 = quoteSpanArray.length;
            for (int i = 0; i < n6; ++i) {
                QuoteSpan cfr_ignored_1 = quoteSpanArray[i];
                stringBuilder.append("</blockquote>\n");
            }
            n3 = n4;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void withinHtml(StringBuilder stringBuilder, Spanned spanned) {
        int n = spanned.length();
        int n2 = 0;
        while (n2 < spanned.length()) {
            int n3 = spanned.nextSpanTransition(n2, n, ParagraphStyle.class);
            ParagraphStyle[] paragraphStyleArray = spanned.getSpans(n2, n3, ParagraphStyle.class);
            String string2 = " ";
            boolean bl = false;
            for (int i = 0; i < paragraphStyleArray.length; ++i) {
                if (!(paragraphStyleArray[i] instanceof AlignmentSpan)) continue;
                Layout.Alignment alignment = ((AlignmentSpan)paragraphStyleArray[i]).getAlignment();
                bl = true;
                string2 = alignment == Layout.Alignment.ALIGN_CENTER ? "align=\"center\" " + string2 : (alignment == Layout.Alignment.ALIGN_OPPOSITE ? "align=\"right\" " + string2 : "align=\"left\" " + string2);
            }
            if (bl) {
                stringBuilder.append("<div ").append(string2).append(">");
            }
            Html.withinDiv(stringBuilder, spanned, n2, n3);
            if (bl) {
                stringBuilder.append("</div>");
            }
            n2 = n3;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void withinParagraph(StringBuilder stringBuilder, Spanned spanned, int n, int n2, int n3, boolean bl) {
        int n4 = n;
        while (true) {
            CharacterStyle[] characterStyleArray;
            int n5;
            if (n4 < n2) {
                n5 = spanned.nextSpanTransition(n4, n2, CharacterStyle.class);
                characterStyleArray = spanned.getSpans(n4, n5, CharacterStyle.class);
            } else {
                String string2 = bl ? "" : "</p>\n" + Html.getOpenParaTagWithDirection(spanned, n, n2);
                if (n3 == 1) {
                    stringBuilder.append("<br>\n");
                    return;
                }
                if (n3 == 2) {
                    stringBuilder.append(string2);
                    return;
                }
                int n6 = 2;
                while (true) {
                    if (n6 >= n3) {
                        stringBuilder.append(string2);
                        return;
                    }
                    stringBuilder.append("<br>");
                    ++n6;
                }
            }
            for (int i = 0; i < characterStyleArray.length; ++i) {
                if (characterStyleArray[i] instanceof StyleSpan) {
                    int n7 = ((StyleSpan)characterStyleArray[i]).getStyle();
                    if ((n7 & 1) != 0) {
                        stringBuilder.append("<b>");
                    }
                    if ((n7 & 2) != 0) {
                        stringBuilder.append("<i>");
                    }
                }
                if (characterStyleArray[i] instanceof TypefaceSpan && ((TypefaceSpan)characterStyleArray[i]).getFamily().equals("monospace")) {
                    stringBuilder.append("<tt>");
                }
                if (characterStyleArray[i] instanceof SuperscriptSpan) {
                    stringBuilder.append("<sup>");
                }
                if (characterStyleArray[i] instanceof SubscriptSpan) {
                    stringBuilder.append("<sub>");
                }
                if (characterStyleArray[i] instanceof UnderlineSpan) {
                    stringBuilder.append("<u>");
                }
                if (characterStyleArray[i] instanceof StrikethroughSpan) {
                    stringBuilder.append("<strike>");
                }
                if (characterStyleArray[i] instanceof URLSpan) {
                    stringBuilder.append("<a href=\"");
                    stringBuilder.append(((URLSpan)characterStyleArray[i]).getURL());
                    stringBuilder.append("\">");
                }
                if (characterStyleArray[i] instanceof ImageSpan) {
                    stringBuilder.append("<img src=\"");
                    stringBuilder.append(((ImageSpan)characterStyleArray[i]).getSource());
                    stringBuilder.append("\">");
                    n4 = n5;
                }
                if (characterStyleArray[i] instanceof AbsoluteSizeSpan) {
                    stringBuilder.append("<font size =\"");
                    stringBuilder.append(((AbsoluteSizeSpan)characterStyleArray[i]).getSize() / 6);
                    stringBuilder.append("\">");
                }
                if (!(characterStyleArray[i] instanceof ForegroundColorSpan)) continue;
                stringBuilder.append("<font color =\"#");
                String string3 = Integer.toHexString(0x1000000 + ((ForegroundColorSpan)characterStyleArray[i]).getForegroundColor());
                while (string3.length() < 6) {
                    string3 = "0" + string3;
                }
                stringBuilder.append(string3);
                stringBuilder.append("\">");
            }
            Html.withinStyle(stringBuilder, spanned, n4, n5);
            for (int i = -1 + characterStyleArray.length; i >= 0; --i) {
                if (characterStyleArray[i] instanceof ForegroundColorSpan) {
                    stringBuilder.append("</font>");
                }
                if (characterStyleArray[i] instanceof AbsoluteSizeSpan) {
                    stringBuilder.append("</font>");
                }
                if (characterStyleArray[i] instanceof URLSpan) {
                    stringBuilder.append("</a>");
                }
                if (characterStyleArray[i] instanceof StrikethroughSpan) {
                    stringBuilder.append("</strike>");
                }
                if (characterStyleArray[i] instanceof UnderlineSpan) {
                    stringBuilder.append("</u>");
                }
                if (characterStyleArray[i] instanceof SubscriptSpan) {
                    stringBuilder.append("</sub>");
                }
                if (characterStyleArray[i] instanceof SuperscriptSpan) {
                    stringBuilder.append("</sup>");
                }
                if (characterStyleArray[i] instanceof TypefaceSpan && ((TypefaceSpan)characterStyleArray[i]).getFamily().equals("monospace")) {
                    stringBuilder.append("</tt>");
                }
                if (!(characterStyleArray[i] instanceof StyleSpan)) continue;
                int n8 = ((StyleSpan)characterStyleArray[i]).getStyle();
                if ((n8 & 1) != 0) {
                    stringBuilder.append("</b>");
                }
                if ((n8 & 2) == 0) continue;
                stringBuilder.append("</i>");
            }
            n4 = n5;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void withinStyle(StringBuilder stringBuilder, CharSequence charSequence, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            char c = charSequence.charAt(n3);
            if (c == '<') {
                stringBuilder.append("&lt;");
            } else if (c == '>') {
                stringBuilder.append("&gt;");
            } else if (c == '&') {
                stringBuilder.append("&amp;");
            } else if (c >= '\ud800' && c <= '\udfff') {
                char c2;
                if (c < '\udc00' && n3 + 1 < n2 && (c2 = charSequence.charAt(n3 + 1)) >= '\udc00' && c2 <= '\udfff') {
                    ++n3;
                    int n4 = 0x10000 | c - 55296 << 10 | c2 - 56320;
                    stringBuilder.append("&#").append(n4).append(";");
                }
            } else if (c > '~' || c < ' ') {
                stringBuilder.append("&#").append((int)c).append(";");
            } else if (c == ' ') {
                while (n3 + 1 < n2 && charSequence.charAt(n3 + 1) == ' ') {
                    stringBuilder.append("&nbsp;");
                    ++n3;
                }
                stringBuilder.append(' ');
            } else {
                stringBuilder.append(c);
            }
            ++n3;
        }
        return;
    }

    private static class HtmlParser {
        private static final HTMLSchema schema = new HTMLSchema();

        private HtmlParser() {
        }
    }

    public static interface ImageGetter {
        public Drawable getDrawable(String var1);
    }

    public static interface TagHandler {
        public void handleTag(boolean var1, String var2, Editable var3, XMLReader var4);
    }
}

