/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.view.View;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.util.Locale;
import org.xmlpull.v1.XmlPullParserException;

public class AutoText {
    private static final int DEFAULT = 14337;
    private static final int INCREMENT = 1024;
    private static final int RIGHT = 9300;
    private static final int TRIE_C = 0;
    private static final int TRIE_CHILD = 2;
    private static final int TRIE_NEXT = 3;
    private static final char TRIE_NULL = '\uffff';
    private static final int TRIE_OFF = 1;
    private static final int TRIE_ROOT = 0;
    private static final int TRIE_SIZEOF = 4;
    private static AutoText sInstance = new AutoText(Resources.getSystem());
    private static Object sLock = new Object();
    private Locale mLocale;
    private int mSize;
    private String mText;
    private char[] mTrie;
    private char mTrieUsed;

    private AutoText(Resources resources) {
        this.mLocale = resources.getConfiguration().locale;
        this.init(resources);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void add(String string2, char c) {
        int n = string2.length();
        int n2 = 0;
        this.mSize = 1 + this.mSize;
        int n3 = 0;
        while (n3 < n) {
            block5: {
                char c2 = string2.charAt(n3);
                while (true) {
                    block7: {
                        boolean bl;
                        block6: {
                            char c3 = this.mTrie[n2];
                            bl = false;
                            if (c3 == '\uffff') break block6;
                            if (c2 != this.mTrie['\u0000' + this.mTrie[n2]]) break block7;
                            if (n3 == n - 1) {
                                this.mTrie['\u0001' + this.mTrie[n2]] = c;
                                return;
                            }
                            n2 = 2 + this.mTrie[n2];
                            bl = true;
                        }
                        if (!bl) {
                            char c4;
                            this.mTrie[n2] = c4 = this.newTrieNode();
                            this.mTrie['\u0000' + this.mTrie[n2]] = c2;
                            this.mTrie['\u0001' + this.mTrie[n2]] = 65535;
                            this.mTrie[3 + this.mTrie[n2]] = 65535;
                            this.mTrie[2 + this.mTrie[n2]] = 65535;
                            if (n3 != n - 1) break;
                            this.mTrie['\u0001' + this.mTrie[n2]] = c;
                            return;
                        }
                        break block5;
                    }
                    n2 = 3 + this.mTrie[n2];
                }
                n2 = 2 + this.mTrie[n2];
            }
            ++n3;
        }
    }

    public static String get(CharSequence charSequence, int n, int n2, View view) {
        return AutoText.getInstance(view).lookup(charSequence, n, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static AutoText getInstance(View view) {
        Resources resources = view.getContext().getResources();
        Locale locale = resources.getConfiguration().locale;
        Object object = sLock;
        synchronized (object) {
            AutoText autoText = sInstance;
            if (!locale.equals(autoText.mLocale)) {
                sInstance = autoText = new AutoText(resources);
            }
            return autoText;
        }
    }

    private int getSize() {
        return this.mSize;
    }

    public static int getSize(View view) {
        return AutoText.getInstance(view).getSize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void init(Resources resources) {
        XmlResourceParser xmlResourceParser = resources.getXml(0x1110002);
        StringBuilder stringBuilder = new StringBuilder(9300);
        this.mTrie = new char[14337];
        this.mTrie[0] = 65535;
        this.mTrieUsed = '\u0001';
        try {
            XmlUtils.beginDocument(xmlResourceParser, "words");
            while (true) {
                char c;
                XmlUtils.nextElement(xmlResourceParser);
                String string2 = xmlResourceParser.getName();
                if (string2 == null || !string2.equals("word")) {
                    resources.flushLayoutCache();
                    this.mText = stringBuilder.toString();
                    return;
                }
                String string3 = xmlResourceParser.getAttributeValue(null, "src");
                if (xmlResourceParser.next() != 4) continue;
                String string4 = xmlResourceParser.getText();
                if (string4.equals("")) {
                    c = '\u0000';
                } else {
                    c = (char)stringBuilder.length();
                    stringBuilder.append((char)string4.length());
                    stringBuilder.append(string4);
                }
                this.add(string3, c);
                continue;
                break;
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new RuntimeException(xmlPullParserException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            xmlResourceParser.close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String lookup(CharSequence charSequence, int n, int n2) {
        char c = this.mTrie[0];
        int n3 = n;
        block0: while (true) {
            String string2 = null;
            if (n3 >= n2) return string2;
            char c2 = charSequence.charAt(n3);
            while (true) {
                block7: {
                    block6: {
                        if (c == '\uffff') break block6;
                        if (c2 != this.mTrie[c + '\u0000']) break block7;
                        if (n3 == n2 - 1 && this.mTrie[c + '\u0001'] != '\uffff') {
                            char c3 = this.mTrie[c + '\u0001'];
                            char c4 = this.mText.charAt(c3);
                            return this.mText.substring(c3 + '\u0001', c4 + (c3 + '\u0001'));
                        }
                        c = this.mTrie[c + 2];
                    }
                    string2 = null;
                    if (c == '\uffff') return string2;
                    ++n3;
                    continue block0;
                }
                c = this.mTrie[c + 3];
            }
            break;
        }
    }

    private char newTrieNode() {
        if (4 + this.mTrieUsed > this.mTrie.length) {
            char[] cArray = new char[1024 + this.mTrie.length];
            System.arraycopy((char[])this.mTrie, (int)0, (char[])cArray, (int)0, (int)this.mTrie.length);
            this.mTrie = cArray;
        }
        char c = this.mTrieUsed;
        this.mTrieUsed = (char)(4 + this.mTrieUsed);
        return c;
    }
}

