/*
 * Decompiled with CFR 0.152.
 */
package android.test;

import android.app.Activity;
import android.app.Instrumentation;
import android.content.Intent;
import android.os.Bundle;
import android.test.FlakyTest;
import android.test.RepetitiveTest;
import android.test.UiThreadTest;
import android.util.Log;
import android.view.KeyEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import junit.framework.TestCase;

public class InstrumentationTestCase
extends TestCase {
    private Instrumentation mInstrumentation;

    private void runMethod(Method method, int n) throws Throwable {
        this.runMethod(method, n, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runMethod(Method method, int n, boolean bl) throws Throwable {
        int n2 = 0;
        while (true) {
            Bundle bundle;
            Throwable throwable;
            try {
                method.invoke(this, null);
                ++n2;
                throwable = null;
                if (!bl) continue;
                bundle = new Bundle();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.fillInStackTrace();
                Throwable throwable2 = invocationTargetException.getTargetException();
                throwable = throwable2;
                ++n2;
                if (!bl) continue;
                Bundle bundle2 = new Bundle();
                {
                    catch (Throwable throwable3) {
                        int n3 = n2 + 1;
                        if (bl) {
                            Bundle bundle3 = new Bundle();
                            bundle3.putInt("currentiterations", n3);
                            this.getInstrumentation().sendStatus(2, bundle3);
                        }
                        throw throwable3;
                    }
                }
                bundle2.putInt("currentiterations", n2);
                this.getInstrumentation().sendStatus(2, bundle2);
                continue;
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.fillInStackTrace();
                    throwable = illegalAccessException;
                    ++n2;
                    if (!bl) continue;
                    Bundle bundle4 = new Bundle();
                    bundle4.putInt("currentiterations", n2);
                    this.getInstrumentation().sendStatus(2, bundle4);
                    if (n2 < n && (bl || throwable != null)) continue;
                    if (throwable == null) break;
                    throw throwable;
                }
            }
            bundle.putInt("currentiterations", n2);
            this.getInstrumentation().sendStatus(2, bundle);
            continue;
            break;
        }
    }

    public Instrumentation getInstrumentation() {
        return this.mInstrumentation;
    }

    @Deprecated
    public void injectInsrumentation(Instrumentation instrumentation) {
        this.injectInstrumentation(instrumentation);
    }

    public void injectInstrumentation(Instrumentation instrumentation) {
        this.mInstrumentation = instrumentation;
    }

    public final <T extends Activity> T launchActivity(String string2, Class<T> clazz, Bundle bundle) {
        Intent intent = new Intent("android.intent.action.MAIN");
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        return this.launchActivityWithIntent(string2, clazz, intent);
    }

    public final <T extends Activity> T launchActivityWithIntent(String string2, Class<T> clazz, Intent intent) {
        intent.setClassName(string2, clazz.getName());
        intent.addFlags(0x10000000);
        Activity activity = this.getInstrumentation().startActivitySync(intent);
        this.getInstrumentation().waitForIdleSync();
        return (T)activity;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void runTest() throws Throwable {
        Method method;
        String string2 = this.getName();
        InstrumentationTestCase.assertNotNull(string2);
        try {
            Method method2;
            method = method2 = this.getClass().getMethod(string2, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            InstrumentationTestCase.fail("Method \"" + string2 + "\" not found");
            method = null;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            InstrumentationTestCase.fail("Method \"" + string2 + "\" should be public");
        }
        int n = 1;
        boolean bl = false;
        if (method.isAnnotationPresent(FlakyTest.class)) {
            n = method.getAnnotation(FlakyTest.class).tolerance();
        } else {
            boolean bl2 = method.isAnnotationPresent(RepetitiveTest.class);
            bl = false;
            if (bl2) {
                n = method.getAnnotation(RepetitiveTest.class).numIterations();
                bl = true;
            }
        }
        if (method.isAnnotationPresent(UiThreadTest.class)) {
            final int n2 = n;
            final boolean bl3 = bl;
            final Method method3 = method;
            final Throwable[] throwableArray = new Throwable[1];
            this.getInstrumentation().runOnMainSync(new Runnable(){

                @Override
                public void run() {
                    try {
                        InstrumentationTestCase.this.runMethod(method3, n2, bl3);
                        return;
                    }
                    catch (Throwable throwable) {
                        throwableArray[0] = throwable;
                        return;
                    }
                }
            });
            if (throwableArray[0] == null) return;
            throw throwableArray[0];
        } else {
            this.runMethod(method, n, bl);
        }
    }

    public void runTestOnUiThread(final Runnable runnable) throws Throwable {
        final Throwable[] throwableArray = new Throwable[1];
        this.getInstrumentation().runOnMainSync(new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                    return;
                }
                catch (Throwable throwable) {
                    throwableArray[0] = throwable;
                    return;
                }
            }
        });
        if (throwableArray[0] != null) {
            throw throwableArray[0];
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendKeys(String var1_1) {
        var2_2 = var1_1.split(" ");
        var3_3 = var2_2.length;
        var4_4 = this.getInstrumentation();
        var5_5 = 0;
        block7: while (true) {
            block15: {
                if (var5_5 >= var3_3) {
                    var4_4.waitForIdleSync();
                    return;
                }
                var6_6 = var2_2[var5_5];
                var7_7 = var6_6.indexOf(42);
                if (var7_7 == -1) {
                    var11_10 = 1;
                } else {
                    try {
                        var11_10 = var10_9 = Integer.parseInt(var6_6.substring(0, var7_7));
                    }
                    catch (NumberFormatException var8_8) {
                        Log.w("ActivityTestCase", "Invalid repeat count: " + var6_6);
                        break block15;
                    }
                }
                if (var7_7 != -1) {
                    var6_6 = var6_6.substring(var7_7 + 1);
                }
                block8: for (var12_11 = 0; var12_11 < var11_10; ++var12_11) {
                    var17_14 = KeyEvent.class.getField("KEYCODE_" + var6_6).getInt(null);
                    try {
                        var4_4.sendKeyDownUpSync(var17_14);
lbl28:
                        // 2 sources

                        continue block8;
                    }
                    catch (SecurityException var18_15) {
                        ** continue;
                    }
                }
            }
lbl33:
            // 3 sources

            while (true) {
                ++var5_5;
                continue block7;
                break;
            }
            break;
        }
        catch (NoSuchFieldException var15_13) {
            Log.w("ActivityTestCase", "Unknown keycode: KEYCODE_" + var6_6);
            ** GOTO lbl33
        }
        catch (IllegalAccessException var13_12) {
            Log.w("ActivityTestCase", "Unknown keycode: KEYCODE_" + var6_6);
            ** continue;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendKeys(int ... nArray) {
        int n = nArray.length;
        Instrumentation instrumentation = this.getInstrumentation();
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                instrumentation.waitForIdleSync();
                return;
            }
            try {
                instrumentation.sendKeyDownUpSync(nArray[n2]);
            }
            catch (SecurityException securityException) {}
            ++n2;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendRepeatedKeys(int ... nArray) {
        int n = nArray.length;
        if ((n & 1) == 1) {
            throw new IllegalArgumentException("The size of the keys array must be a multiple of 2");
        }
        Instrumentation instrumentation = this.getInstrumentation();
        int n2 = 0;
        block2: while (true) {
            if (n2 >= n) {
                instrumentation.waitForIdleSync();
                return;
            }
            int n3 = nArray[n2];
            int n4 = nArray[n2 + 1];
            int n5 = 0;
            while (true) {
                if (n5 < n3) {
                    instrumentation.sendKeyDownUpSync(n4);
                } else {
                    n2 += 2;
                    continue block2;
                    catch (SecurityException securityException) {}
                }
                ++n5;
            }
            break;
        }
    }

    @Override
    protected void tearDown() throws Exception {
        Runtime.getRuntime().gc();
        Runtime.getRuntime().runFinalization();
        Runtime.getRuntime().gc();
        super.tearDown();
    }
}

