/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.app.ActivityThread;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.provider.Settings;
import android.telephony.CellInfo;
import android.telephony.CellLocation;
import android.telephony.IccOpenLogicalChannelResponse;
import android.telephony.NeighboringCellInfo;
import android.telephony.PhoneStateListener;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telecom.ITelecomService;
import com.android.internal.telephony.IPhoneSubInfo;
import com.android.internal.telephony.ITelephony;
import com.android.internal.telephony.ITelephonyRegistry;
import com.android.internal.telephony.PhoneConstants;
import com.asus.cta.CtaChecker;
import com.asus.cta.MobileDataChecker;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TelephonyManager {
    public static final String ACTION_PHONE_STATE_CHANGED = "android.intent.action.PHONE_STATE";
    public static final String ACTION_PRECISE_CALL_STATE_CHANGED = "android.intent.action.PRECISE_CALL_STATE";
    public static final String ACTION_PRECISE_DATA_CONNECTION_STATE_CHANGED = "android.intent.action.PRECISE_DATA_CONNECTION_STATE_CHANGED";
    public static final String ACTION_RESPOND_VIA_MESSAGE = "android.intent.action.RESPOND_VIA_MESSAGE";
    public static final int CALL_STATE_IDLE = 0;
    public static final int CALL_STATE_OFFHOOK = 2;
    public static final int CALL_STATE_RINGING = 1;
    public static final int CARRIER_PRIVILEGE_STATUS_ERROR_LOADING_RULES = -2;
    public static final int CARRIER_PRIVILEGE_STATUS_HAS_ACCESS = 1;
    public static final int CARRIER_PRIVILEGE_STATUS_NO_ACCESS = 0;
    public static final int CARRIER_PRIVILEGE_STATUS_RULES_NOT_LOADED = -1;
    public static final int DATA_ACTIVITY_DORMANT = 4;
    public static final int DATA_ACTIVITY_IN = 1;
    public static final int DATA_ACTIVITY_INOUT = 3;
    public static final int DATA_ACTIVITY_NONE = 0;
    public static final int DATA_ACTIVITY_OUT = 2;
    public static final int DATA_CONNECTED = 2;
    public static final int DATA_CONNECTING = 1;
    public static final int DATA_DISCONNECTED = 0;
    public static final int DATA_SUSPENDED = 3;
    public static final int DATA_UNKNOWN = -1;
    public static final String EXTRA_BACKGROUND_CALL_STATE = "background_state";
    public static final String EXTRA_DATA_APN = "apn";
    public static final String EXTRA_DATA_APN_TYPE = "apnType";
    public static final String EXTRA_DATA_CHANGE_REASON = "reason";
    public static final String EXTRA_DATA_FAILURE_CAUSE = "failCause";
    public static final String EXTRA_DATA_LINK_PROPERTIES_KEY = "linkProperties";
    public static final String EXTRA_DATA_NETWORK_TYPE = "networkType";
    public static final String EXTRA_DATA_STATE = "state";
    public static final String EXTRA_DISCONNECT_CAUSE = "disconnect_cause";
    public static final String EXTRA_FOREGROUND_CALL_STATE = "foreground_state";
    public static final String EXTRA_INCOMING_NUMBER = "incoming_number";
    public static final String EXTRA_PRECISE_DISCONNECT_CAUSE = "precise_disconnect_cause";
    public static final String EXTRA_RINGING_CALL_STATE = "ringing_state";
    public static final String EXTRA_STATE = "state";
    public static final String EXTRA_STATE_IDLE;
    public static final String EXTRA_STATE_OFFHOOK;
    public static final String EXTRA_STATE_RINGING;
    public static final int NETWORK_CLASS_2_G = 1;
    public static final int NETWORK_CLASS_3_G = 2;
    public static final int NETWORK_CLASS_4_G = 3;
    public static final int NETWORK_CLASS_UNKNOWN = 0;
    public static final int NETWORK_TYPE_1xRTT = 7;
    public static final int NETWORK_TYPE_CDMA = 4;
    public static final int NETWORK_TYPE_EDGE = 2;
    public static final int NETWORK_TYPE_EHRPD = 14;
    public static final int NETWORK_TYPE_EVDO_0 = 5;
    public static final int NETWORK_TYPE_EVDO_A = 6;
    public static final int NETWORK_TYPE_EVDO_B = 12;
    public static final int NETWORK_TYPE_GPRS = 1;
    public static final int NETWORK_TYPE_GSM = 16;
    public static final int NETWORK_TYPE_HSDPA = 8;
    public static final int NETWORK_TYPE_HSPA = 10;
    public static final int NETWORK_TYPE_HSPAP = 15;
    public static final int NETWORK_TYPE_HSUPA = 9;
    public static final int NETWORK_TYPE_IDEN = 11;
    public static final int NETWORK_TYPE_LTE = 13;
    public static final int NETWORK_TYPE_UMTS = 3;
    public static final int NETWORK_TYPE_UNKNOWN = 0;
    public static final int PHONE_TYPE_CDMA = 2;
    public static final int PHONE_TYPE_GSM = 1;
    public static final int PHONE_TYPE_NONE = 0;
    public static final int PHONE_TYPE_SIP = 3;
    public static final int SIM_STATE_ABSENT = 1;
    public static final int SIM_STATE_CARD_IO_ERROR = 6;
    public static final int SIM_STATE_NETWORK_LOCKED = 4;
    public static final int SIM_STATE_NOT_READY = 7;
    public static final int SIM_STATE_PIN_REQUIRED = 2;
    public static final int SIM_STATE_PUK_REQUIRED = 3;
    public static final int SIM_STATE_READY = 5;
    public static final int SIM_STATE_UNKNOWN = 0;
    private static final String TAG = "TelephonyManager";
    private static String multiSimConfig;
    private static final String sDefaultMmsUA = "Android-Mms/2.0";
    private static final String sDefaultMmsUAP = "http://www.google.com/oha/rdf/ua-profile-kila.xml";
    private static TelephonyManager sInstance;
    private static final String sKernelCmdLine;
    private static final String sLteOnCdmaProductType;
    private static final Pattern sProductTypePattern;
    private static ITelephonyRegistry sRegistry;
    private final Context mContext;

    static {
        multiSimConfig = SystemProperties.get("persist.radio.multisim.config");
        sInstance = new TelephonyManager();
        EXTRA_STATE_IDLE = PhoneConstants.State.IDLE.toString();
        EXTRA_STATE_RINGING = PhoneConstants.State.RINGING.toString();
        EXTRA_STATE_OFFHOOK = PhoneConstants.State.OFFHOOK.toString();
        sKernelCmdLine = TelephonyManager.getProcCmdLine();
        sProductTypePattern = Pattern.compile("\\sproduct_type\\s*=\\s*(\\w+)");
        sLteOnCdmaProductType = SystemProperties.get("telephony.lteOnCdmaProductType", "");
    }

    private TelephonyManager() {
        this.mContext = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public TelephonyManager(Context context) {
        Context context2 = context.getApplicationContext();
        this.mContext = context2 != null ? context2 : context;
        if (sRegistry == null) {
            sRegistry = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));
        }
    }

    public static TelephonyManager from(Context context) {
        return (TelephonyManager)context.getSystemService("phone");
    }

    public static TelephonyManager getDefault() {
        return sInstance;
    }

    private static long getDefaultSubscription() {
        return SubscriptionManager.getDefaultSubId();
    }

    private ITelephony getITelephony() {
        return ITelephony.Stub.asInterface(ServiceManager.getService("phone"));
    }

    public static int getIntAtIndex(ContentResolver contentResolver, String string2, int n) throws Settings.SettingNotFoundException {
        String string3 = Settings.Global.getString(contentResolver, string2);
        if (string3 != null) {
            String[] stringArray = string3.split(",");
            if (n >= 0 && n < stringArray.length && stringArray[n] != null) {
                try {
                    int n2 = Integer.parseInt(stringArray[n]);
                    return n2;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        throw new Settings.SettingNotFoundException(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getLteOnCdmaModeStatic() {
        String string2 = "";
        int n = SystemProperties.getInt("telephony.lteOnCdmaDevice", -1);
        int n2 = n;
        if (n2 == -1) {
            Matcher matcher = sProductTypePattern.matcher(sKernelCmdLine);
            n2 = matcher.find() ? (sLteOnCdmaProductType.equals(string2 = matcher.group(1)) ? 1 : 0) : 0;
        }
        Rlog.d(TAG, "getLteOnCdmaMode=" + n2 + " curVal=" + n + " product_type='" + string2 + "' lteOnCdmaProductType='" + sLteOnCdmaProductType + "'");
        return n2;
    }

    public static int getNetworkClass(int n) {
        switch (n) {
            default: {
                return 0;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 16: {
                return 1;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return 2;
            }
            case 13: 
        }
        return 3;
    }

    public static String getNetworkTypeName(int n) {
        switch (n) {
            default: {
                return "UNKNOWN";
            }
            case 1: {
                return "GPRS";
            }
            case 2: {
                return "EDGE";
            }
            case 3: {
                return "UMTS";
            }
            case 8: {
                return "HSDPA";
            }
            case 9: {
                return "HSUPA";
            }
            case 10: {
                return "HSPA";
            }
            case 4: {
                return "CDMA";
            }
            case 5: {
                return "CDMA - EvDo rev. 0";
            }
            case 6: {
                return "CDMA - EvDo rev. A";
            }
            case 12: {
                return "CDMA - EvDo rev. B";
            }
            case 7: {
                return "CDMA - 1xRTT";
            }
            case 13: {
                return "LTE";
            }
            case 14: {
                return "CDMA - eHRPD";
            }
            case 11: {
                return "iDEN";
            }
            case 15: {
                return "HSPA+";
            }
            case 16: 
        }
        return "GSM";
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getPhoneType(int n) {
        int n2 = 2;
        switch (n) {
            default: {
                n2 = 1;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return n2;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 12: {
                return 1;
            }
            case 11: {
                if (TelephonyManager.getLteOnCdmaModeStatic() == 1) return n2;
                return 1;
            }
        }
    }

    private int getPhoneTypeFromNetworkType() {
        return this.getPhoneTypeFromNetworkType(TelephonyManager.getDefaultSubscription());
    }

    private int getPhoneTypeFromNetworkType(long l) {
        String string2 = TelephonyManager.getTelephonyProperty("ro.telephony.default_network", l, null);
        if (string2 != null) {
            return TelephonyManager.getPhoneType(Integer.parseInt(string2));
        }
        return 0;
    }

    private int getPhoneTypeFromProperty() {
        return this.getPhoneTypeFromProperty(TelephonyManager.getDefaultSubscription());
    }

    private int getPhoneTypeFromProperty(long l) {
        String string2 = TelephonyManager.getTelephonyProperty("gsm.current.phone-type", l, null);
        if (string2 != null) {
            return Integer.parseInt(string2);
        }
        return this.getPhoneTypeFromNetworkType(l);
    }

    /*
     * Unable to fully structure code
     */
    private static String getProcCmdLine() {
        block20: {
            var0 = "";
            var1_1 = null;
            var2_2 = new FileInputStream("/proc/cmdline");
            var9_3 = new byte[2048];
            var10_4 = var2_2.read(var9_3);
            if (var10_4 <= 0) break block20;
            try {
                var0 = var11_5 = new String(var9_3, 0, var10_4);
            }
            catch (Throwable var4_13) {
                var1_1 = var2_2;
                ** continue;
            }
            catch (IOException var3_9) {
                var1_1 = var2_2;
                ** continue;
            }
        }
        if (var2_2 != null) {
            var2_2.close();
        }
lbl15:
        // 6 sources

        while (true) {
            Rlog.d("TelephonyManager", "/proc/cmdline=" + var0);
            return var0;
        }
        catch (IOException var12_6) {
            ** GOTO lbl15
        }
        catch (IOException var3_7) lbl-1000:
        // 2 sources

        {
            while (true) {
                try {
                    Rlog.d("TelephonyManager", "No /proc/cmdline exception=" + var3_8);
                    if (var1_1 == null) ** GOTO lbl15
                }
                catch (Throwable var4_11) lbl-1000:
                // 2 sources

                {
                    while (true) {
                        if (var1_1 != null) {
                            var1_1.close();
                        }
lbl32:
                        // 4 sources

                        throw var4_12;
                        catch (IOException var5_14) {
                            ** continue;
                        }
                        break;
                    }
                }
                try {
                    var1_1.close();
                }
                catch (IOException var7_10) {}
                ** continue;
                break;
            }
        }
    }

    private IPhoneSubInfo getSubscriberInfo() {
        return IPhoneSubInfo.Stub.asInterface(ServiceManager.getService("iphonesubinfo"));
    }

    private ITelecomService getTelecomService() {
        return ITelecomService.Stub.asInterface(ServiceManager.getService("telecom"));
    }

    public static String getTelephonyProperty(String string2, int n, String string3) {
        String string4 = SystemProperties.get(string2);
        String string5 = null;
        if (string4 != null) {
            int n2 = string4.length();
            string5 = null;
            if (n2 > 0) {
                String[] stringArray = string4.split(",");
                string5 = null;
                if (n >= 0) {
                    int n3 = stringArray.length;
                    string5 = null;
                    if (n < n3) {
                        String string6 = stringArray[n];
                        string5 = null;
                        if (string6 != null) {
                            string5 = stringArray[n];
                        }
                    }
                }
            }
        }
        if (string5 == null) {
            return string3;
        }
        return string5;
    }

    public static String getTelephonyProperty(String string2, long l, String string3) {
        int n = SubscriptionManager.getPhoneId(l);
        String string4 = SystemProperties.get(string2);
        String string5 = null;
        if (string4 != null) {
            int n2 = string4.length();
            string5 = null;
            if (n2 > 0) {
                String[] stringArray = string4.split(",");
                string5 = null;
                if (n >= 0) {
                    int n3 = stringArray.length;
                    string5 = null;
                    if (n < n3) {
                        String string6 = stringArray[n];
                        string5 = null;
                        if (string6 != null) {
                            string5 = stringArray[n];
                        }
                    }
                }
            }
        }
        if (string5 == null) {
            return string3;
        }
        return string5;
    }

    public static boolean putIntAtIndex(ContentResolver contentResolver, String string2, int n, int n2) {
        String string3 = "";
        String string4 = Settings.Global.getString(contentResolver, string2);
        String[] stringArray = null;
        if (string4 != null) {
            stringArray = string4.split(",");
        }
        for (int i = 0; i < n; ++i) {
            String string5 = "";
            if (stringArray != null && i < stringArray.length) {
                string5 = stringArray[i];
            }
            string3 = string3 + string5 + ",";
        }
        String string6 = string3 + n2;
        if (stringArray != null) {
            for (int i = n + 1; i < stringArray.length; ++i) {
                string6 = string6 + "," + stringArray[i];
            }
        }
        return Settings.Global.putString(contentResolver, string2, string6);
    }

    public static void setTelephonyProperty(String string2, long l, String string3) {
        String string4 = "";
        String string5 = SystemProperties.get(string2);
        int n = SubscriptionManager.getPhoneId(l);
        if (string3 == null) {
            string3 = "";
        }
        String[] stringArray = null;
        if (string5 != null) {
            stringArray = string5.split(",");
        }
        if (n < 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            String string6 = "";
            if (stringArray != null && i < stringArray.length) {
                string6 = stringArray[i];
            }
            string4 = string4 + string6 + ",";
        }
        String string7 = string4 + string3;
        if (stringArray != null) {
            for (int i = n + 1; i < stringArray.length; ++i) {
                string7 = string7 + "," + stringArray[i];
            }
        }
        if (string2.length() > 31 || string7.length() > 91) {
            Rlog.d(TAG, "setTelephonyProperty length too long:" + string2 + ", " + string7);
            return;
        }
        Rlog.d(TAG, "setTelephonyProperty property=" + string2 + " propVal=" + string7);
        SystemProperties.set(string2, string7);
    }

    public void answerRingingCall() {
        try {
            this.getITelephony().answerRingingCall();
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelephony#answerRingingCall", remoteException);
            return;
        }
    }

    public void call(String string2, String string3) {
        try {
            this.getITelephony().call(string2, string3);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelephony#call", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int checkCarrierPrivilegesForPackage(String string2) {
        try {
            return this.getITelephony().checkCarrierPrivilegesForPackage(string2);
        }
        catch (RemoteException remoteException) {
            Rlog.e(TAG, "hasCarrierPrivileges RemoteException", remoteException);
            return 0;
        }
        catch (NullPointerException nullPointerException) {
            Rlog.e(TAG, "hasCarrierPrivileges NPE", nullPointerException);
            return 0;
        }
    }

    public void dial(String string2) {
        try {
            this.getITelephony().dial(string2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelephony#dial", remoteException);
            return;
        }
    }

    public boolean disableDataConnectivity() {
        try {
            boolean bl = this.getITelephony().disableDataConnectivity();
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelephony#disableDataConnectivity", remoteException);
            return false;
        }
    }

    public void disableLocationUpdates() {
        this.disableLocationUpdates(TelephonyManager.getDefaultSubscription());
    }

    public void disableLocationUpdates(long l) {
        try {
            this.getITelephony().disableLocationUpdatesForSubscriber(l);
            return;
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public boolean enableDataConnectivity() {
        try {
            boolean bl = this.getITelephony().enableDataConnectivity();
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelephony#enableDataConnectivity", remoteException);
            return false;
        }
    }

    public void enableLocationUpdates() {
        this.enableLocationUpdates(TelephonyManager.getDefaultSubscription());
    }

    public void enableLocationUpdates(long l) {
        try {
            this.getITelephony().enableLocationUpdatesForSubscriber(l);
            return;
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void enableSimplifiedNetworkSettings(boolean bl) {
        this.enableSimplifiedNetworkSettingsForSubscriber(TelephonyManager.getDefaultSubscription(), bl);
    }

    public void enableSimplifiedNetworkSettingsForSubscriber(long l, boolean bl) {
        try {
            this.getITelephony().enableSimplifiedNetworkSettingsForSubscriber(l, bl);
            return;
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public boolean endCall() {
        try {
            boolean bl = this.getITelephony().endCall();
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelephony#endCall", remoteException);
            return false;
        }
    }

    public List<CellInfo> getAllCellInfo() {
        try {
            List<CellInfo> list = this.getITelephony().getAllCellInfo();
            return list;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getCallState() {
        try {
            return this.getTelecomService().getCallState();
        }
        catch (RemoteException remoteException) {
            return 0;
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    public int getCallState(long l) {
        try {
            int n = this.getITelephony().getCallStateForSubscriber(l);
            return n;
        }
        catch (RemoteException remoteException) {
            return 0;
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<String> getCarrierPackageNamesForIntent(Intent intent) {
        try {
            return this.getITelephony().getCarrierPackageNamesForIntent(intent);
        }
        catch (RemoteException remoteException) {
            Rlog.e(TAG, "getCarrierPackageNamesForIntent RemoteException", remoteException);
            return null;
        }
        catch (NullPointerException nullPointerException) {
            Rlog.e(TAG, "getCarrierPackageNamesForIntent NPE", nullPointerException);
            return null;
        }
    }

    public int getCdmaEriIconIndex() {
        return this.getCdmaEriIconIndex(TelephonyManager.getDefaultSubscription());
    }

    public int getCdmaEriIconIndex(long l) {
        try {
            int n = this.getITelephony().getCdmaEriIconIndexForSubscriber(l);
            return n;
        }
        catch (RemoteException remoteException) {
            return -1;
        }
        catch (NullPointerException nullPointerException) {
            return -1;
        }
    }

    public int getCdmaEriIconMode() {
        return this.getCdmaEriIconMode(TelephonyManager.getDefaultSubscription());
    }

    public int getCdmaEriIconMode(long l) {
        try {
            int n = this.getITelephony().getCdmaEriIconModeForSubscriber(l);
            return n;
        }
        catch (RemoteException remoteException) {
            return -1;
        }
        catch (NullPointerException nullPointerException) {
            return -1;
        }
    }

    public String getCdmaEriText() {
        return this.getCdmaEriText(TelephonyManager.getDefaultSubscription());
    }

    public String getCdmaEriText(long l) {
        try {
            String string2 = this.getITelephony().getCdmaEriTextForSubscriber(l);
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getCdmaMdn() {
        return this.getCdmaMdn(TelephonyManager.getDefaultSubscription());
    }

    public String getCdmaMdn(long l) {
        try {
            String string2 = this.getITelephony().getCdmaMdn(l);
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getCdmaMin() {
        return this.getCdmaMin(TelephonyManager.getDefaultSubscription());
    }

    public String getCdmaMin(long l) {
        try {
            String string2 = this.getITelephony().getCdmaMin(l);
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public CellLocation getCellLocation() {
        CellLocation cellLocation;
        Bundle bundle;
        block5: {
            bundle = this.getITelephony().getCellLocation();
            if (!bundle.isEmpty()) break block5;
            return null;
        }
        try {
            cellLocation = CellLocation.newFromBundle(bundle);
            boolean bl = cellLocation.isEmpty();
            if (bl) {
                return null;
            }
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            cellLocation = null;
        }
        return cellLocation;
    }

    public CellLocation getCellLocationForSlotID(int n) {
        CellLocation cellLocation;
        Bundle bundle;
        block5: {
            bundle = this.getITelephony().getCellLocationForSlotID(n);
            if (!bundle.isEmpty()) break block5;
            return null;
        }
        try {
            cellLocation = CellLocation.newFromBundle(bundle);
            boolean bl = cellLocation.isEmpty();
            if (bl) {
                return null;
            }
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            cellLocation = null;
        }
        return cellLocation;
    }

    public String getCompleteVoiceMailNumber() {
        return this.getCompleteVoiceMailNumber(TelephonyManager.getDefaultSubscription());
    }

    public String getCompleteVoiceMailNumber(long l) {
        try {
            String string2 = this.getSubscriberInfo().getCompleteVoiceMailNumberForSubscriber(l);
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public int getCurrentPhoneType() {
        return this.getCurrentPhoneType(TelephonyManager.getDefaultSubscription());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getCurrentPhoneType(long l) {
        ITelephony iTelephony = this.getITelephony();
        if (iTelephony == null) return this.getPhoneTypeFromProperty(l);
        try {
            return iTelephony.getActivePhoneTypeForSubscriber(l);
        }
        catch (RemoteException remoteException) {
            return this.getPhoneTypeFromProperty(l);
        }
        catch (NullPointerException nullPointerException) {
            return this.getPhoneTypeFromProperty(l);
        }
    }

    public int getDataActivity() {
        try {
            int n = this.getITelephony().getDataActivity();
            return n;
        }
        catch (RemoteException remoteException) {
            return 0;
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    public boolean getDataEnabled() {
        try {
            boolean bl = this.getITelephony().getDataEnabled();
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelephony#getDataEnabled", remoteException);
            return false;
        }
    }

    public int getDataNetworkType() {
        return this.getDataNetworkType(SubscriptionManager.getDefaultDataSubId());
    }

    public int getDataNetworkType(long l) {
        int n;
        block4: {
            ITelephony iTelephony = this.getITelephony();
            n = 0;
            if (iTelephony == null) break block4;
            try {
                int n2;
                n = n2 = iTelephony.getDataNetworkTypeForSubscriber(l);
            }
            catch (RemoteException remoteException) {
                return 0;
            }
            catch (NullPointerException nullPointerException) {
                return 0;
            }
        }
        return n;
    }

    public int getDataState() {
        try {
            int n = this.getITelephony().getDataState();
            return n;
        }
        catch (RemoteException remoteException) {
            return 0;
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    public int getDefaultSim() {
        return 0;
    }

    public String getDeviceId() {
        return this.getDeviceId(this.getDefaultSim());
    }

    public String getDeviceId(int n) {
        long[] lArray = SubscriptionManager.getSubId(n);
        try {
            String string2 = this.getSubscriberInfo().getDeviceIdForSubscriber(lArray[0]);
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getDeviceSoftwareVersion() {
        try {
            String string2 = this.getSubscriberInfo().getDeviceSvn();
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getGroupIdLevel1() {
        try {
            String string2 = this.getSubscriberInfo().getGroupIdLevel1();
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getGroupIdLevel1(long l) {
        try {
            String string2 = this.getSubscriberInfo().getGroupIdLevel1ForSubscriber(l);
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getIccSimChallengeResponse(int n, String string2) {
        return this.getIccSimChallengeResponse(TelephonyManager.getDefaultSubscription(), n, string2);
    }

    public String getIccSimChallengeResponse(long l, int n, String string2) {
        try {
            String string3 = this.getSubscriberInfo().getIccSimChallengeResponse(l, n, string2);
            return string3;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getImei() {
        return this.getImei(this.getDefaultSim());
    }

    public String getImei(int n) {
        long[] lArray = SubscriptionManager.getSubId(n);
        try {
            String string2 = this.getSubscriberInfo().getImeiForSubscriber(lArray[0]);
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getIsimChallengeResponse(String string2) {
        try {
            String string3 = this.getSubscriberInfo().getIsimChallengeResponse(string2);
            return string3;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getIsimDomain() {
        try {
            String string2 = this.getSubscriberInfo().getIsimDomain();
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getIsimImpi() {
        try {
            String string2 = this.getSubscriberInfo().getIsimImpi();
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String[] getIsimImpu() {
        try {
            String[] stringArray = this.getSubscriberInfo().getIsimImpu();
            return stringArray;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getIsimIst() {
        try {
            String string2 = this.getSubscriberInfo().getIsimIst();
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String[] getIsimPcscf() {
        try {
            String[] stringArray = this.getSubscriberInfo().getIsimPcscf();
            return stringArray;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getLine1AlphaTag() {
        return this.getLine1AlphaTagForSubscriber(TelephonyManager.getDefaultSubscription());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLine1AlphaTagForSubscriber(long l) {
        String string2;
        try {
            String string3;
            string2 = string3 = this.getITelephony().getLine1AlphaTagForDisplay(l);
        }
        catch (NullPointerException nullPointerException) {
            string2 = null;
        }
        catch (RemoteException remoteException) {
            string2 = null;
        }
        if (string2 != null) {
            return string2;
        }
        try {
            return this.getSubscriberInfo().getLine1AlphaTagForSubscriber(l);
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getLine1Number() {
        return this.getLine1NumberForSubscriber(TelephonyManager.getDefaultSubscription());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLine1NumberForSubscriber(long l) {
        String string2;
        try {
            String string3;
            string2 = string3 = this.getITelephony().getLine1NumberForDisplay(l);
        }
        catch (NullPointerException nullPointerException) {
            string2 = null;
        }
        catch (RemoteException remoteException) {
            string2 = null;
        }
        if (string2 != null) {
            return string2;
        }
        try {
            return this.getSubscriberInfo().getLine1NumberForSubscriber(l);
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public int getLteOnCdmaMode() {
        return this.getLteOnCdmaMode(TelephonyManager.getDefaultSubscription());
    }

    public int getLteOnCdmaMode(long l) {
        try {
            int n = this.getITelephony().getLteOnCdmaModeForSubscriber(l);
            return n;
        }
        catch (RemoteException remoteException) {
            return -1;
        }
        catch (NullPointerException nullPointerException) {
            return -1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getMmsUAProfUrl() {
        if (this.mContext == null) {
            return null;
        }
        String string2 = this.mContext.getResources().getString(17039414);
        if (!TextUtils.isEmpty(string2)) return string2;
        return sDefaultMmsUAP;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getMmsUserAgent() {
        if (this.mContext == null) {
            return null;
        }
        String string2 = this.mContext.getResources().getString(17039413);
        if (!TextUtils.isEmpty(string2)) return string2;
        return sDefaultMmsUA;
    }

    public String getMsisdn() {
        return this.getMsisdn(TelephonyManager.getDefaultSubscription());
    }

    public String getMsisdn(long l) {
        try {
            String string2 = this.getSubscriberInfo().getMsisdnForSubscriber(l);
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public MultiSimVariants getMultiSimConfiguration() {
        String string2 = SystemProperties.get("persist.radio.multisim.config");
        if (string2.equals("dsds")) {
            return MultiSimVariants.DSDS;
        }
        if (string2.equals("dsda")) {
            return MultiSimVariants.DSDA;
        }
        if (string2.equals("tsts")) {
            return MultiSimVariants.TSTS;
        }
        return MultiSimVariants.UNKNOWN;
    }

    public List<NeighboringCellInfo> getNeighboringCellInfo() {
        try {
            List<NeighboringCellInfo> list = this.getITelephony().getNeighboringCellInfo(this.mContext.getOpPackageName());
            return list;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getNetworkCountryIso() {
        return this.getNetworkCountryIso(TelephonyManager.getDefaultSubscription());
    }

    public String getNetworkCountryIso(long l) {
        return TelephonyManager.getTelephonyProperty("gsm.operator.iso-country", l, "");
    }

    public String getNetworkOperator() {
        return this.getNetworkOperator(TelephonyManager.getDefaultSubscription());
    }

    public String getNetworkOperator(long l) {
        return TelephonyManager.getTelephonyProperty("gsm.operator.numeric", l, "");
    }

    public String getNetworkOperatorName() {
        return this.getNetworkOperatorName(TelephonyManager.getDefaultSubscription());
    }

    public String getNetworkOperatorName(long l) {
        return TelephonyManager.getTelephonyProperty("gsm.operator.alpha", l, "");
    }

    public int getNetworkType() {
        return this.getDataNetworkType();
    }

    public int getNetworkType(long l) {
        int n;
        block4: {
            ITelephony iTelephony = this.getITelephony();
            n = 0;
            if (iTelephony == null) break block4;
            try {
                int n2;
                n = n2 = iTelephony.getNetworkTypeForSubscriber(l);
            }
            catch (RemoteException remoteException) {
                return 0;
            }
            catch (NullPointerException nullPointerException) {
                return 0;
            }
        }
        return n;
    }

    public String getNetworkTypeName() {
        return TelephonyManager.getNetworkTypeName(this.getNetworkType());
    }

    public String[] getPcscfAddress(String string2) {
        try {
            String[] stringArray = this.getITelephony().getPcscfAddress(string2);
            return stringArray;
        }
        catch (RemoteException remoteException) {
            return new String[0];
        }
    }

    public int getPhoneCount() {
        switch (3.$SwitchMap$android$telephony$TelephonyManager$MultiSimVariants[this.getMultiSimConfiguration().ordinal()]) {
            default: {
                return 1;
            }
            case 1: 
            case 2: {
                return 2;
            }
            case 3: 
        }
        return 3;
    }

    public int getPhoneType() {
        if (!this.isVoiceCapable()) {
            return 0;
        }
        return this.getCurrentPhoneType();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getPreferredNetworkType() {
        try {
            return this.getITelephony().getPreferredNetworkType();
        }
        catch (RemoteException remoteException) {
            Rlog.e(TAG, "getPreferredNetworkType RemoteException", remoteException);
            return -1;
        }
        catch (NullPointerException nullPointerException) {
            Rlog.e(TAG, "getPreferredNetworkType NPE", nullPointerException);
            return -1;
        }
    }

    public int getSimCount() {
        if (this.isMultiSimEnabled()) {
            return 2;
        }
        return 1;
    }

    public String getSimCountryIso() {
        return this.getSimCountryIso(TelephonyManager.getDefaultSubscription());
    }

    public String getSimCountryIso(long l) {
        return TelephonyManager.getTelephonyProperty("gsm.sim.operator.iso-country", l, "");
    }

    public String getSimOperator() {
        long l = TelephonyManager.getDefaultSubscription();
        Rlog.d(TAG, "getSimOperator(): default subId=" + l);
        return this.getSimOperator(l);
    }

    public String getSimOperator(long l) {
        String string2 = TelephonyManager.getTelephonyProperty("gsm.sim.operator.numeric", l, "");
        Rlog.d(TAG, "getSimOperator: subId=" + l + " operator=" + string2);
        return string2;
    }

    public String getSimOperatorName() {
        return this.getSimOperatorName(TelephonyManager.getDefaultSubscription());
    }

    public String getSimOperatorName(long l) {
        return TelephonyManager.getTelephonyProperty("gsm.sim.operator.alpha", l, "");
    }

    public String getSimSerialNumber() {
        return this.getSimSerialNumber(TelephonyManager.getDefaultSubscription());
    }

    public String getSimSerialNumber(long l) {
        try {
            String string2 = this.getSubscriberInfo().getIccSerialNumberForSubscriber(l);
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public int getSimState() {
        return this.getSimState(this.getDefaultSim());
    }

    public int getSimState(int n) {
        String string2 = TelephonyManager.getTelephonyProperty("gsm.sim.state", n, "");
        if ("ABSENT".equals(string2)) {
            return 1;
        }
        if ("PIN_REQUIRED".equals(string2)) {
            return 2;
        }
        if ("PUK_REQUIRED".equals(string2)) {
            return 3;
        }
        if ("NETWORK_LOCKED".equals(string2)) {
            return 4;
        }
        if ("READY".equals(string2)) {
            return 5;
        }
        if ("CARD_IO_ERROR".equals(string2)) {
            return 6;
        }
        if ("NOT_READY".equals(string2)) {
            return 7;
        }
        return 0;
    }

    public boolean getSimplifiedNetworkSettingsEnabled() {
        return this.getSimplifiedNetworkSettingsEnabledForSubscriber(TelephonyManager.getDefaultSubscription());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getSimplifiedNetworkSettingsEnabledForSubscriber(long l) {
        try {
            return this.getITelephony().getSimplifiedNetworkSettingsEnabledForSubscriber(l);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public String getSubscriberId() {
        return this.getSubscriberId(TelephonyManager.getDefaultSubscription());
    }

    public String getSubscriberId(long l) {
        try {
            String string2 = this.getSubscriberInfo().getSubscriberIdForSubscriber(l);
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getVoiceMailAlphaTag() {
        return this.getVoiceMailAlphaTag(TelephonyManager.getDefaultSubscription());
    }

    public String getVoiceMailAlphaTag(long l) {
        try {
            String string2 = this.getSubscriberInfo().getVoiceMailAlphaTagForSubscriber(l);
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getVoiceMailNumber() {
        return this.getVoiceMailNumber(TelephonyManager.getDefaultSubscription());
    }

    public String getVoiceMailNumber(long l) {
        try {
            String string2 = this.getSubscriberInfo().getVoiceMailNumberForSubscriber(l);
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public int getVoiceMessageCount() {
        return this.getVoiceMessageCount(TelephonyManager.getDefaultSubscription());
    }

    public int getVoiceMessageCount(long l) {
        try {
            int n = this.getITelephony().getVoiceMessageCountForSubscriber(l);
            return n;
        }
        catch (RemoteException remoteException) {
            return 0;
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    public int getVoiceNetworkType() {
        return this.getVoiceNetworkType(TelephonyManager.getDefaultSubscription());
    }

    public int getVoiceNetworkType(long l) {
        int n;
        block4: {
            ITelephony iTelephony = this.getITelephony();
            n = 0;
            if (iTelephony == null) break block4;
            try {
                int n2;
                n = n2 = iTelephony.getVoiceNetworkTypeForSubscriber(l);
            }
            catch (RemoteException remoteException) {
                return 0;
            }
            catch (NullPointerException nullPointerException) {
                return 0;
            }
        }
        return n;
    }

    public boolean handlePinMmi(String string2) {
        try {
            boolean bl = this.getITelephony().handlePinMmi(string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelephony#handlePinMmi", remoteException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int hasCarrierPrivileges() {
        try {
            return this.getITelephony().hasCarrierPrivileges();
        }
        catch (RemoteException remoteException) {
            Rlog.e(TAG, "hasCarrierPrivileges RemoteException", remoteException);
            return 0;
        }
        catch (NullPointerException nullPointerException) {
            Rlog.e(TAG, "hasCarrierPrivileges NPE", nullPointerException);
            return 0;
        }
    }

    public boolean hasIccCard() {
        return this.hasIccCard(this.getDefaultSim());
    }

    public boolean hasIccCard(int n) {
        try {
            boolean bl = this.getITelephony().hasIccCardUsingSlotId(n);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public boolean hasIccCard(long l) {
        int n;
        block4: {
            n = SubscriptionManager.getPhoneId(l);
            if (-1000 != n) break block4;
            return false;
        }
        try {
            boolean bl = this.getITelephony().hasIccCardUsingSlotId(n);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean iccCloseLogicalChannel(int n) {
        try {
            return this.getITelephony().iccCloseLogicalChannel(n);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] iccExchangeSimIO(int n, int n2, int n3, int n4, int n5, String string2) {
        try {
            return this.getITelephony().iccExchangeSimIO(n, n2, n3, n4, n5, string2);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IccOpenLogicalChannelResponse iccOpenLogicalChannel(String string2) {
        try {
            return this.getITelephony().iccOpenLogicalChannel(string2);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String iccTransmitApduBasicChannel(int n, int n2, int n3, int n4, int n5, String string2) {
        try {
            return this.getITelephony().iccTransmitApduBasicChannel(n, n2, n3, n4, n5, string2);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
        catch (RemoteException remoteException) {
            return "";
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String iccTransmitApduLogicalChannel(int n, int n2, int n3, int n4, int n5, int n6, String string2) {
        try {
            return this.getITelephony().iccTransmitApduLogicalChannel(n, n2, n3, n4, n5, n6, string2);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
        catch (RemoteException remoteException) {
            return "";
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int invokeOemRilRequestRaw(byte[] byArray, byte[] byArray2) {
        try {
            return this.getITelephony().invokeOemRilRequestRaw(byArray, byArray2);
        }
        catch (NullPointerException nullPointerException) {
            return -1;
        }
        catch (RemoteException remoteException) {
            return -1;
        }
    }

    public boolean isDataConnectivityPossible() {
        try {
            boolean bl = this.getITelephony().isDataConnectivityPossible();
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelephony#isDataConnectivityPossible", remoteException);
            return false;
        }
    }

    public boolean isIdle() {
        try {
            boolean bl = this.getITelephony().isIdle();
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelephony#isIdle", remoteException);
            return true;
        }
    }

    public boolean isMultiSimEnabled() {
        return multiSimConfig.equals("dsds") || multiSimConfig.equals("dsda") || multiSimConfig.equals("tsts");
    }

    public boolean isNetworkRoaming() {
        return this.isNetworkRoaming(TelephonyManager.getDefaultSubscription());
    }

    public boolean isNetworkRoaming(long l) {
        return "true".equals(TelephonyManager.getTelephonyProperty("gsm.operator.isroaming", l, null));
    }

    public boolean isOffhook() {
        try {
            boolean bl = this.getITelephony().isOffhook();
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelephony#isOffhook", remoteException);
            return false;
        }
    }

    public boolean isRadioOn() {
        try {
            boolean bl = this.getITelephony().isRadioOn();
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelephony#isRadioOn", remoteException);
            return false;
        }
    }

    public boolean isRinging() {
        try {
            boolean bl = this.getITelephony().isRinging();
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelephony#isRinging", remoteException);
            return false;
        }
    }

    public boolean isSimPinEnabled() {
        try {
            boolean bl = this.getITelephony().isSimPinEnabled();
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelephony#isSimPinEnabled", remoteException);
            return false;
        }
    }

    public boolean isSmsCapable() {
        if (this.mContext == null) {
            return true;
        }
        return this.mContext.getResources().getBoolean(17956932);
    }

    public boolean isVoiceCapable() {
        if (this.mContext == null) {
            return true;
        }
        return this.mContext.getResources().getBoolean(17956931);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void listen(PhoneStateListener phoneStateListener, int n) {
        String string2 = this.mContext != null ? this.mContext.getPackageName() : "<unknown>";
        try {
            boolean bl = this.getITelephony() != null;
            Boolean bl2 = bl;
            sRegistry.listenForSubscriber(phoneStateListener.mSubId, string2, phoneStateListener.callback, n, bl2);
            return;
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public boolean needsOtaServiceProvisioning() {
        try {
            boolean bl = this.getITelephony().needsOtaServiceProvisioning();
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelephony#needsOtaServiceProvisioning", remoteException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String nvReadItem(int n) {
        try {
            return this.getITelephony().nvReadItem(n);
        }
        catch (RemoteException remoteException) {
            Rlog.e(TAG, "nvReadItem RemoteException", remoteException);
            return "";
        }
        catch (NullPointerException nullPointerException) {
            Rlog.e(TAG, "nvReadItem NPE", nullPointerException);
            return "";
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean nvResetConfig(int n) {
        try {
            return this.getITelephony().nvResetConfig(n);
        }
        catch (RemoteException remoteException) {
            Rlog.e(TAG, "nvResetConfig RemoteException", remoteException);
            return false;
        }
        catch (NullPointerException nullPointerException) {
            Rlog.e(TAG, "nvResetConfig NPE", nullPointerException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean nvWriteCdmaPrl(byte[] byArray) {
        try {
            return this.getITelephony().nvWriteCdmaPrl(byArray);
        }
        catch (RemoteException remoteException) {
            Rlog.e(TAG, "nvWriteCdmaPrl RemoteException", remoteException);
            return false;
        }
        catch (NullPointerException nullPointerException) {
            Rlog.e(TAG, "nvWriteCdmaPrl NPE", nullPointerException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean nvWriteItem(int n, String string2) {
        try {
            return this.getITelephony().nvWriteItem(n, string2);
        }
        catch (RemoteException remoteException) {
            Rlog.e(TAG, "nvWriteItem RemoteException", remoteException);
            return false;
        }
        catch (NullPointerException nullPointerException) {
            Rlog.e(TAG, "nvWriteItem NPE", nullPointerException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String sendEnvelopeWithStatus(String string2) {
        try {
            return this.getITelephony().sendEnvelopeWithStatus(string2);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
        catch (RemoteException remoteException) {
            return "";
        }
    }

    public void setCellInfoListRate(int n) {
        try {
            this.getITelephony().setCellInfoListRate(n);
            return;
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDataEnabled(boolean bl) {
        void var3_3;
        if (Build.CTA && bl) {
            Runnable runnable = new Runnable(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    ITelephony iTelephony;
                    boolean bl = new CtaChecker(null).checkPermission(8, ActivityThread.currentPackageName());
                    try {
                        iTelephony = TelephonyManager.this.getITelephony();
                        iTelephony.setDataEnabled(true);
                        if (bl) return;
                    }
                    catch (RemoteException remoteException) {
                        Log.e(TelephonyManager.TAG, "Error calling ITelephony#setDataEnabled", remoteException);
                        return;
                    }
                    iTelephony.setDataEnabled(false);
                }
            };
        } else {
            boolean bl2 = SystemProperties.get("persist.sys.asus.MDE", "1").equals("1");
            Object var3_4 = null;
            if (bl2) {
                Object var3_5 = null;
                if (bl) {
                    final Context context = ActivityThread.currentActivityThread().getApplication().getApplicationContext();
                    context.setTheme(16974123);
                    Object var3_6 = null;
                    if (context != null) {
                        Runnable runnable = new Runnable(){

                            /*
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            @Override
                            public void run() {
                                MobileDataChecker mobileDataChecker = new MobileDataChecker(context);
                                boolean bl = mobileDataChecker.checkPermission(0, "all");
                                try {
                                    ITelephony iTelephony = TelephonyManager.this.getITelephony();
                                    if (!bl) {
                                        Settings.Global.putInt(context.getContentResolver(), "mobile_data", 1);
                                        Settings.Global.putInt(context.getContentResolver(), "mobile_data", 0);
                                        return;
                                    }
                                    iTelephony.setDataEnabled(true);
                                    return;
                                }
                                catch (RemoteException remoteException) {
                                    return;
                                }
                                finally {
                                    if (Settings.System.getInt(context.getContentResolver(), "MobileDataCheckerPass", 0) == 1) {
                                        mobileDataChecker.release();
                                    }
                                }
                            }
                        };
                    }
                }
            }
        }
        if (var3_3 != null) {
            new Thread((Runnable)var3_3).start();
            return;
        }
        try {
            this.getITelephony().setDataEnabled(bl);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelephony#setDataEnabled", remoteException);
            return;
        }
    }

    public boolean setGlobalPreferredNetworkType() {
        return this.setPreferredNetworkType(10);
    }

    public void setImsRegistrationState(boolean bl) {
        try {
            this.getITelephony().setImsRegistrationState(bl);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void setLine1NumberForDisplay(String string2, String string3) {
        this.setLine1NumberForDisplayForSubscriber(TelephonyManager.getDefaultSubscription(), string2, string3);
    }

    public void setLine1NumberForDisplayForSubscriber(long l, String string2, String string3) {
        try {
            this.getITelephony().setLine1NumberForDisplayForSubscriber(l, string2, string3);
            return;
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setOperatorBrandOverride(String string2) {
        try {
            return this.getITelephony().setOperatorBrandOverride(string2);
        }
        catch (RemoteException remoteException) {
            Rlog.e(TAG, "setOperatorBrandOverride RemoteException", remoteException);
            return false;
        }
        catch (NullPointerException nullPointerException) {
            Rlog.e(TAG, "setOperatorBrandOverride NPE", nullPointerException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setPreferredNetworkType(int n) {
        try {
            return this.getITelephony().setPreferredNetworkType(n);
        }
        catch (RemoteException remoteException) {
            Rlog.e(TAG, "setPreferredNetworkType RemoteException", remoteException);
            return false;
        }
        catch (NullPointerException nullPointerException) {
            Rlog.e(TAG, "setPreferredNetworkType NPE", nullPointerException);
            return false;
        }
    }

    public boolean setRadio(boolean bl) {
        try {
            boolean bl2 = this.getITelephony().setRadio(bl);
            return bl2;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelephony#setRadio", remoteException);
            return false;
        }
    }

    public boolean setRadioPower(boolean bl) {
        try {
            boolean bl2 = this.getITelephony().setRadioPower(bl);
            return bl2;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelephony#setRadioPower", remoteException);
            return false;
        }
    }

    public void silenceRinger() {
        try {
            this.getTelecomService().silenceRinger();
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelecomService#silenceRinger", remoteException);
            return;
        }
    }

    public boolean supplyPin(String string2) {
        try {
            boolean bl = this.getITelephony().supplyPin(string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelephony#supplyPin", remoteException);
            return false;
        }
    }

    public int[] supplyPinReportResult(String string2) {
        try {
            int[] nArray = this.getITelephony().supplyPinReportResult(string2);
            return nArray;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelephony#supplyPinReportResult", remoteException);
            return new int[0];
        }
    }

    public boolean supplyPuk(String string2, String string3) {
        try {
            boolean bl = this.getITelephony().supplyPuk(string2, string3);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelephony#supplyPuk", remoteException);
            return false;
        }
    }

    public int[] supplyPukReportResult(String string2, String string3) {
        try {
            int[] nArray = this.getITelephony().supplyPukReportResult(string2, string3);
            return nArray;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelephony#]", remoteException);
            return new int[0];
        }
    }

    public void toggleRadioOnOff() {
        try {
            this.getITelephony().toggleRadioOnOff();
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelephony#toggleRadioOnOff", remoteException);
            return;
        }
    }

    public void updateServiceLocation() {
        try {
            this.getITelephony().updateServiceLocation();
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelephony#updateServiceLocation", remoteException);
            return;
        }
    }

    public static final class MultiSimVariants
    extends Enum<MultiSimVariants> {
        private static final /* synthetic */ MultiSimVariants[] $VALUES;
        public static final /* enum */ MultiSimVariants DSDA;
        public static final /* enum */ MultiSimVariants DSDS;
        public static final /* enum */ MultiSimVariants TSTS;
        public static final /* enum */ MultiSimVariants UNKNOWN;

        static {
            DSDS = new MultiSimVariants();
            DSDA = new MultiSimVariants();
            TSTS = new MultiSimVariants();
            UNKNOWN = new MultiSimVariants();
            MultiSimVariants[] multiSimVariantsArray = new MultiSimVariants[]{DSDS, DSDA, TSTS, UNKNOWN};
            $VALUES = multiSimVariantsArray;
        }

        public static MultiSimVariants valueOf(String string2) {
            return Enum.valueOf(MultiSimVariants.class, string2);
        }

        public static MultiSimVariants[] values() {
            return (MultiSimVariants[])$VALUES.clone();
        }
    }

    public static interface WifiCallingChoices {
        public static final int ALWAYS_USE = 0;
        public static final int ASK_EVERY_TIME = 1;
        public static final int NEVER_USE = 2;
    }
}

