/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.os.Handler;
import android.os.Message;
import android.os.RemoteException;
import android.telecom.CameraCapabilities;
import android.telecom.VideoProfile;
import com.android.internal.os.SomeArgs;
import com.android.internal.telecom.IVideoCallback;

final class VideoCallbackServant {
    private static final int MSG_CHANGE_CALL_DATA_USAGE = 4;
    private static final int MSG_CHANGE_CAMERA_CAPABILITIES = 5;
    private static final int MSG_CHANGE_PEER_DIMENSIONS = 3;
    private static final int MSG_CHANGE_VIDEO_QUALITY = 6;
    private static final int MSG_HANDLE_CALL_SESSION_EVENT = 2;
    private static final int MSG_RECEIVE_SESSION_MODIFY_REQUEST = 0;
    private static final int MSG_RECEIVE_SESSION_MODIFY_RESPONSE = 1;
    private final IVideoCallback mDelegate;
    private final Handler mHandler = new Handler(){

        private void internalHandleMessage(Message message) throws RemoteException {
            switch (message.what) {
                default: {
                    return;
                }
                case 0: {
                    VideoCallbackServant.this.mDelegate.receiveSessionModifyRequest((VideoProfile)message.obj);
                    return;
                }
                case 1: {
                    SomeArgs someArgs = (SomeArgs)message.obj;
                    try {
                        VideoCallbackServant.this.mDelegate.receiveSessionModifyResponse(someArgs.argi1, (VideoProfile)someArgs.arg1, (VideoProfile)someArgs.arg2);
                        return;
                    }
                    finally {
                        someArgs.recycle();
                    }
                }
                case 2: {
                    SomeArgs someArgs = (SomeArgs)message.obj;
                    try {
                        VideoCallbackServant.this.mDelegate.handleCallSessionEvent(someArgs.argi1);
                        return;
                    }
                    finally {
                        someArgs.recycle();
                    }
                }
                case 3: {
                    SomeArgs someArgs = (SomeArgs)message.obj;
                    try {
                        VideoCallbackServant.this.mDelegate.changePeerDimensions(someArgs.argi1, someArgs.argi2);
                        return;
                    }
                    finally {
                        someArgs.recycle();
                    }
                }
                case 4: {
                    SomeArgs someArgs = (SomeArgs)message.obj;
                    try {
                        VideoCallbackServant.this.mDelegate.changeCallDataUsage((Long)someArgs.arg1);
                        return;
                    }
                    finally {
                        someArgs.recycle();
                    }
                }
                case 5: {
                    VideoCallbackServant.this.mDelegate.changeCameraCapabilities((CameraCapabilities)message.obj);
                    return;
                }
                case 6: 
            }
            VideoCallbackServant.this.mDelegate.changeVideoQuality(message.arg1);
        }

        @Override
        public void handleMessage(Message message) {
            try {
                this.internalHandleMessage(message);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }
    };
    private final IVideoCallback mStub = new IVideoCallback.Stub(){

        @Override
        public void changeCallDataUsage(long l) throws RemoteException {
            SomeArgs someArgs = SomeArgs.obtain();
            someArgs.arg1 = l;
            VideoCallbackServant.this.mHandler.obtainMessage(4, someArgs).sendToTarget();
        }

        @Override
        public void changeCameraCapabilities(CameraCapabilities cameraCapabilities) throws RemoteException {
            VideoCallbackServant.this.mHandler.obtainMessage(5, cameraCapabilities).sendToTarget();
        }

        @Override
        public void changePeerDimensions(int n, int n2) throws RemoteException {
            SomeArgs someArgs = SomeArgs.obtain();
            someArgs.argi1 = n;
            someArgs.argi2 = n2;
            VideoCallbackServant.this.mHandler.obtainMessage(3, someArgs).sendToTarget();
        }

        @Override
        public void changeVideoQuality(int n) throws RemoteException {
            VideoCallbackServant.this.mHandler.obtainMessage(6, n, 0).sendToTarget();
        }

        @Override
        public void handleCallSessionEvent(int n) throws RemoteException {
            SomeArgs someArgs = SomeArgs.obtain();
            someArgs.argi1 = n;
            VideoCallbackServant.this.mHandler.obtainMessage(2, someArgs).sendToTarget();
        }

        @Override
        public void receiveSessionModifyRequest(VideoProfile videoProfile) throws RemoteException {
            VideoCallbackServant.this.mHandler.obtainMessage(0, videoProfile).sendToTarget();
        }

        @Override
        public void receiveSessionModifyResponse(int n, VideoProfile videoProfile, VideoProfile videoProfile2) throws RemoteException {
            SomeArgs someArgs = SomeArgs.obtain();
            someArgs.argi1 = n;
            someArgs.arg1 = videoProfile;
            someArgs.arg2 = videoProfile2;
            VideoCallbackServant.this.mHandler.obtainMessage(1, someArgs).sendToTarget();
        }
    };

    public VideoCallbackServant(IVideoCallback iVideoCallback) {
        this.mDelegate = iVideoCallback;
    }

    public IVideoCallback getStub() {
        return this.mStub;
    }
}

