/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.telecom.Log;
import android.telecom.PhoneAccountHandle;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;

public class PhoneAccount
implements Parcelable {
    public static final int ACTIVE = 2;
    public static final int CAPABILITY_CALL_PROVIDER = 2;
    public static final int CAPABILITY_CONNECTION_MANAGER = 1;
    public static final int CAPABILITY_PLACE_EMERGENCY_CALLS = 16;
    public static final int CAPABILITY_SIM_SUBSCRIPTION = 4;
    public static final int CAPABILITY_VIDEO_CALLING = 8;
    public static final Parcelable.Creator<PhoneAccount> CREATOR = new Parcelable.Creator<PhoneAccount>(){

        @Override
        public PhoneAccount createFromParcel(Parcel parcel) {
            return new PhoneAccount(parcel);
        }

        public PhoneAccount[] newArray(int n) {
            return new PhoneAccount[n];
        }
    };
    public static final int LCH = 1;
    public static final int LCHMUTE = 3;
    public static final String SCHEME_SIP = "sip";
    public static final String SCHEME_SMSTO = "smsto";
    public static final String SCHEME_TEL = "tel";
    public static final String SCHEME_VOICEMAIL = "voicemail";
    private BitSet dsda = new BitSet();
    private final PhoneAccountHandle mAccountHandle;
    private final Uri mAddress;
    private final int mCapabilities;
    private final int mIconResId;
    private final CharSequence mLabel;
    private final CharSequence mShortDescription;
    private final Uri mSubscriptionAddress;
    private final List<String> mSupportedUriSchemes;

    private PhoneAccount(Parcel parcel) {
        ClassLoader classLoader = PhoneAccount.class.getClassLoader();
        this.mAccountHandle = (PhoneAccountHandle)parcel.readParcelable(this.getClass().getClassLoader());
        this.mAddress = (Uri)parcel.readParcelable(this.getClass().getClassLoader());
        this.mSubscriptionAddress = (Uri)parcel.readParcelable(this.getClass().getClassLoader());
        this.mCapabilities = parcel.readInt();
        this.mIconResId = parcel.readInt();
        this.mLabel = parcel.readCharSequence();
        this.mShortDescription = parcel.readCharSequence();
        ArrayList arrayList = new ArrayList();
        parcel.readList(arrayList, classLoader);
        this.mSupportedUriSchemes = Collections.unmodifiableList(arrayList);
    }

    private PhoneAccount(PhoneAccountHandle phoneAccountHandle, Uri uri, Uri uri2, int n, int n2, CharSequence charSequence, CharSequence charSequence2, List<String> list) {
        this.mAccountHandle = phoneAccountHandle;
        this.mAddress = uri;
        this.mSubscriptionAddress = uri2;
        this.mCapabilities = n;
        this.mIconResId = n2;
        this.mLabel = charSequence;
        this.mShortDescription = charSequence2;
        this.mSupportedUriSchemes = Collections.unmodifiableList(list);
    }

    public static Builder builder(PhoneAccountHandle phoneAccountHandle, CharSequence charSequence) {
        return new Builder(phoneAccountHandle, charSequence);
    }

    /*
     * Unable to fully structure code
     */
    private Drawable getIcon(Context var1_1, int var2_2) {
        try {
            var5_3 = var1_1.createPackageContext(this.mAccountHandle.getComponentName().getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException var3_5) {
            var4_6 = new Object[]{this.mAccountHandle.getComponentName().getPackageName()};
            Log.w(this, "Cannot find package %s", var4_6);
            return null;
        }
        try {
            var8_4 = var5_3.getDrawable(var2_2);
            return var8_4;
        }
        catch (Resources.NotFoundException var6_7) lbl-1000:
        // 2 sources

        {
            while (true) {
                var7_10 = new Object[]{var2_2, this.mAccountHandle.getComponentName().getPackageName()};
                Log.e(this, (Throwable)var6_8, "Cannot find icon %d in package %s", var7_10);
                return null;
            }
        }
        catch (MissingResourceException var6_9) {
            ** continue;
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public PhoneAccountHandle getAccountHandle() {
        return this.mAccountHandle;
    }

    public Uri getAddress() {
        return this.mAddress;
    }

    public int getCapabilities() {
        return this.mCapabilities;
    }

    public Drawable getIcon(Context context) {
        return this.getIcon(context, this.mIconResId);
    }

    public int getIconResId() {
        return this.mIconResId;
    }

    public CharSequence getLabel() {
        return this.mLabel;
    }

    public CharSequence getShortDescription() {
        return this.mShortDescription;
    }

    public Uri getSubscriptionAddress() {
        return this.mSubscriptionAddress;
    }

    public List<String> getSupportedUriSchemes() {
        return this.mSupportedUriSchemes;
    }

    public boolean hasCapabilities(int n) {
        return (n & this.mCapabilities) == n;
    }

    public boolean isSet(int n) {
        return this.dsda.get(n);
    }

    public void setBit(int n) {
        this.dsda.set(n);
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public boolean supportsUriScheme(String string2) {
        String string3;
        if (this.mSupportedUriSchemes == null) return false;
        if (string2 == null) {
            return false;
        }
        Iterator<String> iterator = this.mSupportedUriSchemes.iterator();
        do {
            if (!iterator.hasNext()) return false;
        } while ((string3 = iterator.next()) == null || !string3.equals(string2));
        return true;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public void unSetBit(int n) {
        this.dsda.set(n, false);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeParcelable(this.mAccountHandle, 0);
        parcel.writeParcelable(this.mAddress, 0);
        parcel.writeParcelable(this.mSubscriptionAddress, 0);
        parcel.writeInt(this.mCapabilities);
        parcel.writeInt(this.mIconResId);
        parcel.writeCharSequence(this.mLabel);
        parcel.writeCharSequence(this.mShortDescription);
        parcel.writeList(this.mSupportedUriSchemes);
    }

    public static class Builder {
        private PhoneAccountHandle mAccountHandle;
        private Uri mAddress;
        private int mCapabilities;
        private int mIconResId;
        private CharSequence mLabel;
        private CharSequence mShortDescription;
        private Uri mSubscriptionAddress;
        private List<String> mSupportedUriSchemes = new ArrayList<String>();

        public Builder(PhoneAccount phoneAccount) {
            this.mAccountHandle = phoneAccount.getAccountHandle();
            this.mAddress = phoneAccount.getAddress();
            this.mSubscriptionAddress = phoneAccount.getSubscriptionAddress();
            this.mCapabilities = phoneAccount.getCapabilities();
            this.mIconResId = phoneAccount.getIconResId();
            this.mLabel = phoneAccount.getLabel();
            this.mShortDescription = phoneAccount.getShortDescription();
            this.mSupportedUriSchemes.addAll(phoneAccount.getSupportedUriSchemes());
        }

        public Builder(PhoneAccountHandle phoneAccountHandle, CharSequence charSequence) {
            this.mAccountHandle = phoneAccountHandle;
            this.mLabel = charSequence;
        }

        public Builder addSupportedUriScheme(String string2) {
            if (!TextUtils.isEmpty(string2) && !this.mSupportedUriSchemes.contains(string2)) {
                this.mSupportedUriSchemes.add(string2);
            }
            return this;
        }

        public PhoneAccount build() {
            if (this.mSupportedUriSchemes.isEmpty()) {
                this.addSupportedUriScheme(PhoneAccount.SCHEME_TEL);
            }
            return new PhoneAccount(this.mAccountHandle, this.mAddress, this.mSubscriptionAddress, this.mCapabilities, this.mIconResId, this.mLabel, this.mShortDescription, this.mSupportedUriSchemes);
        }

        public Builder setAddress(Uri uri) {
            this.mAddress = uri;
            return this;
        }

        public Builder setCapabilities(int n) {
            this.mCapabilities = n;
            return this;
        }

        public Builder setIconResId(int n) {
            this.mIconResId = n;
            return this;
        }

        public Builder setShortDescription(CharSequence charSequence) {
            this.mShortDescription = charSequence;
            return this;
        }

        public Builder setSubscriptionAddress(Uri uri) {
            this.mSubscriptionAddress = uri;
            return this;
        }

        public Builder setSupportedUriSchemes(List<String> list) {
            this.mSupportedUriSchemes.clear();
            if (list != null && !list.isEmpty()) {
                Iterator<String> iterator = list.iterator();
                while (iterator.hasNext()) {
                    this.addSupportedUriScheme(iterator.next());
                }
            }
            return this;
        }
    }
}

