/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.speech.tts.AbstractEventLogger;
import android.speech.tts.BlockingAudioTrack;
import android.speech.tts.PlaybackQueueItem;
import android.speech.tts.TextToSpeechService;
import java.util.LinkedList;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class SynthesisPlaybackQueueItem
extends PlaybackQueueItem {
    private static final boolean DBG = false;
    private static final long MAX_UNCONSUMED_AUDIO_MS = 500L;
    private static final String TAG = "TTS.SynthQueueItem";
    private final BlockingAudioTrack mAudioTrack;
    private final LinkedList<ListEntry> mDataBufferList;
    private volatile boolean mDone = false;
    private final Lock mListLock = new ReentrantLock();
    private final AbstractEventLogger mLogger;
    private final Condition mNotFull;
    private final Condition mReadReady = this.mListLock.newCondition();
    private volatile int mStatusCode = 0;
    private volatile boolean mStopped = false;
    private int mUnconsumedBytes = 0;

    SynthesisPlaybackQueueItem(TextToSpeechService.AudioOutputParams audioOutputParams, int n, int n2, int n3, TextToSpeechService.UtteranceProgressDispatcher utteranceProgressDispatcher, Object object, AbstractEventLogger abstractEventLogger) {
        super(utteranceProgressDispatcher, object);
        this.mNotFull = this.mListLock.newCondition();
        this.mDataBufferList = new LinkedList();
        this.mAudioTrack = new BlockingAudioTrack(audioOutputParams, n, n2, n3);
        this.mLogger = abstractEventLogger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] take() throws InterruptedException {
        ListEntry listEntry;
        block7: {
            try {
                this.mListLock.lock();
                while (this.mDataBufferList.size() == 0 && !this.mStopped && !this.mDone) {
                    this.mReadReady.await();
                }
                boolean bl = this.mStopped;
                if (bl) {
                    this.mListLock.unlock();
                    return null;
                }
                listEntry = this.mDataBufferList.poll();
                if (listEntry != null) break block7;
                this.mListLock.unlock();
                return null;
            }
            catch (Throwable throwable) {
                this.mListLock.unlock();
                throw throwable;
            }
        }
        this.mUnconsumedBytes -= listEntry.mBytes.length;
        this.mNotFull.signal();
        byte[] byArray = listEntry.mBytes;
        this.mListLock.unlock();
        return byArray;
    }

    void done() {
        try {
            this.mListLock.lock();
            this.mDone = true;
            this.mReadReady.signal();
            this.mNotFull.signal();
            return;
        }
        finally {
            this.mListLock.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void put(byte[] byArray) throws InterruptedException {
        try {
            this.mListLock.lock();
            while (this.mAudioTrack.getAudioLengthMs(this.mUnconsumedBytes) > 500L && !this.mStopped) {
                this.mNotFull.await();
            }
            boolean bl = this.mStopped;
            if (bl) {
                this.mListLock.unlock();
                return;
            }
            this.mDataBufferList.add(new ListEntry(byArray));
            this.mUnconsumedBytes += byArray.length;
            this.mReadReady.signal();
            this.mListLock.unlock();
            return;
        }
        catch (Throwable throwable) {
            this.mListLock.unlock();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        TextToSpeechService.UtteranceProgressDispatcher utteranceProgressDispatcher = this.getDispatcher();
        utteranceProgressDispatcher.dispatchOnStart();
        if (!this.mAudioTrack.init()) {
            utteranceProgressDispatcher.dispatchOnError(-5);
            return;
        }
        try {
            byte[] byArray;
            while ((byArray = this.take()) != null) {
                this.mAudioTrack.write(byArray);
                this.mLogger.onAudioDataWritten();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.mAudioTrack.waitAndRelease();
        if (this.mStatusCode == 0) {
            utteranceProgressDispatcher.dispatchOnSuccess();
        } else if (this.mStatusCode == -2) {
            utteranceProgressDispatcher.dispatchOnStop();
        } else {
            utteranceProgressDispatcher.dispatchOnError(this.mStatusCode);
        }
        this.mLogger.onCompleted(this.mStatusCode);
    }

    @Override
    void stop(int n) {
        try {
            this.mListLock.lock();
            this.mStopped = true;
            this.mStatusCode = n;
            this.mReadReady.signal();
            this.mNotFull.signal();
            this.mAudioTrack.stop();
            return;
        }
        finally {
            this.mListLock.unlock();
        }
    }

    static final class ListEntry {
        final byte[] mBytes;

        ListEntry(byte[] byArray) {
            this.mBytes = byArray;
        }
    }
}

