/*
 * Decompiled with CFR 0.152.
 */
package android.speech;

import android.app.Service;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.speech.IRecognitionListener;
import android.speech.IRecognitionService;
import android.util.Log;
import java.lang.ref.WeakReference;

public abstract class RecognitionService
extends Service {
    private static final boolean DBG = false;
    private static final int MSG_CANCEL = 3;
    private static final int MSG_RESET = 4;
    private static final int MSG_START_LISTENING = 1;
    private static final int MSG_STOP_LISTENING = 2;
    public static final String SERVICE_INTERFACE = "android.speech.RecognitionService";
    public static final String SERVICE_META_DATA = "android.speech";
    private static final String TAG = "RecognitionService";
    private RecognitionServiceBinder mBinder = new RecognitionServiceBinder(this);
    private Callback mCurrentCallback = null;
    private final Handler mHandler = new Handler(){

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    return;
                }
                case 1: {
                    StartListeningArgs startListeningArgs = (StartListeningArgs)message.obj;
                    RecognitionService.this.dispatchStartListening(startListeningArgs.mIntent, startListeningArgs.mListener);
                    return;
                }
                case 2: {
                    RecognitionService.this.dispatchStopListening((IRecognitionListener)message.obj);
                    return;
                }
                case 3: {
                    RecognitionService.this.dispatchCancel((IRecognitionListener)message.obj);
                    return;
                }
                case 4: 
            }
            RecognitionService.this.dispatchClearCallback();
        }
    };

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkPermissions(IRecognitionListener iRecognitionListener) {
        if (this.checkCallingOrSelfPermission("android.permission.RECORD_AUDIO") == 0) {
            return true;
        }
        try {
            Log.e(TAG, "call for recognition service without RECORD_AUDIO permissions");
            iRecognitionListener.onError(9);
            return false;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "sending ERROR_INSUFFICIENT_PERMISSIONS message failed", remoteException);
            return false;
        }
    }

    private void dispatchCancel(IRecognitionListener iRecognitionListener) {
        if (this.mCurrentCallback == null) {
            return;
        }
        if (this.mCurrentCallback.mListener.asBinder() != iRecognitionListener.asBinder()) {
            Log.w(TAG, "cancel called by client who did not call startListening - ignoring");
            return;
        }
        this.onCancel(this.mCurrentCallback);
        this.mCurrentCallback = null;
    }

    private void dispatchClearCallback() {
        this.mCurrentCallback = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dispatchStartListening(Intent intent, final IRecognitionListener iRecognitionListener) {
        if (this.mCurrentCallback == null) {
            try {
                iRecognitionListener.asBinder().linkToDeath(new IBinder.DeathRecipient(){

                    @Override
                    public void binderDied() {
                        RecognitionService.this.mHandler.sendMessage(RecognitionService.this.mHandler.obtainMessage(3, iRecognitionListener));
                    }
                }, 0);
                this.mCurrentCallback = new Callback(iRecognitionListener);
                this.onStartListening(intent, this.mCurrentCallback);
                return;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "dead listener on startListening");
                return;
            }
        }
        try {
            iRecognitionListener.onError(8);
        }
        catch (RemoteException remoteException) {
            Log.d(TAG, "onError call from startListening failed");
        }
        Log.i(TAG, "concurrent startListening received - ignoring this call");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dispatchStopListening(IRecognitionListener iRecognitionListener) {
        try {
            if (this.mCurrentCallback == null) {
                iRecognitionListener.onError(5);
                Log.w(TAG, "stopListening called with no preceding startListening - ignoring");
                return;
            }
            if (this.mCurrentCallback.mListener.asBinder() != iRecognitionListener.asBinder()) {
                iRecognitionListener.onError(8);
                Log.w(TAG, "stopListening called by other caller than startListening - ignoring");
                return;
            }
        }
        catch (RemoteException remoteException) {
            Log.d(TAG, "onError call from stopListening failed");
            return;
        }
        {
            this.onStopListening(this.mCurrentCallback);
            return;
        }
    }

    @Override
    public final IBinder onBind(Intent intent) {
        return this.mBinder;
    }

    protected abstract void onCancel(Callback var1);

    @Override
    public void onDestroy() {
        this.mCurrentCallback = null;
        this.mBinder.clearReference();
        super.onDestroy();
    }

    protected abstract void onStartListening(Intent var1, Callback var2);

    protected abstract void onStopListening(Callback var1);

    public class Callback {
        private final IRecognitionListener mListener;

        private Callback(IRecognitionListener iRecognitionListener) {
            this.mListener = iRecognitionListener;
        }

        public void beginningOfSpeech() throws RemoteException {
            this.mListener.onBeginningOfSpeech();
        }

        public void bufferReceived(byte[] byArray) throws RemoteException {
            this.mListener.onBufferReceived(byArray);
        }

        public void endOfSpeech() throws RemoteException {
            this.mListener.onEndOfSpeech();
        }

        public void error(int n) throws RemoteException {
            Message.obtain(RecognitionService.this.mHandler, 4).sendToTarget();
            this.mListener.onError(n);
        }

        public void partialResults(Bundle bundle) throws RemoteException {
            this.mListener.onPartialResults(bundle);
        }

        public void readyForSpeech(Bundle bundle) throws RemoteException {
            this.mListener.onReadyForSpeech(bundle);
        }

        public void results(Bundle bundle) throws RemoteException {
            Message.obtain(RecognitionService.this.mHandler, 4).sendToTarget();
            this.mListener.onResults(bundle);
        }

        public void rmsChanged(float f) throws RemoteException {
            this.mListener.onRmsChanged(f);
        }
    }

    private static final class RecognitionServiceBinder
    extends IRecognitionService.Stub {
        private final WeakReference<RecognitionService> mServiceRef;

        public RecognitionServiceBinder(RecognitionService recognitionService) {
            this.mServiceRef = new WeakReference<RecognitionService>(recognitionService);
        }

        @Override
        public void cancel(IRecognitionListener iRecognitionListener) {
            RecognitionService recognitionService = (RecognitionService)this.mServiceRef.get();
            if (recognitionService != null && recognitionService.checkPermissions(iRecognitionListener)) {
                recognitionService.mHandler.sendMessage(Message.obtain(recognitionService.mHandler, 3, iRecognitionListener));
            }
        }

        public void clearReference() {
            this.mServiceRef.clear();
        }

        @Override
        public void startListening(Intent intent, IRecognitionListener iRecognitionListener) {
            RecognitionService recognitionService = (RecognitionService)this.mServiceRef.get();
            if (recognitionService != null && recognitionService.checkPermissions(iRecognitionListener)) {
                Handler handler = recognitionService.mHandler;
                Handler handler2 = recognitionService.mHandler;
                recognitionService.getClass();
                handler.sendMessage(Message.obtain(handler2, 1, recognitionService.new StartListeningArgs(intent, iRecognitionListener)));
            }
        }

        @Override
        public void stopListening(IRecognitionListener iRecognitionListener) {
            RecognitionService recognitionService = (RecognitionService)this.mServiceRef.get();
            if (recognitionService != null && recognitionService.checkPermissions(iRecognitionListener)) {
                recognitionService.mHandler.sendMessage(Message.obtain(recognitionService.mHandler, 2, iRecognitionListener));
            }
        }
    }

    private class StartListeningArgs {
        public final Intent mIntent;
        public final IRecognitionListener mListener;

        public StartListeningArgs(Intent intent, IRecognitionListener iRecognitionListener) {
            this.mIntent = intent;
            this.mListener = iRecognitionListener;
        }
    }
}

