/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.content.ComponentName;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.service.notification.Condition;
import android.text.TextUtils;
import android.util.Slog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class ZenModeConfig
implements Parcelable {
    private static final String ALLOW_ATT_ALARMS = "alarms";
    private static final String ALLOW_ATT_CALLS = "calls";
    private static final String ALLOW_ATT_EVENTS = "events";
    private static final String ALLOW_ATT_FROM = "from";
    private static final String ALLOW_ATT_MESSAGES = "messages";
    private static final String ALLOW_TAG = "allow";
    public static final int[] ALL_DAYS;
    private static final String CONDITION_ATT_COMPONENT = "component";
    private static final String CONDITION_ATT_FLAGS = "flags";
    private static final String CONDITION_ATT_ICON = "icon";
    private static final String CONDITION_ATT_ID = "id";
    private static final String CONDITION_ATT_LINE1 = "line1";
    private static final String CONDITION_ATT_LINE2 = "line2";
    private static final String CONDITION_ATT_STATE = "state";
    private static final String CONDITION_ATT_SUMMARY = "summary";
    private static final String CONDITION_TAG = "condition";
    private static final String COUNTDOWN_PATH = "countdown";
    public static final Parcelable.Creator<ZenModeConfig> CREATOR;
    private static final boolean DEFAULT_ALLOW_ALARMS = true;
    private static final boolean DEFAULT_ALLOW_EVENTS = true;
    private static final String DOWNTIME_PATH = "downtime";
    private static final String EXIT_CONDITION_ATT_COMPONENT = "component";
    private static final String EXIT_CONDITION_TAG = "exitCondition";
    public static final int MAX_SOURCE = 2;
    private static final int MINUTES_MS = 60000;
    public static final int[] MINUTE_BUCKETS;
    private static final int SECONDS_MS = 1000;
    private static final String SLEEP_ATT_END_HR = "endHour";
    private static final String SLEEP_ATT_END_MIN = "endMin";
    private static final String SLEEP_ATT_MODE = "mode";
    private static final String SLEEP_ATT_START_HR = "startHour";
    private static final String SLEEP_ATT_START_MIN = "startMin";
    public static final String SLEEP_MODE_DAYS_PREFIX = "days:";
    public static final String SLEEP_MODE_NIGHTS = "nights";
    public static final String SLEEP_MODE_WEEKNIGHTS = "weeknights";
    private static final String SLEEP_TAG = "sleep";
    public static final int SOURCE_ANYONE = 0;
    public static final int SOURCE_CONTACT = 1;
    public static final int SOURCE_STAR = 2;
    private static final String SYSTEM_AUTHORITY = "android";
    private static String TAG;
    public static final int[] WEEKNIGHT_DAYS;
    private static final int XML_VERSION = 1;
    private static final String ZEN_ATT_VERSION = "version";
    private static final String ZEN_TAG = "zen";
    private static final int ZERO_VALUE_MS = 20000;
    public boolean allowAlarms;
    public boolean allowCalls;
    public boolean allowEvents;
    public int allowFrom;
    public boolean allowMessages;
    public ComponentName[] conditionComponents;
    public Uri[] conditionIds;
    public Condition exitCondition;
    public ComponentName exitConditionComponent;
    public int sleepEndHour;
    public int sleepEndMinute;
    public String sleepMode;
    public int sleepStartHour;
    public int sleepStartMinute;

    static {
        TAG = "ZenModeConfig";
        ALL_DAYS = new int[]{1, 2, 3, 4, 5, 6, 7};
        WEEKNIGHT_DAYS = new int[]{1, 2, 3, 4, 5};
        MINUTE_BUCKETS = new int[]{15, 30, 45, 60, 120, 180, 240, 480};
        CREATOR = new Parcelable.Creator<ZenModeConfig>(){

            @Override
            public ZenModeConfig createFromParcel(Parcel parcel) {
                return new ZenModeConfig(parcel);
            }

            public ZenModeConfig[] newArray(int n) {
                return new ZenModeConfig[n];
            }
        };
    }

    public ZenModeConfig() {
        this.allowEvents = true;
        this.allowFrom = 0;
        this.allowAlarms = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ZenModeConfig(Parcel parcel) {
        int n;
        int n2 = 1;
        this.allowEvents = n2;
        this.allowFrom = 0;
        this.allowAlarms = n2;
        int n3 = parcel.readInt() == n2 ? n2 : 0;
        this.allowCalls = n3;
        int n4 = parcel.readInt() == n2 ? n2 : 0;
        this.allowMessages = n4;
        int n5 = parcel.readInt() == n2 ? n2 : 0;
        this.allowEvents = n5;
        if (parcel.readInt() == n2) {
            this.sleepMode = parcel.readString();
        }
        this.sleepStartHour = parcel.readInt();
        this.sleepStartMinute = parcel.readInt();
        this.sleepEndHour = parcel.readInt();
        this.sleepEndMinute = parcel.readInt();
        int n6 = parcel.readInt();
        if (n6 > 0) {
            this.conditionComponents = new ComponentName[n6];
            parcel.readTypedArray(this.conditionComponents, ComponentName.CREATOR);
        }
        if ((n = parcel.readInt()) > 0) {
            this.conditionIds = new Uri[n];
            parcel.readTypedArray(this.conditionIds, Uri.CREATOR);
        }
        this.allowFrom = parcel.readInt();
        this.exitCondition = (Condition)parcel.readParcelable(null);
        this.exitConditionComponent = (ComponentName)parcel.readParcelable(null);
        if (parcel.readInt() != n2) {
            n2 = 0;
        }
        this.allowAlarms = n2;
    }

    public static boolean isValidCountdownConditionId(Uri uri) {
        return ZenModeConfig.tryParseCountdownConditionId(uri) != 0L;
    }

    public static boolean isValidDowntimeConditionId(Uri uri) {
        return ZenModeConfig.tryParseDowntimeConditionId(uri) != null;
    }

    public static boolean isValidHour(int n) {
        return n >= 0 && n < 24;
    }

    public static boolean isValidMinute(int n) {
        return n >= 0 && n < 60;
    }

    public static boolean isValidSleepMode(String string2) {
        return string2 == null || string2.equals(SLEEP_MODE_NIGHTS) || string2.equals(SLEEP_MODE_WEEKNIGHTS) || ZenModeConfig.tryParseDays(string2) != null;
    }

    public static Condition readConditionXml(XmlPullParser xmlPullParser) {
        Uri uri = ZenModeConfig.safeUri(xmlPullParser, CONDITION_ATT_ID);
        String string2 = xmlPullParser.getAttributeValue(null, CONDITION_ATT_SUMMARY);
        String string3 = xmlPullParser.getAttributeValue(null, CONDITION_ATT_LINE1);
        String string4 = xmlPullParser.getAttributeValue(null, CONDITION_ATT_LINE2);
        int n = ZenModeConfig.safeInt(xmlPullParser, CONDITION_ATT_ICON, -1);
        int n2 = ZenModeConfig.safeInt(xmlPullParser, CONDITION_ATT_STATE, -1);
        int n3 = ZenModeConfig.safeInt(xmlPullParser, CONDITION_ATT_FLAGS, -1);
        try {
            Condition condition = new Condition(uri, string2, string3, string4, n, n2, n3);
            return condition;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Slog.w(TAG, "Unable to read condition xml", illegalArgumentException);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ZenModeConfig readXml(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        if (xmlPullParser.getEventType() != 2) {
            return null;
        }
        if (!ZEN_TAG.equals(xmlPullParser.getName())) {
            return null;
        }
        ZenModeConfig zenModeConfig = new ZenModeConfig();
        ZenModeConfig.safeInt(xmlPullParser, ZEN_ATT_VERSION, 1);
        ArrayList<ComponentName> arrayList = new ArrayList<ComponentName>();
        ArrayList<Uri> arrayList2 = new ArrayList<Uri>();
        while (true) {
            int n;
            if ((n = xmlPullParser.next()) == 1) {
                throw new IllegalStateException("Failed to reach END_DOCUMENT");
            }
            String string2 = xmlPullParser.getName();
            if (n == 3 && ZEN_TAG.equals(string2)) {
                if (arrayList.isEmpty()) return zenModeConfig;
                zenModeConfig.conditionComponents = arrayList.toArray(new ComponentName[arrayList.size()]);
                zenModeConfig.conditionIds = arrayList2.toArray(new Uri[arrayList2.size()]);
                return zenModeConfig;
            }
            if (n != 2) continue;
            if (ALLOW_TAG.equals(string2)) {
                zenModeConfig.allowCalls = ZenModeConfig.safeBoolean(xmlPullParser, ALLOW_ATT_CALLS, false);
                zenModeConfig.allowMessages = ZenModeConfig.safeBoolean(xmlPullParser, ALLOW_ATT_MESSAGES, false);
                zenModeConfig.allowEvents = ZenModeConfig.safeBoolean(xmlPullParser, ALLOW_ATT_EVENTS, true);
                zenModeConfig.allowFrom = ZenModeConfig.safeInt(xmlPullParser, ALLOW_ATT_FROM, 0);
                if (zenModeConfig.allowFrom < 0) throw new IndexOutOfBoundsException("bad source in config:" + zenModeConfig.allowFrom);
                if (zenModeConfig.allowFrom > 2) {
                    throw new IndexOutOfBoundsException("bad source in config:" + zenModeConfig.allowFrom);
                }
                zenModeConfig.allowAlarms = ZenModeConfig.safeBoolean(xmlPullParser, ALLOW_ATT_ALARMS, true);
                continue;
            }
            if (SLEEP_TAG.equals(string2)) {
                String string3 = xmlPullParser.getAttributeValue(null, SLEEP_ATT_MODE);
                if (!ZenModeConfig.isValidSleepMode(string3)) {
                    string3 = null;
                }
                zenModeConfig.sleepMode = string3;
                int n2 = ZenModeConfig.safeInt(xmlPullParser, SLEEP_ATT_START_HR, 0);
                int n3 = ZenModeConfig.safeInt(xmlPullParser, SLEEP_ATT_START_MIN, 0);
                int n4 = ZenModeConfig.safeInt(xmlPullParser, SLEEP_ATT_END_HR, 0);
                int n5 = ZenModeConfig.safeInt(xmlPullParser, SLEEP_ATT_END_MIN, 0);
                if (!ZenModeConfig.isValidHour(n2)) {
                    n2 = 0;
                }
                zenModeConfig.sleepStartHour = n2;
                if (!ZenModeConfig.isValidMinute(n3)) {
                    n3 = 0;
                }
                zenModeConfig.sleepStartMinute = n3;
                if (!ZenModeConfig.isValidHour(n4)) {
                    n4 = 0;
                }
                zenModeConfig.sleepEndHour = n4;
                if (!ZenModeConfig.isValidMinute(n5)) {
                    n5 = 0;
                }
                zenModeConfig.sleepEndMinute = n5;
                continue;
            }
            if (CONDITION_TAG.equals(string2)) {
                ComponentName componentName = ZenModeConfig.safeComponentName(xmlPullParser, "component");
                Uri uri = ZenModeConfig.safeUri(xmlPullParser, CONDITION_ATT_ID);
                if (componentName == null || uri == null) continue;
                arrayList.add(componentName);
                arrayList2.add(uri);
                continue;
            }
            if (!EXIT_CONDITION_TAG.equals(string2)) continue;
            zenModeConfig.exitCondition = ZenModeConfig.readConditionXml(xmlPullParser);
            if (zenModeConfig.exitCondition == null) continue;
            zenModeConfig.exitConditionComponent = ZenModeConfig.safeComponentName(xmlPullParser, "component");
        }
    }

    private static boolean safeBoolean(XmlPullParser xmlPullParser, String string2, boolean bl) {
        String string3 = xmlPullParser.getAttributeValue(null, string2);
        if (TextUtils.isEmpty(string3)) {
            return bl;
        }
        return Boolean.valueOf(string3);
    }

    private static ComponentName safeComponentName(XmlPullParser xmlPullParser, String string2) {
        String string3 = xmlPullParser.getAttributeValue(null, string2);
        if (TextUtils.isEmpty(string3)) {
            return null;
        }
        return ComponentName.unflattenFromString(string3);
    }

    private static int safeInt(XmlPullParser xmlPullParser, String string2, int n) {
        return ZenModeConfig.tryParseInt(xmlPullParser.getAttributeValue(null, string2), n);
    }

    private static Uri safeUri(XmlPullParser xmlPullParser, String string2) {
        String string3 = xmlPullParser.getAttributeValue(null, string2);
        if (TextUtils.isEmpty(string3)) {
            return null;
        }
        return Uri.parse(string3);
    }

    public static String sourceToString(int n) {
        switch (n) {
            default: {
                return "UNKNOWN";
            }
            case 0: {
                return "anyone";
            }
            case 1: {
                return "contacts";
            }
            case 2: 
        }
        return "stars";
    }

    public static Uri toCountdownConditionId(long l) {
        return new Uri.Builder().scheme(CONDITION_TAG).authority(SYSTEM_AUTHORITY).appendPath(COUNTDOWN_PATH).appendPath(Long.toString(l)).build();
    }

    public static Uri toDowntimeConditionId(DowntimeInfo downtimeInfo) {
        return new Uri.Builder().scheme(CONDITION_TAG).authority(SYSTEM_AUTHORITY).appendPath(DOWNTIME_PATH).appendQueryParameter("start", downtimeInfo.startHour + "." + downtimeInfo.startMinute).appendQueryParameter("end", downtimeInfo.endHour + "." + downtimeInfo.endMinute).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Condition toTimeCondition(int n) {
        long l;
        long l2 = System.currentTimeMillis();
        if (n == 0) {
            l = 20000L;
            return ZenModeConfig.toTimeCondition(l2 + l, n);
        }
        l = 60000 * n;
        return ZenModeConfig.toTimeCondition(l2 + l, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Condition toTimeCondition(long l, int n) {
        int n2 = n < 60 ? n : Math.round((float)n / 60.0f);
        int n3 = n < 60 ? 18087961 : 18087962;
        Resources resources = Resources.getSystem();
        Object[] objectArray = new Object[]{n2};
        String string2 = resources.getQuantityString(n3, n2, objectArray);
        return new Condition(ZenModeConfig.toCountdownConditionId(l), string2, "", "", 0, 1, 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long tryParseCountdownConditionId(Uri uri) {
        if (!Condition.isValidId(uri, SYSTEM_AUTHORITY)) {
            return 0L;
        }
        if (uri.getPathSegments().size() != 2) return 0L;
        if (!COUNTDOWN_PATH.equals(uri.getPathSegments().get(0))) return 0L;
        try {
            return Long.parseLong(uri.getPathSegments().get(1));
        }
        catch (RuntimeException runtimeException) {
            Slog.w(TAG, "Error parsing countdown condition: " + uri, runtimeException);
            return 0L;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int[] tryParseDays(String string2) {
        if (string2 == null) {
            return null;
        }
        String string3 = string2.trim();
        if (SLEEP_MODE_NIGHTS.equals(string3)) {
            return ALL_DAYS;
        }
        if (SLEEP_MODE_WEEKNIGHTS.equals(string3)) {
            return WEEKNIGHT_DAYS;
        }
        if (!string3.startsWith(SLEEP_MODE_DAYS_PREFIX)) {
            return null;
        }
        if (string3.equals(SLEEP_MODE_DAYS_PREFIX)) {
            return null;
        }
        String[] stringArray = string3.substring(SLEEP_MODE_DAYS_PREFIX.length()).split(",");
        if (stringArray.length == 0) {
            return null;
        }
        int[] nArray = new int[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            int n2 = ZenModeConfig.tryParseInt(stringArray[n], -1);
            if (n2 == -1) {
                return null;
            }
            nArray[n] = n2;
            ++n;
        }
        return nArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static DowntimeInfo tryParseDowntimeConditionId(Uri uri) {
        int[] nArray;
        int[] nArray2;
        block3: {
            block2: {
                if (!Condition.isValidId(uri, SYSTEM_AUTHORITY) || uri.getPathSegments().size() != 1 || !DOWNTIME_PATH.equals(uri.getPathSegments().get(0))) break block2;
                nArray2 = ZenModeConfig.tryParseHourAndMinute(uri.getQueryParameter("start"));
                nArray = ZenModeConfig.tryParseHourAndMinute(uri.getQueryParameter("end"));
                if (nArray2 != null && nArray != null) break block3;
            }
            return null;
        }
        DowntimeInfo downtimeInfo = new DowntimeInfo();
        downtimeInfo.startHour = nArray2[0];
        downtimeInfo.startMinute = nArray2[1];
        downtimeInfo.endHour = nArray[0];
        downtimeInfo.endMinute = nArray[1];
        return downtimeInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int[] tryParseHourAndMinute(String string2) {
        int n;
        int n2;
        block3: {
            block2: {
                int n3;
                if (TextUtils.isEmpty(string2) || (n3 = string2.indexOf(46)) < 1 || n3 >= -1 + string2.length()) break block2;
                n2 = ZenModeConfig.tryParseInt(string2.substring(0, n3), -1);
                n = ZenModeConfig.tryParseInt(string2.substring(n3 + 1), -1);
                if (ZenModeConfig.isValidHour(n2) && ZenModeConfig.isValidMinute(n)) break block3;
            }
            return null;
        }
        return new int[]{n2, n};
    }

    private static int tryParseInt(String string2, int n) {
        if (TextUtils.isEmpty(string2)) {
            return n;
        }
        try {
            int n2 = Integer.valueOf(string2);
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static void writeConditionXml(Condition condition, XmlSerializer xmlSerializer) throws IOException {
        xmlSerializer.attribute(null, CONDITION_ATT_ID, condition.id.toString());
        xmlSerializer.attribute(null, CONDITION_ATT_SUMMARY, condition.summary);
        xmlSerializer.attribute(null, CONDITION_ATT_LINE1, condition.line1);
        xmlSerializer.attribute(null, CONDITION_ATT_LINE2, condition.line2);
        xmlSerializer.attribute(null, CONDITION_ATT_ICON, Integer.toString(condition.icon));
        xmlSerializer.attribute(null, CONDITION_ATT_STATE, Integer.toString(condition.state));
        xmlSerializer.attribute(null, CONDITION_ATT_FLAGS, Integer.toString(condition.flags));
    }

    public ZenModeConfig copy() {
        Parcel parcel = Parcel.obtain();
        try {
            this.writeToParcel(parcel, 0);
            parcel.setDataPosition(0);
            ZenModeConfig zenModeConfig = new ZenModeConfig(parcel);
            return zenModeConfig;
        }
        finally {
            parcel.recycle();
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl = true;
        if (!(object instanceof ZenModeConfig)) {
            return false;
        }
        if (object == this) return bl;
        ZenModeConfig zenModeConfig = (ZenModeConfig)object;
        if (zenModeConfig.allowCalls != this.allowCalls) return false;
        if (zenModeConfig.allowMessages != this.allowMessages) return false;
        if (zenModeConfig.allowFrom != this.allowFrom) return false;
        if (zenModeConfig.allowEvents != this.allowEvents) return false;
        if (zenModeConfig.allowAlarms != this.allowAlarms) return false;
        if (!Objects.equals(zenModeConfig.sleepMode, this.sleepMode)) return false;
        if (zenModeConfig.sleepStartHour != this.sleepStartHour) return false;
        if (zenModeConfig.sleepStartMinute != this.sleepStartMinute) return false;
        if (zenModeConfig.sleepEndHour != this.sleepEndHour) return false;
        if (zenModeConfig.sleepEndMinute != this.sleepEndMinute) return false;
        if (!Objects.deepEquals(zenModeConfig.conditionComponents, this.conditionComponents)) return false;
        if (!Objects.deepEquals(zenModeConfig.conditionIds, this.conditionIds)) return false;
        if (!Objects.equals(zenModeConfig.exitCondition, this.exitCondition)) return false;
        if (Objects.equals(zenModeConfig.exitConditionComponent, this.exitConditionComponent)) return bl;
        return false;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.allowCalls, this.allowMessages, this.allowFrom, this.allowEvents, this.sleepMode, this.sleepStartHour, this.sleepStartMinute, this.sleepEndHour, this.sleepEndMinute, Arrays.hashCode(this.conditionComponents), Arrays.hashCode(this.conditionIds), this.exitCondition, this.exitConditionComponent};
        return Objects.hash(objectArray);
    }

    public boolean isValid() {
        return ZenModeConfig.isValidHour(this.sleepStartHour) && ZenModeConfig.isValidMinute(this.sleepStartMinute) && ZenModeConfig.isValidHour(this.sleepEndHour) && ZenModeConfig.isValidMinute(this.sleepEndMinute) && ZenModeConfig.isValidSleepMode(this.sleepMode);
    }

    public DowntimeInfo toDowntimeInfo() {
        DowntimeInfo downtimeInfo = new DowntimeInfo();
        downtimeInfo.startHour = this.sleepStartHour;
        downtimeInfo.startMinute = this.sleepStartMinute;
        downtimeInfo.endHour = this.sleepEndHour;
        downtimeInfo.endMinute = this.sleepEndMinute;
        return downtimeInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(ZenModeConfig.class.getSimpleName()).append('[').append("allowCalls=").append(this.allowCalls).append(",allowMessages=").append(this.allowMessages).append(",allowFrom=").append(ZenModeConfig.sourceToString(this.allowFrom)).append(",allowEvents=").append(this.allowEvents).append(",allowAlarms=").append(this.allowAlarms).append(",sleepMode=").append(this.sleepMode).append(",sleepStart=").append(this.sleepStartHour).append('.').append(this.sleepStartMinute).append(",sleepEnd=").append(this.sleepEndHour).append('.').append(this.sleepEndMinute).append(",conditionComponents=");
        String string2 = this.conditionComponents == null ? null : TextUtils.join((CharSequence)",", this.conditionComponents);
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append(",conditionIds=");
        Uri[] uriArray = this.conditionIds;
        String string3 = null;
        if (uriArray == null) {
            return stringBuilder2.append(string3).append(",exitCondition=").append(this.exitCondition).append(",exitConditionComponent=").append(this.exitConditionComponent).append(']').toString();
        }
        string3 = TextUtils.join((CharSequence)",", this.conditionIds);
        return stringBuilder2.append(string3).append(",exitCondition=").append(this.exitCondition).append(",exitConditionComponent=").append(this.exitConditionComponent).append(']').toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = 1;
        int n3 = this.allowCalls ? n2 : 0;
        parcel.writeInt(n3);
        int n4 = this.allowMessages ? n2 : 0;
        parcel.writeInt(n4);
        int n5 = this.allowEvents ? n2 : 0;
        parcel.writeInt(n5);
        if (this.sleepMode != null) {
            parcel.writeInt(n2);
            parcel.writeString(this.sleepMode);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.sleepStartHour);
        parcel.writeInt(this.sleepStartMinute);
        parcel.writeInt(this.sleepEndHour);
        parcel.writeInt(this.sleepEndMinute);
        if (this.conditionComponents != null && this.conditionComponents.length > 0) {
            parcel.writeInt(this.conditionComponents.length);
            parcel.writeTypedArray(this.conditionComponents, 0);
        } else {
            parcel.writeInt(0);
        }
        if (this.conditionIds != null && this.conditionIds.length > 0) {
            parcel.writeInt(this.conditionIds.length);
            parcel.writeTypedArray(this.conditionIds, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.allowFrom);
        parcel.writeParcelable(this.exitCondition, 0);
        parcel.writeParcelable(this.exitConditionComponent, 0);
        if (!this.allowAlarms) {
            n2 = 0;
        }
        parcel.writeInt(n2);
    }

    public void writeXml(XmlSerializer xmlSerializer) throws IOException {
        xmlSerializer.startTag(null, ZEN_TAG);
        xmlSerializer.attribute(null, ZEN_ATT_VERSION, Integer.toString(1));
        xmlSerializer.startTag(null, ALLOW_TAG);
        xmlSerializer.attribute(null, ALLOW_ATT_CALLS, Boolean.toString(this.allowCalls));
        xmlSerializer.attribute(null, ALLOW_ATT_MESSAGES, Boolean.toString(this.allowMessages));
        xmlSerializer.attribute(null, ALLOW_ATT_EVENTS, Boolean.toString(this.allowEvents));
        xmlSerializer.attribute(null, ALLOW_ATT_FROM, Integer.toString(this.allowFrom));
        xmlSerializer.attribute(null, ALLOW_ATT_ALARMS, Boolean.toString(this.allowAlarms));
        xmlSerializer.endTag(null, ALLOW_TAG);
        xmlSerializer.startTag(null, SLEEP_TAG);
        if (this.sleepMode != null) {
            xmlSerializer.attribute(null, SLEEP_ATT_MODE, this.sleepMode);
        }
        xmlSerializer.attribute(null, SLEEP_ATT_START_HR, Integer.toString(this.sleepStartHour));
        xmlSerializer.attribute(null, SLEEP_ATT_START_MIN, Integer.toString(this.sleepStartMinute));
        xmlSerializer.attribute(null, SLEEP_ATT_END_HR, Integer.toString(this.sleepEndHour));
        xmlSerializer.attribute(null, SLEEP_ATT_END_MIN, Integer.toString(this.sleepEndMinute));
        xmlSerializer.endTag(null, SLEEP_TAG);
        if (this.conditionComponents != null && this.conditionIds != null && this.conditionComponents.length == this.conditionIds.length) {
            for (int i = 0; i < this.conditionComponents.length; ++i) {
                xmlSerializer.startTag(null, CONDITION_TAG);
                xmlSerializer.attribute(null, "component", this.conditionComponents[i].flattenToString());
                xmlSerializer.attribute(null, CONDITION_ATT_ID, this.conditionIds[i].toString());
                xmlSerializer.endTag(null, CONDITION_TAG);
            }
        }
        if (this.exitCondition != null && this.exitConditionComponent != null) {
            xmlSerializer.startTag(null, EXIT_CONDITION_TAG);
            xmlSerializer.attribute(null, "component", this.exitConditionComponent.flattenToString());
            ZenModeConfig.writeConditionXml(this.exitCondition, xmlSerializer);
            xmlSerializer.endTag(null, EXIT_CONDITION_TAG);
        }
        xmlSerializer.endTag(null, ZEN_TAG);
    }

    public static class DowntimeInfo {
        public int endHour;
        public int endMinute;
        public int startHour;
        public int startMinute;

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (!(object instanceof DowntimeInfo)) break block2;
                    DowntimeInfo downtimeInfo = (DowntimeInfo)object;
                    if (this.startHour == downtimeInfo.startHour && this.startMinute == downtimeInfo.startMinute && this.endHour == downtimeInfo.endHour && this.endMinute == downtimeInfo.endMinute) break block3;
                }
                return false;
            }
            return true;
        }

        public int hashCode() {
            return 0;
        }
    }
}

