/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.security.KeyChain;
import android.security.KeyStore;
import android.util.Log;
import com.android.org.bouncycastle.util.io.pem.PemObject;
import com.android.org.bouncycastle.util.io.pem.PemObjectGenerator;
import com.android.org.bouncycastle.util.io.pem.PemReader;
import com.android.org.bouncycastle.util.io.pem.PemWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

public class Credentials {
    public static final String CA_CERTIFICATE = "CACERT_";
    public static final String EXTENSION_CER = ".cer";
    public static final String EXTENSION_CRT = ".crt";
    public static final String EXTENSION_P12 = ".p12";
    public static final String EXTENSION_PFX = ".pfx";
    public static final String EXTRA_CA_CERTIFICATES_DATA = "ca_certificates_data";
    public static final String EXTRA_CA_CERTIFICATES_NAME = "ca_certificates_name";
    public static final String EXTRA_INSTALL_AS_UID = "install_as_uid";
    public static final String EXTRA_PRIVATE_KEY = "PKEY";
    public static final String EXTRA_PUBLIC_KEY = "KEY";
    public static final String EXTRA_USER_CERTIFICATE_DATA = "user_certificate_data";
    public static final String EXTRA_USER_CERTIFICATE_NAME = "user_certificate_name";
    public static final String EXTRA_USER_PRIVATE_KEY_DATA = "user_private_key_data";
    public static final String EXTRA_USER_PRIVATE_KEY_NAME = "user_private_key_name";
    public static final String EXTRA_WAPI_AS_CERTIFICATES_DATA = "wapi_ca_certificates_data";
    public static final String EXTRA_WAPI_AS_CERTIFICATES_NAME = "wapi_ca_certificates_name";
    public static final String EXTRA_WAPI_USER_CERTIFICATES_DATA = "wapi_user_certificate_data";
    public static final String EXTRA_WAPI_USER_CERTIFICATES_NAME = "wapi_user_certificate_name";
    public static final String INSTALL_ACTION = "android.credentials.INSTALL";
    public static final String INSTALL_AS_USER_ACTION = "android.credentials.INSTALL_AS_USER";
    public static final String LOCKDOWN_VPN = "LOCKDOWN_VPN";
    private static final String LOGTAG = "Credentials";
    public static final String UNLOCK_ACTION = "com.android.credentials.UNLOCK";
    public static final String USER_CERTIFICATE = "USRCERT_";
    public static final String USER_PRIVATE_KEY = "USRPKEY_";
    public static final String VPN = "VPN_";
    public static final String WAPI_AS_CERTIFICATE = "WAPIAS_";
    public static final String WAPI_USER_CERTIFICATE = "WAPIUSR_";
    public static final String WIFI = "WIFI_";
    private static Credentials singleton;

    public static List<X509Certificate> convertFromPem(byte[] byArray) throws IOException, CertificateException {
        PemObject pemObject;
        PemReader pemReader = new PemReader((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(byArray), StandardCharsets.US_ASCII));
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        while ((pemObject = pemReader.readPemObject()) != null) {
            if (pemObject.getType().equals("CERTIFICATE")) {
                arrayList.add((X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(pemObject.getContent())));
                continue;
            }
            throw new IllegalArgumentException("Unknown type " + pemObject.getType());
        }
        pemReader.close();
        return arrayList;
    }

    public static byte[] convertToPem(Certificate ... certificateArray) throws IOException, CertificateEncodingException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PemWriter pemWriter = new PemWriter((Writer)new OutputStreamWriter((OutputStream)byteArrayOutputStream, StandardCharsets.US_ASCII));
        int n = certificateArray.length;
        for (int i = 0; i < n; ++i) {
            pemWriter.writeObject((PemObjectGenerator)new PemObject("CERTIFICATE", certificateArray[i].getEncoded()));
        }
        pemWriter.close();
        return byteArrayOutputStream.toByteArray();
    }

    static boolean deleteAllTypesForAlias(KeyStore keyStore, String string2) {
        return keyStore.delKey(USER_PRIVATE_KEY + string2) | Credentials.deleteCertificateTypesForAlias(keyStore, string2);
    }

    static boolean deleteCertificateTypesForAlias(KeyStore keyStore, String string2) {
        return keyStore.delete(USER_CERTIFICATE + string2) | keyStore.delete(CA_CERTIFICATE + string2);
    }

    public static Credentials getInstance() {
        if (singleton == null) {
            singleton = new Credentials();
        }
        return singleton;
    }

    public void install(Context context) {
        try {
            context.startActivity(KeyChain.createInstallIntent());
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            Log.w(LOGTAG, activityNotFoundException.toString());
            return;
        }
    }

    public void install(Context context, String string2, byte[] byArray) {
        try {
            Intent intent = KeyChain.createInstallIntent();
            intent.putExtra(string2, byArray);
            context.startActivity(intent);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            Log.w(LOGTAG, activityNotFoundException.toString());
            return;
        }
    }

    public void install(Context context, KeyPair keyPair) {
        try {
            Intent intent = KeyChain.createInstallIntent();
            intent.putExtra(EXTRA_PRIVATE_KEY, keyPair.getPrivate().getEncoded());
            intent.putExtra(EXTRA_PUBLIC_KEY, keyPair.getPublic().getEncoded());
            context.startActivity(intent);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            Log.w(LOGTAG, activityNotFoundException.toString());
            return;
        }
    }

    public void unlock(Context context) {
        try {
            context.startActivity(new Intent(UNLOCK_ACTION));
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            Log.w(LOGTAG, activityNotFoundException.toString());
            return;
        }
    }
}

