/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

public class Matrix2f {
    final float[] mMat = new float[4];

    public Matrix2f() {
        this.loadIdentity();
    }

    public Matrix2f(float[] fArray) {
        System.arraycopy((float[])fArray, (int)0, (float[])this.mMat, (int)0, (int)this.mMat.length);
    }

    public float get(int n, int n2) {
        return this.mMat[n2 + n * 2];
    }

    public float[] getArray() {
        return this.mMat;
    }

    public void load(Matrix2f matrix2f) {
        System.arraycopy((float[])matrix2f.getArray(), (int)0, (float[])this.mMat, (int)0, (int)this.mMat.length);
    }

    public void loadIdentity() {
        this.mMat[0] = 1.0f;
        this.mMat[1] = 0.0f;
        this.mMat[2] = 0.0f;
        this.mMat[3] = 1.0f;
    }

    public void loadMultiply(Matrix2f matrix2f, Matrix2f matrix2f2) {
        for (int i = 0; i < 2; ++i) {
            float f = 0.0f;
            float f2 = 0.0f;
            for (int j = 0; j < 2; ++j) {
                float f3 = matrix2f2.get(i, j);
                f += f3 * matrix2f.get(j, 0);
                f2 += f3 * matrix2f.get(j, 1);
            }
            this.set(i, 0, f);
            this.set(i, 1, f2);
        }
    }

    public void loadRotate(float f) {
        float f2 = f * ((float)Math.PI / 180);
        float f3 = (float)Math.cos(f2);
        float f4 = (float)Math.sin(f2);
        this.mMat[0] = f3;
        this.mMat[1] = -f4;
        this.mMat[2] = f4;
        this.mMat[3] = f3;
    }

    public void loadScale(float f, float f2) {
        this.loadIdentity();
        this.mMat[0] = f;
        this.mMat[3] = f2;
    }

    public void multiply(Matrix2f matrix2f) {
        Matrix2f matrix2f2 = new Matrix2f();
        matrix2f2.loadMultiply(this, matrix2f);
        this.load(matrix2f2);
    }

    public void rotate(float f) {
        Matrix2f matrix2f = new Matrix2f();
        matrix2f.loadRotate(f);
        this.multiply(matrix2f);
    }

    public void scale(float f, float f2) {
        Matrix2f matrix2f = new Matrix2f();
        matrix2f.loadScale(f, f2);
        this.multiply(matrix2f);
    }

    public void set(int n, int n2, float f) {
        this.mMat[n2 + n * 2] = f;
    }

    public void transpose() {
        float f = this.mMat[1];
        this.mMat[1] = this.mMat[2];
        this.mMat[2] = f;
    }
}

