/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.os.Trace;
import android.renderscript.AllocationAdapter;
import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.FieldPacker;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RSInvalidStateException;
import android.renderscript.RSRuntimeException;
import android.renderscript.RenderScript;
import android.renderscript.Type;
import android.util.Log;
import android.view.Surface;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.HashMap;

public class Allocation
extends BaseObj {
    public static final int USAGE_GRAPHICS_CONSTANTS = 8;
    public static final int USAGE_GRAPHICS_RENDER_TARGET = 16;
    public static final int USAGE_GRAPHICS_TEXTURE = 2;
    public static final int USAGE_GRAPHICS_VERTEX = 4;
    public static final int USAGE_IO_INPUT = 32;
    public static final int USAGE_IO_OUTPUT = 64;
    public static final int USAGE_SCRIPT = 1;
    public static final int USAGE_SHARED = 128;
    static HashMap<Long, Allocation> mAllocationMap = new HashMap();
    static BitmapFactory.Options mBitmapOptions = new BitmapFactory.Options();
    Allocation mAdaptedAllocation;
    Bitmap mBitmap;
    OnBufferAvailableListener mBufferNotifier;
    boolean mConstrainedFace;
    boolean mConstrainedLOD;
    boolean mConstrainedY;
    boolean mConstrainedZ;
    int mCurrentCount;
    int mCurrentDimX;
    int mCurrentDimY;
    int mCurrentDimZ;
    boolean mReadAllowed = true;
    Type.CubemapFace mSelectedFace = Type.CubemapFace.POSITIVE_X;
    int mSelectedLOD;
    int mSelectedY;
    int mSelectedZ;
    int mSize;
    Type mType;
    int mUsage;
    boolean mWriteAllowed = true;

    static {
        Allocation.mBitmapOptions.inScaled = false;
    }

    Allocation(long l, RenderScript renderScript, Type type, int n) {
        super(l, renderScript);
        if ((n & 0xFFFFFF00) != 0) {
            throw new RSIllegalArgumentException("Unknown usage specified.");
        }
        if ((n & 0x20) != 0) {
            this.mWriteAllowed = false;
            if ((n & 0xFFFFFFDC) != 0) {
                throw new RSIllegalArgumentException("Invalid usage combination.");
            }
        }
        this.mType = type;
        this.mUsage = n;
        if (type != null) {
            this.mSize = this.mType.getCount() * this.mType.getElement().getBytesSize();
            this.updateCacheInfo(type);
        }
        try {
            Method method = RenderScript.registerNativeAllocation;
            Object object = RenderScript.sRuntime;
            Object[] objectArray = new Object[]{this.mSize};
            method.invoke(object, objectArray);
            return;
        }
        catch (Exception exception) {
            Log.e("RenderScript_jni", "Couldn't invoke registerNativeAllocation:" + exception);
            throw new RSRuntimeException("Couldn't invoke registerNativeAllocation:" + exception);
        }
    }

    private void copy1DRangeFromUnchecked(int n, int n2, Object object, Element.DataType dataType, int n3) {
        Trace.traceBegin(32768L, "copy1DRangeFromUnchecked");
        int n4 = n2 * this.mType.mElement.getBytesSize();
        this.data1DChecks(n, n2, n3 * dataType.mSize, n4);
        this.mRS.nAllocationData1D(this.getIDSafe(), n, this.mSelectedLOD, n2, object, n4, dataType);
        Trace.traceEnd(32768L);
    }

    private void copy3DRangeFromUnchecked(int n, int n2, int n3, int n4, int n5, int n6, Object object, Element.DataType dataType, int n7) {
        Trace.traceBegin(32768L, "copy3DRangeFromUnchecked");
        this.mRS.validate();
        this.validate3DRange(n, n2, n3, n4, n5, n6);
        this.mRS.nAllocationData3D(this.getIDSafe(), n, n2, n3, this.mSelectedLOD, n4, n5, n6, object, n7 * dataType.mSize, dataType);
        Trace.traceEnd(32768L);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void copyFromUnchecked(Object object, Element.DataType dataType, int n) {
        Trace.traceBegin(32768L, "copyFromUnchecked");
        this.mRS.validate();
        if (this.mCurrentDimZ > 0) {
            this.copy3DRangeFromUnchecked(0, 0, 0, this.mCurrentDimX, this.mCurrentDimY, this.mCurrentDimZ, object, dataType, n);
        } else if (this.mCurrentDimY > 0) {
            this.copy2DRangeFromUnchecked(0, 0, this.mCurrentDimX, this.mCurrentDimY, object, dataType, n);
        } else {
            this.copy1DRangeFromUnchecked(0, this.mCurrentCount, object, dataType, n);
        }
        Trace.traceEnd(32768L);
    }

    private void copyTo(Object object, Element.DataType dataType, int n) {
        Trace.traceBegin(32768L, "copyTo");
        this.mRS.validate();
        this.mRS.nAllocationRead(this.getID(this.mRS), object, dataType);
        Trace.traceEnd(32768L);
    }

    public static Allocation createCubemapFromBitmap(RenderScript renderScript, Bitmap bitmap) {
        return Allocation.createCubemapFromBitmap(renderScript, bitmap, MipmapControl.MIPMAP_NONE, 2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Allocation createCubemapFromBitmap(RenderScript renderScript, Bitmap bitmap, MipmapControl mipmapControl, int n) {
        boolean bl = true;
        renderScript.validate();
        int n2 = bitmap.getHeight();
        int n3 = bitmap.getWidth();
        if (n3 % 6 != 0) {
            throw new RSIllegalArgumentException("Cubemap height must be multiple of 6");
        }
        if (n3 / 6 != n2) {
            throw new RSIllegalArgumentException("Only square cube map faces supported");
        }
        boolean bl2 = (n2 & n2 - 1) == 0 ? bl : false;
        if (!bl2) {
            throw new RSIllegalArgumentException("Only power of 2 cube faces supported");
        }
        Element element = Allocation.elementFromBitmap(renderScript, bitmap);
        Type.Builder builder = new Type.Builder(renderScript, element);
        builder.setX(n2);
        builder.setY(n2);
        builder.setFaces(bl);
        if (mipmapControl != MipmapControl.MIPMAP_FULL) {
            bl = false;
        }
        builder.setMipmaps(bl);
        Type type = builder.create();
        long l = renderScript.nAllocationCubeCreateFromBitmap(type.getID(renderScript), mipmapControl.mID, bitmap, n);
        if (l == 0L) {
            throw new RSRuntimeException("Load failed for bitmap " + bitmap + " element " + element);
        }
        return new Allocation(l, renderScript, type, n);
    }

    public static Allocation createCubemapFromCubeFaces(RenderScript renderScript, Bitmap bitmap, Bitmap bitmap2, Bitmap bitmap3, Bitmap bitmap4, Bitmap bitmap5, Bitmap bitmap6) {
        return Allocation.createCubemapFromCubeFaces(renderScript, bitmap, bitmap2, bitmap3, bitmap4, bitmap5, bitmap6, MipmapControl.MIPMAP_NONE, 2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Allocation createCubemapFromCubeFaces(RenderScript renderScript, Bitmap bitmap, Bitmap bitmap2, Bitmap bitmap3, Bitmap bitmap4, Bitmap bitmap5, Bitmap bitmap6, MipmapControl mipmapControl, int n) {
        int n2 = bitmap.getHeight();
        if (bitmap.getWidth() != n2 || bitmap2.getWidth() != n2 || bitmap2.getHeight() != n2 || bitmap3.getWidth() != n2 || bitmap3.getHeight() != n2 || bitmap4.getWidth() != n2 || bitmap4.getHeight() != n2 || bitmap5.getWidth() != n2 || bitmap5.getHeight() != n2 || bitmap6.getWidth() != n2 || bitmap6.getHeight() != n2) {
            throw new RSIllegalArgumentException("Only square cube map faces supported");
        }
        boolean bl = (n2 & n2 - 1) == 0;
        if (!bl) {
            throw new RSIllegalArgumentException("Only power of 2 cube faces supported");
        }
        Type.Builder builder = new Type.Builder(renderScript, Allocation.elementFromBitmap(renderScript, bitmap));
        builder.setX(n2);
        builder.setY(n2);
        builder.setFaces(true);
        boolean bl2 = mipmapControl == MipmapControl.MIPMAP_FULL;
        builder.setMipmaps(bl2);
        Allocation allocation = Allocation.createTyped(renderScript, builder.create(), mipmapControl, n);
        AllocationAdapter allocationAdapter = AllocationAdapter.create2D(renderScript, allocation);
        allocationAdapter.setFace(Type.CubemapFace.POSITIVE_X);
        allocationAdapter.copyFrom(bitmap);
        allocationAdapter.setFace(Type.CubemapFace.NEGATIVE_X);
        allocationAdapter.copyFrom(bitmap2);
        allocationAdapter.setFace(Type.CubemapFace.POSITIVE_Y);
        allocationAdapter.copyFrom(bitmap3);
        allocationAdapter.setFace(Type.CubemapFace.NEGATIVE_Y);
        allocationAdapter.copyFrom(bitmap4);
        allocationAdapter.setFace(Type.CubemapFace.POSITIVE_Z);
        allocationAdapter.copyFrom(bitmap5);
        allocationAdapter.setFace(Type.CubemapFace.NEGATIVE_Z);
        allocationAdapter.copyFrom(bitmap6);
        return allocation;
    }

    public static Allocation createFromBitmap(RenderScript renderScript, Bitmap bitmap) {
        if (renderScript.getApplicationContext().getApplicationInfo().targetSdkVersion >= 18) {
            return Allocation.createFromBitmap(renderScript, bitmap, MipmapControl.MIPMAP_NONE, 131);
        }
        return Allocation.createFromBitmap(renderScript, bitmap, MipmapControl.MIPMAP_NONE, 2);
    }

    public static Allocation createFromBitmap(RenderScript renderScript, Bitmap bitmap, MipmapControl mipmapControl, int n) {
        Trace.traceBegin(32768L, "createFromBitmap");
        renderScript.validate();
        if (bitmap.getConfig() == null) {
            if ((n & 0x80) != 0) {
                throw new RSIllegalArgumentException("USAGE_SHARED cannot be used with a Bitmap that has a null config.");
            }
            Bitmap bitmap2 = Bitmap.createBitmap(bitmap.getWidth(), bitmap.getHeight(), Bitmap.Config.ARGB_8888);
            new Canvas(bitmap2).drawBitmap(bitmap, 0.0f, 0.0f, null);
            return Allocation.createFromBitmap(renderScript, bitmap2, mipmapControl, n);
        }
        Type type = Allocation.typeFromBitmap(renderScript, bitmap, mipmapControl);
        if (mipmapControl == MipmapControl.MIPMAP_NONE && type.getElement().isCompatible(Element.RGBA_8888(renderScript)) && n == 131) {
            long l = renderScript.nAllocationCreateBitmapBackedAllocation(type.getID(renderScript), mipmapControl.mID, bitmap, n);
            if (l == 0L) {
                throw new RSRuntimeException("Load failed.");
            }
            Allocation allocation = new Allocation(l, renderScript, type, n);
            allocation.setBitmap(bitmap);
            return allocation;
        }
        long l = renderScript.nAllocationCreateFromBitmap(type.getID(renderScript), mipmapControl.mID, bitmap, n);
        if (l == 0L) {
            throw new RSRuntimeException("Load failed.");
        }
        Trace.traceEnd(32768L);
        return new Allocation(l, renderScript, type, n);
    }

    public static Allocation createFromBitmapResource(RenderScript renderScript, Resources resources, int n) {
        if (renderScript.getApplicationContext().getApplicationInfo().targetSdkVersion >= 18) {
            return Allocation.createFromBitmapResource(renderScript, resources, n, MipmapControl.MIPMAP_NONE, 3);
        }
        return Allocation.createFromBitmapResource(renderScript, resources, n, MipmapControl.MIPMAP_NONE, 2);
    }

    public static Allocation createFromBitmapResource(RenderScript renderScript, Resources resources, int n, MipmapControl mipmapControl, int n2) {
        renderScript.validate();
        if ((n2 & 0xE0) != 0) {
            throw new RSIllegalArgumentException("Unsupported usage specified.");
        }
        Bitmap bitmap = BitmapFactory.decodeResource(resources, n);
        Allocation allocation = Allocation.createFromBitmap(renderScript, bitmap, mipmapControl, n2);
        bitmap.recycle();
        return allocation;
    }

    public static Allocation createFromString(RenderScript renderScript, String string2, int n) {
        renderScript.validate();
        try {
            byte[] byArray = string2.getBytes("UTF-8");
            Allocation allocation = Allocation.createSized(renderScript, Element.U8(renderScript), byArray.length, n);
            allocation.copyFrom(byArray);
            return allocation;
        }
        catch (Exception exception) {
            throw new RSRuntimeException("Could not convert string to utf-8.");
        }
    }

    public static Allocation createSized(RenderScript renderScript, Element element, int n) {
        return Allocation.createSized(renderScript, element, n, 1);
    }

    public static Allocation createSized(RenderScript renderScript, Element element, int n, int n2) {
        Trace.traceBegin(32768L, "createSized");
        renderScript.validate();
        Type.Builder builder = new Type.Builder(renderScript, element);
        builder.setX(n);
        Type type = builder.create();
        long l = renderScript.nAllocationCreateTyped(type.getID(renderScript), MipmapControl.MIPMAP_NONE.mID, n2, 0L);
        if (l == 0L) {
            throw new RSRuntimeException("Allocation creation failed.");
        }
        Trace.traceEnd(32768L);
        return new Allocation(l, renderScript, type, n2);
    }

    public static Allocation createTyped(RenderScript renderScript, Type type) {
        return Allocation.createTyped(renderScript, type, MipmapControl.MIPMAP_NONE, 1);
    }

    public static Allocation createTyped(RenderScript renderScript, Type type, int n) {
        return Allocation.createTyped(renderScript, type, MipmapControl.MIPMAP_NONE, n);
    }

    public static Allocation createTyped(RenderScript renderScript, Type type, MipmapControl mipmapControl, int n) {
        Trace.traceBegin(32768L, "createTyped");
        renderScript.validate();
        if (type.getID(renderScript) == 0L) {
            throw new RSInvalidStateException("Bad Type");
        }
        long l = renderScript.nAllocationCreateTyped(type.getID(renderScript), mipmapControl.mID, n, 0L);
        if (l == 0L) {
            throw new RSRuntimeException("Allocation creation failed.");
        }
        Trace.traceEnd(32768L);
        return new Allocation(l, renderScript, type, n);
    }

    private void data1DChecks(int n, int n2, int n3, int n4) {
        this.mRS.validate();
        if (n < 0) {
            throw new RSIllegalArgumentException("Offset must be >= 0.");
        }
        if (n2 < 1) {
            throw new RSIllegalArgumentException("Count must be >= 1.");
        }
        if (n + n2 > this.mCurrentCount) {
            throw new RSIllegalArgumentException("Overflow, Available count " + this.mCurrentCount + ", got " + n2 + " at offset " + n + ".");
        }
        if (n3 < n4) {
            throw new RSIllegalArgumentException("Array too small for allocation type.");
        }
    }

    static Element elementFromBitmap(RenderScript renderScript, Bitmap bitmap) {
        Bitmap.Config config = bitmap.getConfig();
        if (config == Bitmap.Config.ALPHA_8) {
            return Element.A_8(renderScript);
        }
        if (config == Bitmap.Config.ARGB_4444) {
            return Element.RGBA_4444(renderScript);
        }
        if (config == Bitmap.Config.ARGB_8888) {
            return Element.RGBA_8888(renderScript);
        }
        if (config == Bitmap.Config.RGB_565) {
            return Element.RGB_565(renderScript);
        }
        throw new RSInvalidStateException("Bad bitmap type: " + (Object)((Object)config));
    }

    private long getIDSafe() {
        if (this.mAdaptedAllocation != null) {
            return this.mAdaptedAllocation.getID(this.mRS);
        }
        return this.getID(this.mRS);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void sendBufferNotification(long l) {
        HashMap<Long, Allocation> hashMap = mAllocationMap;
        synchronized (hashMap) {
            Allocation allocation = mAllocationMap.get(new Long(l));
            if (allocation != null && allocation.mBufferNotifier != null) {
                allocation.mBufferNotifier.onBufferAvailable(allocation);
            }
            return;
        }
    }

    private void setBitmap(Bitmap bitmap) {
        this.mBitmap = bitmap;
    }

    /*
     * Enabled aggressive block sorting
     */
    static Type typeFromBitmap(RenderScript renderScript, Bitmap bitmap, MipmapControl mipmapControl) {
        Type.Builder builder = new Type.Builder(renderScript, Allocation.elementFromBitmap(renderScript, bitmap));
        builder.setX(bitmap.getWidth());
        builder.setY(bitmap.getHeight());
        boolean bl = mipmapControl == MipmapControl.MIPMAP_FULL;
        builder.setMipmaps(bl);
        return builder.create();
    }

    private void updateCacheInfo(Type type) {
        this.mCurrentDimX = type.getX();
        this.mCurrentDimY = type.getY();
        this.mCurrentDimZ = type.getZ();
        this.mCurrentCount = this.mCurrentDimX;
        if (this.mCurrentDimY > 1) {
            this.mCurrentCount *= this.mCurrentDimY;
        }
        if (this.mCurrentDimZ > 1) {
            this.mCurrentCount *= this.mCurrentDimZ;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void validate2DRange(int n, int n2, int n3, int n4) {
        block6: {
            block5: {
                if (this.mAdaptedAllocation != null) break block5;
                if (n < 0 || n2 < 0) {
                    throw new RSIllegalArgumentException("Offset cannot be negative.");
                }
                if (n4 < 0 || n3 < 0) {
                    throw new RSIllegalArgumentException("Height or width cannot be negative.");
                }
                if (n + n3 > this.mCurrentDimX || n2 + n4 > this.mCurrentDimY) break block6;
            }
            return;
        }
        throw new RSIllegalArgumentException("Updated region larger than allocation.");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void validate3DRange(int n, int n2, int n3, int n4, int n5, int n6) {
        block6: {
            block5: {
                if (this.mAdaptedAllocation != null) break block5;
                if (n < 0 || n2 < 0 || n3 < 0) {
                    throw new RSIllegalArgumentException("Offset cannot be negative.");
                }
                if (n5 < 0 || n4 < 0 || n6 < 0) {
                    throw new RSIllegalArgumentException("Height or width cannot be negative.");
                }
                if (n + n4 > this.mCurrentDimX || n2 + n5 > this.mCurrentDimY || n3 + n6 > this.mCurrentDimZ) break block6;
            }
            return;
        }
        throw new RSIllegalArgumentException("Updated region larger than allocation.");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void validateBitmapFormat(Bitmap bitmap) {
        Bitmap.Config config = bitmap.getConfig();
        if (config == null) {
            throw new RSIllegalArgumentException("Bitmap has an unsupported format for this operation");
        }
        switch (1.$SwitchMap$android$graphics$Bitmap$Config[config.ordinal()]) {
            case 1: {
                if (this.mType.getElement().mKind == Element.DataKind.PIXEL_A) return;
                throw new RSIllegalArgumentException("Allocation kind is " + (Object)((Object)this.mType.getElement().mKind) + ", type " + (Object)((Object)this.mType.getElement().mType) + " of " + this.mType.getElement().getBytesSize() + " bytes, passed bitmap was " + (Object)((Object)config));
            }
            case 2: {
                if (this.mType.getElement().mKind == Element.DataKind.PIXEL_RGBA && this.mType.getElement().getBytesSize() == 4) return;
                throw new RSIllegalArgumentException("Allocation kind is " + (Object)((Object)this.mType.getElement().mKind) + ", type " + (Object)((Object)this.mType.getElement().mType) + " of " + this.mType.getElement().getBytesSize() + " bytes, passed bitmap was " + (Object)((Object)config));
            }
            case 3: {
                if (this.mType.getElement().mKind == Element.DataKind.PIXEL_RGB && this.mType.getElement().getBytesSize() == 2) return;
                throw new RSIllegalArgumentException("Allocation kind is " + (Object)((Object)this.mType.getElement().mKind) + ", type " + (Object)((Object)this.mType.getElement().mType) + " of " + this.mType.getElement().getBytesSize() + " bytes, passed bitmap was " + (Object)((Object)config));
            }
            default: {
                return;
            }
            case 4: 
        }
        if (this.mType.getElement().mKind == Element.DataKind.PIXEL_RGBA && this.mType.getElement().getBytesSize() == 2) return;
        throw new RSIllegalArgumentException("Allocation kind is " + (Object)((Object)this.mType.getElement().mKind) + ", type " + (Object)((Object)this.mType.getElement().mType) + " of " + this.mType.getElement().getBytesSize() + " bytes, passed bitmap was " + (Object)((Object)config));
    }

    private void validateBitmapSize(Bitmap bitmap) {
        if (this.mCurrentDimX != bitmap.getWidth() || this.mCurrentDimY != bitmap.getHeight()) {
            throw new RSIllegalArgumentException("Cannot update allocation from bitmap, sizes mismatch");
        }
    }

    private void validateIsFloat32() {
        if (this.mType.mElement.mType == Element.DataType.FLOAT_32) {
            return;
        }
        throw new RSIllegalArgumentException("32 bit float source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    private void validateIsFloat64() {
        if (this.mType.mElement.mType == Element.DataType.FLOAT_64) {
            return;
        }
        throw new RSIllegalArgumentException("64 bit float source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    private void validateIsInt16() {
        if (this.mType.mElement.mType == Element.DataType.SIGNED_16 || this.mType.mElement.mType == Element.DataType.UNSIGNED_16) {
            return;
        }
        throw new RSIllegalArgumentException("16 bit integer source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    private void validateIsInt32() {
        if (this.mType.mElement.mType == Element.DataType.SIGNED_32 || this.mType.mElement.mType == Element.DataType.UNSIGNED_32) {
            return;
        }
        throw new RSIllegalArgumentException("32 bit integer source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    private void validateIsInt64() {
        if (this.mType.mElement.mType == Element.DataType.SIGNED_64 || this.mType.mElement.mType == Element.DataType.UNSIGNED_64) {
            return;
        }
        throw new RSIllegalArgumentException("64 bit integer source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    private void validateIsInt8() {
        if (this.mType.mElement.mType == Element.DataType.SIGNED_8 || this.mType.mElement.mType == Element.DataType.UNSIGNED_8) {
            return;
        }
        throw new RSIllegalArgumentException("8 bit integer source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    private void validateIsObject() {
        if (this.mType.mElement.mType == Element.DataType.RS_ELEMENT || this.mType.mElement.mType == Element.DataType.RS_TYPE || this.mType.mElement.mType == Element.DataType.RS_ALLOCATION || this.mType.mElement.mType == Element.DataType.RS_SAMPLER || this.mType.mElement.mType == Element.DataType.RS_SCRIPT || this.mType.mElement.mType == Element.DataType.RS_MESH || this.mType.mElement.mType == Element.DataType.RS_PROGRAM_FRAGMENT || this.mType.mElement.mType == Element.DataType.RS_PROGRAM_VERTEX || this.mType.mElement.mType == Element.DataType.RS_PROGRAM_RASTER || this.mType.mElement.mType == Element.DataType.RS_PROGRAM_STORE) {
            return;
        }
        throw new RSIllegalArgumentException("Object source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    private Element.DataType validateObjectIsPrimitiveArray(Object object, boolean bl) {
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            throw new RSIllegalArgumentException("Object passed is not an array of primitives.");
        }
        Class<?> clazz2 = clazz.getComponentType();
        if (!clazz2.isPrimitive()) {
            throw new RSIllegalArgumentException("Object passed is not an Array of primitives.");
        }
        if (clazz2 == Long.TYPE) {
            if (bl) {
                this.validateIsInt64();
                return this.mType.mElement.mType;
            }
            return Element.DataType.SIGNED_64;
        }
        if (clazz2 == Integer.TYPE) {
            if (bl) {
                this.validateIsInt32();
                return this.mType.mElement.mType;
            }
            return Element.DataType.SIGNED_32;
        }
        if (clazz2 == Short.TYPE) {
            if (bl) {
                this.validateIsInt16();
                return this.mType.mElement.mType;
            }
            return Element.DataType.SIGNED_16;
        }
        if (clazz2 == Byte.TYPE) {
            if (bl) {
                this.validateIsInt8();
                return this.mType.mElement.mType;
            }
            return Element.DataType.SIGNED_8;
        }
        if (clazz2 == Float.TYPE) {
            if (bl) {
                this.validateIsFloat32();
            }
            return Element.DataType.FLOAT_32;
        }
        if (clazz2 == Double.TYPE) {
            if (bl) {
                this.validateIsFloat64();
            }
            return Element.DataType.FLOAT_64;
        }
        return null;
    }

    public void copy1DRangeFrom(int n, int n2, Allocation allocation, int n3) {
        Trace.traceBegin(32768L, "copy1DRangeFrom");
        this.mRS.nAllocationData2D(this.getIDSafe(), n, 0, this.mSelectedLOD, this.mSelectedFace.mID, n2, 1, allocation.getID(this.mRS), n3, 0, allocation.mSelectedLOD, allocation.mSelectedFace.mID);
    }

    public void copy1DRangeFrom(int n, int n2, Object object) {
        this.copy1DRangeFromUnchecked(n, n2, object, this.validateObjectIsPrimitiveArray(object, true), Array.getLength(object));
    }

    public void copy1DRangeFrom(int n, int n2, byte[] byArray) {
        this.validateIsInt8();
        this.copy1DRangeFromUnchecked(n, n2, byArray, Element.DataType.SIGNED_8, byArray.length);
    }

    public void copy1DRangeFrom(int n, int n2, float[] fArray) {
        this.validateIsFloat32();
        this.copy1DRangeFromUnchecked(n, n2, fArray, Element.DataType.FLOAT_32, fArray.length);
    }

    public void copy1DRangeFrom(int n, int n2, int[] nArray) {
        this.validateIsInt32();
        this.copy1DRangeFromUnchecked(n, n2, nArray, Element.DataType.SIGNED_32, nArray.length);
    }

    public void copy1DRangeFrom(int n, int n2, short[] sArray) {
        this.validateIsInt16();
        this.copy1DRangeFromUnchecked(n, n2, sArray, Element.DataType.SIGNED_16, sArray.length);
    }

    public void copy1DRangeFromUnchecked(int n, int n2, Object object) {
        this.copy1DRangeFromUnchecked(n, n2, object, this.validateObjectIsPrimitiveArray(object, false), Array.getLength(object));
    }

    public void copy1DRangeFromUnchecked(int n, int n2, byte[] byArray) {
        this.copy1DRangeFromUnchecked(n, n2, byArray, Element.DataType.SIGNED_8, byArray.length);
    }

    public void copy1DRangeFromUnchecked(int n, int n2, float[] fArray) {
        this.copy1DRangeFromUnchecked(n, n2, fArray, Element.DataType.FLOAT_32, fArray.length);
    }

    public void copy1DRangeFromUnchecked(int n, int n2, int[] nArray) {
        this.copy1DRangeFromUnchecked(n, n2, nArray, Element.DataType.SIGNED_32, nArray.length);
    }

    public void copy1DRangeFromUnchecked(int n, int n2, short[] sArray) {
        this.copy1DRangeFromUnchecked(n, n2, sArray, Element.DataType.SIGNED_16, sArray.length);
    }

    public void copy2DRangeFrom(int n, int n2, int n3, int n4, Allocation allocation, int n5, int n6) {
        Trace.traceBegin(32768L, "copy2DRangeFrom");
        this.mRS.validate();
        this.validate2DRange(n, n2, n3, n4);
        this.mRS.nAllocationData2D(this.getIDSafe(), n, n2, this.mSelectedLOD, this.mSelectedFace.mID, n3, n4, allocation.getID(this.mRS), n5, n6, allocation.mSelectedLOD, allocation.mSelectedFace.mID);
        Trace.traceEnd(32768L);
    }

    public void copy2DRangeFrom(int n, int n2, int n3, int n4, Object object) {
        Trace.traceBegin(32768L, "copy2DRangeFrom");
        this.copy2DRangeFromUnchecked(n, n2, n3, n4, object, this.validateObjectIsPrimitiveArray(object, true), Array.getLength(object));
        Trace.traceEnd(32768L);
    }

    public void copy2DRangeFrom(int n, int n2, int n3, int n4, byte[] byArray) {
        this.validateIsInt8();
        this.copy2DRangeFromUnchecked(n, n2, n3, n4, byArray, Element.DataType.SIGNED_8, byArray.length);
    }

    public void copy2DRangeFrom(int n, int n2, int n3, int n4, float[] fArray) {
        this.validateIsFloat32();
        this.copy2DRangeFromUnchecked(n, n2, n3, n4, fArray, Element.DataType.FLOAT_32, fArray.length);
    }

    public void copy2DRangeFrom(int n, int n2, int n3, int n4, int[] nArray) {
        this.validateIsInt32();
        this.copy2DRangeFromUnchecked(n, n2, n3, n4, nArray, Element.DataType.SIGNED_32, nArray.length);
    }

    public void copy2DRangeFrom(int n, int n2, int n3, int n4, short[] sArray) {
        this.validateIsInt16();
        this.copy2DRangeFromUnchecked(n, n2, n3, n4, sArray, Element.DataType.SIGNED_16, sArray.length);
    }

    public void copy2DRangeFrom(int n, int n2, Bitmap bitmap) {
        Trace.traceBegin(32768L, "copy2DRangeFrom");
        this.mRS.validate();
        if (bitmap.getConfig() == null) {
            Bitmap bitmap2 = Bitmap.createBitmap(bitmap.getWidth(), bitmap.getHeight(), Bitmap.Config.ARGB_8888);
            new Canvas(bitmap2).drawBitmap(bitmap, 0.0f, 0.0f, null);
            this.copy2DRangeFrom(n, n2, bitmap2);
            return;
        }
        this.validateBitmapFormat(bitmap);
        this.validate2DRange(n, n2, bitmap.getWidth(), bitmap.getHeight());
        this.mRS.nAllocationData2D(this.getIDSafe(), n, n2, this.mSelectedLOD, this.mSelectedFace.mID, bitmap);
        Trace.traceEnd(32768L);
    }

    void copy2DRangeFromUnchecked(int n, int n2, int n3, int n4, Object object, Element.DataType dataType, int n5) {
        Trace.traceBegin(32768L, "copy2DRangeFromUnchecked");
        this.mRS.validate();
        this.validate2DRange(n, n2, n3, n4);
        this.mRS.nAllocationData2D(this.getIDSafe(), n, n2, this.mSelectedLOD, this.mSelectedFace.mID, n3, n4, object, n5 * dataType.mSize, dataType);
        Trace.traceEnd(32768L);
    }

    public void copy3DRangeFrom(int n, int n2, int n3, int n4, int n5, int n6, Allocation allocation, int n7, int n8, int n9) {
        this.mRS.validate();
        this.validate3DRange(n, n2, n3, n4, n5, n6);
        this.mRS.nAllocationData3D(this.getIDSafe(), n, n2, n3, this.mSelectedLOD, n4, n5, n6, allocation.getID(this.mRS), n7, n8, n9, allocation.mSelectedLOD);
    }

    public void copy3DRangeFrom(int n, int n2, int n3, int n4, int n5, int n6, Object object) {
        Trace.traceBegin(32768L, "copy3DRangeFrom");
        this.copy3DRangeFromUnchecked(n, n2, n3, n4, n5, n6, object, this.validateObjectIsPrimitiveArray(object, true), Array.getLength(object));
        Trace.traceEnd(32768L);
    }

    public void copyFrom(Bitmap bitmap) {
        Trace.traceBegin(32768L, "copyFrom");
        this.mRS.validate();
        if (bitmap.getConfig() == null) {
            Bitmap bitmap2 = Bitmap.createBitmap(bitmap.getWidth(), bitmap.getHeight(), Bitmap.Config.ARGB_8888);
            new Canvas(bitmap2).drawBitmap(bitmap, 0.0f, 0.0f, null);
            this.copyFrom(bitmap2);
            return;
        }
        this.validateBitmapSize(bitmap);
        this.validateBitmapFormat(bitmap);
        this.mRS.nAllocationCopyFromBitmap(this.getID(this.mRS), bitmap);
        Trace.traceEnd(32768L);
    }

    public void copyFrom(Allocation allocation) {
        Trace.traceBegin(32768L, "copyFrom");
        this.mRS.validate();
        if (!this.mType.equals(allocation.getType())) {
            throw new RSIllegalArgumentException("Types of allocations must match.");
        }
        this.copy2DRangeFrom(0, 0, this.mCurrentDimX, this.mCurrentDimY, allocation, 0, 0);
        Trace.traceEnd(32768L);
    }

    public void copyFrom(Object object) {
        Trace.traceBegin(32768L, "copyFrom");
        this.copyFromUnchecked(object, this.validateObjectIsPrimitiveArray(object, true), Array.getLength(object));
        Trace.traceEnd(32768L);
    }

    public void copyFrom(byte[] byArray) {
        this.validateIsInt8();
        this.copyFromUnchecked(byArray, Element.DataType.SIGNED_8, byArray.length);
    }

    public void copyFrom(float[] fArray) {
        this.validateIsFloat32();
        this.copyFromUnchecked(fArray, Element.DataType.FLOAT_32, fArray.length);
    }

    public void copyFrom(int[] nArray) {
        this.validateIsInt32();
        this.copyFromUnchecked(nArray, Element.DataType.SIGNED_32, nArray.length);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void copyFrom(BaseObj[] baseObjArray) {
        Trace.traceBegin(32768L, "copyFrom");
        this.mRS.validate();
        this.validateIsObject();
        if (baseObjArray.length != this.mCurrentCount) {
            throw new RSIllegalArgumentException("Array size mismatch, allocation sizeX = " + this.mCurrentCount + ", array length = " + baseObjArray.length);
        }
        if (RenderScript.sPointerSize == 8) {
            long[] lArray = new long[4 * baseObjArray.length];
            for (int i = 0; i < baseObjArray.length; ++i) {
                lArray[i * 4] = baseObjArray[i].getID(this.mRS);
            }
            this.copy1DRangeFromUnchecked(0, this.mCurrentCount, (Object)lArray);
        } else {
            int[] nArray = new int[baseObjArray.length];
            for (int i = 0; i < baseObjArray.length; ++i) {
                nArray[i] = (int)baseObjArray[i].getID(this.mRS);
            }
            this.copy1DRangeFromUnchecked(0, this.mCurrentCount, nArray);
        }
        Trace.traceEnd(32768L);
    }

    public void copyFrom(short[] sArray) {
        this.validateIsInt16();
        this.copyFromUnchecked(sArray, Element.DataType.SIGNED_16, sArray.length);
    }

    public void copyFromUnchecked(Object object) {
        Trace.traceBegin(32768L, "copyFromUnchecked");
        this.copyFromUnchecked(object, this.validateObjectIsPrimitiveArray(object, false), Array.getLength(object));
        Trace.traceEnd(32768L);
    }

    public void copyFromUnchecked(byte[] byArray) {
        this.copyFromUnchecked(byArray, Element.DataType.SIGNED_8, byArray.length);
    }

    public void copyFromUnchecked(float[] fArray) {
        this.copyFromUnchecked(fArray, Element.DataType.FLOAT_32, fArray.length);
    }

    public void copyFromUnchecked(int[] nArray) {
        this.copyFromUnchecked(nArray, Element.DataType.SIGNED_32, nArray.length);
    }

    public void copyFromUnchecked(short[] sArray) {
        this.copyFromUnchecked(sArray, Element.DataType.SIGNED_16, sArray.length);
    }

    public void copyTo(Bitmap bitmap) {
        Trace.traceBegin(32768L, "copyTo");
        this.mRS.validate();
        this.validateBitmapFormat(bitmap);
        this.validateBitmapSize(bitmap);
        this.mRS.nAllocationCopyToBitmap(this.getID(this.mRS), bitmap);
        Trace.traceEnd(32768L);
    }

    public void copyTo(Object object) {
        this.copyTo(object, this.validateObjectIsPrimitiveArray(object, true), Array.getLength(object));
    }

    public void copyTo(byte[] byArray) {
        this.validateIsInt8();
        this.copyTo(byArray, Element.DataType.SIGNED_8, byArray.length);
    }

    public void copyTo(float[] fArray) {
        this.validateIsFloat32();
        this.copyTo(fArray, Element.DataType.FLOAT_32, fArray.length);
    }

    public void copyTo(int[] nArray) {
        this.validateIsInt32();
        this.copyTo(nArray, Element.DataType.SIGNED_32, nArray.length);
    }

    public void copyTo(short[] sArray) {
        this.validateIsInt16();
        this.copyTo(sArray, Element.DataType.SIGNED_16, sArray.length);
    }

    @Override
    protected void finalize() throws Throwable {
        Method method = RenderScript.registerNativeFree;
        Object object = RenderScript.sRuntime;
        Object[] objectArray = new Object[]{this.mSize};
        method.invoke(object, objectArray);
        super.finalize();
    }

    public void generateMipmaps() {
        this.mRS.nAllocationGenerateMipmaps(this.getID(this.mRS));
    }

    public int getBytesSize() {
        if (this.mType.mDimYuv != 0) {
            return (int)Math.ceil(1.5 * (double)(this.mType.getCount() * this.mType.getElement().getBytesSize()));
        }
        return this.mType.getCount() * this.mType.getElement().getBytesSize();
    }

    public Element getElement() {
        return this.mType.getElement();
    }

    public Surface getSurface() {
        if ((0x20 & this.mUsage) == 0) {
            throw new RSInvalidStateException("Allocation is not a surface texture.");
        }
        return this.mRS.nAllocationGetSurface(this.getID(this.mRS));
    }

    public Type getType() {
        return this.mType;
    }

    public int getUsage() {
        return this.mUsage;
    }

    public void ioReceive() {
        Trace.traceBegin(32768L, "ioReceive");
        if ((0x20 & this.mUsage) == 0) {
            throw new RSIllegalArgumentException("Can only receive if IO_INPUT usage specified.");
        }
        this.mRS.validate();
        this.mRS.nAllocationIoReceive(this.getID(this.mRS));
        Trace.traceEnd(32768L);
    }

    public void ioSend() {
        Trace.traceBegin(32768L, "ioSend");
        if ((0x40 & this.mUsage) == 0) {
            throw new RSIllegalArgumentException("Can only send buffer if IO_OUTPUT usage specified.");
        }
        this.mRS.validate();
        this.mRS.nAllocationIoSend(this.getID(this.mRS));
        Trace.traceEnd(32768L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resize(int n) {
        synchronized (this) {
            if (this.mRS.getApplicationContext().getApplicationInfo().targetSdkVersion >= 21) {
                throw new RSRuntimeException("Resize is not allowed in API 21+.");
            }
            if (this.mType.getY() <= 0 && this.mType.getZ() <= 0 && !this.mType.hasFaces() && !this.mType.hasMipmaps()) {
                this.mRS.nAllocationResize1D(this.getID(this.mRS), n);
                this.mRS.finish();
                this.mType = new Type(this.mRS.nAllocationGetType(this.getID(this.mRS)), this.mRS);
                this.mType.updateFromNative();
                this.updateCacheInfo(this.mType);
                return;
            }
            throw new RSInvalidStateException("Resize only support for 1D allocations at this time.");
        }
    }

    public void setFromFieldPacker(int n, int n2, FieldPacker fieldPacker) {
        int n3;
        this.mRS.validate();
        if (n2 >= this.mType.mElement.mElements.length) {
            throw new RSIllegalArgumentException("Component_number " + n2 + " out of range.");
        }
        if (n < 0) {
            throw new RSIllegalArgumentException("Offset must be >= 0.");
        }
        byte[] byArray = fieldPacker.getData();
        int n4 = fieldPacker.getPos();
        if (n4 != (n3 = this.mType.mElement.mElements[n2].getBytesSize() * this.mType.mElement.mArraySizes[n2])) {
            throw new RSIllegalArgumentException("Field packer sizelength " + n4 + " does not match component size " + n3 + ".");
        }
        this.mRS.nAllocationElementData1D(this.getIDSafe(), n, this.mSelectedLOD, n2, byArray, n4);
    }

    public void setFromFieldPacker(int n, FieldPacker fieldPacker) {
        this.mRS.validate();
        int n2 = this.mType.mElement.getBytesSize();
        byte[] byArray = fieldPacker.getData();
        int n3 = fieldPacker.getPos();
        int n4 = n3 / n2;
        if (n2 * n4 != n3) {
            throw new RSIllegalArgumentException("Field packer length " + n3 + " not divisible by element size " + n2 + ".");
        }
        this.copy1DRangeFromUnchecked(n, n4, byArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setOnBufferAvailableListener(OnBufferAvailableListener onBufferAvailableListener) {
        HashMap<Long, Allocation> hashMap = mAllocationMap;
        synchronized (hashMap) {
            mAllocationMap.put(new Long(this.getID(this.mRS)), this);
            this.mBufferNotifier = onBufferAvailableListener;
            return;
        }
    }

    public void setSurface(Surface surface) {
        this.mRS.validate();
        if ((0x40 & this.mUsage) == 0) {
            throw new RSInvalidStateException("Allocation is not USAGE_IO_OUTPUT.");
        }
        this.mRS.nAllocationSetSurface(this.getID(this.mRS), surface);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void syncAll(int n) {
        Trace.traceBegin(32768L, "syncAll");
        switch (n) {
            default: {
                throw new RSIllegalArgumentException("Source must be exactly one usage type.");
            }
            case 1: 
            case 2: {
                if ((0x80 & this.mUsage) != 0) {
                    this.copyFrom(this.mBitmap);
                }
            }
            case 4: 
            case 8: {
                break;
            }
            case 128: {
                if ((0x80 & this.mUsage) == 0) break;
                this.copyTo(this.mBitmap);
            }
        }
        this.mRS.validate();
        this.mRS.nAllocationSyncAll(this.getIDSafe(), n);
        Trace.traceEnd(32768L);
    }

    @Override
    void updateFromNative() {
        super.updateFromNative();
        long l = this.mRS.nAllocationGetType(this.getID(this.mRS));
        if (l != 0L) {
            this.mType = new Type(l, this.mRS);
            this.mType.updateFromNative();
            this.updateCacheInfo(this.mType);
        }
    }

    public static final class MipmapControl
    extends Enum<MipmapControl> {
        private static final /* synthetic */ MipmapControl[] $VALUES;
        public static final /* enum */ MipmapControl MIPMAP_FULL;
        public static final /* enum */ MipmapControl MIPMAP_NONE;
        public static final /* enum */ MipmapControl MIPMAP_ON_SYNC_TO_TEXTURE;
        int mID;

        static {
            MIPMAP_NONE = new MipmapControl(0);
            MIPMAP_FULL = new MipmapControl(1);
            MIPMAP_ON_SYNC_TO_TEXTURE = new MipmapControl(2);
            MipmapControl[] mipmapControlArray = new MipmapControl[]{MIPMAP_NONE, MIPMAP_FULL, MIPMAP_ON_SYNC_TO_TEXTURE};
            $VALUES = mipmapControlArray;
        }

        private MipmapControl(int n2) {
            this.mID = n2;
        }

        public static MipmapControl valueOf(String string2) {
            return Enum.valueOf(MipmapControl.class, string2);
        }

        public static MipmapControl[] values() {
            return (MipmapControl[])$VALUES.clone();
        }
    }

    public static interface OnBufferAvailableListener {
        public void onBufferAvailable(Allocation var1);
    }
}

