/*
 * Decompiled with CFR 0.152.
 */
package android.printservice;

import android.os.RemoteException;
import android.print.PrintJobId;
import android.print.PrintJobInfo;
import android.printservice.IPrintServiceClient;
import android.printservice.PrintDocument;
import android.printservice.PrintService;
import android.text.TextUtils;
import android.util.Log;

public final class PrintJob {
    private static final String LOG_TAG = "PrintJob";
    private PrintJobInfo mCachedInfo;
    private final PrintDocument mDocument;
    private final IPrintServiceClient mPrintServiceClient;

    PrintJob(PrintJobInfo printJobInfo, IPrintServiceClient iPrintServiceClient) {
        this.mCachedInfo = printJobInfo;
        this.mPrintServiceClient = iPrintServiceClient;
        this.mDocument = new PrintDocument(this.mCachedInfo.getId(), iPrintServiceClient, printJobInfo.getDocumentInfo());
    }

    private boolean isInImmutableState() {
        int n = this.mCachedInfo.getState();
        return n == 5 || n == 7 || n == 6;
    }

    private boolean setState(int n, String string2) {
        try {
            if (this.mPrintServiceClient.setPrintJobState(this.mCachedInfo.getId(), n, string2)) {
                this.mCachedInfo.setState(n);
                this.mCachedInfo.setStateReason(string2);
                return true;
            }
        }
        catch (RemoteException remoteException) {
            Log.e(LOG_TAG, "Error setting the state of job: " + this.mCachedInfo.getId(), remoteException);
        }
        return false;
    }

    public boolean block(String string2) {
        PrintService.throwIfNotCalledOnMainThread();
        PrintJobInfo printJobInfo = this.getInfo();
        int n = printJobInfo.getState();
        if (n == 3 || n == 4 && !TextUtils.equals(printJobInfo.getStateReason(), string2)) {
            return this.setState(4, string2);
        }
        return false;
    }

    public boolean cancel() {
        PrintService.throwIfNotCalledOnMainThread();
        if (!this.isInImmutableState()) {
            return this.setState(7, null);
        }
        return false;
    }

    public boolean complete() {
        PrintService.throwIfNotCalledOnMainThread();
        if (this.isStarted()) {
            return this.setState(5, null);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        boolean bl = false;
        if (object == null) return bl;
        Class<?> clazz = this.getClass();
        Class<?> clazz2 = object.getClass();
        bl = false;
        if (clazz != clazz2) return bl;
        PrintJob printJob = (PrintJob)object;
        return this.mCachedInfo.getId().equals(printJob.mCachedInfo.getId());
    }

    public boolean fail(String string2) {
        PrintService.throwIfNotCalledOnMainThread();
        if (!this.isInImmutableState()) {
            return this.setState(6, string2);
        }
        return false;
    }

    public int getAdvancedIntOption(String string2) {
        PrintService.throwIfNotCalledOnMainThread();
        return this.getInfo().getAdvancedIntOption(string2);
    }

    public String getAdvancedStringOption(String string2) {
        PrintService.throwIfNotCalledOnMainThread();
        return this.getInfo().getAdvancedStringOption(string2);
    }

    public PrintDocument getDocument() {
        PrintService.throwIfNotCalledOnMainThread();
        return this.mDocument;
    }

    public PrintJobId getId() {
        PrintService.throwIfNotCalledOnMainThread();
        return this.mCachedInfo.getId();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PrintJobInfo getInfo() {
        PrintJobInfo printJobInfo;
        PrintService.throwIfNotCalledOnMainThread();
        if (this.isInImmutableState()) {
            return this.mCachedInfo;
        }
        try {
            PrintJobInfo printJobInfo2;
            printJobInfo = printJobInfo2 = this.mPrintServiceClient.getPrintJobInfo(this.mCachedInfo.getId());
        }
        catch (RemoteException remoteException) {
            Log.e(LOG_TAG, "Couldn't get info for job: " + this.mCachedInfo.getId(), remoteException);
            printJobInfo = null;
        }
        if (printJobInfo != null) {
            this.mCachedInfo = printJobInfo;
        }
        return this.mCachedInfo;
    }

    public String getTag() {
        PrintService.throwIfNotCalledOnMainThread();
        return this.getInfo().getTag();
    }

    public boolean hasAdvancedOption(String string2) {
        PrintService.throwIfNotCalledOnMainThread();
        return this.getInfo().hasAdvancedOption(string2);
    }

    public int hashCode() {
        return this.mCachedInfo.getId().hashCode();
    }

    public boolean isBlocked() {
        PrintService.throwIfNotCalledOnMainThread();
        return this.getInfo().getState() == 4;
    }

    public boolean isCancelled() {
        PrintService.throwIfNotCalledOnMainThread();
        return this.getInfo().getState() == 7;
    }

    public boolean isCompleted() {
        PrintService.throwIfNotCalledOnMainThread();
        return this.getInfo().getState() == 5;
    }

    public boolean isFailed() {
        PrintService.throwIfNotCalledOnMainThread();
        return this.getInfo().getState() == 6;
    }

    public boolean isQueued() {
        PrintService.throwIfNotCalledOnMainThread();
        return this.getInfo().getState() == 2;
    }

    public boolean isStarted() {
        PrintService.throwIfNotCalledOnMainThread();
        return this.getInfo().getState() == 3;
    }

    public boolean setTag(String string2) {
        PrintService.throwIfNotCalledOnMainThread();
        if (this.isInImmutableState()) {
            return false;
        }
        try {
            boolean bl = this.mPrintServiceClient.setPrintJobTag(this.mCachedInfo.getId(), string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(LOG_TAG, "Error setting tag for job: " + this.mCachedInfo.getId(), remoteException);
            return false;
        }
    }

    public boolean start() {
        PrintService.throwIfNotCalledOnMainThread();
        int n = this.getInfo().getState();
        if (n == 2 || n == 4) {
            return this.setState(3, null);
        }
        return false;
    }
}

