/*
 * Decompiled with CFR 0.152.
 */
package android.print;

import android.print.PrintJobId;
import android.print.PrintJobInfo;
import android.print.PrintManager;

public final class PrintJob {
    private PrintJobInfo mCachedInfo;
    private final PrintManager mPrintManager;

    PrintJob(PrintJobInfo printJobInfo, PrintManager printManager) {
        this.mCachedInfo = printJobInfo;
        this.mPrintManager = printManager;
    }

    private boolean isInImmutableState() {
        int n = this.mCachedInfo.getState();
        return n == 5 || n == 7;
    }

    public void cancel() {
        int n = this.getInfo().getState();
        if (n == 2 || n == 3 || n == 4 || n == 6) {
            this.mPrintManager.cancelPrintJob(this.mCachedInfo.getId());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        boolean bl = false;
        if (object == null) return bl;
        Class<?> clazz = this.getClass();
        Class<?> clazz2 = object.getClass();
        bl = false;
        if (clazz != clazz2) return bl;
        PrintJob printJob = (PrintJob)object;
        return this.mCachedInfo.getId().equals(printJob.mCachedInfo.getId());
    }

    public PrintJobId getId() {
        return this.mCachedInfo.getId();
    }

    public PrintJobInfo getInfo() {
        if (this.isInImmutableState()) {
            return this.mCachedInfo;
        }
        PrintJobInfo printJobInfo = this.mPrintManager.getPrintJobInfo(this.mCachedInfo.getId());
        if (printJobInfo != null) {
            this.mCachedInfo = printJobInfo;
        }
        return this.mCachedInfo;
    }

    public int hashCode() {
        return this.mCachedInfo.getId().hashCode();
    }

    public boolean isBlocked() {
        return this.getInfo().getState() == 4;
    }

    public boolean isCancelled() {
        return this.getInfo().getState() == 7;
    }

    public boolean isCompleted() {
        return this.getInfo().getState() == 5;
    }

    public boolean isFailed() {
        return this.getInfo().getState() == 6;
    }

    public boolean isQueued() {
        return this.getInfo().getState() == 2;
    }

    public boolean isStarted() {
        return this.getInfo().getState() == 3;
    }

    public void restart() {
        if (this.isFailed()) {
            this.mPrintManager.restartPrintJob(this.mCachedInfo.getId());
        }
    }
}

