/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.Preference;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;

public abstract class TwoStatePreference
extends Preference {
    boolean mChecked;
    private boolean mCheckedSet;
    private boolean mDisableDependentsState;
    private CharSequence mSummaryOff;
    private CharSequence mSummaryOn;

    public TwoStatePreference(Context context) {
        this(context, null);
    }

    public TwoStatePreference(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public TwoStatePreference(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public TwoStatePreference(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
    }

    public boolean getDisableDependentsState() {
        return this.mDisableDependentsState;
    }

    public CharSequence getSummaryOff() {
        return this.mSummaryOff;
    }

    public CharSequence getSummaryOn() {
        return this.mSummaryOn;
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onClick() {
        super.onClick();
        boolean bl = !this.isChecked();
        if (this.callChangeListener(bl)) {
            this.setChecked(bl);
        }
    }

    @Override
    protected Object onGetDefaultValue(TypedArray typedArray, int n) {
        return typedArray.getBoolean(n, false);
    }

    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        if (parcelable == null || !parcelable.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        SavedState savedState = (SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.setChecked(savedState.checked);
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        if (this.isPersistent()) {
            return parcelable;
        }
        SavedState savedState = new SavedState(parcelable);
        savedState.checked = this.isChecked();
        return savedState;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onSetInitialValue(boolean bl, Object object) {
        boolean bl2 = bl ? this.getPersistedBoolean(this.mChecked) : ((Boolean)object).booleanValue();
        this.setChecked(bl2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setChecked(boolean bl) {
        boolean bl2 = this.mChecked != bl;
        if (bl2 || !this.mCheckedSet) {
            this.mChecked = bl;
            this.mCheckedSet = true;
            this.persistBoolean(bl);
            if (bl2) {
                this.notifyDependencyChange(this.shouldDisableDependents());
                this.notifyChanged();
            }
        }
    }

    public void setDisableDependentsState(boolean bl) {
        this.mDisableDependentsState = bl;
    }

    public void setSummaryOff(int n) {
        this.setSummaryOff(this.getContext().getString(n));
    }

    public void setSummaryOff(CharSequence charSequence) {
        this.mSummaryOff = charSequence;
        if (!this.isChecked()) {
            this.notifyChanged();
        }
    }

    public void setSummaryOn(int n) {
        this.setSummaryOn(this.getContext().getString(n));
    }

    public void setSummaryOn(CharSequence charSequence) {
        this.mSummaryOn = charSequence;
        if (this.isChecked()) {
            this.notifyChanged();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean shouldDisableDependents() {
        boolean bl;
        if (this.mDisableDependentsState) {
            bl = this.mChecked;
        } else {
            if (!this.mChecked) {
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        boolean bl2 = super.shouldDisableDependents();
        boolean bl3 = false;
        if (!bl2) return bl3;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    void syncSummaryView(View view) {
        TextView textView = (TextView)view.findViewById(0x1020010);
        if (textView != null) {
            CharSequence charSequence;
            boolean bl = true;
            if (this.mChecked && !TextUtils.isEmpty(this.mSummaryOn)) {
                textView.setText(this.mSummaryOn);
                bl = false;
            } else if (!this.mChecked && !TextUtils.isEmpty(this.mSummaryOff)) {
                textView.setText(this.mSummaryOff);
                bl = false;
            }
            if (bl && !TextUtils.isEmpty(charSequence = this.getSummary())) {
                textView.setText(charSequence);
                bl = false;
            }
            int n = 8;
            if (!bl) {
                n = 0;
            }
            if (n != textView.getVisibility()) {
                textView.setVisibility(n);
            }
        }
    }

    static class SavedState
    extends Preference.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        boolean checked;

        /*
         * Enabled aggressive block sorting
         */
        public SavedState(Parcel parcel) {
            int n = 1;
            super(parcel);
            if (parcel.readInt() != n) {
                n = 0;
            }
            this.checked = n;
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            int n2 = this.checked ? 1 : 0;
            parcel.writeInt(n2);
        }
    }
}

