/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.DialogPreference;
import android.preference.Preference;
import android.util.AttributeSet;
import com.android.internal.R;
import java.util.Arrays;

public class MultiCheckPreference
extends DialogPreference {
    private CharSequence[] mEntries;
    private String[] mEntryValues;
    private boolean[] mOrigValues;
    private boolean[] mSetValues;
    private String mSummary;

    public MultiCheckPreference(Context context) {
        this(context, null);
    }

    public MultiCheckPreference(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0x1010091);
    }

    public MultiCheckPreference(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public MultiCheckPreference(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ListPreference, n, n2);
        this.mEntries = typedArray.getTextArray(0);
        if (this.mEntries != null) {
            this.setEntries(this.mEntries);
        }
        this.setEntryValuesCS(typedArray.getTextArray(1));
        typedArray.recycle();
        TypedArray typedArray2 = context.obtainStyledAttributes(attributeSet, R.styleable.Preference, 0, 0);
        this.mSummary = typedArray2.getString(7);
        typedArray2.recycle();
    }

    private void setEntryValuesCS(CharSequence[] charSequenceArray) {
        this.setValues(null);
        if (charSequenceArray != null) {
            this.mEntryValues = new String[charSequenceArray.length];
            for (int i = 0; i < charSequenceArray.length; ++i) {
                this.mEntryValues[i] = charSequenceArray[i].toString();
            }
        }
    }

    public int findIndexOfValue(String string2) {
        if (string2 != null && this.mEntryValues != null) {
            for (int i = -1 + this.mEntryValues.length; i >= 0; --i) {
                if (!this.mEntryValues[i].equals(string2)) continue;
                return i;
            }
        }
        return -1;
    }

    public CharSequence[] getEntries() {
        return this.mEntries;
    }

    public String[] getEntryValues() {
        return this.mEntryValues;
    }

    @Override
    public CharSequence getSummary() {
        if (this.mSummary == null) {
            return super.getSummary();
        }
        return this.mSummary;
    }

    public boolean getValue(int n) {
        return this.mSetValues[n];
    }

    public boolean[] getValues() {
        return this.mSetValues;
    }

    @Override
    protected void onDialogClosed(boolean bl) {
        super.onDialogClosed(bl);
        if (bl && this.callChangeListener(this.getValues())) {
            return;
        }
        System.arraycopy((boolean[])this.mOrigValues, (int)0, (boolean[])this.mSetValues, (int)0, (int)this.mSetValues.length);
    }

    @Override
    protected Object onGetDefaultValue(TypedArray typedArray, int n) {
        return typedArray.getString(n);
    }

    @Override
    protected void onPrepareDialogBuilder(AlertDialog.Builder builder) {
        super.onPrepareDialogBuilder(builder);
        if (this.mEntries == null || this.mEntryValues == null) {
            throw new IllegalStateException("ListPreference requires an entries array and an entryValues array.");
        }
        this.mOrigValues = Arrays.copyOf(this.mSetValues, this.mSetValues.length);
        builder.setMultiChoiceItems(this.mEntries, this.mSetValues, new DialogInterface.OnMultiChoiceClickListener(){

            @Override
            public void onClick(DialogInterface dialogInterface, int n, boolean bl) {
                ((MultiCheckPreference)MultiCheckPreference.this).mSetValues[n] = bl;
            }
        });
    }

    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        if (parcelable == null || !parcelable.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        SavedState savedState = (SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.setValues(savedState.values);
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        if (this.isPersistent()) {
            return parcelable;
        }
        SavedState savedState = new SavedState(parcelable);
        savedState.values = this.getValues();
        return savedState;
    }

    @Override
    protected void onSetInitialValue(boolean bl, Object object) {
    }

    public void setEntries(int n) {
        this.setEntries(this.getContext().getResources().getTextArray(n));
    }

    public void setEntries(CharSequence[] charSequenceArray) {
        this.mEntries = charSequenceArray;
        this.mSetValues = new boolean[charSequenceArray.length];
        this.mOrigValues = new boolean[charSequenceArray.length];
    }

    public void setEntryValues(int n) {
        this.setEntryValuesCS(this.getContext().getResources().getTextArray(n));
    }

    public void setEntryValues(String[] stringArray) {
        this.mEntryValues = stringArray;
        Arrays.fill(this.mSetValues, false);
        Arrays.fill(this.mOrigValues, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setSummary(CharSequence charSequence) {
        super.setSummary(charSequence);
        if (charSequence == null && this.mSummary != null) {
            this.mSummary = null;
            return;
        } else {
            if (charSequence == null || charSequence.equals(this.mSummary)) return;
            this.mSummary = charSequence.toString();
            return;
        }
    }

    public void setValue(int n, boolean bl) {
        this.mSetValues[n] = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setValues(boolean[] blArray) {
        if (this.mSetValues != null) {
            Arrays.fill(this.mSetValues, false);
            Arrays.fill(this.mOrigValues, false);
            if (blArray != null) {
                boolean[] blArray2 = this.mSetValues;
                int n = blArray.length < this.mSetValues.length ? blArray.length : this.mSetValues.length;
                System.arraycopy((boolean[])blArray, (int)0, (boolean[])blArray2, (int)0, (int)n);
            }
        }
    }

    private static class SavedState
    extends Preference.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        boolean[] values;

        public SavedState(Parcel parcel) {
            super(parcel);
            this.values = parcel.createBooleanArray();
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeBooleanArray(this.values);
        }
    }
}

