/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.DialogPreference;
import android.preference.Preference;
import android.text.TextUtils;
import android.util.AttributeSet;
import com.android.internal.R;

public class ListPreference
extends DialogPreference {
    private int mClickedDialogEntryIndex;
    private CharSequence[] mEntries;
    private CharSequence[] mEntryValues;
    private String mSummary;
    private String mValue;
    private boolean mValueSet;

    public ListPreference(Context context) {
        this(context, null);
    }

    public ListPreference(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0x1010091);
    }

    public ListPreference(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public ListPreference(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ListPreference, n, n2);
        this.mEntries = typedArray.getTextArray(0);
        this.mEntryValues = typedArray.getTextArray(1);
        typedArray.recycle();
        TypedArray typedArray2 = context.obtainStyledAttributes(attributeSet, R.styleable.Preference, n, n2);
        this.mSummary = typedArray2.getString(7);
        typedArray2.recycle();
    }

    static /* synthetic */ int access$002(ListPreference listPreference, int n) {
        listPreference.mClickedDialogEntryIndex = n;
        return n;
    }

    private int getValueIndex() {
        return this.findIndexOfValue(this.mValue);
    }

    public int findIndexOfValue(String string2) {
        if (string2 != null && this.mEntryValues != null) {
            for (int i = -1 + this.mEntryValues.length; i >= 0; --i) {
                if (!this.mEntryValues[i].equals(string2)) continue;
                return i;
            }
        }
        return -1;
    }

    public CharSequence[] getEntries() {
        return this.mEntries;
    }

    public CharSequence getEntry() {
        int n = this.getValueIndex();
        if (n >= 0 && this.mEntries != null) {
            return this.mEntries[n];
        }
        return null;
    }

    public CharSequence[] getEntryValues() {
        return this.mEntryValues;
    }

    @Override
    public CharSequence getSummary() {
        CharSequence charSequence = this.getEntry();
        if (this.mSummary == null || charSequence == null) {
            return super.getSummary();
        }
        return String.format(this.mSummary, charSequence);
    }

    public String getValue() {
        return this.mValue;
    }

    @Override
    protected void onDialogClosed(boolean bl) {
        String string2;
        super.onDialogClosed(bl);
        if (bl && this.mClickedDialogEntryIndex >= 0 && this.mEntryValues != null && this.callChangeListener(string2 = this.mEntryValues[this.mClickedDialogEntryIndex].toString())) {
            this.setValue(string2);
        }
    }

    @Override
    protected Object onGetDefaultValue(TypedArray typedArray, int n) {
        return typedArray.getString(n);
    }

    @Override
    protected void onPrepareDialogBuilder(AlertDialog.Builder builder) {
        super.onPrepareDialogBuilder(builder);
        if (this.mEntries == null || this.mEntryValues == null) {
            throw new IllegalStateException("ListPreference requires an entries array and an entryValues array.");
        }
        this.mClickedDialogEntryIndex = this.getValueIndex();
        builder.setSingleChoiceItems(this.mEntries, this.mClickedDialogEntryIndex, new DialogInterface.OnClickListener(){

            @Override
            public void onClick(DialogInterface dialogInterface, int n) {
                ListPreference.access$002(ListPreference.this, n);
                ListPreference.this.onClick(dialogInterface, -1);
                dialogInterface.dismiss();
            }
        });
        builder.setPositiveButton(null, null);
    }

    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        if (parcelable == null || !parcelable.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        SavedState savedState = (SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.setValue(savedState.value);
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        if (this.isPersistent()) {
            return parcelable;
        }
        SavedState savedState = new SavedState(parcelable);
        savedState.value = this.getValue();
        return savedState;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onSetInitialValue(boolean bl, Object object) {
        String string2 = bl ? this.getPersistedString(this.mValue) : (String)object;
        this.setValue(string2);
    }

    public void setEntries(int n) {
        this.setEntries(this.getContext().getResources().getTextArray(n));
    }

    public void setEntries(CharSequence[] charSequenceArray) {
        this.mEntries = charSequenceArray;
    }

    public void setEntryValues(int n) {
        this.setEntryValues(this.getContext().getResources().getTextArray(n));
    }

    public void setEntryValues(CharSequence[] charSequenceArray) {
        this.mEntryValues = charSequenceArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setSummary(CharSequence charSequence) {
        super.setSummary(charSequence);
        if (charSequence == null && this.mSummary != null) {
            this.mSummary = null;
            return;
        } else {
            if (charSequence == null || charSequence.equals(this.mSummary)) return;
            this.mSummary = charSequence.toString();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setValue(String string2) {
        boolean bl = !TextUtils.equals(this.mValue, string2);
        if (bl || !this.mValueSet) {
            this.mValue = string2;
            this.mValueSet = true;
            this.persistString(string2);
            if (bl) {
                this.notifyChanged();
            }
        }
    }

    public void setValueIndex(int n) {
        if (this.mEntryValues != null) {
            this.setValue(this.mEntryValues[n].toString());
        }
    }

    private static class SavedState
    extends Preference.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        String value;

        public SavedState(Parcel parcel) {
            super(parcel);
            this.value = parcel.readString();
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeString(this.value);
        }
    }
}

