/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;

public class WorkSource
implements Parcelable {
    public static final Parcelable.Creator<WorkSource> CREATOR;
    static final boolean DEBUG = false;
    static final String TAG = "WorkSource";
    static WorkSource sGoneWork;
    static WorkSource sNewbWork;
    static final WorkSource sTmpWorkSource;
    String[] mNames;
    int mNum;
    int[] mUids;

    static {
        sTmpWorkSource = new WorkSource(0);
        CREATOR = new Parcelable.Creator<WorkSource>(){

            @Override
            public WorkSource createFromParcel(Parcel parcel) {
                return new WorkSource(parcel);
            }

            public WorkSource[] newArray(int n) {
                return new WorkSource[n];
            }
        };
    }

    public WorkSource() {
        this.mNum = 0;
    }

    public WorkSource(int n) {
        this.mNum = 1;
        this.mUids = new int[]{n, 0};
        this.mNames = null;
    }

    public WorkSource(int n, String string2) {
        if (string2 == null) {
            throw new NullPointerException("Name can't be null");
        }
        this.mNum = 1;
        this.mUids = new int[]{n, 0};
        this.mNames = new String[]{string2, null};
    }

    WorkSource(Parcel parcel) {
        this.mNum = parcel.readInt();
        this.mUids = parcel.createIntArray();
        this.mNames = parcel.createStringArray();
    }

    /*
     * Enabled aggressive block sorting
     */
    public WorkSource(WorkSource workSource) {
        if (workSource == null) {
            this.mNum = 0;
            return;
        }
        this.mNum = workSource.mNum;
        if (workSource.mUids == null) {
            this.mUids = null;
            this.mNames = null;
            return;
        }
        this.mUids = (int[])workSource.mUids.clone();
        String[] stringArray = workSource.mNames != null ? (String[])workSource.mNames.clone() : null;
        this.mNames = stringArray;
    }

    private static WorkSource addWork(WorkSource workSource, int n) {
        if (workSource == null) {
            return new WorkSource(n);
        }
        workSource.insert(workSource.mNum, n);
        return workSource;
    }

    private static WorkSource addWork(WorkSource workSource, int n, String string2) {
        if (workSource == null) {
            return new WorkSource(n, string2);
        }
        workSource.insert(workSource.mNum, n, string2);
        return workSource;
    }

    private int compare(WorkSource workSource, int n, int n2) {
        int n3 = this.mUids[n] - workSource.mUids[n2];
        if (n3 != 0) {
            return n3;
        }
        return this.mNames[n].compareTo(workSource.mNames[n2]);
    }

    private void insert(int n, int n2) {
        if (this.mUids == null) {
            this.mUids = new int[4];
            this.mUids[0] = n2;
            this.mNum = 1;
            return;
        }
        if (this.mNum >= this.mUids.length) {
            int[] nArray = new int[3 * this.mNum / 2];
            if (n > 0) {
                System.arraycopy((int[])this.mUids, (int)0, (int[])nArray, (int)0, (int)n);
            }
            if (n < this.mNum) {
                System.arraycopy((int[])this.mUids, (int)n, (int[])nArray, (int)(n + 1), (int)(this.mNum - n));
            }
            this.mUids = nArray;
            this.mUids[n] = n2;
            this.mNum = 1 + this.mNum;
            return;
        }
        if (n < this.mNum) {
            System.arraycopy((int[])this.mUids, (int)n, (int[])this.mUids, (int)(n + 1), (int)(this.mNum - n));
        }
        this.mUids[n] = n2;
        this.mNum = 1 + this.mNum;
    }

    private void insert(int n, int n2, String string2) {
        if (this.mUids == null) {
            this.mUids = new int[4];
            this.mUids[0] = n2;
            this.mNames = new String[4];
            this.mNames[0] = string2;
            this.mNum = 1;
            return;
        }
        if (this.mNum >= this.mUids.length) {
            int[] nArray = new int[3 * this.mNum / 2];
            String[] stringArray = new String[3 * this.mNum / 2];
            if (n > 0) {
                System.arraycopy((int[])this.mUids, (int)0, (int[])nArray, (int)0, (int)n);
                System.arraycopy(this.mNames, 0, stringArray, 0, n);
            }
            if (n < this.mNum) {
                System.arraycopy((int[])this.mUids, (int)n, (int[])nArray, (int)(n + 1), (int)(this.mNum - n));
                System.arraycopy(this.mNames, n, stringArray, n + 1, this.mNum - n);
            }
            this.mUids = nArray;
            this.mNames = stringArray;
            this.mUids[n] = n2;
            this.mNames[n] = string2;
            this.mNum = 1 + this.mNum;
            return;
        }
        if (n < this.mNum) {
            System.arraycopy((int[])this.mUids, (int)n, (int[])this.mUids, (int)(n + 1), (int)(this.mNum - n));
            System.arraycopy(this.mNames, n, this.mNames, n + 1, this.mNum - n);
        }
        this.mUids[n] = n2;
        this.mNames[n] = string2;
        this.mNum = 1 + this.mNum;
    }

    private boolean removeUids(WorkSource workSource) {
        int n = this.mNum;
        int[] nArray = this.mUids;
        int n2 = workSource.mNum;
        int[] nArray2 = workSource.mUids;
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n && n4 < n2) {
            if (nArray2[n4] == nArray[n3]) {
                bl = true;
                if (n3 < --n) {
                    System.arraycopy((int[])nArray, (int)(n3 + 1), (int[])nArray, (int)n3, (int)(n - n3));
                }
                ++n4;
                continue;
            }
            if (nArray2[n4] > nArray[n3]) {
                ++n3;
                continue;
            }
            ++n4;
        }
        this.mNum = n;
        return bl;
    }

    private boolean removeUidsAndNames(WorkSource workSource) {
        int n = this.mNum;
        int[] nArray = this.mUids;
        String[] stringArray = this.mNames;
        int n2 = workSource.mNum;
        int[] nArray2 = workSource.mUids;
        String[] stringArray2 = workSource.mNames;
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n && n4 < n2) {
            if (nArray2[n4] == nArray[n3] && stringArray2[n4].equals(stringArray[n3])) {
                bl = true;
                if (n3 < --n) {
                    System.arraycopy((int[])nArray, (int)(n3 + 1), (int[])nArray, (int)n3, (int)(n - n3));
                    System.arraycopy(stringArray, n3 + 1, stringArray, n3, n - n3);
                }
                ++n4;
                continue;
            }
            if (nArray2[n4] > nArray[n3] || nArray2[n4] == nArray[n3] && stringArray2[n4].compareTo(stringArray[n3]) > 0) {
                ++n3;
                continue;
            }
            ++n4;
        }
        this.mNum = n;
        return bl;
    }

    private boolean updateLocked(WorkSource workSource, boolean bl, boolean bl2) {
        if (this.mNames == null && workSource.mNames == null) {
            return this.updateUidsLocked(workSource, bl, bl2);
        }
        if (this.mNum > 0 && this.mNames == null) {
            throw new IllegalArgumentException("Other " + workSource + " has names, but target " + this + " does not");
        }
        if (workSource.mNum > 0 && workSource.mNames == null) {
            throw new IllegalArgumentException("Target " + this + " has names, but other " + workSource + " does not");
        }
        return this.updateUidsAndNamesLocked(workSource, bl, bl2);
    }

    private boolean updateUidsAndNamesLocked(WorkSource workSource, boolean bl, boolean bl2) {
        int n = workSource.mNum;
        int[] nArray = workSource.mUids;
        String[] stringArray = workSource.mNames;
        boolean bl3 = false;
        int n2 = 0;
        int n3 = 0;
        block0: while (n2 < this.mNum || n3 < n) {
            int n4 = -1;
            if (n2 >= this.mNum || n3 < n && (n4 = this.compare(workSource, n2, n3)) > 0) {
                bl3 = true;
                this.insert(n2, nArray[n3], stringArray[n3]);
                if (bl2) {
                    sNewbWork = WorkSource.addWork(sNewbWork, nArray[n3], stringArray[n3]);
                }
                ++n2;
                ++n3;
                continue;
            }
            if (!bl) {
                if (n3 < n && n4 == 0) {
                    ++n3;
                }
                ++n2;
                continue;
            }
            int n5 = n2;
            while (true) {
                block12: {
                    block11: {
                        if (n4 >= 0) break block11;
                        sGoneWork = WorkSource.addWork(sGoneWork, this.mUids[n2], this.mNames[n2]);
                        if (++n2 < this.mNum) break block12;
                    }
                    if (n5 < n2) {
                        System.arraycopy((int[])this.mUids, (int)n2, (int[])this.mUids, (int)n5, (int)(this.mNum - n2));
                        System.arraycopy(this.mNames, n2, this.mNames, n5, this.mNum - n2);
                        this.mNum -= n2 - n5;
                        n2 = n5;
                    }
                    if (n2 >= this.mNum || n4 != 0) continue block0;
                    ++n2;
                    ++n3;
                    continue block0;
                }
                if (n3 < n) {
                    n4 = this.compare(workSource, n2, n3);
                    continue;
                }
                n4 = -1;
            }
        }
        return bl3;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean updateUidsLocked(WorkSource workSource, boolean bl, boolean bl2) {
        int n = this.mNum;
        int[] nArray = this.mUids;
        int n2 = workSource.mNum;
        int[] nArray2 = workSource.mUids;
        boolean bl3 = false;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            if (n3 >= n && n4 >= n2) {
                this.mNum = n;
                this.mUids = nArray;
                return bl3;
            }
            if (n3 >= n || n4 < n2 && nArray2[n4] < nArray[n3]) {
                bl3 = true;
                if (nArray == null) {
                    nArray = new int[4];
                    nArray[0] = nArray2[n4];
                } else if (n >= nArray.length) {
                    int[] nArray3 = new int[3 * nArray.length / 2];
                    if (n3 > 0) {
                        System.arraycopy((int[])nArray, (int)0, (int[])nArray3, (int)0, (int)n3);
                    }
                    if (n3 < n) {
                        System.arraycopy((int[])nArray, (int)n3, (int[])nArray3, (int)(n3 + 1), (int)(n - n3));
                    }
                    nArray = nArray3;
                    nArray[n3] = nArray2[n4];
                } else {
                    if (n3 < n) {
                        System.arraycopy((int[])nArray, (int)n3, (int[])nArray, (int)(n3 + 1), (int)(n - n3));
                    }
                    nArray[n3] = nArray2[n4];
                }
                if (bl2) {
                    sNewbWork = WorkSource.addWork(sNewbWork, nArray2[n4]);
                }
                ++n;
                ++n3;
                ++n4;
                continue;
            }
            if (!bl) {
                if (n4 < n2 && nArray2[n4] == nArray[n3]) {
                    ++n4;
                }
                ++n3;
                continue;
            }
            int n5 = n3;
            while (n3 < n && (n4 >= n2 || nArray2[n4] > nArray[n3])) {
                sGoneWork = WorkSource.addWork(sGoneWork, nArray[n3]);
                ++n3;
            }
            if (n5 < n3) {
                System.arraycopy((int[])nArray, (int)n3, (int[])nArray, (int)n5, (int)(n - n3));
                n -= n3 - n5;
                n3 = n5;
            }
            if (n3 >= n || n4 >= n2 || nArray2[n4] != nArray[n3]) continue;
            ++n3;
            ++n4;
        }
    }

    public boolean add(int n) {
        if (this.mNum <= 0) {
            this.mNames = null;
            this.insert(0, n);
            return true;
        }
        if (this.mNames != null) {
            throw new IllegalArgumentException("Adding without name to named " + this);
        }
        int n2 = Arrays.binarySearch(this.mUids, 0, this.mNum, n);
        if (n2 >= 0) {
            return false;
        }
        this.insert(-1 + -n2, n);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean add(int n, String string2) {
        if (this.mNum <= 0) {
            this.insert(0, n, string2);
            return true;
        }
        if (this.mNames == null) {
            throw new IllegalArgumentException("Adding name to unnamed " + this);
        }
        int n2 = 0;
        while (true) {
            block8: {
                int n3;
                block9: {
                    block7: {
                        if (n2 >= this.mNum || this.mUids[n2] > n) break block7;
                        if (this.mUids[n2] != n) break block8;
                        n3 = this.mNames[n2].compareTo(string2);
                        if (n3 <= 0) break block9;
                    }
                    this.insert(n2, n, string2);
                    return true;
                }
                if (n3 == 0) {
                    return false;
                }
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean add(WorkSource workSource) {
        WorkSource workSource2 = sTmpWorkSource;
        synchronized (workSource2) {
            return this.updateLocked(workSource, false, false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WorkSource addReturningNewbs(int n) {
        WorkSource workSource = sTmpWorkSource;
        synchronized (workSource) {
            sNewbWork = null;
            WorkSource.sTmpWorkSource.mUids[0] = n;
            this.updateLocked(sTmpWorkSource, false, true);
            return sNewbWork;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WorkSource addReturningNewbs(WorkSource workSource) {
        WorkSource workSource2 = sTmpWorkSource;
        synchronized (workSource2) {
            sNewbWork = null;
            this.updateLocked(workSource, false, true);
            return sNewbWork;
        }
    }

    public void clear() {
        this.mNum = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void clearNames() {
        if (this.mNames != null) {
            this.mNames = null;
            int n = 1;
            int n2 = this.mNum;
            for (int i = 1; i < this.mNum; ++i) {
                if (this.mUids[i] == this.mUids[i - 1]) {
                    --n2;
                    continue;
                }
                this.mUids[n] = this.mUids[i];
                ++n;
            }
            this.mNum = n2;
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean diff(WorkSource workSource) {
        int n = this.mNum;
        if (n == workSource.mNum) {
            int[] nArray = this.mUids;
            int[] nArray2 = workSource.mUids;
            String[] stringArray = this.mNames;
            String[] stringArray2 = workSource.mNames;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                if (nArray[n2] != nArray2[n2] || stringArray != null && stringArray2 != null && !stringArray[n2].equals(stringArray2[n2])) break;
                ++n2;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        return object instanceof WorkSource && !this.diff((WorkSource)object);
    }

    public int get(int n) {
        return this.mUids[n];
    }

    public String getName(int n) {
        if (this.mNames != null) {
            return this.mNames[n];
        }
        return null;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.mNum; ++i) {
            n = (n << 4 | n >>> 28) ^ this.mUids[i];
        }
        if (this.mNames != null) {
            for (int i = 0; i < this.mNum; ++i) {
                n = (n << 4 | n >>> 28) ^ this.mNames[i].hashCode();
            }
        }
        return n;
    }

    public boolean remove(WorkSource workSource) {
        if (this.mNum <= 0 || workSource.mNum <= 0) {
            return false;
        }
        if (this.mNames == null && workSource.mNames == null) {
            return this.removeUids(workSource);
        }
        if (this.mNames == null) {
            throw new IllegalArgumentException("Other " + workSource + " has names, but target " + this + " does not");
        }
        if (workSource.mNames == null) {
            throw new IllegalArgumentException("Target " + this + " has names, but other " + workSource + " does not");
        }
        return this.removeUidsAndNames(workSource);
    }

    public void set(int n) {
        this.mNum = 1;
        if (this.mUids == null) {
            this.mUids = new int[2];
        }
        this.mUids[0] = n;
        this.mNames = null;
    }

    public void set(int n, String string2) {
        if (string2 == null) {
            throw new NullPointerException("Name can't be null");
        }
        this.mNum = 1;
        if (this.mUids == null) {
            this.mUids = new int[2];
            this.mNames = new String[2];
        }
        this.mUids[0] = n;
        this.mNames[0] = string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void set(WorkSource workSource) {
        if (workSource == null) {
            this.mNum = 0;
            return;
        }
        this.mNum = workSource.mNum;
        if (workSource.mUids == null) {
            this.mUids = null;
            this.mNames = null;
            return;
        }
        if (this.mUids != null && this.mUids.length >= this.mNum) {
            System.arraycopy((int[])workSource.mUids, (int)0, (int[])this.mUids, (int)0, (int)this.mNum);
        } else {
            this.mUids = (int[])workSource.mUids.clone();
        }
        if (workSource.mNames == null) {
            this.mNames = null;
            return;
        }
        if (this.mNames != null && this.mNames.length >= this.mNum) {
            System.arraycopy(workSource.mNames, 0, this.mNames, 0, this.mNum);
            return;
        }
        this.mNames = (String[])workSource.mNames.clone();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WorkSource[] setReturningDiffs(WorkSource workSource) {
        WorkSource workSource2 = sTmpWorkSource;
        synchronized (workSource2) {
            sNewbWork = null;
            sGoneWork = null;
            this.updateLocked(workSource, true, true);
            if (sNewbWork == null && sGoneWork == null) {
                return null;
            }
            WorkSource[] workSourceArray = new WorkSource[]{sNewbWork, sGoneWork};
            return workSourceArray;
        }
    }

    public int size() {
        return this.mNum;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WorkSource stripNames() {
        if (this.mNum <= 0) {
            return new WorkSource();
        }
        WorkSource workSource = new WorkSource();
        int n = 0;
        while (n < this.mNum) {
            int n2 = this.mUids[n];
            if (n == 0 || -1 != n2) {
                workSource.add(n2);
            }
            ++n;
        }
        return workSource;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("WorkSource{");
        for (int i = 0; i < this.mNum; ++i) {
            if (i != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.mUids[i]);
            if (this.mNames == null) continue;
            stringBuilder.append(" ");
            stringBuilder.append(this.mNames[i]);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mNum);
        parcel.writeIntArray(this.mUids);
        parcel.writeStringArray(this.mNames);
    }
}

