/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.SystemProperties;

public final class Trace {
    private static final int MAX_SECTION_NAME_LEN = 127;
    private static final String TAG = "Trace";
    public static final long TRACE_TAG_ACTIVITY_MANAGER = 64L;
    public static final long TRACE_TAG_ALWAYS = 1L;
    public static final long TRACE_TAG_APP = 4096L;
    public static final long TRACE_TAG_AUDIO = 256L;
    public static final long TRACE_TAG_BIONIC = 65536L;
    public static final long TRACE_TAG_CAMERA = 1024L;
    public static final long TRACE_TAG_DALVIK = 16384L;
    public static final long TRACE_TAG_GRAPHICS = 2L;
    public static final long TRACE_TAG_HAL = 2048L;
    public static final long TRACE_TAG_INPUT = 4L;
    public static final long TRACE_TAG_NEVER = 0L;
    private static final long TRACE_TAG_NOT_READY = Long.MIN_VALUE;
    public static final long TRACE_TAG_POWER = 131072L;
    public static final long TRACE_TAG_RESOURCES = 8192L;
    public static final long TRACE_TAG_RS = 32768L;
    public static final long TRACE_TAG_SYNC_MANAGER = 128L;
    public static final long TRACE_TAG_VIDEO = 512L;
    public static final long TRACE_TAG_VIEW = 8L;
    public static final long TRACE_TAG_WEBVIEW = 16L;
    public static final long TRACE_TAG_WINDOW_MANAGER = 32L;
    private static volatile long sEnabledTags = Long.MIN_VALUE;

    static {
        SystemProperties.addChangeCallback(new Runnable(){

            @Override
            public void run() {
                Trace.cacheEnabledTags();
            }
        });
    }

    private Trace() {
    }

    public static void asyncTraceBegin(long l, String string2, int n) {
        if (Trace.isTagEnabled(l)) {
            Trace.nativeAsyncTraceBegin(l, string2, n);
        }
    }

    public static void asyncTraceEnd(long l, String string2, int n) {
        if (Trace.isTagEnabled(l)) {
            Trace.nativeAsyncTraceEnd(l, string2, n);
        }
    }

    public static void beginSection(String string2) {
        if (Trace.isTagEnabled(4096L)) {
            if (string2.length() > 127) {
                throw new IllegalArgumentException("sectionName is too long");
            }
            Trace.nativeTraceBegin(4096L, string2);
        }
    }

    private static long cacheEnabledTags() {
        long l;
        sEnabledTags = l = Trace.nativeGetEnabledTags();
        return l;
    }

    public static void endSection() {
        if (Trace.isTagEnabled(4096L)) {
            Trace.nativeTraceEnd(4096L);
        }
    }

    public static boolean isTagEnabled(long l) {
        long l2 = sEnabledTags;
        if (l2 == Long.MIN_VALUE) {
            l2 = Trace.cacheEnabledTags();
        }
        return (l2 & l) != 0L;
    }

    private static native void nativeAsyncTraceBegin(long var0, String var2, int var3);

    private static native void nativeAsyncTraceEnd(long var0, String var2, int var3);

    private static native long nativeGetEnabledTags();

    private static native void nativeSetAppTracingAllowed(boolean var0);

    private static native void nativeSetTracingEnabled(boolean var0);

    private static native void nativeTraceBegin(long var0, String var2);

    private static native void nativeTraceCounter(long var0, String var2, int var3);

    private static native void nativeTraceEnd(long var0);

    public static void setAppTracingAllowed(boolean bl) {
        Trace.nativeSetAppTracingAllowed(bl);
        Trace.cacheEnabledTags();
    }

    public static void setTracingEnabled(boolean bl) {
        Trace.nativeSetTracingEnabled(bl);
        Trace.cacheEnabledTags();
    }

    public static void traceBegin(long l, String string2) {
        if (Trace.isTagEnabled(l)) {
            Trace.nativeTraceBegin(l, string2);
        }
    }

    public static void traceCounter(long l, String string2, int n) {
        if (Trace.isTagEnabled(l)) {
            Trace.nativeTraceCounter(l, string2, n);
        }
    }

    public static void traceEnd(long l) {
        if (Trace.isTagEnabled(l)) {
            Trace.nativeTraceEnd(l);
        }
    }
}

