/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import java.util.ArrayList;

public class SystemProperties {
    public static final int PROP_NAME_MAX = 31;
    public static final int PROP_VALUE_MAX = 91;
    private static final ArrayList<Runnable> sChangeCallbacks = new ArrayList();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void addChangeCallback(Runnable runnable) {
        ArrayList<Runnable> arrayList = sChangeCallbacks;
        synchronized (arrayList) {
            if (sChangeCallbacks.size() == 0) {
                SystemProperties.native_add_change_callback();
            }
            sChangeCallbacks.add(runnable);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void callChangeCallbacks() {
        ArrayList<Runnable> arrayList = sChangeCallbacks;
        synchronized (arrayList) {
            if (sChangeCallbacks.size() == 0) {
                return;
            }
            ArrayList<Runnable> arrayList2 = new ArrayList<Runnable>(sChangeCallbacks);
            int n = 0;
            while (n < arrayList2.size()) {
                arrayList2.get(n).run();
                ++n;
            }
            return;
        }
    }

    public static String get(String string2) {
        if (string2.length() > 31) {
            throw new IllegalArgumentException("key.length > 31");
        }
        return SystemProperties.native_get(string2);
    }

    public static String get(String string2, String string3) {
        if (string2.length() > 31) {
            throw new IllegalArgumentException("key.length > 31");
        }
        return SystemProperties.native_get(string2, string3);
    }

    public static boolean getBoolean(String string2, boolean bl) {
        if (string2.length() > 31) {
            throw new IllegalArgumentException("key.length > 31");
        }
        return SystemProperties.native_get_boolean(string2, bl);
    }

    public static int getInt(String string2, int n) {
        if (string2.length() > 31) {
            throw new IllegalArgumentException("key.length > 31");
        }
        return SystemProperties.native_get_int(string2, n);
    }

    public static long getLong(String string2, long l) {
        if (string2.length() > 31) {
            throw new IllegalArgumentException("key.length > 31");
        }
        return SystemProperties.native_get_long(string2, l);
    }

    private static native void native_add_change_callback();

    private static native String native_get(String var0);

    private static native String native_get(String var0, String var1);

    private static native boolean native_get_boolean(String var0, boolean var1);

    private static native int native_get_int(String var0, int var1);

    private static native long native_get_long(String var0, long var1);

    private static native void native_set(String var0, String var1);

    public static void set(String string2, String string3) {
        if (string2.length() > 31) {
            throw new IllegalArgumentException("key.length > 31");
        }
        if (string3 != null && string3.length() > 91) {
            throw new IllegalArgumentException("val.length > 91");
        }
        SystemProperties.native_set(string2, string3);
    }
}

