/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.animation.ValueAnimator;
import android.app.ActivityManagerNative;
import android.app.ActivityThread;
import android.app.ApplicationErrorReport;
import android.app.IActivityManager;
import android.content.Intent;
import android.os.Binder;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.MessageQueue;
import android.os.NetworkOnMainThreadException;
import android.os.Parcel;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Printer;
import android.util.Singleton;
import android.util.Slog;
import android.view.IWindowManager;
import com.android.internal.os.RuntimeInit;
import com.android.internal.util.FastPrintWriter;
import dalvik.system.BlockGuard;
import dalvik.system.CloseGuard;
import dalvik.system.VMDebug;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public final class StrictMode {
    private static final int ALL_THREAD_DETECT_BITS = 15;
    private static final int ALL_VM_DETECT_BITS = 32256;
    public static final int DETECT_CUSTOM = 8;
    public static final int DETECT_DISK_READ = 2;
    public static final int DETECT_DISK_WRITE = 1;
    public static final int DETECT_NETWORK = 4;
    public static final int DETECT_VM_ACTIVITY_LEAKS = 2048;
    public static final int DETECT_VM_CLOSABLE_LEAKS = 1024;
    public static final int DETECT_VM_CURSOR_LEAKS = 512;
    private static final int DETECT_VM_FILE_URI_EXPOSURE = 16384;
    private static final int DETECT_VM_INSTANCE_LEAKS = 4096;
    public static final int DETECT_VM_REGISTRATION_LEAKS = 8192;
    public static final String DISABLE_PROPERTY = "persist.sys.strictmode.disable";
    private static final HashMap<Class, Integer> EMPTY_CLASS_LIMIT_MAP;
    private static final boolean IS_ENG_BUILD = false;
    private static final boolean IS_USER_BUILD = false;
    private static final boolean LOG_V = false;
    private static final int MAX_OFFENSES_PER_LOOP = 10;
    private static final int MAX_SPAN_TAGS = 20;
    private static final long MIN_DIALOG_INTERVAL_MS = 30000L;
    private static final long MIN_LOG_INTERVAL_MS = 1000L;
    private static final Span NO_OP_SPAN;
    public static final int PENALTY_DEATH = 64;
    public static final int PENALTY_DEATH_ON_NETWORK = 512;
    public static final int PENALTY_DIALOG = 32;
    public static final int PENALTY_DROPBOX = 128;
    public static final int PENALTY_FLASH = 2048;
    public static final int PENALTY_GATHER = 256;
    public static final int PENALTY_LOG = 16;
    private static final String TAG = "StrictMode";
    private static final int THREAD_PENALTY_MASK = 3056;
    public static final String VISUAL_PROPERTY = "persist.sys.strictmode.visual";
    private static final int VM_PENALTY_MASK = 208;
    private static final ThreadLocal<ArrayList<ViolationInfo>> gatheredViolations;
    private static final AtomicInteger sDropboxCallsInFlight;
    private static final HashMap<Class, Integer> sExpectedActivityInstanceCount;
    private static boolean sIsIdlerRegistered;
    private static long sLastInstanceCountCheckMillis;
    private static final HashMap<Integer, Long> sLastVmViolationTime;
    private static final MessageQueue.IdleHandler sProcessIdleHandler;
    private static final ThreadLocal<ThreadSpanState> sThisThreadSpanState;
    private static volatile VmPolicy sVmPolicy;
    private static volatile int sVmPolicyMask;
    private static Singleton<IWindowManager> sWindowManager;
    private static final ThreadLocal<AndroidBlockGuardPolicy> threadAndroidPolicy;
    private static final ThreadLocal<Handler> threadHandler;
    private static final ThreadLocal<ArrayList<ViolationInfo>> violationsBeingTimed;

    static {
        LOG_V = Log.isLoggable(TAG, 2);
        IS_USER_BUILD = "user".equals(Build.TYPE);
        IS_ENG_BUILD = "eng".equals(Build.TYPE);
        EMPTY_CLASS_LIMIT_MAP = new HashMap();
        sVmPolicyMask = 0;
        sVmPolicy = VmPolicy.LAX;
        sDropboxCallsInFlight = new AtomicInteger(0);
        gatheredViolations = new ThreadLocal<ArrayList<ViolationInfo>>(){

            @Override
            protected ArrayList<ViolationInfo> initialValue() {
                return null;
            }
        };
        violationsBeingTimed = new ThreadLocal<ArrayList<ViolationInfo>>(){

            @Override
            protected ArrayList<ViolationInfo> initialValue() {
                return new ArrayList<ViolationInfo>();
            }
        };
        threadHandler = new ThreadLocal<Handler>(){

            @Override
            protected Handler initialValue() {
                return new Handler();
            }
        };
        threadAndroidPolicy = new ThreadLocal<AndroidBlockGuardPolicy>(){

            @Override
            protected AndroidBlockGuardPolicy initialValue() {
                return new AndroidBlockGuardPolicy(0);
            }
        };
        sLastInstanceCountCheckMillis = 0L;
        sIsIdlerRegistered = false;
        sProcessIdleHandler = new MessageQueue.IdleHandler(){

            @Override
            public boolean queueIdle() {
                long l = SystemClock.uptimeMillis();
                if (l - sLastInstanceCountCheckMillis > 30000L) {
                    StrictMode.access$1502(l);
                    StrictMode.conditionallyCheckInstanceCounts();
                }
                return true;
            }
        };
        sLastVmViolationTime = new HashMap();
        NO_OP_SPAN = new Span(){

            @Override
            public void finish() {
            }
        };
        sThisThreadSpanState = new ThreadLocal<ThreadSpanState>(){

            @Override
            protected ThreadSpanState initialValue() {
                return new ThreadSpanState();
            }
        };
        sWindowManager = new Singleton<IWindowManager>(){

            @Override
            protected IWindowManager create() {
                return IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
            }
        };
        sExpectedActivityInstanceCount = new HashMap();
    }

    private StrictMode() {
    }

    static /* synthetic */ long access$1502(long l) {
        sLastInstanceCountCheckMillis = l;
        return l;
    }

    public static ThreadPolicy allowThreadDiskReads() {
        int n = StrictMode.getThreadPolicyMask();
        int n2 = n & 0xFFFFFFFD;
        if (n2 != n) {
            StrictMode.setThreadPolicyMask(n2);
        }
        return new ThreadPolicy(n);
    }

    public static ThreadPolicy allowThreadDiskWrites() {
        int n = StrictMode.getThreadPolicyMask();
        int n2 = n & 0xFFFFFFFC;
        if (n2 != n) {
            StrictMode.setThreadPolicyMask(n2);
        }
        return new ThreadPolicy(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean amTheSystemServerProcess() {
        if (Process.myUid() == 1000) {
            Throwable throwable = new Throwable();
            throwable.fillInStackTrace();
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            int n = stackTraceElementArray.length;
            for (int i = 0; i < n; ++i) {
                String string2 = stackTraceElementArray[i].getClassName();
                if (string2 == null || !string2.startsWith("com.android.server.")) continue;
                return true;
            }
        }
        return false;
    }

    static void clearGatheredViolations() {
        gatheredViolations.set(null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void conditionallyCheckInstanceCounts() {
        VmPolicy vmPolicy = StrictMode.getVmPolicy();
        if (vmPolicy.classInstanceLimit.size() != 0) {
            System.gc();
            System.runFinalization();
            System.gc();
            for (Map.Entry<Class, Integer> entry : vmPolicy.classInstanceLimit.entrySet()) {
                Class clazz = entry.getKey();
                int n = entry.getValue();
                long l = VMDebug.countInstancesOfClass((Class)clazz, (boolean)false);
                if (l <= (long)n) continue;
                InstanceCountViolation instanceCountViolation = new InstanceCountViolation(clazz, l, n);
                StrictMode.onVmPolicyViolation(instanceCountViolation.getMessage(), instanceCountViolation);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean conditionallyEnableDebugLogging() {
        boolean bl = SystemProperties.getBoolean(VISUAL_PROPERTY, false) && !StrictMode.amTheSystemServerProcess();
        boolean bl2 = SystemProperties.getBoolean(DISABLE_PROPERTY, false);
        if (!bl && (IS_USER_BUILD || bl2)) {
            StrictMode.setCloseGuardEnabled(false);
            return false;
        }
        if (IS_ENG_BUILD) {
            bl = true;
        }
        int n = 7;
        if (!IS_USER_BUILD) {
            n |= 0x80;
        }
        if (bl) {
            n |= 0x800;
        }
        StrictMode.setThreadPolicyMask(n);
        if (IS_USER_BUILD) {
            StrictMode.setCloseGuardEnabled(false);
            return true;
        }
        VmPolicy.Builder builder = new VmPolicy.Builder().detectAll().penaltyDropBox();
        if (IS_ENG_BUILD) {
            builder.penaltyLog();
        }
        StrictMode.setVmPolicy(builder.build());
        StrictMode.setCloseGuardEnabled(StrictMode.vmClosableObjectLeaksEnabled());
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void decrementExpectedActivityCount(Class clazz) {
        long l;
        int n;
        block11: {
            block10: {
                if (clazz == null) break block10;
                synchronized (StrictMode.class) {
                    if ((0x800 & StrictMode.sVmPolicy.mask) == 0) {
                        return;
                    }
                    Integer n2 = sExpectedActivityInstanceCount.get(clazz);
                    int n3 = n2 != null && n2 != 0 ? -1 + n2 : 0;
                    if (n3 == 0) {
                        sExpectedActivityInstanceCount.remove(clazz);
                    } else {
                        sExpectedActivityInstanceCount.put(clazz, n3);
                    }
                    n = n3 + 1;
                    if (InstanceTracker.getInstanceCount(clazz) <= n) break block10;
                }
                System.gc();
                System.runFinalization();
                System.gc();
                l = VMDebug.countInstancesOfClass((Class)clazz, (boolean)false);
                if (l > (long)n) break block11;
            }
            return;
        }
        InstanceCountViolation instanceCountViolation = new InstanceCountViolation(clazz, l, n);
        StrictMode.onVmPolicyViolation(instanceCountViolation.getMessage(), instanceCountViolation);
    }

    private static void dropboxViolationAsync(final int n, final ViolationInfo violationInfo) {
        int n2 = sDropboxCallsInFlight.incrementAndGet();
        if (n2 > 20) {
            sDropboxCallsInFlight.decrementAndGet();
            return;
        }
        if (LOG_V) {
            Log.d(TAG, "Dropboxing async; in-flight=" + n2);
        }
        new Thread("callActivityManagerForStrictModeDropbox"){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                Process.setThreadPriority(10);
                try {
                    IActivityManager iActivityManager = ActivityManagerNative.getDefault();
                    if (iActivityManager == null) {
                        Log.d(StrictMode.TAG, "No activity manager; failed to Dropbox violation.");
                    } else {
                        iActivityManager.handleApplicationStrictModeViolation(RuntimeInit.getApplicationObject(), n, violationInfo);
                    }
                }
                catch (RemoteException remoteException) {
                    Log.e(StrictMode.TAG, "RemoteException handling StrictMode violation", remoteException);
                }
                int n2 = sDropboxCallsInFlight.decrementAndGet();
                if (LOG_V) {
                    Log.d(StrictMode.TAG, "Dropbox complete; in-flight=" + n2);
                }
            }
        }.start();
    }

    public static void enableDeathOnNetwork() {
        StrictMode.setThreadPolicyMask(0x200 | (4 | StrictMode.getThreadPolicyMask()));
    }

    public static void enableDefaults() {
        StrictMode.setThreadPolicy(new ThreadPolicy.Builder().detectAll().penaltyLog().build());
        StrictMode.setVmPolicy(new VmPolicy.Builder().detectAll().penaltyLog().build());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Span enterCriticalSpan(String string2) {
        if (IS_USER_BUILD) {
            return NO_OP_SPAN;
        }
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException("name must be non-null and non-empty");
        }
        ThreadSpanState threadSpanState = sThisThreadSpanState.get();
        synchronized (threadSpanState) {
            Span span;
            if (threadSpanState.mFreeListHead != null) {
                span = threadSpanState.mFreeListHead;
                threadSpanState.mFreeListHead = span.mNext;
                threadSpanState.mFreeListSize = -1 + threadSpanState.mFreeListSize;
            } else {
                Span span2;
                span = span2 = new Span(threadSpanState);
            }
            Span.access$1902(span, string2);
            Span.access$2002(span, SystemClock.uptimeMillis());
            Span.access$1802(span, threadSpanState.mActiveHead);
            Span.access$2102(span, null);
            threadSpanState.mActiveHead = span;
            threadSpanState.mActiveSize = 1 + threadSpanState.mActiveSize;
            if (span.mNext != null) {
                Span.access$2102(span.mNext, span);
            }
            if (LOG_V) {
                Log.d(TAG, "Span enter=" + string2 + "; size=" + threadSpanState.mActiveSize);
            }
            return span;
        }
    }

    private static void executeDeathPenalty(ViolationInfo violationInfo) {
        int n = StrictMode.parseViolationFromMessage(violationInfo.crashInfo.exceptionMessage);
        throw new StrictModeViolation(violationInfo.policy, n, null);
    }

    public static ThreadPolicy getThreadPolicy() {
        return new ThreadPolicy(StrictMode.getThreadPolicyMask());
    }

    public static int getThreadPolicyMask() {
        return BlockGuard.getThreadPolicy().getPolicyMask();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static VmPolicy getVmPolicy() {
        synchronized (StrictMode.class) {
            return sVmPolicy;
        }
    }

    static boolean hasGatheredViolations() {
        return gatheredViolations.get() != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void incrementExpectedActivityCount(Class clazz) {
        if (clazz == null) {
            return;
        }
        synchronized (StrictMode.class) {
            int n;
            if ((0x800 & StrictMode.sVmPolicy.mask) == 0) {
                return;
            }
            Integer n2 = sExpectedActivityInstanceCount.get(clazz);
            if (n2 == null) {
                n = 1;
            } else {
                int n3 = n2;
                n = n3 + 1;
            }
            Integer n4 = n;
            sExpectedActivityInstanceCount.put(clazz, n4);
            return;
        }
    }

    public static void noteDiskRead() {
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (!(policy instanceof AndroidBlockGuardPolicy)) {
            return;
        }
        ((AndroidBlockGuardPolicy)policy).onReadFromDisk();
    }

    public static void noteDiskWrite() {
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (!(policy instanceof AndroidBlockGuardPolicy)) {
            return;
        }
        ((AndroidBlockGuardPolicy)policy).onWriteToDisk();
    }

    public static void noteSlowCall(String string2) {
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (!(policy instanceof AndroidBlockGuardPolicy)) {
            return;
        }
        ((AndroidBlockGuardPolicy)policy).onCustomSlowCall(string2);
    }

    private static void onBinderStrictModePolicyChange(int n) {
        StrictMode.setBlockGuardPolicy(n);
    }

    public static void onFileUriExposed(String string2) {
        String string3 = "file:// Uri exposed through " + string2;
        StrictMode.onVmPolicyViolation(string3, new Throwable(string3));
    }

    public static void onIntentReceiverLeaked(Throwable throwable) {
        StrictMode.onVmPolicyViolation(null, throwable);
    }

    public static void onServiceConnectionLeaked(Throwable throwable) {
        StrictMode.onVmPolicyViolation(null, throwable);
    }

    public static void onSqliteObjectLeaked(String string2, Throwable throwable) {
        StrictMode.onVmPolicyViolation(string2, throwable);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void onVmPolicyViolation(String string2, Throwable throwable) {
        boolean bl = (0x80 & sVmPolicyMask) != 0;
        boolean bl2 = (0x40 & sVmPolicyMask) != 0;
        boolean bl3 = (0x10 & sVmPolicyMask) != 0;
        ViolationInfo violationInfo = new ViolationInfo(throwable, sVmPolicyMask);
        violationInfo.numAnimationsRunning = 0;
        violationInfo.tags = null;
        violationInfo.broadcastIntentAction = null;
        Integer n = violationInfo.hashCode();
        long l = SystemClock.uptimeMillis();
        long l2 = 0L;
        long l3 = Long.MAX_VALUE;
        HashMap<Integer, Long> hashMap = sLastVmViolationTime;
        // MONITORENTER : hashMap
        if (sLastVmViolationTime.containsKey(n)) {
            l2 = sLastVmViolationTime.get(n);
            l3 = l - l2;
        }
        if (l3 > 1000L) {
            sLastVmViolationTime.put(n, l);
        }
        // MONITOREXIT : hashMap
        if (bl3 && l3 > 1000L) {
            Log.e(TAG, string2, throwable);
        }
        int n2 = 0x80 | 0x7E00 & sVmPolicyMask;
        if (bl && !bl2) {
            StrictMode.dropboxViolationAsync(n2, violationInfo);
            return;
        }
        if (bl && l2 == 0L) {
            int n3 = StrictMode.getThreadPolicyMask();
            try {
                StrictMode.setThreadPolicyMask(0);
                ActivityManagerNative.getDefault().handleApplicationStrictModeViolation(RuntimeInit.getApplicationObject(), n2, violationInfo);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "RemoteException trying to handle StrictMode violation", remoteException);
            }
            finally {
                StrictMode.setThreadPolicyMask(n3);
            }
        }
        if (!bl2) return;
        System.err.println("StrictMode VmPolicy violation with POLICY_DEATH; shutting down.");
        Process.killProcess(Process.myPid());
        System.exit(10);
    }

    public static void onWebViewMethodCalledOnWrongThread(Throwable throwable) {
        StrictMode.onVmPolicyViolation(null, throwable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int parsePolicyFromMessage(String string2) {
        if (string2 == null) return 0;
        if (!string2.startsWith("policy=")) {
            return 0;
        }
        int n = string2.indexOf(32);
        if (n == -1) return 0;
        String string3 = string2.substring(7, n);
        try {
            return Integer.valueOf(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int parseViolationFromMessage(String string2) {
        if (string2 == null) {
            return 0;
        }
        int n = string2.indexOf("violation=");
        if (n == -1) return 0;
        int n2 = n + "violation=".length();
        int n3 = string2.indexOf(32, n2);
        if (n3 == -1) {
            n3 = string2.length();
        }
        String string3 = string2.substring(n2, n3);
        try {
            return Integer.valueOf(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static void readAndHandleBinderCallViolations(Parcel parcel) {
        StringWriter stringWriter = new StringWriter();
        FastPrintWriter fastPrintWriter = new FastPrintWriter(stringWriter, false, 256);
        new LogStackTrace().printStackTrace(fastPrintWriter);
        ((PrintWriter)fastPrintWriter).flush();
        String string2 = stringWriter.toString();
        int n = StrictMode.getThreadPolicyMask();
        boolean bl = (n & 0x100) != 0;
        int n2 = parcel.readInt();
        for (int i = 0; i < n2; ++i) {
            String string3;
            if (LOG_V) {
                Log.d(TAG, "strict mode violation stacks read from binder call.  i=" + i);
            }
            boolean bl2 = !bl;
            ViolationInfo violationInfo = new ViolationInfo(parcel, bl2);
            if (violationInfo.crashInfo.stackTrace != null && violationInfo.crashInfo.stackTrace.length() > 10000) {
                string3 = violationInfo.crashInfo.stackTrace.substring(256);
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                ApplicationErrorReport.CrashInfo crashInfo = violationInfo.crashInfo;
                crashInfo.stackTrace = stringBuilder.append(crashInfo.stackTrace).append("# via Binder call with stack:\n").append(string2).toString();
                BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
                if (!(policy instanceof AndroidBlockGuardPolicy)) continue;
                ((AndroidBlockGuardPolicy)policy).handleViolationWithTimingAttempt(violationInfo);
                continue;
            }
            while (i < n2) {
                boolean bl3 = !bl;
                new ViolationInfo(parcel, bl3);
                ++i;
            }
            StrictMode.clearGatheredViolations();
            Slog.wtfStack(TAG, "Stack is too large: numViolations=" + n2 + " policy=#" + Integer.toHexString(n) + " front=" + string3);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void setBlockGuardPolicy(int n) {
        AndroidBlockGuardPolicy androidBlockGuardPolicy;
        if (n == 0) {
            BlockGuard.setThreadPolicy((BlockGuard.Policy)BlockGuard.LAX_POLICY);
            return;
        }
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (policy instanceof AndroidBlockGuardPolicy) {
            androidBlockGuardPolicy = (AndroidBlockGuardPolicy)policy;
        } else {
            androidBlockGuardPolicy = threadAndroidPolicy.get();
            BlockGuard.setThreadPolicy((BlockGuard.Policy)androidBlockGuardPolicy);
        }
        androidBlockGuardPolicy.setPolicyMask(n);
    }

    private static void setCloseGuardEnabled(boolean bl) {
        if (!(CloseGuard.getReporter() instanceof AndroidCloseGuardReporter)) {
            CloseGuard.setReporter((CloseGuard.Reporter)new AndroidCloseGuardReporter());
        }
        CloseGuard.setEnabled((boolean)bl);
    }

    public static void setThreadPolicy(ThreadPolicy threadPolicy) {
        StrictMode.setThreadPolicyMask(threadPolicy.mask);
    }

    private static void setThreadPolicyMask(int n) {
        StrictMode.setBlockGuardPolicy(n);
        Binder.setThreadStrictModePolicy(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setVmPolicy(VmPolicy vmPolicy) {
        synchronized (StrictMode.class) {
            sVmPolicy = vmPolicy;
            sVmPolicyMask = vmPolicy.mask;
            StrictMode.setCloseGuardEnabled(StrictMode.vmClosableObjectLeaksEnabled());
            Looper looper = Looper.getMainLooper();
            if (looper != null) {
                MessageQueue messageQueue = looper.mQueue;
                if (vmPolicy.classInstanceLimit.size() == 0 || (0xD0 & sVmPolicyMask) == 0) {
                    messageQueue.removeIdleHandler(sProcessIdleHandler);
                    sIsIdlerRegistered = false;
                } else if (!sIsIdlerRegistered) {
                    messageQueue.addIdleHandler(sProcessIdleHandler);
                    sIsIdlerRegistered = true;
                }
            }
            return;
        }
    }

    private static boolean tooManyViolationsThisLoop() {
        return violationsBeingTimed.get().size() >= 10;
    }

    public static Object trackActivity(Object object) {
        return new InstanceTracker(object);
    }

    public static boolean vmClosableObjectLeaksEnabled() {
        return (0x400 & sVmPolicyMask) != 0;
    }

    public static boolean vmFileUriExposureEnabled() {
        return (0x4000 & sVmPolicyMask) != 0;
    }

    public static boolean vmRegistrationLeaksEnabled() {
        return (0x2000 & sVmPolicyMask) != 0;
    }

    public static boolean vmSqliteObjectLeaksEnabled() {
        return (0x200 & sVmPolicyMask) != 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    static void writeGatheredViolationsToParcel(Parcel parcel) {
        ArrayList<ViolationInfo> arrayList = gatheredViolations.get();
        if (arrayList == null) {
            parcel.writeInt(0);
        } else {
            parcel.writeInt(arrayList.size());
            for (int i = 0; i < arrayList.size(); ++i) {
                int n = parcel.dataPosition();
                arrayList.get(i).writeToParcel(parcel, 0);
                if (parcel.dataPosition() - n <= 10240) continue;
                Slog.d(TAG, "Wrote violation #" + i + " of " + arrayList.size() + ": " + (parcel.dataPosition() - n) + " bytes");
            }
            if (LOG_V) {
                Log.d(TAG, "wrote violations to response parcel; num=" + arrayList.size());
            }
            arrayList.clear();
        }
        gatheredViolations.set(null);
    }

    private static class AndroidBlockGuardPolicy
    implements BlockGuard.Policy {
        private ArrayMap<Integer, Long> mLastViolationTime;
        private int mPolicyMask;

        public AndroidBlockGuardPolicy(int n) {
            this.mPolicyMask = n;
        }

        public int getPolicyMask() {
            return this.mPolicyMask;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void handleViolation(ViolationInfo violationInfo) {
            if (violationInfo == null || violationInfo.crashInfo == null || violationInfo.crashInfo.stackTrace == null) {
                Log.wtf(StrictMode.TAG, "unexpected null stacktrace");
                return;
            }
            if (LOG_V) {
                Log.d(StrictMode.TAG, "handleViolation; policy=" + violationInfo.policy);
            }
            if ((0x100 & violationInfo.policy) != 0) {
                ViolationInfo violationInfo2;
                ArrayList<ViolationInfo> arrayList = (ArrayList<ViolationInfo>)gatheredViolations.get();
                if (arrayList == null) {
                    arrayList = new ArrayList<ViolationInfo>(1);
                    gatheredViolations.set(arrayList);
                } else if (arrayList.size() >= 5) {
                    return;
                }
                Iterator iterator = arrayList.iterator();
                do {
                    if (!iterator.hasNext()) {
                        arrayList.add(violationInfo);
                        return;
                    }
                    violationInfo2 = (ViolationInfo)iterator.next();
                } while (!violationInfo.crashInfo.stackTrace.equals(violationInfo2.crashInfo.stackTrace));
                return;
            }
            Integer n = violationInfo.hashCode();
            long l = 0L;
            if (this.mLastViolationTime != null) {
                Long l2 = this.mLastViolationTime.get(n);
                if (l2 != null) {
                    l = l2;
                }
            } else {
                this.mLastViolationTime = new ArrayMap(1);
            }
            long l3 = SystemClock.uptimeMillis();
            this.mLastViolationTime.put(n, l3);
            long l4 = l == 0L ? Long.MAX_VALUE : l3 - l;
            if ((0x10 & violationInfo.policy) != 0 && l4 > 1000L) {
                if (violationInfo.durationMillis != -1) {
                    Log.d(StrictMode.TAG, "StrictMode policy violation; ~duration=" + violationInfo.durationMillis + " ms: " + violationInfo.crashInfo.stackTrace);
                } else {
                    Log.d(StrictMode.TAG, "StrictMode policy violation: " + violationInfo.crashInfo.stackTrace);
                }
            }
            int n2 = 0x20 & violationInfo.policy;
            int n3 = 0;
            if (n2 != 0) {
                long l5 = l4 - 30000L;
                long l6 = l5 == 0L ? 0 : (l5 < 0L ? -1 : 1);
                n3 = 0;
                if (l6 > 0) {
                    n3 = 0 | 0x20;
                }
            }
            if ((0x80 & violationInfo.policy) != 0 && l == 0L) {
                n3 = 0x80 | n3;
            }
            if (n3 != 0) {
                int n4 = n3 | StrictMode.parseViolationFromMessage(violationInfo.crashInfo.exceptionMessage);
                int n5 = StrictMode.getThreadPolicyMask();
                boolean bl = (0xBF0 & violationInfo.policy) == 128;
                if (bl) {
                    StrictMode.dropboxViolationAsync(n4, violationInfo);
                    return;
                }
                try {
                    StrictMode.setThreadPolicyMask(0);
                    ActivityManagerNative.getDefault().handleApplicationStrictModeViolation(RuntimeInit.getApplicationObject(), n4, violationInfo);
                }
                catch (RemoteException remoteException) {
                    Log.e(StrictMode.TAG, "RemoteException trying to handle StrictMode violation", remoteException);
                }
                finally {
                    StrictMode.setThreadPolicyMask(n5);
                }
            }
            if ((0x40 & violationInfo.policy) == 0) return;
            StrictMode.executeDeathPenalty(violationInfo);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void handleViolationWithTimingAttempt(ViolationInfo violationInfo) {
            if (Looper.myLooper() == null || (0xBF0 & violationInfo.policy) == 64) {
                violationInfo.durationMillis = -1;
                this.handleViolation(violationInfo);
                return;
            }
            final ArrayList arrayList = (ArrayList)violationsBeingTimed.get();
            if (arrayList.size() >= 10) return;
            arrayList.add(violationInfo);
            if (arrayList.size() > 1) return;
            final IWindowManager iWindowManager = (0x800 & violationInfo.policy) != 0 ? (IWindowManager)sWindowManager.get() : null;
            if (iWindowManager != null) {
                try {
                    iWindowManager.showStrictModeViolation(true);
                }
                catch (RemoteException remoteException) {}
            }
            ((Handler)threadHandler.get()).postAtFrontOfQueue(new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    long l = SystemClock.uptimeMillis();
                    if (iWindowManager != null) {
                        try {
                            iWindowManager.showStrictModeViolation(false);
                        }
                        catch (RemoteException remoteException) {}
                    }
                    int n = 0;
                    while (true) {
                        if (n >= arrayList.size()) {
                            arrayList.clear();
                            return;
                        }
                        ViolationInfo violationInfo = (ViolationInfo)arrayList.get(n);
                        violationInfo.violationNumThisLoop = n + 1;
                        violationInfo.durationMillis = (int)(l - violationInfo.violationUptimeMillis);
                        AndroidBlockGuardPolicy.this.handleViolation(violationInfo);
                        ++n;
                    }
                }
            });
        }

        /*
         * Enabled aggressive block sorting
         */
        void onCustomSlowCall(String string2) {
            if ((8 & this.mPolicyMask) == 0 || StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            StrictModeCustomViolation strictModeCustomViolation = new StrictModeCustomViolation(this.mPolicyMask, string2);
            strictModeCustomViolation.fillInStackTrace();
            this.startHandlingViolationException(strictModeCustomViolation);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onNetwork() {
            block5: {
                block4: {
                    if ((4 & this.mPolicyMask) == 0) break block4;
                    if ((0x200 & this.mPolicyMask) != 0) {
                        throw new NetworkOnMainThreadException();
                    }
                    if (!StrictMode.tooManyViolationsThisLoop()) break block5;
                }
                return;
            }
            StrictModeNetworkViolation strictModeNetworkViolation = new StrictModeNetworkViolation(this.mPolicyMask);
            strictModeNetworkViolation.fillInStackTrace();
            this.startHandlingViolationException(strictModeNetworkViolation);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onReadFromDisk() {
            if ((2 & this.mPolicyMask) == 0 || StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            StrictModeDiskReadViolation strictModeDiskReadViolation = new StrictModeDiskReadViolation(this.mPolicyMask);
            strictModeDiskReadViolation.fillInStackTrace();
            this.startHandlingViolationException(strictModeDiskReadViolation);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onWriteToDisk() {
            if ((1 & this.mPolicyMask) == 0 || StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            StrictModeDiskWriteViolation strictModeDiskWriteViolation = new StrictModeDiskWriteViolation(this.mPolicyMask);
            strictModeDiskWriteViolation.fillInStackTrace();
            this.startHandlingViolationException(strictModeDiskWriteViolation);
        }

        public void setPolicyMask(int n) {
            this.mPolicyMask = n;
        }

        void startHandlingViolationException(BlockGuard.BlockGuardPolicyException blockGuardPolicyException) {
            ViolationInfo violationInfo = new ViolationInfo((Throwable)blockGuardPolicyException, blockGuardPolicyException.getPolicy());
            violationInfo.violationUptimeMillis = SystemClock.uptimeMillis();
            this.handleViolationWithTimingAttempt(violationInfo);
        }

        public String toString() {
            return "AndroidBlockGuardPolicy; mPolicyMask=" + this.mPolicyMask;
        }
    }

    private static class AndroidCloseGuardReporter
    implements CloseGuard.Reporter {
        private AndroidCloseGuardReporter() {
        }

        public void report(String string2, Throwable throwable) {
            StrictMode.onVmPolicyViolation(string2, throwable);
        }
    }

    private static class InstanceCountViolation
    extends Throwable {
        private static final StackTraceElement[] FAKE_STACK;
        final Class mClass;
        final long mInstances;
        final int mLimit;

        static {
            StackTraceElement[] stackTraceElementArray = new StackTraceElement[]{new StackTraceElement("android.os.StrictMode", "setClassInstanceLimit", "StrictMode.java", 1)};
            FAKE_STACK = stackTraceElementArray;
        }

        public InstanceCountViolation(Class clazz, long l, int n) {
            super(clazz.toString() + "; instances=" + l + "; limit=" + n);
            this.setStackTrace(FAKE_STACK);
            this.mClass = clazz;
            this.mInstances = l;
            this.mLimit = n;
        }
    }

    private static final class InstanceTracker {
        private static final HashMap<Class<?>, Integer> sInstanceCounts = new HashMap();
        private final Class<?> mKlass;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public InstanceTracker(Object object) {
            this.mKlass = object.getClass();
            HashMap<Class<?>, Integer> hashMap = sInstanceCounts;
            synchronized (hashMap) {
                Integer n = sInstanceCounts.get(this.mKlass);
                int n2 = n != null ? 1 + n : 1;
                sInstanceCounts.put(this.mKlass, n2);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static int getInstanceCount(Class<?> clazz) {
            HashMap<Class<?>, Integer> hashMap = sInstanceCounts;
            synchronized (hashMap) {
                Integer n = sInstanceCounts.get(clazz);
                if (n == null) return 0;
                return n;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void finalize() throws Throwable {
            block6: {
                try {
                    HashMap<Class<?>, Integer> hashMap = sInstanceCounts;
                    synchronized (hashMap) {
                        Integer n = sInstanceCounts.get(this.mKlass);
                        if (n == null) break block6;
                        int n2 = -1 + n;
                        if (n2 <= 0) break block7;
                        sInstanceCounts.put(this.mKlass, n2);
                    }
                }
                catch (Throwable throwable) {
                    super.finalize();
                    throw throwable;
                }
                {
                    block7: {
                        break block6;
                    }
                    sInstanceCounts.remove(this.mKlass);
                }
            }
            super.finalize();
        }
    }

    private static class LogStackTrace
    extends Exception {
        private LogStackTrace() {
        }
    }

    public static class Span {
        private final ThreadSpanState mContainerState;
        private long mCreateMillis;
        private String mName;
        private Span mNext;
        private Span mPrev;

        protected Span() {
            this.mContainerState = null;
        }

        Span(ThreadSpanState threadSpanState) {
            this.mContainerState = threadSpanState;
        }

        static /* synthetic */ Span access$1802(Span span, Span span2) {
            span.mNext = span2;
            return span2;
        }

        static /* synthetic */ String access$1902(Span span, String string2) {
            span.mName = string2;
            return string2;
        }

        static /* synthetic */ long access$2002(Span span, long l) {
            span.mCreateMillis = l;
            return l;
        }

        static /* synthetic */ Span access$2102(Span span, Span span2) {
            span.mPrev = span2;
            return span2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void finish() {
            ThreadSpanState threadSpanState = this.mContainerState;
            synchronized (threadSpanState) {
                if (this.mName == null) {
                    return;
                }
                if (this.mPrev != null) {
                    this.mPrev.mNext = this.mNext;
                }
                if (this.mNext != null) {
                    this.mNext.mPrev = this.mPrev;
                }
                if (threadSpanState.mActiveHead == this) {
                    threadSpanState.mActiveHead = this.mNext;
                }
                threadSpanState.mActiveSize = -1 + threadSpanState.mActiveSize;
                if (LOG_V) {
                    Log.d(StrictMode.TAG, "Span finished=" + this.mName + "; size=" + threadSpanState.mActiveSize);
                }
                this.mCreateMillis = -1L;
                this.mName = null;
                this.mPrev = null;
                this.mNext = null;
                if (threadSpanState.mFreeListSize < 5) {
                    this.mNext = threadSpanState.mFreeListHead;
                    threadSpanState.mFreeListHead = this;
                    threadSpanState.mFreeListSize = 1 + threadSpanState.mFreeListSize;
                }
                return;
            }
        }
    }

    private static class StrictModeCustomViolation
    extends StrictModeViolation {
        public StrictModeCustomViolation(int n, String string2) {
            super(n, 8, string2);
        }
    }

    private static class StrictModeDiskReadViolation
    extends StrictModeViolation {
        public StrictModeDiskReadViolation(int n) {
            super(n, 2, null);
        }
    }

    private static class StrictModeDiskWriteViolation
    extends StrictModeViolation {
        public StrictModeDiskWriteViolation(int n) {
            super(n, 1, null);
        }
    }

    public static class StrictModeNetworkViolation
    extends StrictModeViolation {
        public StrictModeNetworkViolation(int n) {
            super(n, 4, null);
        }
    }

    public static class StrictModeViolation
    extends BlockGuard.BlockGuardPolicyException {
        public StrictModeViolation(int n, int n2, String string2) {
            super(n, n2, string2);
        }
    }

    public static final class ThreadPolicy {
        public static final ThreadPolicy LAX = new ThreadPolicy(0);
        final int mask;

        private ThreadPolicy(int n) {
            this.mask = n;
        }

        public String toString() {
            return "[StrictMode.ThreadPolicy; mask=" + this.mask + "]";
        }

        public static final class Builder {
            private int mMask = 0;

            public Builder() {
                this.mMask = 0;
            }

            public Builder(ThreadPolicy threadPolicy) {
                this.mMask = threadPolicy.mask;
            }

            private Builder disable(int n) {
                this.mMask &= ~n;
                return this;
            }

            private Builder enable(int n) {
                this.mMask = n | this.mMask;
                return this;
            }

            public ThreadPolicy build() {
                if (this.mMask != 0 && (0xF0 & this.mMask) == 0) {
                    this.penaltyLog();
                }
                return new ThreadPolicy(this.mMask);
            }

            public Builder detectAll() {
                return this.enable(15);
            }

            public Builder detectCustomSlowCalls() {
                return this.enable(8);
            }

            public Builder detectDiskReads() {
                return this.enable(2);
            }

            public Builder detectDiskWrites() {
                return this.enable(1);
            }

            public Builder detectNetwork() {
                return this.enable(4);
            }

            public Builder penaltyDeath() {
                return this.enable(64);
            }

            public Builder penaltyDeathOnNetwork() {
                return this.enable(512);
            }

            public Builder penaltyDialog() {
                return this.enable(32);
            }

            public Builder penaltyDropBox() {
                return this.enable(128);
            }

            public Builder penaltyFlashScreen() {
                return this.enable(2048);
            }

            public Builder penaltyLog() {
                return this.enable(16);
            }

            public Builder permitAll() {
                return this.disable(15);
            }

            public Builder permitCustomSlowCalls() {
                return this.disable(8);
            }

            public Builder permitDiskReads() {
                return this.disable(2);
            }

            public Builder permitDiskWrites() {
                return this.disable(1);
            }

            public Builder permitNetwork() {
                return this.disable(4);
            }
        }
    }

    private static class ThreadSpanState {
        public Span mActiveHead;
        public int mActiveSize;
        public Span mFreeListHead;
        public int mFreeListSize;

        private ThreadSpanState() {
        }
    }

    public static class ViolationInfo {
        public String broadcastIntentAction;
        public final ApplicationErrorReport.CrashInfo crashInfo;
        public int durationMillis = -1;
        public int numAnimationsRunning = 0;
        public long numInstances = -1L;
        public final int policy;
        public String[] tags;
        public int violationNumThisLoop;
        public long violationUptimeMillis;

        public ViolationInfo() {
            this.crashInfo = null;
            this.policy = 0;
        }

        public ViolationInfo(Parcel parcel) {
            this(parcel, false);
        }

        /*
         * Enabled aggressive block sorting
         */
        public ViolationInfo(Parcel parcel, boolean bl) {
            this.crashInfo = new ApplicationErrorReport.CrashInfo(parcel);
            int n = parcel.readInt();
            this.policy = bl ? n & 0xFFFFFEFF : n;
            this.durationMillis = parcel.readInt();
            this.violationNumThisLoop = parcel.readInt();
            this.numAnimationsRunning = parcel.readInt();
            this.violationUptimeMillis = parcel.readLong();
            this.numInstances = parcel.readLong();
            this.broadcastIntentAction = parcel.readString();
            this.tags = parcel.readStringArray();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public ViolationInfo(Throwable throwable, int n) {
            this.crashInfo = new ApplicationErrorReport.CrashInfo(throwable);
            this.violationUptimeMillis = SystemClock.uptimeMillis();
            this.policy = n;
            this.numAnimationsRunning = ValueAnimator.getCurrentAnimationsCount();
            Intent intent = ActivityThread.getIntentBeingBroadcast();
            if (intent != null) {
                this.broadcastIntentAction = intent.getAction();
            }
            ThreadSpanState threadSpanState = (ThreadSpanState)sThisThreadSpanState.get();
            if (throwable instanceof InstanceCountViolation) {
                this.numInstances = ((InstanceCountViolation)throwable).mInstances;
            }
            synchronized (threadSpanState) {
                int n2 = threadSpanState.mActiveSize;
                if (n2 > 20) {
                    n2 = 20;
                }
                if (n2 != 0) {
                    this.tags = new String[n2];
                    Span span = threadSpanState.mActiveHead;
                    for (int i = 0; span != null && i < n2; ++i) {
                        this.tags[i] = span.mName;
                        span = span.mNext;
                    }
                }
                return;
            }
        }

        public void dump(Printer printer, String string2) {
            this.crashInfo.dump(printer, string2);
            printer.println(string2 + "policy: " + this.policy);
            if (this.durationMillis != -1) {
                printer.println(string2 + "durationMillis: " + this.durationMillis);
            }
            if (this.numInstances != -1L) {
                printer.println(string2 + "numInstances: " + this.numInstances);
            }
            if (this.violationNumThisLoop != 0) {
                printer.println(string2 + "violationNumThisLoop: " + this.violationNumThisLoop);
            }
            if (this.numAnimationsRunning != 0) {
                printer.println(string2 + "numAnimationsRunning: " + this.numAnimationsRunning);
            }
            printer.println(string2 + "violationUptimeMillis: " + this.violationUptimeMillis);
            if (this.broadcastIntentAction != null) {
                printer.println(string2 + "broadcastIntentAction: " + this.broadcastIntentAction);
            }
            if (this.tags != null) {
                String[] stringArray = this.tags;
                int n = stringArray.length;
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    String string3 = stringArray[i];
                    StringBuilder stringBuilder = new StringBuilder().append(string2).append("tag[");
                    int n3 = n2 + 1;
                    printer.println(stringBuilder.append(n2).append("]: ").append(string3).toString());
                    n2 = n3;
                }
            }
        }

        public int hashCode() {
            int n = 629 + this.crashInfo.stackTrace.hashCode();
            if (this.numAnimationsRunning != 0) {
                n *= 37;
            }
            if (this.broadcastIntentAction != null) {
                n = n * 37 + this.broadcastIntentAction.hashCode();
            }
            if (this.tags != null) {
                for (String string2 : this.tags) {
                    n = n * 37 + string2.hashCode();
                }
            }
            return n;
        }

        public void writeToParcel(Parcel parcel, int n) {
            this.crashInfo.writeToParcel(parcel, n);
            int n2 = parcel.dataPosition();
            parcel.writeInt(this.policy);
            parcel.writeInt(this.durationMillis);
            parcel.writeInt(this.violationNumThisLoop);
            parcel.writeInt(this.numAnimationsRunning);
            parcel.writeLong(this.violationUptimeMillis);
            parcel.writeLong(this.numInstances);
            parcel.writeString(this.broadcastIntentAction);
            parcel.writeStringArray(this.tags);
            if (parcel.dataPosition() - n2 > 10240) {
                Slog.d(StrictMode.TAG, "VIO: policy=" + this.policy + " dur=" + this.durationMillis + " numLoop=" + this.violationNumThisLoop + " anim=" + this.numAnimationsRunning + " uptime=" + this.violationUptimeMillis + " numInst=" + this.numInstances);
                Slog.d(StrictMode.TAG, "VIO: action=" + this.broadcastIntentAction);
                Slog.d(StrictMode.TAG, "VIO: tags=" + Arrays.toString(this.tags));
                Slog.d(StrictMode.TAG, "VIO: TOTAL BYTES WRITTEN: " + (parcel.dataPosition() - n2));
            }
        }
    }

    public static final class VmPolicy {
        public static final VmPolicy LAX = new VmPolicy(0, StrictMode.access$100());
        final HashMap<Class, Integer> classInstanceLimit;
        final int mask;

        private VmPolicy(int n, HashMap<Class, Integer> hashMap) {
            if (hashMap == null) {
                throw new NullPointerException("classInstanceLimit == null");
            }
            this.mask = n;
            this.classInstanceLimit = hashMap;
        }

        public String toString() {
            return "[StrictMode.VmPolicy; mask=" + this.mask + "]";
        }

        public static final class Builder {
            private HashMap<Class, Integer> mClassInstanceLimit;
            private boolean mClassInstanceLimitNeedCow = false;
            private int mMask;

            public Builder() {
                this.mMask = 0;
            }

            public Builder(VmPolicy vmPolicy) {
                this.mMask = vmPolicy.mask;
                this.mClassInstanceLimitNeedCow = true;
                this.mClassInstanceLimit = vmPolicy.classInstanceLimit;
            }

            private Builder enable(int n) {
                this.mMask = n | this.mMask;
                return this;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public VmPolicy build() {
                HashMap<Class, Integer> hashMap;
                if (this.mMask != 0 && (0xF0 & this.mMask) == 0) {
                    this.penaltyLog();
                }
                int n = this.mMask;
                if (this.mClassInstanceLimit != null) {
                    hashMap = this.mClassInstanceLimit;
                    return new VmPolicy(n, hashMap);
                }
                hashMap = EMPTY_CLASS_LIMIT_MAP;
                return new VmPolicy(n, hashMap);
            }

            public Builder detectActivityLeaks() {
                return this.enable(2048);
            }

            public Builder detectAll() {
                return this.enable(28160);
            }

            public Builder detectFileUriExposure() {
                return this.enable(16384);
            }

            public Builder detectLeakedClosableObjects() {
                return this.enable(1024);
            }

            public Builder detectLeakedRegistrationObjects() {
                return this.enable(8192);
            }

            public Builder detectLeakedSqlLiteObjects() {
                return this.enable(512);
            }

            public Builder penaltyDeath() {
                return this.enable(64);
            }

            public Builder penaltyDropBox() {
                return this.enable(128);
            }

            public Builder penaltyLog() {
                return this.enable(16);
            }

            /*
             * Enabled aggressive block sorting
             */
            public Builder setClassInstanceLimit(Class clazz, int n) {
                if (clazz == null) {
                    throw new NullPointerException("klass == null");
                }
                if (this.mClassInstanceLimitNeedCow) {
                    if (this.mClassInstanceLimit.containsKey(clazz) && this.mClassInstanceLimit.get(clazz) == n) {
                        return this;
                    }
                    this.mClassInstanceLimitNeedCow = false;
                    this.mClassInstanceLimit = (HashMap)this.mClassInstanceLimit.clone();
                } else if (this.mClassInstanceLimit == null) {
                    this.mClassInstanceLimit = new HashMap();
                }
                this.mMask = 0x1000 | this.mMask;
                this.mClassInstanceLimit.put(clazz, n);
                return this;
            }
        }
    }
}

