/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.util.Slog;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;

public class SELinux {
    private static final int SELINUX_ANDROID_RESTORECON_DATADATA = 16;
    private static final int SELINUX_ANDROID_RESTORECON_FORCE = 8;
    private static final int SELINUX_ANDROID_RESTORECON_NOCHANGE = 1;
    private static final int SELINUX_ANDROID_RESTORECON_RECURSE = 4;
    private static final int SELINUX_ANDROID_RESTORECON_VERBOSE = 2;
    private static final String TAG = "SELinux";

    public static final native boolean checkSELinuxAccess(String var0, String var1, String var2, String var3);

    public static final native String[] getBooleanNames();

    public static final native boolean getBooleanValue(String var0);

    public static final native String getContext();

    public static final native String getFileContext(String var0);

    public static final native String getPeerContext(FileDescriptor var0);

    public static final native String getPidContext(int var0);

    public static final native boolean isSELinuxEnabled();

    public static final native boolean isSELinuxEnforced();

    private static native boolean native_restorecon(String var0, int var1);

    public static boolean restorecon(File file) throws NullPointerException {
        try {
            boolean bl = SELinux.native_restorecon(file.getCanonicalPath(), 0);
            return bl;
        }
        catch (IOException iOException) {
            Slog.e(TAG, "Error getting canonical path. Restorecon failed for " + file.getPath(), iOException);
            return false;
        }
    }

    public static boolean restorecon(String string2) throws NullPointerException {
        if (string2 == null) {
            throw new NullPointerException();
        }
        return SELinux.native_restorecon(string2, 0);
    }

    public static boolean restoreconRecursive(File file) {
        try {
            boolean bl = SELinux.native_restorecon(file.getCanonicalPath(), 4);
            return bl;
        }
        catch (IOException iOException) {
            Slog.e(TAG, "Error getting canonical path. Restorecon failed for " + file.getPath(), iOException);
            return false;
        }
    }

    public static final native boolean setBooleanValue(String var0, boolean var1);

    public static final native boolean setFSCreateContext(String var0);

    public static final native boolean setFileContext(String var0, String var1);

    public static final native boolean setSELinuxEnforce(boolean var0);
}

