/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.util.ArrayMap;

public class RemoteCallbackList<E extends IInterface> {
    private Object[] mActiveBroadcast;
    private int mBroadcastCount = -1;
    ArrayMap<IBinder, Callback> mCallbacks = new ArrayMap();
    private boolean mKilled = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int beginBroadcast() {
        ArrayMap<IBinder, Callback> arrayMap = this.mCallbacks;
        synchronized (arrayMap) {
            int n;
            if (this.mBroadcastCount > 0) {
                throw new IllegalStateException("beginBroadcast() called while already in a broadcast");
            }
            this.mBroadcastCount = n = this.mCallbacks.size();
            if (n <= 0) {
                return 0;
            }
            Object[] objectArray = this.mActiveBroadcast;
            if (objectArray == null || objectArray.length < n) {
                this.mActiveBroadcast = objectArray = new Object[n];
            }
            int n2 = 0;
            while (n2 < n) {
                objectArray[n2] = this.mCallbacks.valueAt(n2);
                ++n2;
            }
            return n;
        }
    }

    public void finishBroadcast() {
        if (this.mBroadcastCount < 0) {
            throw new IllegalStateException("finishBroadcast() called outside of a broadcast");
        }
        Object[] objectArray = this.mActiveBroadcast;
        if (objectArray != null) {
            int n = this.mBroadcastCount;
            for (int i = 0; i < n; ++i) {
                objectArray[i] = null;
            }
        }
        this.mBroadcastCount = -1;
    }

    public Object getBroadcastCookie(int n) {
        return ((Callback)this.mActiveBroadcast[n]).mCookie;
    }

    public E getBroadcastItem(int n) {
        return ((Callback)this.mActiveBroadcast[n]).mCallback;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getRegisteredCallbackCount() {
        ArrayMap<IBinder, Callback> arrayMap = this.mCallbacks;
        synchronized (arrayMap) {
            if (!this.mKilled) return this.mCallbacks.size();
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void kill() {
        ArrayMap<IBinder, Callback> arrayMap = this.mCallbacks;
        synchronized (arrayMap) {
            int n = -1 + this.mCallbacks.size();
            while (true) {
                if (n < 0) {
                    this.mCallbacks.clear();
                    this.mKilled = true;
                    return;
                }
                Callback callback = this.mCallbacks.valueAt(n);
                callback.mCallback.asBinder().unlinkToDeath(callback, 0);
                --n;
            }
        }
    }

    public void onCallbackDied(E e) {
    }

    public void onCallbackDied(E e, Object object) {
        this.onCallbackDied(e);
    }

    public boolean register(E e) {
        return this.register(e, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean register(E e, Object object) {
        ArrayMap<IBinder, Callback> arrayMap = this.mCallbacks;
        synchronized (arrayMap) {
            if (this.mKilled) {
                return false;
            }
            IBinder iBinder = e.asBinder();
            try {
                Callback callback = new Callback(this, e, object);
                iBinder.linkToDeath(callback, 0);
                this.mCallbacks.put(iBinder, callback);
                return true;
            }
            catch (RemoteException remoteException) {
                return false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean unregister(E e) {
        ArrayMap<IBinder, Callback> arrayMap = this.mCallbacks;
        synchronized (arrayMap) {
            Callback callback = this.mCallbacks.remove(e.asBinder());
            if (callback != null) {
                callback.mCallback.asBinder().unlinkToDeath(callback, 0);
                return true;
            }
            return false;
        }
    }

    private static final class Callback
    implements IBinder.DeathRecipient {
        final E mCallback;
        final Object mCookie;
        final /* synthetic */ RemoteCallbackList this$0;

        Callback(E e, Object object) {
            this.this$0 = var1_1;
            this.mCallback = e;
            this.mCookie = object;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void binderDied() {
            ArrayMap<IBinder, Callback> arrayMap = this.this$0.mCallbacks;
            synchronized (arrayMap) {
                this.this$0.mCallbacks.remove(this.mCallback.asBinder());
            }
            this.this$0.onCallbackDied(this.mCallback, this.mCookie);
        }
    }
}

