/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.BadParcelableException;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.NetworkOnMainThreadException;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.os.StrictMode;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Size;
import android.util.SizeF;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Parcel {
    private static final boolean DEBUG_ARRAY_MAP = false;
    private static final boolean DEBUG_RECYCLE = false;
    private static final int EX_BAD_PARCELABLE = -2;
    private static final int EX_HAS_REPLY_HEADER = -128;
    private static final int EX_ILLEGAL_ARGUMENT = -3;
    private static final int EX_ILLEGAL_STATE = -5;
    private static final int EX_NETWORK_MAIN_THREAD = -6;
    private static final int EX_NULL_POINTER = -4;
    private static final int EX_SECURITY = -1;
    private static final int EX_UNSUPPORTED_OPERATION = -7;
    private static final int POOL_SIZE = 6;
    public static final Parcelable.Creator<String> STRING_CREATOR;
    private static final String TAG = "Parcel";
    private static final int VAL_BOOLEAN = 9;
    private static final int VAL_BOOLEANARRAY = 23;
    private static final int VAL_BUNDLE = 3;
    private static final int VAL_BYTE = 20;
    private static final int VAL_BYTEARRAY = 13;
    private static final int VAL_CHARSEQUENCE = 10;
    private static final int VAL_CHARSEQUENCEARRAY = 24;
    private static final int VAL_DOUBLE = 8;
    private static final int VAL_FLOAT = 7;
    private static final int VAL_IBINDER = 15;
    private static final int VAL_INTARRAY = 18;
    private static final int VAL_INTEGER = 1;
    private static final int VAL_LIST = 11;
    private static final int VAL_LONG = 6;
    private static final int VAL_LONGARRAY = 19;
    private static final int VAL_MAP = 2;
    private static final int VAL_NULL = -1;
    private static final int VAL_OBJECTARRAY = 17;
    private static final int VAL_PARCELABLE = 4;
    private static final int VAL_PARCELABLEARRAY = 16;
    private static final int VAL_PERSISTABLEBUNDLE = 25;
    private static final int VAL_SERIALIZABLE = 21;
    private static final int VAL_SHORT = 5;
    private static final int VAL_SIZE = 26;
    private static final int VAL_SIZEF = 27;
    private static final int VAL_SPARSEARRAY = 12;
    private static final int VAL_SPARSEBOOLEANARRAY = 22;
    private static final int VAL_STRING = 0;
    private static final int VAL_STRINGARRAY = 14;
    private static final HashMap<ClassLoader, HashMap<String, Parcelable.Creator>> mCreators;
    private static final Parcel[] sHolderPool;
    private static final Parcel[] sOwnedPool;
    private long mNativePtr;
    private boolean mOwnsNativeParcelObject;
    private RuntimeException mStack;

    static {
        sOwnedPool = new Parcel[6];
        sHolderPool = new Parcel[6];
        STRING_CREATOR = new Parcelable.Creator<String>(){

            @Override
            public String createFromParcel(Parcel parcel) {
                return parcel.readString();
            }

            public String[] newArray(int n) {
                return new String[n];
            }
        };
        mCreators = new HashMap();
    }

    private Parcel(long l) {
        this.init(l);
    }

    static native void clearFileDescriptor(FileDescriptor var0);

    static native void closeFileDescriptor(FileDescriptor var0) throws IOException;

    private void destroy() {
        if (this.mNativePtr != 0L) {
            if (this.mOwnsNativeParcelObject) {
                Parcel.nativeDestroy(this.mNativePtr);
            }
            this.mNativePtr = 0L;
        }
    }

    static native FileDescriptor dupFileDescriptor(FileDescriptor var0) throws IOException;

    private void freeBuffer() {
        if (this.mOwnsNativeParcelObject) {
            Parcel.nativeFreeBuffer(this.mNativePtr);
        }
    }

    private void init(long l) {
        if (l != 0L) {
            this.mNativePtr = l;
            this.mOwnsNativeParcelObject = false;
            return;
        }
        this.mNativePtr = Parcel.nativeCreate();
        this.mOwnsNativeParcelObject = true;
    }

    private static native void nativeAppendFrom(long var0, long var2, int var4, int var5);

    private static native long nativeCreate();

    private static native byte[] nativeCreateByteArray(long var0);

    private static native int nativeDataAvail(long var0);

    private static native int nativeDataCapacity(long var0);

    private static native int nativeDataPosition(long var0);

    private static native int nativeDataSize(long var0);

    private static native void nativeDestroy(long var0);

    private static native void nativeEnforceInterface(long var0, String var2);

    private static native void nativeFreeBuffer(long var0);

    private static native boolean nativeHasFileDescriptors(long var0);

    private static native byte[] nativeMarshall(long var0);

    private static native boolean nativePushAllowFds(long var0, boolean var2);

    private static native byte[] nativeReadBlob(long var0);

    private static native double nativeReadDouble(long var0);

    private static native FileDescriptor nativeReadFileDescriptor(long var0);

    private static native float nativeReadFloat(long var0);

    private static native int nativeReadInt(long var0);

    private static native long nativeReadLong(long var0);

    private static native String nativeReadString(long var0);

    private static native IBinder nativeReadStrongBinder(long var0);

    private static native void nativeRestoreAllowFds(long var0, boolean var2);

    private static native void nativeSetDataCapacity(long var0, int var2);

    private static native void nativeSetDataPosition(long var0, int var2);

    private static native void nativeSetDataSize(long var0, int var2);

    private static native void nativeUnmarshall(long var0, byte[] var2, int var3, int var4);

    private static native void nativeWriteBlob(long var0, byte[] var2, int var3, int var4);

    private static native void nativeWriteByteArray(long var0, byte[] var2, int var3, int var4);

    private static native void nativeWriteDouble(long var0, double var2);

    private static native void nativeWriteFileDescriptor(long var0, FileDescriptor var2);

    private static native void nativeWriteFloat(long var0, float var2);

    private static native void nativeWriteInt(long var0, int var2);

    private static native void nativeWriteInterfaceToken(long var0, String var2);

    private static native void nativeWriteLong(long var0, long var2);

    private static native void nativeWriteString(long var0, String var2);

    private static native void nativeWriteStrongBinder(long var0, IBinder var2);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Parcel obtain() {
        Parcel[] parcelArray = sOwnedPool;
        synchronized (parcelArray) {
            int n = 0;
            while (n < 6) {
                Parcel parcel = parcelArray[n];
                if (parcel != null) {
                    parcelArray[n] = null;
                    return parcel;
                }
                ++n;
            }
            return new Parcel(0L);
        }
    }

    protected static final Parcel obtain(int n) {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static final Parcel obtain(long l) {
        Parcel[] parcelArray = sHolderPool;
        synchronized (parcelArray) {
            int n = 0;
            while (n < 6) {
                Parcel parcel = parcelArray[n];
                if (parcel != null) {
                    parcelArray[n] = null;
                    parcel.init(l);
                    return parcel;
                }
                ++n;
            }
            return new Parcel(l);
        }
    }

    static native FileDescriptor openFileDescriptor(String var0, int var1) throws FileNotFoundException;

    private void readArrayInternal(Object[] objectArray, int n, ClassLoader classLoader) {
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.readValue(classLoader);
        }
    }

    private void readListInternal(List list, int n, ClassLoader classLoader) {
        while (n > 0) {
            list.add(this.readValue(classLoader));
            --n;
        }
    }

    private final Serializable readSerializable(final ClassLoader classLoader) {
        String string2 = this.readString();
        if (string2 == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.createByteArray());
        try {
            Serializable serializable = (Serializable)new ObjectInputStream(byteArrayInputStream){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
                    Class<?> clazz;
                    if (classLoader != null && (clazz = Class.forName(objectStreamClass.getName(), false, classLoader)) != null) {
                        return clazz;
                    }
                    return super.resolveClass(objectStreamClass);
                }
            }.readObject();
            return serializable;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Parcelable encountered IOException reading a Serializable object (name = " + string2 + ")", iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Parcelable encountered ClassNotFoundException reading a Serializable object (name = " + string2 + ")", classNotFoundException);
        }
    }

    private void readSparseArrayInternal(SparseArray sparseArray, int n, ClassLoader classLoader) {
        while (n > 0) {
            sparseArray.append(this.readInt(), this.readValue(classLoader));
            --n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void readSparseBooleanArrayInternal(SparseBooleanArray sparseBooleanArray, int n) {
        while (n > 0) {
            int n2 = this.readInt();
            boolean bl = this.readByte() == 1;
            sparseBooleanArray.append(n2, bl);
            --n;
        }
        return;
    }

    public final void appendFrom(Parcel parcel, int n, int n2) {
        Parcel.nativeAppendFrom(this.mNativePtr, parcel.mNativePtr, n, n2);
    }

    public final IBinder[] createBinderArray() {
        IBinder[] iBinderArray;
        int n = this.readInt();
        if (n >= 0) {
            iBinderArray = new IBinder[n];
            for (int i = 0; i < n; ++i) {
                iBinderArray[i] = this.readStrongBinder();
            }
        } else {
            iBinderArray = null;
        }
        return iBinderArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final ArrayList<IBinder> createBinderArrayList() {
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        ArrayList<IBinder> arrayList = new ArrayList<IBinder>(n);
        while (n > 0) {
            arrayList.add(this.readStrongBinder());
            --n;
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final boolean[] createBooleanArray() {
        int n = this.readInt();
        if (n < 0) return null;
        if (n > this.dataAvail() >> 2) return null;
        boolean[] blArray = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            boolean bl = this.readInt() != 0;
            blArray[n2] = bl;
            ++n2;
        }
        return blArray;
    }

    public final byte[] createByteArray() {
        return Parcel.nativeCreateByteArray(this.mNativePtr);
    }

    public final char[] createCharArray() {
        char[] cArray;
        int n = this.readInt();
        if (n >= 0 && n <= this.dataAvail() >> 2) {
            cArray = new char[n];
            for (int i = 0; i < n; ++i) {
                cArray[i] = (char)this.readInt();
            }
        } else {
            cArray = null;
        }
        return cArray;
    }

    public final double[] createDoubleArray() {
        double[] dArray;
        int n = this.readInt();
        if (n >= 0 && n <= this.dataAvail() >> 3) {
            dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = this.readDouble();
            }
        } else {
            dArray = null;
        }
        return dArray;
    }

    public final float[] createFloatArray() {
        float[] fArray;
        int n = this.readInt();
        if (n >= 0 && n <= this.dataAvail() >> 2) {
            fArray = new float[n];
            for (int i = 0; i < n; ++i) {
                fArray[i] = this.readFloat();
            }
        } else {
            fArray = null;
        }
        return fArray;
    }

    public final int[] createIntArray() {
        int[] nArray;
        int n = this.readInt();
        if (n >= 0 && n <= this.dataAvail() >> 2) {
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = this.readInt();
            }
        } else {
            nArray = null;
        }
        return nArray;
    }

    public final long[] createLongArray() {
        long[] lArray;
        int n = this.readInt();
        if (n >= 0 && n <= this.dataAvail() >> 3) {
            lArray = new long[n];
            for (int i = 0; i < n; ++i) {
                lArray[i] = this.readLong();
            }
        } else {
            lArray = null;
        }
        return lArray;
    }

    public final String[] createStringArray() {
        String[] stringArray;
        int n = this.readInt();
        if (n >= 0) {
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = this.readString();
            }
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final ArrayList<String> createStringArrayList() {
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(n);
        while (n > 0) {
            arrayList.add(this.readString());
            --n;
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final <T> T[] createTypedArray(Parcelable.Creator<T> creator) {
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        T[] TArray = creator.newArray(n);
        int n2 = 0;
        while (n2 < n) {
            if (this.readInt() != 0) {
                TArray[n2] = creator.createFromParcel(this);
            }
            ++n2;
        }
        return TArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final <T> ArrayList<T> createTypedArrayList(Parcelable.Creator<T> creator) {
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        ArrayList<T> arrayList = new ArrayList<T>(n);
        while (n > 0) {
            if (this.readInt() != 0) {
                arrayList.add(creator.createFromParcel(this));
            } else {
                arrayList.add(null);
            }
            --n;
        }
        return arrayList;
    }

    public final int dataAvail() {
        return Parcel.nativeDataAvail(this.mNativePtr);
    }

    public final int dataCapacity() {
        return Parcel.nativeDataCapacity(this.mNativePtr);
    }

    public final int dataPosition() {
        return Parcel.nativeDataPosition(this.mNativePtr);
    }

    public final int dataSize() {
        return Parcel.nativeDataSize(this.mNativePtr);
    }

    public final void enforceInterface(String string2) {
        Parcel.nativeEnforceInterface(this.mNativePtr, string2);
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    public final boolean hasFileDescriptors() {
        return Parcel.nativeHasFileDescriptors(this.mNativePtr);
    }

    public final byte[] marshall() {
        return Parcel.nativeMarshall(this.mNativePtr);
    }

    public final boolean pushAllowFds(boolean bl) {
        return Parcel.nativePushAllowFds(this.mNativePtr, bl);
    }

    public final Object[] readArray(ClassLoader classLoader) {
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        Object[] objectArray = new Object[n];
        this.readArrayInternal(objectArray, n, classLoader);
        return objectArray;
    }

    public final ArrayList readArrayList(ClassLoader classLoader) {
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        ArrayList arrayList = new ArrayList(n);
        this.readListInternal(arrayList, n, classLoader);
        return arrayList;
    }

    public void readArrayMap(ArrayMap arrayMap, ClassLoader classLoader) {
        int n = this.readInt();
        if (n < 0) {
            return;
        }
        this.readArrayMapInternal(arrayMap, n, classLoader);
    }

    void readArrayMapInternal(ArrayMap arrayMap, int n, ClassLoader classLoader) {
        while (n > 0) {
            arrayMap.append(this.readString(), this.readValue(classLoader));
            --n;
        }
        arrayMap.validate();
    }

    void readArrayMapSafelyInternal(ArrayMap arrayMap, int n, ClassLoader classLoader) {
        while (n > 0) {
            arrayMap.put(this.readString(), this.readValue(classLoader));
            --n;
        }
    }

    public final void readBinderArray(IBinder[] iBinderArray) {
        int n = this.readInt();
        if (n == iBinderArray.length) {
            for (int i = 0; i < n; ++i) {
                iBinderArray[i] = this.readStrongBinder();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public final void readBinderList(List<IBinder> list) {
        int n;
        int n2 = list.size();
        int n3 = this.readInt();
        for (n = 0; n < n2 && n < n3; ++n) {
            list.set(n, this.readStrongBinder());
        }
        while (n < n3) {
            list.add(this.readStrongBinder());
            ++n;
        }
        while (n < n2) {
            list.remove(n3);
            ++n;
        }
    }

    public final byte[] readBlob() {
        return Parcel.nativeReadBlob(this.mNativePtr);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void readBooleanArray(boolean[] blArray) {
        int n = this.readInt();
        if (n != blArray.length) {
            throw new RuntimeException("bad array lengths");
        }
        int n2 = 0;
        while (n2 < n) {
            boolean bl = this.readInt() != 0;
            blArray[n2] = bl;
            ++n2;
        }
        return;
    }

    public final Bundle readBundle() {
        return this.readBundle(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Bundle readBundle(ClassLoader classLoader) {
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        Bundle bundle = new Bundle(this, n);
        if (classLoader == null) return bundle;
        bundle.setClassLoader(classLoader);
        return bundle;
    }

    public final byte readByte() {
        return (byte)(0xFF & this.readInt());
    }

    public final void readByteArray(byte[] byArray) {
        byte[] byArray2 = this.createByteArray();
        if (byArray2.length == byArray.length) {
            System.arraycopy((byte[])byArray2, (int)0, (byte[])byArray, (int)0, (int)byArray2.length);
            return;
        }
        throw new RuntimeException("bad array lengths");
    }

    public final void readCharArray(char[] cArray) {
        int n = this.readInt();
        if (n == cArray.length) {
            for (int i = 0; i < n; ++i) {
                cArray[i] = (char)this.readInt();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public final CharSequence readCharSequence() {
        return TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(this);
    }

    public final CharSequence[] readCharSequenceArray() {
        int n = this.readInt();
        CharSequence[] charSequenceArray = null;
        if (n >= 0) {
            charSequenceArray = new CharSequence[n];
            for (int i = 0; i < n; ++i) {
                charSequenceArray[i] = this.readCharSequence();
            }
        }
        return charSequenceArray;
    }

    public final <T extends Parcelable> T readCreator(Parcelable.Creator<T> creator, ClassLoader classLoader) {
        if (creator instanceof Parcelable.ClassLoaderCreator) {
            return (T)((Parcelable)((Parcelable.ClassLoaderCreator)creator).createFromParcel(this, classLoader));
        }
        return (T)((Parcelable)creator.createFromParcel(this));
    }

    public final double readDouble() {
        return Parcel.nativeReadDouble(this.mNativePtr);
    }

    public final void readDoubleArray(double[] dArray) {
        int n = this.readInt();
        if (n == dArray.length) {
            for (int i = 0; i < n; ++i) {
                dArray[i] = this.readDouble();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public final void readException() {
        int n = this.readExceptionCode();
        if (n != 0) {
            this.readException(n, this.readString());
        }
    }

    public final void readException(int n, String string2) {
        switch (n) {
            default: {
                throw new RuntimeException("Unknown exception code: " + n + " msg " + string2);
            }
            case -1: {
                throw new SecurityException(string2);
            }
            case -2: {
                throw new BadParcelableException(string2);
            }
            case -3: {
                throw new IllegalArgumentException(string2);
            }
            case -4: {
                throw new NullPointerException(string2);
            }
            case -5: {
                throw new IllegalStateException(string2);
            }
            case -6: {
                throw new NetworkOnMainThreadException();
            }
            case -7: 
        }
        throw new UnsupportedOperationException(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int readExceptionCode() {
        int n = this.readInt();
        if (n != -128) return n;
        if (this.readInt() == 0) {
            Log.e(TAG, "Unexpected zero-sized Parcel reply header.");
            return 0;
        }
        StrictMode.readAndHandleBinderCallViolations(this);
        return 0;
    }

    public final ParcelFileDescriptor readFileDescriptor() {
        FileDescriptor fileDescriptor = Parcel.nativeReadFileDescriptor(this.mNativePtr);
        if (fileDescriptor != null) {
            return new ParcelFileDescriptor(fileDescriptor);
        }
        return null;
    }

    public final float readFloat() {
        return Parcel.nativeReadFloat(this.mNativePtr);
    }

    public final void readFloatArray(float[] fArray) {
        int n = this.readInt();
        if (n == fArray.length) {
            for (int i = 0; i < n; ++i) {
                fArray[i] = this.readFloat();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public final HashMap readHashMap(ClassLoader classLoader) {
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        HashMap hashMap = new HashMap(n);
        this.readMapInternal(hashMap, n, classLoader);
        return hashMap;
    }

    public final int readInt() {
        return Parcel.nativeReadInt(this.mNativePtr);
    }

    public final void readIntArray(int[] nArray) {
        int n = this.readInt();
        if (n == nArray.length) {
            for (int i = 0; i < n; ++i) {
                nArray[i] = this.readInt();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public final void readList(List list, ClassLoader classLoader) {
        this.readListInternal(list, this.readInt(), classLoader);
    }

    public final long readLong() {
        return Parcel.nativeReadLong(this.mNativePtr);
    }

    public final void readLongArray(long[] lArray) {
        int n = this.readInt();
        if (n == lArray.length) {
            for (int i = 0; i < n; ++i) {
                lArray[i] = this.readLong();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public final void readMap(Map map, ClassLoader classLoader) {
        this.readMapInternal(map, this.readInt(), classLoader);
    }

    void readMapInternal(Map map, int n, ClassLoader classLoader) {
        while (n > 0) {
            map.put(this.readValue(classLoader), this.readValue(classLoader));
            --n;
        }
    }

    public final <T extends Parcelable> T readParcelable(ClassLoader classLoader) {
        Parcelable.Creator<T> creator = this.readParcelableCreator(classLoader);
        if (creator == null) {
            return null;
        }
        if (creator instanceof Parcelable.ClassLoaderCreator) {
            return (T)((Parcelable)((Parcelable.ClassLoaderCreator)creator).createFromParcel(this, classLoader));
        }
        return (T)((Parcelable)creator.createFromParcel(this));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Parcelable[] readParcelableArray(ClassLoader classLoader) {
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        Parcelable[] parcelableArray = new Parcelable[n];
        int n2 = 0;
        while (n2 < n) {
            parcelableArray[n2] = this.readParcelable(classLoader);
            ++n2;
        }
        return parcelableArray;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final <T extends Parcelable> Parcelable.Creator<T> readParcelableCreator(ClassLoader var1_1) {
        var2_2 = this.readString();
        if (var2_2 == null) {
            return null;
        }
        var3_3 = Parcel.mCreators;
        synchronized (var3_3) {
            block13: {
                block15: {
                    block14: {
                        var5_4 = Parcel.mCreators.get(var1_1);
                        if (var5_4 == null) {
                            var5_4 = new HashMap<K, V>();
                            Parcel.mCreators.put(var1_1, var5_4);
                        }
                        if ((var7_5 = var5_4.get(var2_2)) != null) break block13;
                        if (var1_1 != null) break block14;
                        try {
                            var16_6 = Class.forName(var2_2);
                        }
                        catch (IllegalAccessException var13_8) {
                            Log.e("Parcel", "Illegal access when unmarshalling: " + var2_2, var13_8);
                            throw new BadParcelableException("IllegalAccessException when unmarshalling: " + var2_2);
                        }
                        catch (ClassNotFoundException var11_9) {
                            Log.e("Parcel", "Class not found when unmarshalling: " + var2_2, var11_9);
                            throw new BadParcelableException("ClassNotFoundException when unmarshalling: " + var2_2);
                        }
                        catch (ClassCastException var10_10) {
                            throw new BadParcelableException("Parcelable protocol requires a Parcelable.Creator object called  CREATOR on class " + var2_2);
                        }
                        catch (NoSuchFieldException var9_11) {
                            throw new BadParcelableException("Parcelable protocol requires a Parcelable.Creator object called  CREATOR on class " + var2_2);
                        }
                        catch (NullPointerException var8_12) {
                            throw new BadParcelableException("Parcelable protocol requires the CREATOR object to be static on class " + var2_2);
                        }
lbl30:
                        // 2 sources

                        while ((var7_5 = (Parcelable.Creator)var16_6.getField("CREATOR").get(null)) == null) {
                            throw new BadParcelableException("Parcelable protocol requires a Parcelable.Creator object called  CREATOR on class " + var2_2);
                        }
                        break block15;
                    }
                    var15_7 = Class.forName(var2_2, true, var1_1);
                    var16_6 = var15_7;
                    ** GOTO lbl30
                }
                var5_4.put(var2_2, var7_5);
            }
            return var7_5;
        }
    }

    public final PersistableBundle readPersistableBundle() {
        return this.readPersistableBundle(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final PersistableBundle readPersistableBundle(ClassLoader classLoader) {
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        PersistableBundle persistableBundle = new PersistableBundle(this, n);
        if (classLoader == null) return persistableBundle;
        persistableBundle.setClassLoader(classLoader);
        return persistableBundle;
    }

    public final FileDescriptor readRawFileDescriptor() {
        return Parcel.nativeReadFileDescriptor(this.mNativePtr);
    }

    public final Serializable readSerializable() {
        return this.readSerializable(null);
    }

    public final Size readSize() {
        return new Size(this.readInt(), this.readInt());
    }

    public final SizeF readSizeF() {
        return new SizeF(this.readFloat(), this.readFloat());
    }

    public final SparseArray readSparseArray(ClassLoader classLoader) {
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        SparseArray sparseArray = new SparseArray(n);
        this.readSparseArrayInternal(sparseArray, n, classLoader);
        return sparseArray;
    }

    public final SparseBooleanArray readSparseBooleanArray() {
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        SparseBooleanArray sparseBooleanArray = new SparseBooleanArray(n);
        this.readSparseBooleanArrayInternal(sparseBooleanArray, n);
        return sparseBooleanArray;
    }

    public final String readString() {
        return Parcel.nativeReadString(this.mNativePtr);
    }

    public final void readStringArray(String[] stringArray) {
        int n = this.readInt();
        if (n == stringArray.length) {
            for (int i = 0; i < n; ++i) {
                stringArray[i] = this.readString();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public final String[] readStringArray() {
        int n = this.readInt();
        String[] stringArray = null;
        if (n >= 0) {
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = this.readString();
            }
        }
        return stringArray;
    }

    public final void readStringList(List<String> list) {
        int n;
        int n2 = list.size();
        int n3 = this.readInt();
        for (n = 0; n < n2 && n < n3; ++n) {
            list.set(n, this.readString());
        }
        while (n < n3) {
            list.add(this.readString());
            ++n;
        }
        while (n < n2) {
            list.remove(n3);
            ++n;
        }
    }

    public final IBinder readStrongBinder() {
        return Parcel.nativeReadStrongBinder(this.mNativePtr);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final <T> void readTypedArray(T[] TArray, Parcelable.Creator<T> creator) {
        int n = this.readInt();
        if (n != TArray.length) {
            throw new RuntimeException("bad array lengths");
        }
        int n2 = 0;
        while (n2 < n) {
            TArray[n2] = this.readInt() != 0 ? creator.createFromParcel(this) : null;
            ++n2;
        }
        return;
    }

    @Deprecated
    public final <T> T[] readTypedArray(Parcelable.Creator<T> creator) {
        return this.createTypedArray(creator);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final <T> void readTypedList(List<T> list, Parcelable.Creator<T> creator) {
        int n;
        int n2 = list.size();
        int n3 = this.readInt();
        for (n = 0; n < n2 && n < n3; ++n) {
            if (this.readInt() != 0) {
                list.set(n, creator.createFromParcel(this));
                continue;
            }
            list.set(n, null);
        }
        while (n < n3) {
            if (this.readInt() != 0) {
                list.add(creator.createFromParcel(this));
            } else {
                list.add(null);
            }
            ++n;
        }
        while (n < n2) {
            list.remove(n3);
            ++n;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Object readValue(ClassLoader classLoader) {
        int n = 1;
        int n2 = this.readInt();
        switch (n2) {
            default: {
                int n3 = -4 + this.dataPosition();
                throw new RuntimeException("Parcel " + this + ": Unmarshalling unknown type code " + n2 + " at offset " + n3);
            }
            case -1: {
                return null;
            }
            case 0: {
                return this.readString();
            }
            case 1: {
                return this.readInt();
            }
            case 2: {
                return this.readHashMap(classLoader);
            }
            case 4: {
                return this.readParcelable(classLoader);
            }
            case 5: {
                return (short)this.readInt();
            }
            case 6: {
                return this.readLong();
            }
            case 7: {
                return Float.valueOf(this.readFloat());
            }
            case 8: {
                return this.readDouble();
            }
            case 9: {
                if (this.readInt() == n) {
                    return n != 0;
                }
                n = 0;
                return n != 0;
            }
            case 10: {
                return this.readCharSequence();
            }
            case 11: {
                return this.readArrayList(classLoader);
            }
            case 23: {
                return this.createBooleanArray();
            }
            case 13: {
                return this.createByteArray();
            }
            case 14: {
                return this.readStringArray();
            }
            case 24: {
                return this.readCharSequenceArray();
            }
            case 15: {
                return this.readStrongBinder();
            }
            case 17: {
                return this.readArray(classLoader);
            }
            case 18: {
                return this.createIntArray();
            }
            case 19: {
                return this.createLongArray();
            }
            case 20: {
                return this.readByte();
            }
            case 21: {
                return this.readSerializable(classLoader);
            }
            case 16: {
                return this.readParcelableArray(classLoader);
            }
            case 12: {
                return this.readSparseArray(classLoader);
            }
            case 22: {
                return this.readSparseBooleanArray();
            }
            case 3: {
                return this.readBundle(classLoader);
            }
            case 25: {
                return this.readPersistableBundle(classLoader);
            }
            case 26: {
                return this.readSize();
            }
            case 27: 
        }
        return this.readSizeF();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void recycle() {
        Parcel[] parcelArray;
        this.freeBuffer();
        if (this.mOwnsNativeParcelObject) {
            parcelArray = sOwnedPool;
        } else {
            this.mNativePtr = 0L;
            parcelArray = sHolderPool;
        }
        synchronized (parcelArray) {
            int n = 0;
            while (n < 6) {
                if (parcelArray[n] == null) {
                    parcelArray[n] = this;
                    return;
                }
                ++n;
            }
            return;
        }
    }

    public final void restoreAllowFds(boolean bl) {
        Parcel.nativeRestoreAllowFds(this.mNativePtr, bl);
    }

    public final void setDataCapacity(int n) {
        Parcel.nativeSetDataCapacity(this.mNativePtr, n);
    }

    public final void setDataPosition(int n) {
        Parcel.nativeSetDataPosition(this.mNativePtr, n);
    }

    public final void setDataSize(int n) {
        Parcel.nativeSetDataSize(this.mNativePtr, n);
    }

    public final void unmarshall(byte[] byArray, int n, int n2) {
        Parcel.nativeUnmarshall(this.mNativePtr, byArray, n, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void writeArray(Object[] objectArray) {
        if (objectArray == null) {
            this.writeInt(-1);
            return;
        } else {
            int n = objectArray.length;
            this.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.writeValue(objectArray[i]);
            }
        }
    }

    public void writeArrayMap(ArrayMap<String, Object> arrayMap) {
        this.writeArrayMapInternal(arrayMap);
    }

    /*
     * Enabled aggressive block sorting
     */
    void writeArrayMapInternal(ArrayMap<String, Object> arrayMap) {
        if (arrayMap == null) {
            this.writeInt(-1);
            return;
        } else {
            int n = arrayMap.size();
            this.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.writeString(arrayMap.keyAt(i));
                this.writeValue(arrayMap.valueAt(i));
            }
        }
    }

    public final void writeBinderArray(IBinder[] iBinderArray) {
        if (iBinderArray != null) {
            int n = iBinderArray.length;
            this.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.writeStrongBinder(iBinderArray[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void writeBinderList(List<IBinder> list) {
        if (list == null) {
            this.writeInt(-1);
            return;
        } else {
            int n = list.size();
            this.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.writeStrongBinder(list.get(i));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void writeBlob(byte[] byArray) {
        long l = this.mNativePtr;
        int n = byArray != null ? byArray.length : 0;
        Parcel.nativeWriteBlob(l, byArray, 0, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void writeBooleanArray(boolean[] blArray) {
        if (blArray == null) {
            this.writeInt(-1);
            return;
        } else {
            int n = blArray.length;
            this.writeInt(n);
            for (int i = 0; i < n; ++i) {
                int n2 = blArray[i] ? 1 : 0;
                this.writeInt(n2);
            }
        }
    }

    public final void writeBundle(Bundle bundle) {
        if (bundle == null) {
            this.writeInt(-1);
            return;
        }
        bundle.writeToParcel(this, 0);
    }

    public final void writeByte(byte by) {
        this.writeInt(by);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void writeByteArray(byte[] byArray) {
        int n = byArray != null ? byArray.length : 0;
        this.writeByteArray(byArray, 0, n);
    }

    public final void writeByteArray(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            this.writeInt(-1);
            return;
        }
        Arrays.checkOffsetAndCount((int)byArray.length, (int)n, (int)n2);
        Parcel.nativeWriteByteArray(this.mNativePtr, byArray, n, n2);
    }

    public final void writeCharArray(char[] cArray) {
        if (cArray != null) {
            int n = cArray.length;
            this.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.writeInt(cArray[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public final void writeCharSequence(CharSequence charSequence) {
        TextUtils.writeToParcel(charSequence, this, 0);
    }

    public final void writeCharSequenceArray(CharSequence[] charSequenceArray) {
        if (charSequenceArray != null) {
            int n = charSequenceArray.length;
            this.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.writeCharSequence(charSequenceArray[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public final void writeDouble(double d) {
        Parcel.nativeWriteDouble(this.mNativePtr, d);
    }

    public final void writeDoubleArray(double[] dArray) {
        if (dArray != null) {
            int n = dArray.length;
            this.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.writeDouble(dArray[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void writeException(Exception exception) {
        int n;
        if (exception instanceof SecurityException) {
            n = -1;
        } else if (exception instanceof BadParcelableException) {
            n = -2;
        } else if (exception instanceof IllegalArgumentException) {
            n = -3;
        } else if (exception instanceof NullPointerException) {
            n = -4;
        } else if (exception instanceof IllegalStateException) {
            n = -5;
        } else if (exception instanceof NetworkOnMainThreadException) {
            n = -6;
        } else {
            boolean bl = exception instanceof UnsupportedOperationException;
            n = 0;
            if (bl) {
                n = -7;
            }
        }
        this.writeInt(n);
        StrictMode.clearGatheredViolations();
        if (n != 0) {
            this.writeString(exception.getMessage());
            return;
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new RuntimeException(exception);
    }

    public final void writeFileDescriptor(FileDescriptor fileDescriptor) {
        Parcel.nativeWriteFileDescriptor(this.mNativePtr, fileDescriptor);
    }

    public final void writeFloat(float f) {
        Parcel.nativeWriteFloat(this.mNativePtr, f);
    }

    public final void writeFloatArray(float[] fArray) {
        if (fArray != null) {
            int n = fArray.length;
            this.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.writeFloat(fArray[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public final void writeInt(int n) {
        Parcel.nativeWriteInt(this.mNativePtr, n);
    }

    public final void writeIntArray(int[] nArray) {
        if (nArray != null) {
            int n = nArray.length;
            this.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.writeInt(nArray[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public final void writeInterfaceToken(String string2) {
        Parcel.nativeWriteInterfaceToken(this.mNativePtr, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void writeList(List list) {
        if (list == null) {
            this.writeInt(-1);
            return;
        } else {
            int n = list.size();
            this.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.writeValue(list.get(i));
            }
        }
    }

    public final void writeLong(long l) {
        Parcel.nativeWriteLong(this.mNativePtr, l);
    }

    public final void writeLongArray(long[] lArray) {
        if (lArray != null) {
            int n = lArray.length;
            this.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.writeLong(lArray[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public final void writeMap(Map map) {
        this.writeMapInternal(map);
    }

    /*
     * Enabled aggressive block sorting
     */
    void writeMapInternal(Map<String, Object> map) {
        if (map == null) {
            this.writeInt(-1);
            return;
        } else {
            Set<Map.Entry<String, Object>> set = map.entrySet();
            this.writeInt(set.size());
            for (Map.Entry<String, Object> entry : set) {
                this.writeValue(entry.getKey());
                this.writeValue(entry.getValue());
            }
        }
    }

    public final void writeNoException() {
        if (StrictMode.hasGatheredViolations()) {
            this.writeInt(-128);
            int n = this.dataPosition();
            this.writeInt(0);
            StrictMode.writeGatheredViolationsToParcel(this);
            int n2 = this.dataPosition();
            this.setDataPosition(n);
            this.writeInt(n2 - n);
            this.setDataPosition(n2);
            return;
        }
        this.writeInt(0);
    }

    public final void writeParcelable(Parcelable parcelable, int n) {
        if (parcelable == null) {
            this.writeString(null);
            return;
        }
        this.writeString(parcelable.getClass().getName());
        parcelable.writeToParcel(this, n);
    }

    public final <T extends Parcelable> void writeParcelableArray(T[] TArray, int n) {
        if (TArray != null) {
            int n2 = TArray.length;
            this.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                this.writeParcelable((Parcelable)TArray[i], n);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public final void writeParcelableCreator(Parcelable parcelable) {
        this.writeString(parcelable.getClass().getName());
    }

    public final void writePersistableBundle(PersistableBundle persistableBundle) {
        if (persistableBundle == null) {
            this.writeInt(-1);
            return;
        }
        persistableBundle.writeToParcel(this, 0);
    }

    public final void writeSerializable(Serializable serializable) {
        if (serializable == null) {
            this.writeString(null);
            return;
        }
        String string2 = serializable.getClass().getName();
        this.writeString(string2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(serializable);
            objectOutputStream.close();
            this.writeByteArray(byteArrayOutputStream.toByteArray());
            return;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Parcelable encountered IOException writing serializable object (name = " + string2 + ")", iOException);
        }
    }

    public final void writeSize(Size size) {
        this.writeInt(size.getWidth());
        this.writeInt(size.getHeight());
    }

    public final void writeSizeF(SizeF sizeF) {
        this.writeFloat(sizeF.getWidth());
        this.writeFloat(sizeF.getHeight());
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void writeSparseArray(SparseArray<Object> sparseArray) {
        if (sparseArray == null) {
            this.writeInt(-1);
            return;
        } else {
            int n = sparseArray.size();
            this.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.writeInt(sparseArray.keyAt(i));
                this.writeValue(sparseArray.valueAt(i));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void writeSparseBooleanArray(SparseBooleanArray sparseBooleanArray) {
        if (sparseBooleanArray == null) {
            this.writeInt(-1);
            return;
        }
        int n = sparseBooleanArray.size();
        this.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            this.writeInt(sparseBooleanArray.keyAt(n2));
            boolean bl = sparseBooleanArray.valueAt(n2);
            this.writeByte((byte)(bl ? 1 : 0));
            ++n2;
        }
        return;
    }

    public final void writeString(String string2) {
        Parcel.nativeWriteString(this.mNativePtr, string2);
    }

    public final void writeStringArray(String[] stringArray) {
        if (stringArray != null) {
            int n = stringArray.length;
            this.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.writeString(stringArray[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void writeStringList(List<String> list) {
        if (list == null) {
            this.writeInt(-1);
            return;
        } else {
            int n = list.size();
            this.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.writeString(list.get(i));
            }
        }
    }

    public final void writeStrongBinder(IBinder iBinder) {
        Parcel.nativeWriteStrongBinder(this.mNativePtr, iBinder);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void writeStrongInterface(IInterface iInterface) {
        IBinder iBinder = iInterface == null ? null : iInterface.asBinder();
        this.writeStrongBinder(iBinder);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final <T extends Parcelable> void writeTypedArray(T[] TArray, int n) {
        if (TArray == null) {
            this.writeInt(-1);
            return;
        } else {
            int n2 = TArray.length;
            this.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                T t = TArray[i];
                if (t != null) {
                    this.writeInt(1);
                    t.writeToParcel(this, n);
                    continue;
                }
                this.writeInt(0);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final <T extends Parcelable> void writeTypedList(List<T> list) {
        if (list == null) {
            this.writeInt(-1);
            return;
        }
        int n = list.size();
        int n2 = 0;
        this.writeInt(n);
        while (n2 < n) {
            Parcelable parcelable = (Parcelable)list.get(n2);
            if (parcelable != null) {
                this.writeInt(1);
                parcelable.writeToParcel(this, 0);
            } else {
                this.writeInt(0);
            }
            ++n2;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void writeValue(Object object) {
        int n = 1;
        if (object == null) {
            this.writeInt(-1);
            return;
        }
        if (object instanceof String) {
            this.writeInt(0);
            this.writeString((String)object);
            return;
        }
        if (object instanceof Integer) {
            this.writeInt(n);
            this.writeInt((Integer)object);
            return;
        }
        if (object instanceof Map) {
            this.writeInt(2);
            this.writeMap((Map)object);
            return;
        }
        if (object instanceof Bundle) {
            this.writeInt(3);
            this.writeBundle((Bundle)object);
            return;
        }
        if (object instanceof Parcelable) {
            this.writeInt(4);
            this.writeParcelable((Parcelable)object, 0);
            return;
        }
        if (object instanceof Short) {
            this.writeInt(5);
            this.writeInt(((Short)object).intValue());
            return;
        }
        if (object instanceof Long) {
            this.writeInt(6);
            this.writeLong((Long)object);
            return;
        }
        if (object instanceof Float) {
            this.writeInt(7);
            this.writeFloat(((Float)object).floatValue());
            return;
        }
        if (object instanceof Double) {
            this.writeInt(8);
            this.writeDouble((Double)object);
            return;
        }
        if (object instanceof Boolean) {
            this.writeInt(9);
            if (!((Boolean)object).booleanValue()) {
                n = 0;
            }
            this.writeInt(n);
            return;
        }
        if (object instanceof CharSequence) {
            this.writeInt(10);
            this.writeCharSequence((CharSequence)object);
            return;
        }
        if (object instanceof List) {
            this.writeInt(11);
            this.writeList((List)object);
            return;
        }
        if (object instanceof SparseArray) {
            this.writeInt(12);
            this.writeSparseArray((SparseArray)object);
            return;
        }
        if (object instanceof boolean[]) {
            this.writeInt(23);
            this.writeBooleanArray((boolean[])object);
            return;
        }
        if (object instanceof byte[]) {
            this.writeInt(13);
            this.writeByteArray((byte[])object);
            return;
        }
        if (object instanceof String[]) {
            this.writeInt(14);
            this.writeStringArray((String[])object);
            return;
        }
        if (object instanceof CharSequence[]) {
            this.writeInt(24);
            this.writeCharSequenceArray((CharSequence[])object);
            return;
        }
        if (object instanceof IBinder) {
            this.writeInt(15);
            this.writeStrongBinder((IBinder)object);
            return;
        }
        if (object instanceof Parcelable[]) {
            this.writeInt(16);
            this.writeParcelableArray((Parcelable[])object, 0);
            return;
        }
        if (object instanceof int[]) {
            this.writeInt(18);
            this.writeIntArray((int[])object);
            return;
        }
        if (object instanceof long[]) {
            this.writeInt(19);
            this.writeLongArray((long[])object);
            return;
        }
        if (object instanceof Byte) {
            this.writeInt(20);
            this.writeInt(((Byte)object).byteValue());
            return;
        }
        if (object instanceof PersistableBundle) {
            this.writeInt(25);
            this.writePersistableBundle((PersistableBundle)object);
            return;
        }
        if (object instanceof Size) {
            this.writeInt(26);
            this.writeSize((Size)object);
            return;
        }
        if (object instanceof SizeF) {
            this.writeInt(27);
            this.writeSizeF((SizeF)object);
            return;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray() && clazz.getComponentType() == Object.class) {
            this.writeInt(17);
            this.writeArray((Object[])object);
            return;
        }
        if (object instanceof Serializable) {
            this.writeInt(21);
            this.writeSerializable((Serializable)object);
            return;
        }
        throw new RuntimeException("Parcel: unable to marshal value " + object);
    }
}

