/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.Message;
import android.os.MessageQueue;
import android.os.SystemClock;
import android.util.Log;
import android.util.Printer;

public final class Looper {
    private static final String TAG = "Looper";
    private static Looper sMainLooper;
    static final ThreadLocal<Looper> sThreadLocal;
    private Printer mLogging;
    final MessageQueue mQueue;
    final Thread mThread;

    static {
        sThreadLocal = new ThreadLocal();
    }

    private Looper(boolean bl) {
        this.mQueue = new MessageQueue(bl);
        this.mThread = Thread.currentThread();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Looper getMainLooper() {
        synchronized (Looper.class) {
            return sMainLooper;
        }
    }

    public static void loop() {
        Looper looper = Looper.myLooper();
        if (looper == null) {
            throw new RuntimeException("No Looper; Looper.prepare() wasn't called on this thread.");
        }
        MessageQueue messageQueue = looper.mQueue;
        Binder.clearCallingIdentity();
        long l = Binder.clearCallingIdentity();
        Message message;
        while ((message = messageQueue.next()) != null) {
            long l2;
            Printer printer = looper.mLogging;
            if (printer != null) {
                printer.println(">>>>> Dispatching to " + message.target + " " + message.callback + ": " + message.what);
            }
            message.target.dispatchMessage(message);
            if (printer != null) {
                printer.println("<<<<< Finished to " + message.target + " " + message.callback);
            }
            if (l != (l2 = Binder.clearCallingIdentity())) {
                Log.wtf(TAG, "Thread identity changed from 0x" + Long.toHexString(l) + " to 0x" + Long.toHexString(l2) + " while dispatching to " + message.target.getClass().getName() + " " + message.callback + " what=" + message.what);
            }
            message.recycleUnchecked();
        }
        return;
    }

    public static Looper myLooper() {
        return sThreadLocal.get();
    }

    public static MessageQueue myQueue() {
        return Looper.myLooper().mQueue;
    }

    public static void prepare() {
        Looper.prepare(true);
    }

    private static void prepare(boolean bl) {
        if (sThreadLocal.get() != null) {
            throw new RuntimeException("Only one Looper may be created per thread");
        }
        sThreadLocal.set(new Looper(bl));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void prepareMainLooper() {
        Looper.prepare(false);
        synchronized (Looper.class) {
            if (sMainLooper != null) {
                throw new IllegalStateException("The main Looper has already been prepared.");
            }
            sMainLooper = Looper.myLooper();
            return;
        }
    }

    public void dump(Printer printer, String string2) {
        printer.println(string2 + this.toString());
        this.mQueue.dump(printer, string2 + "  ");
    }

    public MessageQueue getQueue() {
        return this.mQueue;
    }

    public Thread getThread() {
        return this.mThread;
    }

    public boolean isCurrentThread() {
        return Thread.currentThread() == this.mThread;
    }

    public boolean isIdling() {
        return this.mQueue.isIdling();
    }

    public int postSyncBarrier() {
        return this.mQueue.enqueueSyncBarrier(SystemClock.uptimeMillis());
    }

    public void quit() {
        this.mQueue.quit(false);
    }

    public void quitSafely() {
        this.mQueue.quit(true);
    }

    public void removeSyncBarrier(int n) {
        this.mQueue.removeSyncBarrier(n);
    }

    public void setMessageLogging(Printer printer) {
        this.mLogging = printer;
    }

    public String toString() {
        return "Looper (" + this.mThread.getName() + ", tid " + this.mThread.getId() + ") {" + Integer.toHexString(System.identityHashCode(this)) + "}";
    }
}

